/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.util;

import cn.g9.j2me.util.Debug;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    private static String[] SOUND_FILE;
    private static boolean IsOpenPower;
    private static boolean IsStopMediaTimeZero;
    private static boolean IsStopUseDeallocate;
    public static Player[] sounds;
    private static int currentPlayerID;
    private static int prevPlayerID;

    static {
        IsOpenPower = false;
        sounds = null;
        currentPlayerID = -1;
    }

    public Sound() {
    }

    public Sound(boolean isStopMediaTimeZero, boolean isStopUseDeallocate) {
        IsStopMediaTimeZero = isStopMediaTimeZero;
        IsStopUseDeallocate = isStopUseDeallocate;
    }

    public static void setOpenPower() {
        IsOpenPower = true;
    }

    public static void setColsePower() {
        IsOpenPower = false;
    }

    public static boolean isOpened() {
        return IsOpenPower;
    }

    public static void initSound(String[] files, boolean isStopMediaTimeZero, boolean isStopUseDeallocate) {
        SOUND_FILE = files;
        IsStopMediaTimeZero = isStopMediaTimeZero;
        IsStopUseDeallocate = isStopUseDeallocate;
    }

    public static void loadAll() {
        sounds = new Player[SOUND_FILE.length];
        int i = 0;
        while (i < sounds.length) {
            Sound.load(i);
            ++i;
        }
    }

    public static void setPlayer(Player[] p, boolean isStopMediaTimeZero, boolean isStopUseDeallocate) {
        sounds = p;
        IsStopMediaTimeZero = isStopMediaTimeZero;
        IsStopUseDeallocate = isStopUseDeallocate;
    }

    public static void load(int id) {
        if (sounds == null) {
            sounds = new Player[SOUND_FILE.length];
        }
        try {
            DataInputStream dis = new DataInputStream(SOUND_FILE[id].getClass().getResourceAsStream(SOUND_FILE[id]));
            Sound.sounds[id] = Manager.createPlayer((InputStream)dis, (String)Sound.type(SOUND_FILE[id]));
            sounds[id].realize();
            Sound.setVolume(100);
        }
        catch (Exception e) {
            Debug.println(e, "s load");
        }
    }

    public static void releaseAll() {
        int i = 0;
        while (i < sounds.length) {
            Sound.release(i);
            ++i;
        }
        currentPlayerID = -1;
    }

    public static void release(int id) {
        if (sounds == null || sounds[id] == null) {
            return;
        }
        try {
            if (sounds[id].getState() == 400) {
                sounds[id].stop();
            }
            if (sounds[id].getState() == 300) {
                sounds[id].deallocate();
            }
            sounds[id].close();
            Sound.sounds[id] = null;
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void play(int id, int loop) {
        if (id > sounds.length - 1) {
            return;
        }
        if (!Sound.isOpened() || sounds == null || sounds[id] == null) {
            return;
        }
        if (sounds[id].getState() == 400) {
            return;
        }
        try {
            sounds[id].setLoopCount(loop);
            sounds[id].start();
            prevPlayerID = currentPlayerID;
            currentPlayerID = id;
        }
        catch (Exception e) {
            Debug.println(e, "pl");
        }
    }

    public static void pauseCurrent() {
        if (sounds[currentPlayerID] != null) {
            Sound.pause(currentPlayerID);
        }
    }

    public static void pause(int id) {
        try {
            if (sounds == null || sounds[id] == null) {
                return;
            }
            if (sounds[id].getState() != 400) {
                return;
            }
            sounds[id].stop();
            if (IsStopMediaTimeZero) {
                sounds[id].setMediaTime(0L);
            }
            if (IsStopUseDeallocate && sounds[id].getState() == 300) {
                sounds[id].deallocate();
            }
        }
        catch (Exception e) {
            Debug.println(e, "stop");
        }
    }

    private static final String type(String name) {
        String s1 = "audio/midi";
        if (name.toLowerCase().endsWith("wav")) {
            s1 = "audio/x-wav";
        } else if (name.toLowerCase().endsWith("mp3")) {
            s1 = "audio/mpeg";
        }
        return s1;
    }

    public static final void setVolume(int size) {
        if (sounds[0] != null) {
            VolumeControl vc = (VolumeControl)sounds[0].getControl("VolumeControl");
            vc.setLevel(size);
        } else {
            Debug.println(new NullPointerException(), "Volume");
        }
    }

    public static int getCurrentPlayerID() {
        return currentPlayerID;
    }

    public static int getPreviousID() {
        return prevPlayerID;
    }

    public static Player[] getSounds() {
        return sounds;
    }
}

