/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class MediaManager {
    public static final int LOOP_INDEFINITELY = -1;
    public static final int CHANNEL_ALL = -1;
    private boolean soundEnabled;
    private Player midiPlayer;
    private int[] soundLoops;
    private int soundPlayed;
    private int musicPlayed;
    private byte[][] soundData;
    private String[] soundFormat;

    MediaManager(MOBCanvas mOBCanvas, int n) {
        this.soundData = new byte[n][];
        this.soundFormat = new String[n];
        this.soundLoops = new int[n];
        this.soundPlayed = -1;
        this.musicPlayed = -1;
    }

    public boolean isEnabled() {
        return this.soundEnabled;
    }

    public void setEnabled(boolean bl) {
        this.soundEnabled = bl;
        if (this.soundEnabled) {
            if (this.musicPlayed != -1 && this.soundLoops[this.musicPlayed] == -1) {
                try {
                    this.midiPlayer.start();
                }
                catch (Exception exception) {}
            }
        } else if (this.musicPlayed != -1) {
            try {
                this.midiPlayer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void allocateMedia(int n, String string, int n2, int n3) {
        try {
            this.soundData[n] = gameTopLevel.getRawData(string);
            this.soundFormat[n] = string.endsWith("snd") ? "audio/amr" : "audio/x-wav";
            this.soundLoops[n] = n2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void allocateMediaMusic(int n, String string, int n2, int n3) {
        try {
            this.soundData[n] = gameTopLevel.getRawData(string);
            this.soundFormat[n] = "audio/midi";
            this.soundLoops[n] = n2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startMusic(int n, int n2) {
        this.stopMusic();
        try {
            if (this.soundEnabled) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.soundData[n2]);
                this.midiPlayer = Manager.createPlayer((InputStream)byteArrayInputStream, (String)this.soundFormat[n2]);
                byteArrayInputStream.close();
                this.midiPlayer.prefetch();
                this.midiPlayer.setLoopCount(this.soundLoops[n2]);
                this.midiPlayer.setMediaTime(0L);
                this.midiPlayer.start();
            }
            this.musicPlayed = n2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopMusic() {
        if (this.midiPlayer != null) {
            try {
                if (this.soundEnabled) {
                    this.midiPlayer.stop();
                }
                this.midiPlayer.deallocate();
                this.midiPlayer.close();
                this.midiPlayer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.musicPlayed = -1;
        }
    }

    public void startChannel(int n, int n2) {
        this.stopChannel();
        try {
            if (this.soundEnabled) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.soundData[n2]);
                this.midiPlayer = Manager.createPlayer((InputStream)byteArrayInputStream, (String)this.soundFormat[n2]);
                byteArrayInputStream.close();
                this.midiPlayer.prefetch();
                this.midiPlayer.setLoopCount(this.soundLoops[n2]);
                this.midiPlayer.setMediaTime(0L);
                this.midiPlayer.start();
            }
            this.soundPlayed = n2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopChannel() {
        if (this.midiPlayer != null) {
            try {
                if (this.soundEnabled) {
                    this.midiPlayer.stop();
                }
                this.midiPlayer.deallocate();
                this.midiPlayer.close();
                this.midiPlayer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void freeMedia(int n) {
        if (this.soundPlayed == n) {
            this.stopChannel();
        }
        if (this.musicPlayed == n) {
            this.stopMusic();
        }
        try {
            this.soundData[n] = null;
            this.soundFormat[n] = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

