/*
 * Decompiled with CFR 0.152.
 */
package d2;

import d2.ActorData;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import util.Consts;
import util.Data;
import util.GE;

public class Animation
implements Consts {
    private byte BASE_FRAME_STEP = (byte)4;
    private byte ACTION_FRAME_STEP = (byte)3;
    public short[][] allClips = null;
    public ActorData[] actorsData = null;
    public int[] actorsDataPos = null;
    public String[] allTexts = null;
    public String[] imgNames = null;
    private String[] imgAlphaNames = null;
    public String[] soundNames = null;
    public Image[] allImages = null;
    public boolean useImgIndexs = false;
    public boolean useSoundIndexs = false;
    public boolean useAttackVetor = false;
    private boolean dataSplitted = false;
    private String resName;

    private Animation() {
    }

    public static Animation getAnimation(String string) {
        if (string == null) {
            return null;
        }
        Animation animation = new Animation();
        animation.resName = string;
        if (!animation.initBaseData()) {
            animation.releaseRes();
            animation = null;
        }
        return animation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initBaseData() {
        boolean bl = true;
        String string = "/res/ks" + this.resName;
        DataInputStream dataInputStream = null;
        try {
            short s;
            dataInputStream = GE.getDataStream(string);
            short s2 = 0;
            this.useImgIndexs = dataInputStream.readBoolean();
            this.useSoundIndexs = dataInputStream.readBoolean();
            this.useAttackVetor = dataInputStream.readBoolean();
            this.dataSplitted = dataInputStream.readBoolean();
            this.ACTION_FRAME_STEP = (byte)(this.ACTION_FRAME_STEP + (this.useAttackVetor ? (byte)1 : 0));
            s2 = dataInputStream.readShort();
            if (s2 > 0) {
                this.imgNames = new String[s2];
                this.imgAlphaNames = new String[s2];
                if (this.allImages == null) {
                    this.allImages = new Image[s2];
                }
                for (s = 0; s < s2; s = (short)(s + 1)) {
                    this.imgNames[s] = dataInputStream.readUTF();
                    this.imgAlphaNames[s] = dataInputStream.readUTF();
                }
            }
            if (this.useSoundIndexs && (s2 = dataInputStream.readShort()) > 0) {
                this.soundNames = new String[s2];
                for (s = 0; s < s2; s = (short)(s + 1)) {
                    this.soundNames[s] = dataInputStream.readUTF();
                }
            }
            if ((s2 = dataInputStream.readShort()) > 0) {
                this.allTexts = new String[s2];
                for (s = 0; s < s2; s = (short)(s + 1)) {
                    this.allTexts[s] = dataInputStream.readUTF();
                }
            }
            this.allClips = null;
            s2 = dataInputStream.readShort();
            if (s2 > 0) {
                this.allClips = new short[s2][];
                for (s = 0; s < s2; s = (short)(s + 1)) {
                    this.allClips[s] = new short[5];
                    this.allClips[s][0] = (short)(dataInputStream.readShort() & 0xFFFF);
                    this.allClips[s][1] = (short)(dataInputStream.readShort() & 0xFFFF);
                    this.allClips[s][2] = (short)(dataInputStream.readShort() & 0xFFFF);
                    this.allClips[s][3] = (short)(dataInputStream.readShort() & 0xFFFF);
                    this.allClips[s][4] = (short)(dataInputStream.readShort() & 0xFFFF);
                }
            }
            s = 0;
            s = dataInputStream.readShort();
            if (s > 0 && this.actorsData == null) {
                this.actorsData = new ActorData[s];
            }
            if (!this.dataSplitted) {
                this.actorsDataPos = new int[s];
                for (short s3 = 0; s3 < s; s3 = (short)(s3 + 1)) {
                    this.actorsDataPos[s3] = dataInputStream.readInt();
                }
            }
        }
        catch (Exception exception) {
            bl = false;
            GE.println("loadAnimation error: " + string);
            GE.printException(exception);
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    GE.printException(iOException);
                }
                dataInputStream = null;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadActorData(int[] nArray) {
        if (this.actorsData == null) {
            return;
        }
        FilterInputStream filterInputStream = null;
        String string = this.resName.substring(0, this.resName.lastIndexOf(46));
        try {
            if (!this.dataSplitted) {
                filterInputStream = GE.getDataStream("/res/ks" + string + "_all.bin");
            }
            Vector<short[]> vector = new Vector<short[]>();
            Vector<short[]> vector2 = new Vector<short[]>();
            int n = 0;
            short s = 0;
            short s2 = 0;
            short s3 = 0;
            byte by = 0;
            for (int i = 0; i < this.actorsData.length; ++i) {
                int n2;
                int n3;
                boolean bl = true;
                if (nArray != null) {
                    boolean bl2 = false;
                    for (int j = 0; j < nArray.length; ++j) {
                        if (nArray[j] != i) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        bl = false;
                    }
                }
                if (this.dataSplitted) {
                    if (!bl) continue;
                    filterInputStream = GE.getDataStream("/res/ks" + string + "_" + i + ".bin");
                } else if (!bl) {
                    filterInputStream.skip(this.actorsDataPos[i]);
                    continue;
                }
                Object object = null;
                Object object2 = null;
                Object object3 = null;
                short[] sArray = null;
                Object object4 = null;
                Object object5 = null;
                n = ((DataInputStream)filterInputStream).readShort();
                by = ((DataInputStream)filterInputStream).readByte();
                if (n > 0) {
                    object = new short[n][];
                    object2 = new short[n][];
                    for (n3 = 0; n3 < n; n3 = (short)(n3 + 1)) {
                        short[] sArray2;
                        s3 = ((DataInputStream)filterInputStream).readShort();
                        if (s3 <= 0) continue;
                        vector.removeAllElements();
                        vector2.removeAllElements();
                        for (n2 = 0; n2 < s3; n2 = (int)((short)(n2 + 1))) {
                            sArray2 = new short[this.BASE_FRAME_STEP];
                            sArray2[0] = ((DataInputStream)filterInputStream).readShort();
                            if (by == 0) {
                                sArray2[1] = ((DataInputStream)filterInputStream).readShort();
                                sArray2[2] = ((DataInputStream)filterInputStream).readShort();
                            } else {
                                sArray2[1] = ((DataInputStream)filterInputStream).readByte();
                                sArray2[2] = ((DataInputStream)filterInputStream).readByte();
                            }
                            sArray2[3] = (short)(((DataInputStream)filterInputStream).readByte() & 0xFF);
                            vector.addElement(sArray2);
                        }
                        for (n2 = 0; n2 < s3 && n2 < vector.size(); n2 = (int)((short)(n2 + 1))) {
                            sArray2 = (short[])vector.elementAt(n2);
                            short s4 = this.allClips[sArray2[0]][0];
                            if (s4 < 6410 || s4 > 6665) continue;
                            vector2.addElement(sArray2);
                            vector.removeElementAt(n2);
                            n2 = (short)(n2 - 1);
                        }
                        object[n3] = new short[vector.size() * this.BASE_FRAME_STEP];
                        for (n2 = 0; n2 < vector.size(); n2 = (int)((short)(n2 + 1))) {
                            sArray2 = (short[])vector.elementAt(n2);
                            object[n3][n2 * this.BASE_FRAME_STEP + 0] = sArray2[0];
                            object[n3][n2 * this.BASE_FRAME_STEP + 1] = sArray2[1];
                            object[n3][n2 * this.BASE_FRAME_STEP + 2] = sArray2[2];
                            object[n3][n2 * this.BASE_FRAME_STEP + 3] = sArray2[3];
                        }
                        object2[n3] = new short[vector2.size() * this.BASE_FRAME_STEP];
                        for (n2 = 0; n2 < vector2.size(); n2 = (int)((short)(n2 + 1))) {
                            sArray2 = (short[])vector2.elementAt(n2);
                            object2[n3][n2 * this.BASE_FRAME_STEP + 0] = sArray2[0];
                            object2[n3][n2 * this.BASE_FRAME_STEP + 1] = sArray2[1];
                            object2[n3][n2 * this.BASE_FRAME_STEP + 2] = sArray2[2];
                            object2[n3][n2 * this.BASE_FRAME_STEP + 3] = sArray2[3];
                        }
                    }
                }
                if ((s = ((DataInputStream)filterInputStream).readShort()) > 0) {
                    object3 = new short[s][];
                    if (this.useImgIndexs) {
                        object4 = new short[s][];
                    }
                    if (this.useSoundIndexs) {
                        object5 = new short[s][];
                    }
                    for (n3 = 0; n3 < s; n3 = (int)((short)(n3 + 1))) {
                        int n4;
                        s2 = ((DataInputStream)filterInputStream).readShort();
                        if (s2 > 0) {
                            object3[n3] = new short[s2 * this.ACTION_FRAME_STEP];
                            for (n2 = 0; n2 < s2; n2 = (int)((short)(n2 + 1))) {
                                object3[n3][n2 * this.ACTION_FRAME_STEP + 0] = ((DataInputStream)filterInputStream).readShort();
                                object3[n3][n2 * this.ACTION_FRAME_STEP + 1] = (short)(((DataInputStream)filterInputStream).readByte() & 0xFF);
                                object3[n3][n2 * this.ACTION_FRAME_STEP + 2] = (short)(((DataInputStream)filterInputStream).readByte() & 0xFF);
                                if (!this.useAttackVetor) continue;
                                object3[n3][n2 * this.ACTION_FRAME_STEP + 3] = (short)(((DataInputStream)filterInputStream).readByte() & 0xFF);
                            }
                        }
                        if (this.useImgIndexs) {
                            n2 = 0;
                            n2 = ((DataInputStream)filterInputStream).readShort();
                            object4[n3] = new short[n2];
                            for (n4 = 0; n4 < n2; ++n4) {
                                object4[n3][n4] = ((DataInputStream)filterInputStream).readShort();
                            }
                        }
                        if (!this.useSoundIndexs) continue;
                        n2 = 0;
                        n2 = ((DataInputStream)filterInputStream).readShort();
                        object5[n3] = new short[n2 * 3];
                        for (n4 = 0; n4 < object5[n3].length; ++n4) {
                            object5[n3][n4] = ((DataInputStream)filterInputStream).readShort();
                        }
                    }
                }
                if (this.useImgIndexs) {
                    n3 = 0;
                    n3 = ((DataInputStream)filterInputStream).readShort();
                    sArray = new short[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        sArray[n2] = ((DataInputStream)filterInputStream).readShort();
                    }
                }
                if (object == null || object3 == null || this.actorsData[i] != null) continue;
                this.actorsData[i] = ActorData.getActorData(object, object3, sArray, object4, object5, object2);
            }
            vector.removeAllElements();
            vector2.removeAllElements();
            vector = null;
            vector2 = null;
            if (this.dataSplitted) {
                filterInputStream.close();
                filterInputStream = null;
            }
        }
        catch (Exception exception) {
            GE.printException(exception);
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
                filterInputStream = null;
            }
        }
    }

    public boolean isActors_Data(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (this.actorsData[nArray[i]] != null) continue;
            return false;
        }
        return true;
    }

    public void initAllImages() {
        for (int i = 0; i < this.allImages.length; ++i) {
            this.allImages[i] = GE.loadKsImage("/" + this.imgNames[i]);
        }
    }

    public void initImages(int n) {
        if (this.actorsData == null || n < 0 || n >= this.actorsData.length) {
            return;
        }
        short[] sArray = this.actorsData[n].actorImgsUsedIndexs;
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            if (s < 0 || s >= this.allImages.length || this.allImages[s] != null) continue;
            this.allImages[s] = GE.loadKsImage("/" + this.imgNames[s]);
        }
    }

    public void initImages(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            if (s < 0 || s >= this.allImages.length || this.allImages[s] != null) continue;
            this.allImages[s] = GE.loadKsImage("/" + this.imgNames[s]);
        }
    }

    public void initImage(int n) {
        if (this.allImages != null) {
            if (this.allImages[n] != null) {
                this.allImages[n] = null;
            }
            this.allImages[n] = GE.loadKsImage("/" + this.imgNames[n]);
        }
    }

    public void releaseRes() {
        this.releaseData();
        this.releaseAllImgs();
    }

    public void releaseData() {
        int n;
        this.allClips = null;
        if (this.allTexts != null) {
            for (n = 0; n < this.allTexts.length; ++n) {
                this.allTexts[n] = null;
            }
            this.allTexts = null;
        }
        if (this.imgNames != null) {
            for (n = 0; n < this.imgNames.length; ++n) {
                this.imgNames[n] = null;
            }
            this.imgNames = null;
        }
        if (this.soundNames != null) {
            for (n = 0; n < this.soundNames.length; ++n) {
                this.soundNames[n] = null;
            }
            this.soundNames = null;
        }
        this.releaseActorData(null);
    }

    public void releaseActorData(int[] nArray) {
        block3: {
            block2: {
                if (nArray != null) break block2;
                if (this.actorsData == null) break block3;
                for (int i = 0; i < this.actorsData.length; ++i) {
                    this.releaseActorData(i);
                }
                break block3;
            }
            for (int i = 0; i < nArray.length; ++i) {
                this.releaseActorData(nArray[i]);
            }
        }
    }

    public void releaseActorData(int n) {
        if (this.actorsData == null || this.actorsData[n] == null || n < 0 || n >= this.actorsData.length) {
            return;
        }
        this.actorsData[n].releaseData();
        this.actorsData[n] = null;
    }

    public void releaseAllImgs() {
        if (this.allImages == null || this.allImages == null) {
            return;
        }
        for (int i = 0; i < this.allImages.length; ++i) {
            this.releaseImageInfo(i);
            this.allImages[i] = null;
        }
    }

    public void releaseActorImgs(int n) {
        if (this.allImages == null || this.actorsData == null || n < 0 || n >= this.actorsData.length || this.actorsData[n] == null) {
            return;
        }
        short[] sArray = this.actorsData[n].actorImgsUsedIndexs;
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            if (s < 0 || s >= this.allImages.length) continue;
            this.releaseImageInfo(s);
            this.allImages[s] = null;
        }
    }

    public void releaseActorImgs(int[] nArray) {
        if (this.allImages == null || this.actorsData == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (this.actorsData[nArray[i]] == null) continue;
            short[] sArray = this.actorsData[nArray[i]].actorImgsUsedIndexs;
            for (int j = 0; j < sArray.length; ++j) {
                short s = sArray[j];
                if (s < 0 || s >= this.allImages.length) continue;
                this.releaseImageInfo(s);
                this.allImages[s] = null;
            }
        }
    }

    public void releaseImg(int n) {
        this.releaseImgs(new short[]{(short)n});
    }

    public void releaseImgs(short[] sArray) {
        if (this.allImages == null || sArray == null) {
            return;
        }
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            if (s >= this.allImages.length || s < 0) continue;
            this.releaseImageInfo(s);
            this.allImages[s] = null;
        }
    }

    private void releaseImageInfo(int n) {
    }

    public ActorData getActorData(int n) {
        if (this.actorsData == null || n < 0 || n >= this.actorsData.length) {
            return null;
        }
        return this.actorsData[n];
    }

    public int getActorCount() {
        if (this.actorsData == null) {
            return -1;
        }
        return this.actorsData.length;
    }

    public int getLogicBox(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.actorsData == null || n2 >= this.actorsData.length || n2 < 0) {
            GE.println("getLogicBox\uff1anull pointer or Array index out of bounds");
            return -1;
        }
        return this.getLogicBox(nArray, n, this.allClips, this.actorsData[n2], n3, n4, n5, n6);
    }

    public int getLogicBox(int[] nArray, int n, short[][] sArray, ActorData actorData, int n2, int n3, int n4, int n5) {
        if (nArray == null || n < 0 || n > 19) {
            return -1;
        }
        if (actorData == null || sArray == null) {
            GE.println("getLogicBox\uff1anull pointer in getLogicBox");
            return -1;
        }
        if (n2 >= actorData.actionFrames.length || n3 >= actorData.actionFrames[n2].length / this.ACTION_FRAME_STEP) {
            GE.println("getLogicBox\uff1aactionId or frameId - Array index out of bounds");
            return -1;
        }
        short s = actorData.actionFrames[n2][n3 * this.ACTION_FRAME_STEP + 0];
        byte by = (byte)actorData.actionFrames[n2][n3 * this.ACTION_FRAME_STEP + 1];
        short[] sArray2 = actorData.baseFramesLogic[s];
        int n6 = 0;
        for (int i = 0; i < sArray2.length / this.BASE_FRAME_STEP; ++i) {
            int n7;
            short s2 = sArray2[i * this.BASE_FRAME_STEP];
            int n8 = sArray2[i * this.BASE_FRAME_STEP + 1];
            int n9 = sArray2[i * this.BASE_FRAME_STEP + 2];
            byte by2 = (byte)sArray2[i * this.BASE_FRAME_STEP + 3];
            if (s2 >= sArray.length) {
                GE.println("clipID - Array index out of bounds");
                continue;
            }
            short s3 = sArray[s2][0];
            int n10 = sArray[s2][3];
            int n11 = sArray[s2][4];
            if (s3 < 6410 || s3 > 6665 || s3 - 6410 != n) continue;
            int n12 = n4;
            int n13 = n5;
            if (by != 0) {
                if ((by & 2) != 0) {
                    n8 = -n8;
                }
                if ((by & 1) != 0) {
                    n9 = -n9;
                }
                if ((by & 4) != 0) {
                    n7 = n8;
                    n8 = n9;
                    n9 = n7;
                }
                by2 = Consts.TRANS_ARRAY[by2][by];
            }
            n7 = n10;
            int n14 = n11;
            if ((by2 & 4) != 0) {
                n7 = n11;
                n14 = n10;
            }
            n12 += n8 - n7 / 2;
            n13 += n9 - n14 / 2;
            if (nArray.length < n6 * this.ACTION_FRAME_STEP) {
                return -2;
            }
            nArray[n6 * 4 + 0] = n12;
            nArray[n6 * 4 + 1] = n13;
            nArray[n6 * 4 + 2] = n7;
            nArray[n6 * 4 + 3] = n14;
            ++n6;
        }
        return n6;
    }

    public byte getAttackVector(int n, int n2, int n3) {
        if (!this.useAttackVetor || this.actorsData == null || n >= this.actorsData.length || n < 0) {
            GE.println("getAttackVector\uff1auseAttackVetor==false or null pointer or Array index out of bounds");
            return -1;
        }
        return this.getAttackVector(this.actorsData[n], n2, n3);
    }

    public byte getAttackVector(ActorData actorData, int n, int n2) {
        if (!this.useAttackVetor || actorData == null) {
            return -1;
        }
        if (actorData == null || this.allClips == null) {
            GE.println("getAttackVector\uff1anull pointer in drawKeyFrame");
            return -1;
        }
        if (n >= actorData.actionFrames.length || n2 >= actorData.actionFrames[n].length / this.ACTION_FRAME_STEP) {
            GE.println("getAttackVector\uff1aactionId or frameId - Array index out of bounds");
            return -1;
        }
        byte by = (byte)actorData.actionFrames[n][n2 * this.ACTION_FRAME_STEP + 3];
        return by;
    }

    public int getActionFrameStep() {
        return this.ACTION_FRAME_STEP;
    }

    public void drawKeyFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        ActorData actorData = this.actorsData[n];
        short s = actorData.actionFrames[n2][n3 * this.ACTION_FRAME_STEP + 0];
        byte by = (byte)actorData.actionFrames[n2][n3 * this.ACTION_FRAME_STEP + 1];
        short[] sArray = actorData.baseFrames[s];
        Image image = null;
        if (bl) {
            by = GE.getTransFlag(by, (byte)2);
        }
        for (int i = 0; i < sArray.length / this.BASE_FRAME_STEP; ++i) {
            short s2 = sArray[i * this.BASE_FRAME_STEP];
            int n6 = sArray[i * this.BASE_FRAME_STEP + 1];
            int n7 = sArray[i * this.BASE_FRAME_STEP + 2];
            byte by2 = (byte)sArray[i * this.BASE_FRAME_STEP + 3];
            if (s2 >= this.allClips.length) {
                GE.println("drawKeyFrame\uff1aclipID - Array index out of bounds");
                continue;
            }
            short s3 = this.allClips[s2][0];
            short s4 = this.allClips[s2][1];
            short s5 = this.allClips[s2][2];
            int n8 = this.allClips[s2][3];
            int n9 = this.allClips[s2][4];
            int n10 = 0;
            short s6 = GE.getResType(s3);
            if (s6 == 1 || s6 == 2 || s6 == 3) {
                n10 = (s4 << 16 & 0xFFFF0000) + (s5 & 0xFFFF);
                if (s6 == 2) {
                    by2 = 0;
                    n8 = GE.FONT.stringWidth(this.allTexts[s3 - 6667]);
                    n9 = Data.FONT_SIZEH;
                }
            } else {
                image = this.allImages[s3];
                if (image == null) {
                    GE.println("drawKeyFrame\uff1aimage is null : " + s3);
                    image = this.allImages[s3] = GE.loadKsImage("/" + this.imgNames[s3]);
                }
            }
            int n11 = n4;
            int n12 = n5;
            int n13 = n8;
            int n14 = n9;
            if ((by2 & 4) != 0) {
                n13 = n9;
                n14 = n8;
            }
            if (by != 0) {
                if ((by & 2) != 0) {
                    n6 = -n6 - n13 % 2;
                }
                if ((by & 1) != 0) {
                    n7 = -n7;
                }
                if ((by & 4) != 0) {
                    int n15 = n6;
                    n6 = n7;
                    n7 = n15;
                }
                by2 = Consts.TRANS_ARRAY[by2][by];
            }
            n11 += n6 - n13 / 2;
            n12 += n7 - n14 / 2;
            graphics.setClip(0, 0, GE.screenW, GE.screenH);
            if (s6 == 0) {
                graphics.drawRegion(image, (int)s4, (int)s5, n8, n9, (int)by2, n11, n12, 0);
                continue;
            }
            if (s6 == 1) {
                GE.fillRect(graphics, n11, n12, n13, n14, n10);
                GE.drawRect(graphics, n11, n12, n13, n14, n10);
                continue;
            }
            if (s6 == 3) {
                GE.drawRect(graphics, n11, n12, n13, n14, n10);
                continue;
            }
            if (s6 != 2) continue;
            GE.drawString(graphics, this.allTexts[s3 - 6667], n11, n12, n10);
        }
        graphics.setClip(0, 0, 240, 320);
    }
}

