/*
 * Decompiled with CFR 0.152.
 */
package d2;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import util.Consts;
import util.GE;

public class Map
implements Consts {
    public static int cameraL;
    public static int cameraT;
    public static int preCameraL;
    public static int preCameraT;
    private static int mapBufferW;
    private static int mapBufferH;
    private static Image imgMapBuffer;
    private static Graphics gMapBuffer;
    public static int viewX;
    public static int viewY;
    public static int viewWidth;
    public static int viewHeight;
    public static short tileX;
    public static short tileY;
    public static short tileHeight;
    public static short tileWidth;
    public static int worldWidth;
    public static int worldHeight;
    private static byte levelFlag;
    private static int mapColor;
    private static short mapStyle;
    private static byte[][] mapDataPhyFlag;
    private static byte[][] mapDataBgTile;
    private static byte[][] mapDataSurTile;
    private static Image[] mapImgs;
    private static short[][] mapClips;
    private static String[] mapImgName;
    private static boolean isDrawBuffer;
    private static boolean isOpenDoubleMap;
    private static int doubleMapScaleW;
    private static int doubleMapScaleH;
    private static int doubleCameraMapL;
    private static int doubleCameraMapT;
    private static int bufferWorldW;
    private static int bufferWorldH;
    private static byte[][] bufferMapBgTileData;
    private static byte[][] bufferMapSurTileData;
    private static byte bufferLevelFlag;
    private static short bufferTileX;
    private static short bufferTileY;
    private static short[][] mapBuffClips;
    public static int screenTrackV;
    public static int screenTrackStep;
    public static int heroStaySize;
    public static int screenTrackStepMax;
    public static final short soffx;
    private static int m_prevX0;
    private static int m_prevX1;
    private static int m_prevY0;
    private static int m_prevY1;
    private static boolean m_updateBg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initData(int n, Vector vector, Vector vector2, Vector vector3) {
        DataInputStream dataInputStream = null;
        int n2 = 0;
        String string = "/res/ks/mapImgsDic.bin";
        try {
            dataInputStream = GE.getDataStream(string);
            n2 = dataInputStream.readShort();
            mapImgs = new Image[n2];
            mapImgName = new String[n2];
            for (int i = 0; i < n2; ++i) {
                Map.mapImgName[i] = dataInputStream.readUTF();
            }
        }
        catch (Exception exception) {
            GE.printException(exception);
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
                dataInputStream = null;
            }
        }
        Map.loadLevel(n, vector, vector2, vector3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLevel(int n, Vector vector, Vector vector2, Vector vector3) {
        if (vector == null || vector2 == null || vector3 == null) {
            return;
        }
        vector.removeAllElements();
        vector2.removeAllElements();
        vector3.removeAllElements();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        byte by = 0;
        DataInputStream dataInputStream = null;
        String string = "/res/ks/map_" + n + ".bin";
        try {
            int n5;
            int n6;
            dataInputStream = GE.getDataStream(string);
            mapColor = dataInputStream.readInt();
            mapStyle = dataInputStream.readShort();
            tileWidth = dataInputStream.readShort();
            tileHeight = dataInputStream.readShort();
            tileX = dataInputStream.readShort();
            tileY = dataInputStream.readShort();
            worldWidth = tileX * tileWidth;
            worldHeight = tileY * tileHeight;
            bufferTileX = tileX;
            bufferTileY = tileY;
            bufferLevelFlag = levelFlag = dataInputStream.readByte();
            if ((levelFlag & 1) != 0) {
                mapDataPhyFlag = new byte[tileX][tileY];
                for (n6 = 0; n6 < tileX; ++n6) {
                    for (n5 = 0; n5 < tileY; ++n5) {
                        Map.mapDataPhyFlag[n6][n5] = dataInputStream.readByte();
                    }
                }
            }
            if ((levelFlag & 2) != 0) {
                mapDataBgTile = new byte[tileX][tileY];
                for (n6 = 0; n6 < tileX; ++n6) {
                    for (n5 = 0; n5 < tileY; ++n5) {
                        Map.mapDataBgTile[n6][n5] = dataInputStream.readByte();
                    }
                }
                bufferMapBgTileData = mapDataBgTile;
            }
            if ((levelFlag & 4) != 0) {
                mapDataSurTile = new byte[tileX][tileY];
                for (n6 = 0; n6 < tileX; ++n6) {
                    for (n5 = 0; n5 < tileY; ++n5) {
                        Map.mapDataSurTile[n6][n5] = dataInputStream.readByte();
                    }
                }
                bufferMapSurTileData = mapDataSurTile;
            }
            if ((levelFlag & 8) != 0) {
                n4 = dataInputStream.readShort();
                for (n6 = 0; n6 < n4; ++n6) {
                    n2 = dataInputStream.readByte() & 0xFF;
                    n3 = dataInputStream.readByte() & 0xFF;
                    s = dataInputStream.readShort();
                    s2 = dataInputStream.readShort();
                    s3 = dataInputStream.readShort();
                    s4 = dataInputStream.readShort();
                    by = dataInputStream.readByte();
                    vector.addElement(new short[]{s, (short)(n2 * tileWidth + tileWidth / 2), (short)(n3 * tileHeight + tileHeight / 2), s2, s3, s4, by});
                }
            }
            if ((levelFlag & 0x10) != 0) {
                n4 = dataInputStream.readShort();
                for (n6 = 0; n6 < n4; ++n6) {
                    n2 = dataInputStream.readByte() & 0xFF;
                    n3 = dataInputStream.readByte() & 0xFF;
                    s = dataInputStream.readShort();
                    s2 = dataInputStream.readShort();
                    s3 = dataInputStream.readShort();
                    s4 = dataInputStream.readShort();
                    by = dataInputStream.readByte();
                    vector2.addElement(new short[]{s, (short)(n2 * tileWidth + tileWidth / 2), (short)(n3 * tileHeight + tileHeight / 2), s2, s3, s4, by});
                }
            }
            if ((levelFlag & 0x20) != 0) {
                n4 = dataInputStream.readShort();
                for (n6 = 0; n6 < n4; ++n6) {
                    n2 = dataInputStream.readByte() & 0xFF;
                    n3 = dataInputStream.readByte() & 0xFF;
                    s = dataInputStream.readShort();
                    s2 = dataInputStream.readShort();
                    s3 = dataInputStream.readShort();
                    s4 = dataInputStream.readShort();
                    by = dataInputStream.readByte();
                    vector3.addElement(new short[]{s, (short)(n2 * tileWidth + tileWidth / 2), (short)(n3 * tileHeight + tileHeight / 2), s2, s3, s4, by});
                }
            }
        }
        catch (Exception exception) {
            GE.printException(exception);
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
                dataInputStream = null;
            }
        }
        string = "/res/ks/mapStyle_" + mapStyle + ".bin";
        try {
            dataInputStream = GE.getDataStream(string);
            n4 = dataInputStream.readShort();
            mapClips = new short[n4][6];
            for (int i = 0; i < n4; ++i) {
                Map.mapClips[i][0] = dataInputStream.readShort();
                Map.mapClips[i][1] = dataInputStream.readShort();
                Map.mapClips[i][2] = dataInputStream.readShort();
                Map.mapClips[i][3] = dataInputStream.readShort();
                Map.mapClips[i][4] = dataInputStream.readShort();
                Map.mapClips[i][5] = (short)(dataInputStream.readByte() & 0xFF);
            }
            mapBuffClips = mapClips;
        }
        catch (Exception exception) {
            GE.printException(exception);
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
                dataInputStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDoubleMapLevel(int n) {
        int n2 = 0;
        DataInputStream dataInputStream = null;
        String string = "/res/ks/map_" + n + ".bin";
        try {
            int n3;
            int n4;
            dataInputStream = GE.getDataStream(string);
            dataInputStream.readInt();
            mapStyle = dataInputStream.readShort();
            dataInputStream.readShort();
            dataInputStream.readShort();
            bufferTileX = dataInputStream.readShort();
            bufferTileY = dataInputStream.readShort();
            bufferWorldW = bufferTileX * tileWidth;
            bufferWorldH = bufferTileY * tileHeight;
            bufferLevelFlag = dataInputStream.readByte();
            if ((bufferLevelFlag & 2) != 0) {
                bufferMapBgTileData = new byte[bufferTileX][bufferTileY];
                for (n4 = 0; n4 < bufferTileX; ++n4) {
                    for (n3 = 0; n3 < bufferTileY; ++n3) {
                        Map.bufferMapBgTileData[n4][n3] = dataInputStream.readByte();
                    }
                }
            }
            if ((bufferLevelFlag & 4) != 0) {
                bufferMapSurTileData = new byte[bufferTileX][bufferTileY];
                for (n4 = 0; n4 < bufferTileX; ++n4) {
                    for (n3 = 0; n3 < bufferTileY; ++n3) {
                        Map.bufferMapSurTileData[n4][n3] = dataInputStream.readByte();
                    }
                }
            }
        }
        catch (Exception exception) {
            GE.printException(exception);
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
                dataInputStream = null;
            }
        }
        string = "/res/ks/mapStyle_" + mapStyle + ".bin";
        try {
            dataInputStream = GE.getDataStream(string);
            n2 = dataInputStream.readShort();
            mapBuffClips = null;
            mapBuffClips = new short[n2][6];
            for (int i = 0; i < n2; ++i) {
                Map.mapBuffClips[i][0] = dataInputStream.readShort();
                Map.mapBuffClips[i][1] = dataInputStream.readShort();
                Map.mapBuffClips[i][2] = dataInputStream.readShort();
                Map.mapBuffClips[i][3] = dataInputStream.readShort();
                Map.mapBuffClips[i][4] = dataInputStream.readShort();
                Map.mapBuffClips[i][5] = (short)(dataInputStream.readByte() & 0xFF);
            }
        }
        catch (Exception exception) {
            GE.printException(exception);
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
                dataInputStream = null;
            }
        }
    }

    public static void setView(int n, int n2, int n3, int n4) {
        viewX = n;
        viewY = n2;
        viewWidth = n3;
        viewHeight = n4;
    }

    public static void setCameraPos(int n, int n2) {
        cameraL = n - viewWidth / 2;
        cameraT = n2 - viewHeight / 2;
        Map.adjustCamera();
        preCameraL = cameraL;
        preCameraT = cameraT;
    }

    public static void loadImg(int n) {
        if (mapImgs[n] != null) {
            return;
        }
        Map.mapImgs[n] = GE.loadImage("/res/imgs/" + mapImgName[n]);
    }

    public static void loadAllImg() {
        for (int i = 0; i < mapImgs.length; ++i) {
            Map.loadImg(i);
        }
    }

    public static void releaseImg(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            Map.releaseImgInfo(nArray[i]);
            Map.mapImgs[nArray[i]] = null;
        }
    }

    public static void releaseAllImg() {
        for (int i = 0; i < mapImgs.length; ++i) {
            Map.releaseImgInfo(i);
            Map.mapImgs[i] = null;
        }
    }

    public static void releaseAllImg(int[] nArray) {
        for (int i = 0; i < mapImgs.length; ++i) {
            for (int j = 0; j < nArray.length && i != nArray[j]; ++j) {
                if (j != nArray.length - 1) continue;
                Map.releaseImgInfo(i);
                Map.mapImgs[i] = null;
            }
        }
    }

    public static void releaseImg(int n) {
        Map.releaseImgInfo(n);
        Map.mapImgs[n] = null;
    }

    private static void releaseImgInfo(int n) {
    }

    public static void releaseAllRes() {
        Map.releaseLevelRes();
        mapImgs = null;
        mapImgName = null;
    }

    public static void releaseLevelRes() {
        mapDataPhyFlag = null;
        mapDataBgTile = null;
        mapDataSurTile = null;
        isDrawBuffer = false;
        if (mapImgs != null) {
            for (int i = 0; i < mapImgs.length; ++i) {
                Map.mapImgs[i] = null;
            }
        }
        mapClips = null;
        m_updateBg = true;
    }

    public static void createBuffer() {
        m_updateBg = true;
        isDrawBuffer = true;
        Map.initBuffer();
    }

    public static void updataBuffer() {
        m_updateBg = true;
    }

    public static void setDrawBuffer(boolean bl) {
        isDrawBuffer = bl;
    }

    public static void createDoubleMap(int n) {
        isOpenDoubleMap = true;
        Map.loadDoubleMapLevel(n);
        Map.createBuffer();
    }

    public static void closeDoubleMap() {
        isOpenDoubleMap = false;
    }

    public static void setMapColor(int n) {
        mapColor = n;
    }

    private static void initBuffer() {
        mapBufferW = viewWidth > tileWidth * bufferTileX ? tileWidth * bufferTileX : (viewWidth / tileWidth + (viewWidth % tileWidth == 0 ? 1 : 2)) * tileWidth;
        mapBufferH = viewHeight > tileHeight * bufferTileY ? tileHeight * bufferTileY : (viewHeight / tileHeight + (viewHeight % tileHeight == 0 ? 1 : 2)) * tileHeight;
        if (imgMapBuffer == null || mapBufferW != imgMapBuffer.getWidth() || mapBufferW != imgMapBuffer.getHeight()) {
            imgMapBuffer = Image.createImage((int)mapBufferW, (int)mapBufferH);
            gMapBuffer = imgMapBuffer.getGraphics();
        }
        if (isOpenDoubleMap) {
            doubleMapScaleW = (worldWidth - viewWidth) / (bufferWorldW - viewWidth);
            doubleMapScaleH = (worldHeight - viewHeight) / (bufferWorldH - viewHeight);
            doubleMapScaleW = doubleMapScaleW >= 2 ? doubleMapScaleW : 2;
            doubleMapScaleH = doubleMapScaleH >= 2 ? doubleMapScaleH : 2;
        }
    }

    public static boolean moveScreen(int n, int n2, int n3) {
        int n4 = GE.gViewWidth / 2;
        int n5 = GE.gViewHeight / 2 + tileHeight;
        if (n == -1) {
            cameraL = cameraL + n4 > n2 + heroStaySize / 2 ? (cameraL -= screenTrackV) : (cameraL + n4 < n2 - heroStaySize / 2 ? (cameraL += screenTrackV) : n2 - n4);
        } else {
            if (n == 3) {
                cameraL = cameraL + soffx > n2 + heroStaySize / 2 ? (cameraL -= (cameraL + soffx - (n2 + heroStaySize / 2)) / screenTrackStep) : (cameraL + soffx < n2 - heroStaySize / 2 ? (cameraL += (n2 - heroStaySize / 2 - (cameraL + soffx)) / screenTrackStep) : n2 - soffx);
            }
            if (n == 2) {
                cameraL = cameraL + GE.gViewWidth - soffx > n2 + heroStaySize / 2 ? (cameraL -= (cameraL + GE.gViewWidth - soffx - (n2 + heroStaySize / 2)) / screenTrackStep) : (cameraL + GE.gViewWidth - soffx < n2 - heroStaySize / 2 ? (cameraL += (n2 - heroStaySize / 2 - (cameraL + GE.gViewWidth - soffx)) / screenTrackStep) : n2 - (GE.gViewWidth - soffx));
            }
        }
        if (n3 - cameraT > n5) {
            cameraT = n3 - cameraT - n5 > heroStaySize ? n3 - n5 - heroStaySize : (cameraT += (n3 - cameraT - n5) / screenTrackStep);
        } else if (n3 - cameraT < n5) {
            cameraT = n3 - cameraT - n5 < -heroStaySize ? n3 - n5 + heroStaySize : (cameraT += (n3 - cameraT - n5) / screenTrackStep);
        }
        Map.adjustCamera();
        if (preCameraL != cameraL || preCameraT != cameraT) {
            preCameraL = cameraL;
            preCameraT = cameraT;
            return true;
        }
        return false;
    }

    public static void adjustCamera() {
        if (cameraL < 0) {
            cameraL = 0;
        }
        if (cameraL > worldWidth - viewWidth) {
            cameraL = worldWidth - viewWidth;
        }
        if (cameraT < 0) {
            cameraT = 0;
        }
        if (cameraT > worldHeight - viewHeight) {
            cameraT = worldHeight - viewHeight;
        }
        if (isOpenDoubleMap) {
            doubleCameraMapL = cameraL / doubleMapScaleW;
            doubleCameraMapT = cameraT / doubleMapScaleH;
            if (doubleCameraMapL < 0) {
                doubleCameraMapL = 0;
            }
            if (doubleCameraMapL > bufferWorldW - viewWidth) {
                doubleCameraMapL = bufferWorldW - viewWidth;
            }
            if (doubleCameraMapT < 0) {
                doubleCameraMapT = 0;
            }
            if (doubleCameraMapT > bufferWorldH - viewHeight) {
                doubleCameraMapT = bufferWorldH - viewHeight;
            }
        }
    }

    public static int getPassType(int n, int n2) {
        if (n < 0 || n >= worldWidth || n2 < 0 || n2 >= worldHeight) {
            return -1;
        }
        return mapDataPhyFlag[n / tileWidth][n2 / tileHeight] & 0xFF;
    }

    public static void setPassType(int n, int n2, byte by) {
        Map.mapDataPhyFlag[n][n2] = by;
    }

    public static void display(Graphics graphics) {
        if (preCameraL != cameraL || preCameraT != cameraT) {
            Map.adjustCamera();
        }
        if (isOpenDoubleMap) {
            Map.drawBuffer(graphics, doubleCameraMapL, doubleCameraMapT);
            Map.drawMap(graphics, cameraL, cameraT);
        } else if (isDrawBuffer) {
            Map.drawBuffer(graphics, cameraL, cameraT);
        } else {
            Map.drawMap(graphics, cameraL, cameraT);
        }
    }

    public static void display(Graphics graphics, int n, int n2) {
        if (isOpenDoubleMap) {
            Map.drawBuffer(graphics, n / doubleMapScaleW, n2 / doubleMapScaleH);
            Map.drawMap(graphics, n, n2);
        } else if (isDrawBuffer) {
            Map.drawBuffer(graphics, n, n2);
        } else {
            Map.drawMap(graphics, n, n2);
        }
    }

    private static void drawMap(Graphics graphics, int n, int n2) {
        if (imgMapBuffer == null || mapDataSurTile == null || mapDataBgTile == null) {
            return;
        }
        short[] sArray = null;
        int n3 = n / tileWidth;
        int n4 = n2 / tileHeight;
        int n5 = viewWidth / tileWidth;
        int n6 = viewHeight / tileWidth;
        graphics.setClip(GE.screenX, GE.screenY, GE.screenW, GE.screenH);
        for (int i = n4; i < n4 + n6 + 1 + n2 % tileHeight / (tileHeight / 2); ++i) {
            for (int j = n3; j < n3 + n5 + 1; ++j) {
                int n7;
                int n8;
                int n9;
                int n10;
                if ((levelFlag & 2) != 0 && (n10 = j < 0 || j >= tileX || i < 0 || i >= tileY ? -1 : mapDataBgTile[j][i] & 0xFF) > 0) {
                    if ((n9 = (sArray = mapClips[--n10])[0] < 6409 ? 0 : (sArray[0] <= 6665 ? 3 : (sArray[0] == 6666 ? 1 : (sArray[0] >= 6667 ? 2 : -1)))) == 1) {
                        GE.fillRect(graphics, j * tileWidth - n, i * tileHeight - n2, sArray[3], sArray[4], sArray[1] << 16 & sArray[2]);
                        graphics.setClip(GE.screenX, GE.screenY, GE.screenW, GE.screenH);
                    } else if (n9 == 0) {
                        if (mapImgs[sArray[0]] == null) {
                            Map.loadImg(sArray[0]);
                        }
                        n8 = (j - n3) * tileWidth - n % tileWidth;
                        n7 = (i - n4) * tileHeight - n2 % tileHeight;
                        graphics.drawRegion(mapImgs[sArray[0]], (int)sArray[1], (int)sArray[2], (int)sArray[3], (int)sArray[4], (int)sArray[5], n8, n7, 0);
                    }
                }
                if ((levelFlag & 4) == 0 || (n10 = j < 0 || j >= tileX || i < 0 || i >= tileY ? -1 : mapDataSurTile[j][i] & 0xFF) <= 0) continue;
                if ((n9 = (sArray = mapClips[--n10])[0] < 6409 ? 0 : (sArray[0] <= 6665 ? 3 : (sArray[0] == 6666 ? 1 : (sArray[0] >= 6667 ? 2 : -1)))) == 1) {
                    GE.fillRect(graphics, j * tileWidth - n, i * tileHeight - n2, sArray[3], sArray[4], sArray[1] << 16 & sArray[2]);
                    graphics.setClip(GE.screenX, GE.screenY, GE.screenW, GE.screenH);
                    continue;
                }
                if (n9 != 0) continue;
                if (mapImgs[sArray[0]] == null) {
                    Map.loadImg(sArray[0]);
                }
                n8 = (j - n3) * tileWidth - n % tileWidth;
                n7 = (i - n4) * tileHeight - n2 % tileHeight;
                graphics.drawRegion(mapImgs[sArray[0]], (int)sArray[1], (int)sArray[2], (int)sArray[3], (int)sArray[4], (int)sArray[5], n8, n7, 0);
            }
        }
    }

    private static void drawBuffer(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (imgMapBuffer == null || mapDataSurTile == null || mapDataBgTile == null) {
            return;
        }
        int n7 = n / tileWidth;
        int n8 = n7 + (viewWidth + tileWidth - 1) / tileWidth;
        if (n8 >= bufferTileX) {
            n8 = bufferTileX - 1;
        }
        if ((n6 = (n5 = n2 / tileHeight) + (viewHeight + tileHeight - 1) / tileHeight) >= bufferTileY) {
            n6 = bufferTileY - 1;
        }
        if (m_updateBg) {
            GE.fillRect(gMapBuffer, 0, 0, mapBufferW, mapBufferH, mapColor);
            m_updateBg = false;
            Map.drawMapBuffer(gMapBuffer, n7, n5, n8, n6);
            m_prevX0 = n7;
            m_prevY0 = n5;
            m_prevX1 = n8;
            m_prevY1 = n6;
        }
        if (m_prevX0 != n7) {
            if (m_prevX0 < n7) {
                n4 = m_prevX1 + 1;
                n3 = n8;
            } else {
                n4 = n7;
                n3 = m_prevX0 - 1;
            }
            Map.drawMapBuffer(gMapBuffer, n4, n5, n3, n6);
            m_prevX0 = n7;
            m_prevX1 = n8;
        }
        if (m_prevY0 != n5) {
            if (m_prevY0 < n5) {
                n4 = m_prevY1 + 1;
                n3 = n6;
            } else {
                n4 = n5;
                n3 = m_prevY0 - 1;
            }
            Map.drawMapBuffer(gMapBuffer, n7, n4, n8, n3);
            m_prevY0 = n5;
            m_prevY1 = n6;
        }
        int n9 = n % mapBufferW;
        int n10 = n2 % mapBufferH;
        int n11 = (n + viewWidth) % mapBufferW;
        int n12 = (n2 + viewHeight) % mapBufferH;
        if (n11 > n9) {
            if (n12 > n10) {
                Map.copyFromBuffer(graphics, n9, n10, viewWidth, viewHeight, 0, viewY);
            } else {
                Map.copyFromBuffer(graphics, n9, n10, viewWidth, viewHeight - n12, 0, viewY);
                Map.copyFromBuffer(graphics, n9, 0, viewWidth, n12, 0, viewY + viewHeight - n12);
            }
        } else if (n12 > n10) {
            Map.copyFromBuffer(graphics, n9, n10, viewWidth - n11, viewHeight, 0, viewY);
            Map.copyFromBuffer(graphics, 0, n10, n11, viewHeight, viewWidth - n11, viewY);
        } else {
            Map.copyFromBuffer(graphics, n9, n10, viewWidth - n11, viewHeight - n12, 0, viewY);
            Map.copyFromBuffer(graphics, n9, 0, viewWidth - n11, n12, 0, viewY + viewHeight - n12);
            Map.copyFromBuffer(graphics, 0, n10, n11, viewHeight - n12, viewWidth - n11, viewY);
            Map.copyFromBuffer(graphics, 0, 0, n11, n12, viewWidth - n11, viewY + viewHeight - n12);
        }
    }

    private static void drawMapBuffer(Graphics graphics, int n, int n2, int n3, int n4) {
        n = GE.limitNumber(n, 0, bufferTileX);
        n3 = GE.limitNumber(n3, 0, bufferTileX);
        n2 = GE.limitNumber(n2, 0, bufferTileY);
        n4 = GE.limitNumber(n4, 0, bufferTileY);
        short[] sArray = null;
        int n5 = n2 * tileHeight % mapBufferH;
        for (int i = n2; i <= n4; ++i) {
            if (i < 0 || i >= bufferTileY) continue;
            int n6 = n * tileWidth % mapBufferW;
            for (int j = n; j <= n3; ++j) {
                int n7;
                short s;
                short s2;
                short s3;
                short s4;
                short s5;
                short s6;
                short s7;
                int n8;
                if (j < 0 || j >= bufferTileX) continue;
                GE.fillRect(graphics, n6, n5, tileWidth, tileHeight, mapColor);
                if ((bufferLevelFlag & 2) != 0 && (n8 = j < 0 || j >= bufferTileX || i < 0 || i >= bufferTileY ? -1 : bufferMapBgTileData[j][i] & 0xFF) > 0) {
                    sArray = mapBuffClips[--n8];
                    s7 = sArray[0];
                    s6 = sArray[1];
                    s5 = sArray[2];
                    s4 = sArray[3];
                    s3 = sArray[4];
                    s2 = sArray[5];
                    s = GE.getResType(s7);
                    if (s == 1) {
                        n7 = s6 << 16 & s5;
                        GE.fillRect(graphics, n6, n5, s4, s3, n7);
                    } else if (s == 0) {
                        if (mapImgs[s7] == null) {
                            Map.loadImg(s7);
                        }
                        GE.setScreen(0, 0, mapBufferW, mapBufferH);
                        GE.drawImage(graphics, mapImgs[s7], s6, s5, s4, s3, s2, n6, n5, 0);
                        GE.resumeScreen();
                    }
                }
                if ((bufferLevelFlag & 4) != 0 && (n8 = j < 0 || j >= bufferTileX || i < 0 || i >= bufferTileY ? -1 : bufferMapSurTileData[j][i] & 0xFF) > 0) {
                    sArray = mapBuffClips[--n8];
                    s7 = sArray[0];
                    s6 = sArray[1];
                    s5 = sArray[2];
                    s4 = sArray[3];
                    s3 = sArray[4];
                    s2 = sArray[5];
                    s = GE.getResType(s7);
                    if (s == 1) {
                        n7 = (s6 << 16) + s5;
                        GE.fillRect(graphics, n6, n5, s4, s3, n7);
                    } else if (s == 0) {
                        if (mapImgs[s7] == null) {
                            Map.loadImg(s7);
                        }
                        GE.setScreen(0, 0, mapBufferW, mapBufferH);
                        GE.drawImage(graphics, mapImgs[s7], s6, s5, s4, s3, s2, n6, n5, 0);
                        GE.resumeScreen();
                    }
                }
                if ((n6 += tileWidth) < mapBufferW) continue;
                n6 -= mapBufferW;
            }
            if ((n5 += tileHeight) < mapBufferH) continue;
            n5 -= mapBufferH;
        }
    }

    public static int getTile(byte by, int n, int n2) {
        if (n < 0 || n >= tileX || n2 < 0 || n2 >= tileY) {
            return -1;
        }
        if (by == 1) {
            return mapDataPhyFlag[n][n2] & 0xFF;
        }
        if (by == 2) {
            return mapDataBgTile[n][n2] & 0xFF;
        }
        if (by == 4) {
            return mapDataSurTile[n][n2] & 0xFF;
        }
        return -1;
    }

    private static void copyFromBuffer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (graphics == null) {
            return;
        }
        graphics.setClip(n5, n6, n3, n4);
        graphics.drawImage(imgMapBuffer, n5 - n, n6 - n2, 0);
    }

    static {
        tileHeight = (short)16;
        tileWidth = (short)16;
        screenTrackV = 8;
        screenTrackStep = 6;
        heroStaySize = tileWidth;
        screenTrackStepMax = 16;
        soffx = (short)(4 * tileWidth);
    }
}

