/*
 * Decompiled with CFR 0.152.
 */
package com.neonplay.paperglider.game;

import com.neonplay.helper.ImageHelper;
import com.neonplay.helper.ImageLoader;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class GameView
extends GameCanvas
implements Runnable {
    private static final int VIRTUAL_SCREEN_WIDTH = 480;
    private static final int VIRTUAL_SCREEN_HEIGHT = 320;
    private static final int PLANE_WIDTH = 64;
    private static final int PLANE_HEIGHT = 24;
    private static final float FRICTION_SPEEDUP_VALUE = 500.0f;
    private static final float FRICTION_SLOWDOWN_VALUE = 300.0f;
    private static final float FRICTION_SPEEDUP_VALUE_OUTSIDE = 550.0f;
    private static final float FRICTION_SLOWDOWN_VALUE_OUTSIDE = 475.0f;
    private static final float Y_POSITION_VALUE = 0.3f;
    private static final float GRAVITY = 20.0f;
    private static final float GRAVITY_OUTSIDE = 12.0f;
    private static final float PLANE_XPOS_SPEED_THRESHOLD_VALUE = 0.1f;
    private static final float PLANE_XPOS_SPEED_VALUE = 0.5f;
    private static final float ANGLE_DESCENDING_VALUE = 5.0E-4f;
    private static final float ANGLE_CLIMBING_VALUE = 3.0E-4f;
    private static final float ANGLE_DESCENDING_VALUE_OUTSIDE = 6.0E-4f;
    private static final float ANGLE_CLIMBING_VALUE_OUTSIDE = 3.0E-4f;
    private static final float VELOCITY_ANGLE_THRESHOLD = 700.0f;
    private static final float VELOCITY_ANGLE_THRESHOLD_OUTSIDE = 800.0f;
    private static final float MAX_PLANE_ANGLE = 85.0f;
    private static final int PLANE_XPOS_VALUE = 100;
    private static final float WIND_BOOST_DECREMENT_VALUE = 20.0f;
    private static final float WIND_BOOST_INITIAL_VALUE = 100.0f;
    private static final float VELOCITY_BOOST = 200.0f;
    private static final float BACKGROUND_CITY_SCROLL_VALUE = 0.016f;
    private static final float BACKGROUND_CITY_SCROLL_ANGLE_VALUE = 5.0f;
    private static final int TOUCH_YPOS_BUFFER = 60;
    private static final float FLICK_TARGET_ANGLE_VALUE = 10.0f;
    private static final float FLICK_LEVEL_ANGLE_VALUE = 200.0f;
    private static final float FLICK_TIME_UNTIL_LEVEL_THE_PLANE = 0.3f;
    private static final float FLICK_PAUSE_TIME_BUFFER = 2.0f;
    private static final float VELOCITY_STARTING_BOOST = 12.0f;
    private static final float FLICK_VALUE = 750.0f;
    private static final float VELOCITY_MAX_VALUE = 1000.0f;
    private static final float VELOCITY_MINIMUM_VALUE = 600.0f;
    private static final float FLICK_MIN_PIXEL_DISTANCE = 6.0f;
    private Graphics g;
    private volatile Thread gameThread;
    float score;
    int best;
    private int touchOldX;
    private int touchOldY;
    private Image planeImage;
    private float planeX;
    private float planeY;
    private float planeVelocityX;
    private float planeVelocityY;
    private float planeAngle;
    private float planeSinAngle;
    private float planeCosAngle;
    private boolean windBoostActive;
    private float windBoostRemaining;
    private float targetWindBoostRemaining;
    private boolean planeMadeItThroughWindow;
    private float slowDownValue;
    private float planeTargetXPositionSpeed;
    private float targetXPosition;
    private boolean diveBomb;
    private boolean diveBombLift;
    private float angleThreshold;
    private float flickStartingX;
    private float flickStartingY;
    private boolean flightInProgress;
    private boolean flickingInProgress;
    private boolean keyboardLaunch;
    private boolean planeCanBeReleasedFromFlick;
    private boolean levelOutThePlane;
    private float flickTargetAngle;
    private float timeSinceFlickingMovement;
    private int pixelsMovedForFlick;
    private boolean angleDownKeyPressed;
    private boolean angleUpKeyPressed;
    private Image garden1BackgroundImage;
    private Image garden2BackgroundImage;
    private Image garden3BackgroundImage;
    private Image garden4BackgroundImage;
    private Image cityBackgroundImage;
    private Image countryBackgroundImage;
    private Image forestBackgroundImage;
    private Image nevadaBackgroundImage;
    private Image moonBackgroundImage;
    private Image houseBackgroundImage;
    private float backgroundScrollX;
    private int bgStage;
    private int bgPlaceInStage;
    private Image bgImage1;
    private Image bgImage2;
    private boolean bgHouse;
    private int houseScrollX;
    private Image pauseImage;
    private Image soundImage;
    private Image windBarImage;
    private Image emptyWindBarImage;
    private Image distanceImage;
    private Image bestImage;
    private Image windImage;
    private Image instructionsImage;
    private Image tapToBoostImage;
    private Image useWindWiselyImage;
    private Image[] numberImage;
    private long lastTime;

    public GameView() {
        super(false);
        this.setFullScreenMode(true);
        this.loadGraphics();
        this.reset();
    }

    public void showNotify() {
        System.out.println("showNotify");
        this.lastTime = System.currentTimeMillis();
        this.g = this.getGraphics();
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    protected void hideNotify() {
        System.out.println("hideNotify");
        this.gameThread = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        Image image = Image.createImage((int)this.getLandscapeWidth(), (int)this.getLandscapeHeight());
        while (this.gameThread == thread) {
            long l = System.currentTimeMillis();
            float f = (float)(l - this.lastTime) / 1000.0f;
            this.lastTime = l;
            this.update(f);
            this.render(image.getGraphics());
            if (this.isLandscape()) {
                this.g.drawImage(image, 0, 0, 20);
            } else {
                this.g.drawRegion(image, 0, 0, this.getLandscapeWidth(), this.getLandscapeHeight(), 6, 0, 0, 20);
            }
            this.flushGraphics();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void loadGraphics() {
        try {
            ImageLoader imageLoader = ImageLoader.getInstance();
            this.garden1BackgroundImage = imageLoader.loadImage("/bggarden1.png");
            this.garden2BackgroundImage = imageLoader.loadImage("/bggarden2.png");
            this.garden3BackgroundImage = imageLoader.loadImage("/bggarden3.png");
            this.garden4BackgroundImage = imageLoader.loadImage("/bggarden4.png");
            this.cityBackgroundImage = imageLoader.loadImage("/bgcity.png");
            this.countryBackgroundImage = imageLoader.loadImage("/bgcountry.png");
            this.forestBackgroundImage = imageLoader.loadImage("/bgforest.png");
            this.nevadaBackgroundImage = imageLoader.loadImage("/bgnevada.png");
            this.moonBackgroundImage = imageLoader.loadImage("/bgmoon.png");
            this.houseBackgroundImage = imageLoader.loadImage("/buildingtransition.png");
            this.planeImage = imageLoader.loadImage("/paper_plane.png");
            this.pauseImage = imageLoader.loadImage("/pause.png");
            this.soundImage = imageLoader.loadImage("/sound_on.png");
            this.windBarImage = imageLoader.loadImage("/windbar.png");
            this.emptyWindBarImage = imageLoader.loadImage("/windbar_empty.png");
            this.distanceImage = imageLoader.loadImage("/distance.png");
            this.bestImage = imageLoader.loadImage("/best.png");
            this.windImage = imageLoader.loadImage("/wind.png");
            this.instructionsImage = imageLoader.loadImage("/instructions.png");
            this.tapToBoostImage = imageLoader.loadImage("/taptoboost.png");
            this.useWindWiselyImage = imageLoader.loadImage("/usewindwisely.png");
            this.numberImage = new Image[10];
            for (int i = 0; i < 10; ++i) {
                this.numberImage[i] = imageLoader.loadImage("/num" + i + ".png");
            }
        }
        catch (IOException iOException) {
            System.out.println("Image loading error.");
        }
    }

    protected void reset() {
        this.score = 0.0f;
        this.best = 0;
        this.planeX = 100.0f;
        this.planeY = 100.0f;
        this.planeAngle = 0.0f;
        this.flickingInProgress = true;
        this.flightInProgress = false;
        this.keyboardLaunch = true;
        this.planeMadeItThroughWindow = false;
        this.slowDownValue = 300.0f;
        this.angleThreshold = 700.0f;
        this.targetXPosition = 192.0f;
        this.planeTargetXPositionSpeed = 100.0f;
        this.windBoostActive = false;
        this.windBoostRemaining = 100.0f;
        this.backgroundScrollX = 0.0f;
        this.bgStage = 0;
        this.bgPlaceInStage = 0;
        this.bgImage1 = this.garden1BackgroundImage;
        this.bgImage2 = this.garden2BackgroundImage;
        this.bgHouse = false;
        this.angleDownKeyPressed = false;
        this.angleUpKeyPressed = false;
    }

    protected void launchPlane(int n, int n2) {
        this.flickingInProgress = false;
        this.flightInProgress = true;
        float f = this.flickStartingX - (float)n;
        float f2 = this.flickStartingY - (float)n2;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        this.planeVelocityX = f3 * 0.3f * 12.0f;
        this.planeVelocityX -= this.timeSinceFlickingMovement * 750.0f;
        System.out.println("Launch velocity = " + this.planeVelocityX + " angle " + this.planeAngle);
        if (this.planeVelocityX <= 600.0f || (float)this.pixelsMovedForFlick < 6.0f) {
            this.planeVelocityX = 600.0f;
        } else if (this.planeVelocityX > 1000.0f) {
            this.planeVelocityX = 1000.0f;
        }
        System.out.println("Launch velocity = " + this.planeVelocityX + " angle " + this.planeAngle);
        this.planeVelocityX = 900.0f;
    }

    protected void update(float f) {
        this.updatePlane(f);
        this.updateBackground(f);
        if (this.planeY < -30.0f || this.planeY > 480.0f) {
            this.reset();
        }
    }

    protected void updateBackground(float f) {
        if (this.flightInProgress) {
            float f2 = Math.abs(this.planeVelocityX * 0.016f - this.planeSinAngle * 5.0f);
            this.backgroundScrollX += (f2 *= 30.0f * f);
            if (this.bgHouse) {
                this.houseScrollX = (int)((float)this.houseScrollX + f2);
                if (this.houseScrollX >= 512) {
                    this.bgHouse = false;
                }
            }
            this.score += f2;
            while (this.backgroundScrollX > 512.0f) {
                this.backgroundScrollX -= 512.0f;
                this.bgImage1 = this.bgImage2;
                ++this.bgPlaceInStage;
                if (this.bgStage == 0) {
                    if (this.bgPlaceInStage >= 3) {
                        ++this.bgStage;
                        this.bgPlaceInStage = 0;
                        this.planeMadeItThroughWindow = true;
                    }
                } else if (this.bgPlaceInStage >= 16) {
                    this.bgHouse = true;
                    this.houseScrollX = -480;
                    ++this.bgStage;
                    this.bgPlaceInStage = 0;
                    if (this.bgStage >= 6) {
                        this.bgStage = 1;
                    }
                }
                switch (this.bgStage) {
                    case 0: {
                        if (this.bgPlaceInStage == 0) {
                            this.bgImage2 = this.garden2BackgroundImage;
                        }
                        if (this.bgPlaceInStage == 1) {
                            this.bgImage2 = this.garden3BackgroundImage;
                        }
                        if (this.bgPlaceInStage != 2) break;
                        this.bgImage2 = this.garden4BackgroundImage;
                        break;
                    }
                    case 1: {
                        this.bgImage2 = this.cityBackgroundImage;
                        break;
                    }
                    case 2: {
                        this.bgImage2 = this.countryBackgroundImage;
                        break;
                    }
                    case 3: {
                        this.bgImage2 = this.forestBackgroundImage;
                        break;
                    }
                    case 4: {
                        this.bgImage2 = this.nevadaBackgroundImage;
                        break;
                    }
                    case 5: {
                        this.bgImage2 = this.moonBackgroundImage;
                    }
                }
            }
        }
    }

    protected void updatePlane(float f) {
        if (this.flickingInProgress) {
            if (this.angleUpKeyPressed) {
                System.out.println("angle up");
                this.planeCanBeReleasedFromFlick = true;
                this.timeSinceFlickingMovement = 0.0f;
                this.flickTargetAngle += f * 200.0f;
                if (this.flickTargetAngle > 89.0f) {
                    this.flickTargetAngle = 89.0f;
                }
            } else if (this.angleDownKeyPressed) {
                System.out.println("angle down");
                this.planeCanBeReleasedFromFlick = true;
                this.timeSinceFlickingMovement = 0.0f;
                this.flickTargetAngle -= f * 200.0f;
                if (this.flickTargetAngle < -89.0f) {
                    this.flickTargetAngle = -89.0f;
                }
            }
            this.timeSinceFlickingMovement += f;
            if (this.timeSinceFlickingMovement > 0.3f && this.planeAngle != 0.0f && !this.keyboardLaunch) {
                this.levelOutThePlane = true;
            }
            if (this.levelOutThePlane) {
                if (this.planeAngle > 0.0f) {
                    this.planeAngle -= 200.0f * f;
                    if (this.planeAngle < 0.0f) {
                        this.planeAngle = 0.0f;
                        this.levelOutThePlane = false;
                        this.flickTargetAngle = 0.0f;
                    }
                } else {
                    this.planeAngle += 200.0f * f;
                    if (this.planeAngle > 0.0f) {
                        this.planeAngle = 0.0f;
                        this.levelOutThePlane = false;
                        this.flickTargetAngle = 0.0f;
                    }
                }
                double d = Math.toRadians(this.planeAngle);
                this.planeSinAngle = (float)Math.sin(d);
                this.planeCosAngle = (float)Math.cos(d);
            } else {
                if (this.planeAngle != this.flickTargetAngle) {
                    if (this.flickTargetAngle != 0.0f) {
                        this.planeAngle += this.flickTargetAngle * 10.0f * f;
                    } else if (this.planeAngle > 0.0f) {
                        this.planeAngle -= 10.0f * f;
                        if (this.planeAngle < 0.0f) {
                            this.planeAngle = 0.0f;
                        }
                    } else {
                        this.planeAngle -= 10.0f * f;
                        if (this.planeAngle > 0.0f) {
                            this.planeAngle = 0.0f;
                        }
                    }
                }
                if (this.flickTargetAngle > 0.0f) {
                    if (this.planeAngle > this.flickTargetAngle) {
                        this.planeAngle = this.flickTargetAngle;
                    }
                } else if (this.planeAngle < this.flickTargetAngle) {
                    this.planeAngle = this.flickTargetAngle;
                }
                double d = Math.toRadians(this.planeAngle);
                this.planeSinAngle = (float)Math.sin(d);
                this.planeCosAngle = (float)Math.cos(d);
            }
        } else if (this.flightInProgress) {
            float f2;
            float f3 = this.planeX;
            float f4 = this.planeY;
            if (this.windBoostActive && this.windBoostRemaining > 0.0f) {
                this.windBoostRemaining -= 20.0f * f;
                if (this.windBoostRemaining < 0.0f) {
                    this.windBoostRemaining = 0.0f;
                    this.windBoostActive = false;
                }
                this.targetWindBoostRemaining = this.windBoostRemaining;
                this.planeVelocityX += 200.0f * f;
            }
            if (this.planeMadeItThroughWindow && this.slowDownValue != 475.0f) {
                this.slowDownValue += 12.0f * f;
                if (this.slowDownValue > 475.0f) {
                    this.slowDownValue = 475.0f;
                }
            }
            float f5 = this.planeMadeItThroughWindow ? 550.0f : 500.0f;
            float f6 = this.planeSinAngle > 0.0f ? this.slowDownValue * this.planeSinAngle : f5 * this.planeSinAngle;
            this.planeVelocityX -= f6 * f;
            if (this.planeMadeItThroughWindow) {
                f2 = 2.0f;
                this.planeVelocityX -= f2 * f;
            }
            this.planeY += this.planeVelocityX * -this.planeSinAngle * 0.3f * f;
            f2 = this.planeMadeItThroughWindow ? 12.0f : 20.0f;
            this.planeY += f2 * f;
            this.planeTargetXPositionSpeed -= 0.5f * f;
            if (this.planeTargetXPositionSpeed < 0.1f) {
                this.planeTargetXPositionSpeed = 0.1f;
            }
            if (this.planeX > this.targetXPosition) {
                this.planeX -= this.planeTargetXPositionSpeed * f;
                if (this.planeX < this.targetXPosition) {
                    this.planeX = this.targetXPosition;
                }
            } else if (this.planeX < this.targetXPosition) {
                this.planeX += this.planeTargetXPositionSpeed * f;
                if (this.planeX > this.targetXPosition) {
                    this.planeX = this.targetXPosition;
                }
            }
            if (!this.diveBomb) {
                float f7;
                float f8 = this.planeMadeItThroughWindow ? 6.0E-4f : 5.0E-4f;
                float f9 = f7 = this.planeMadeItThroughWindow ? 3.0E-4f : 3.0E-4f;
                if (this.planeMadeItThroughWindow && this.angleThreshold != 800.0f) {
                    this.angleThreshold += 10.0f * f;
                    if (this.angleThreshold > 800.0f) {
                        this.angleThreshold = 800.0f;
                    }
                }
                this.planeAngle = this.planeVelocityX - this.angleThreshold < 0.0f ? (this.planeAngle -= (this.planeVelocityX - this.angleThreshold) * (this.planeVelocityX - this.angleThreshold) * f8 * f) : (this.planeAngle += (this.planeVelocityX - this.angleThreshold) * (this.planeVelocityX - this.angleThreshold) * f7 * f);
                this.planeAngle -= 20.0f * f;
                if (this.planeAngle > 85.0f) {
                    this.planeAngle = 85.0f;
                } else if (this.planeAngle < -85.0f && !this.diveBomb) {
                    this.planeAngle = -85.0f;
                    this.diveBomb = true;
                    System.out.println("Nose diving");
                }
                double d = Math.toRadians(this.planeAngle);
                this.planeSinAngle = (float)Math.sin(d);
                this.planeCosAngle = (float)Math.cos(d);
            } else {
                if (this.planeAngle < -95.0f || this.diveBombLift) {
                    if (this.planeAngle < -95.0f) {
                        this.diveBombLift = true;
                    }
                    if (this.planeAngle > -85.0f) {
                        this.diveBombLift = false;
                    }
                    this.planeAngle += (this.planeVelocityX - 700.0f) * (this.planeVelocityX - 700.0f) * 3.0E-4f * f;
                } else {
                    this.planeAngle -= (this.planeVelocityX - 700.0f) * (this.planeVelocityX - 700.0f) * 5.0E-4f * f;
                }
                double d = Math.toRadians(this.planeAngle);
                this.planeSinAngle = (float)Math.sin(d);
                this.planeCosAngle = (float)Math.cos(d);
            }
        }
    }

    private void updateHasThePlaneGoneOffScreen(float f) {
    }

    protected void render(Graphics graphics) {
        int n = this.getLandscapeWidth();
        int n2 = this.getLandscapeHeight();
        int n3 = (int)(this.backgroundScrollX * (float)n2 / 320.0f);
        graphics.drawImage(this.bgImage1, -n3, 0, 4 | 0x10);
        if (n3 > n - this.cityBackgroundImage.getWidth()) {
            graphics.drawImage(this.bgImage2, -n3 + this.cityBackgroundImage.getWidth(), 0, 4 | 0x10);
        }
        if (this.bgHouse) {
            n3 = this.houseScrollX * n2 / 320;
            graphics.drawImage(this.houseBackgroundImage, -n3, 0, 4 | 0x10);
        }
        Image image = ImageHelper.rotateImage(this.planeImage, -this.planeAngle);
        graphics.drawImage(image, (int)this.planeX * n / 480, (int)this.planeY * n2 / 320, 1 | 2);
        graphics.drawImage(this.pauseImage, 0, n2 - 25, 4 | 0x10);
        graphics.drawImage(this.soundImage, n, n2 - 25, 8 | 0x10);
        int n4 = n - this.emptyWindBarImage.getWidth() >> 1;
        int n5 = (int)(174.0f * this.windBoostRemaining / 100.0f);
        graphics.drawImage(this.windImage, n >> 1, 3, 1 | 0x10);
        graphics.drawImage(this.emptyWindBarImage, n4, 20, 4 | 0x10);
        graphics.setClip(n4 + 2, 0, n5, n2);
        graphics.drawImage(this.windBarImage, n4, 20, 4 | 0x10);
        graphics.setClip(0, 0, n, n2);
        graphics.drawImage(this.distanceImage, 4, 3, 4 | 0x10);
        this.renderNumber(graphics, (int)this.score, 4, 20, 4 | 0x10);
        graphics.drawImage(this.bestImage, n - 4, 3, 8 | 0x10);
        this.renderNumber(graphics, this.best, n - 4, 20, 8 | 0x10);
    }

    protected void renderNumber(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 & (0x10 | 2 | 0x20);
        int n7 = n;
        int n8 = 0;
        do {
            n5 = n7 % 10;
            n8 += this.numberImage[n5].getWidth() - 4;
        } while ((n7 /= 10) != 0);
        n2 = (n4 & 4) != 0 ? (n2 += n8) : ((n4 & 1) != 0 ? (n2 += n8 - 4 >> 1) : (n2 -= 4));
        n7 = n;
        do {
            n5 = n7 % 10;
            graphics.drawImage(this.numberImage[n5], n2 -= this.numberImage[n5].getWidth() - 4, n3, 4 | n6);
            n8 += this.numberImage[n5].getWidth() - 4;
        } while ((n7 /= 10) != 0);
    }

    protected void pointerPressed(int n, int n2) {
        if (!this.isLandscape()) {
            int n3 = n;
            n = this.getHeight() - n2;
            n2 = n3;
        }
        n = n * 480 / this.getLandscapeWidth();
        n2 = n2 * 320 / this.getLandscapeHeight();
        if (!this.flightInProgress) {
            this.flickingInProgress = true;
            this.keyboardLaunch = false;
            this.planeX = n;
            this.planeY = n2 - 60;
            this.flickStartingX = n;
            this.flickStartingY = n2;
            this.timeSinceFlickingMovement = 0.0f;
            this.planeCanBeReleasedFromFlick = false;
            this.pixelsMovedForFlick = 0;
        } else if (this.windBoostRemaining > 0.0f) {
            this.windBoostActive = true;
        }
        this.touchOldX = n;
        this.touchOldY = n2;
    }

    protected void pointerDragged(int n, int n2) {
        int n3;
        if (!this.isLandscape()) {
            n3 = n;
            n = this.getHeight() - n2;
            n2 = n3;
        }
        n = n * 480 / this.getLandscapeWidth();
        n2 = n2 * 320 / this.getLandscapeHeight();
        if (this.flickingInProgress) {
            this.keyboardLaunch = false;
            this.planeX = n;
            this.planeY = n2 - 60;
            float f = n > this.touchOldX ? (float)(n - this.touchOldX) : (float)(this.touchOldX - n);
            if (f > (float)(n3 = 2)) {
                this.timeSinceFlickingMovement = 0.0f;
                this.levelOutThePlane = false;
                this.planeCanBeReleasedFromFlick = false;
            }
            boolean bl = false;
            if (n < this.touchOldX) {
                bl = true;
                this.planeCanBeReleasedFromFlick = false;
                this.pixelsMovedForFlick = 0;
            } else {
                if (!this.planeCanBeReleasedFromFlick) {
                    this.timeSinceFlickingMovement = 0.0f;
                    this.planeCanBeReleasedFromFlick = true;
                    this.flickStartingX = n;
                    this.flickStartingY = n2;
                }
                this.pixelsMovedForFlick = (int)((float)this.pixelsMovedForFlick + f);
            }
            float f2 = this.touchOldY - n2;
            float f3 = n - this.touchOldX;
            if (f2 != 0.0f || f3 != 0.0f) {
                float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
                float f5 = (float)Math.toDegrees(GameView.asin(f2 / f4));
                if (bl) {
                    f5 = -f5;
                }
                this.flickTargetAngle = f5;
            }
        }
        this.touchOldX = n;
        this.touchOldY = n2;
    }

    protected void pointerReleased(int n, int n2) {
        if (!this.isLandscape()) {
            int n3 = n;
            n = this.getHeight() - n2;
            n2 = n3;
        }
        n = n * 480 / this.getLandscapeWidth();
        n2 = n2 * 320 / this.getLandscapeHeight();
        if (this.timeSinceFlickingMovement < 2.0f && this.flickingInProgress && !this.flightInProgress) {
            if (this.planeCanBeReleasedFromFlick) {
                this.launchPlane(n, n2);
            }
        } else {
            this.windBoostActive = false;
        }
    }

    protected void keyPressed(int n) {
        System.out.println("Key pressed " + n);
        switch (n) {
            case -1: 
            case 50: {
                if (!this.isLandscape()) break;
                this.angleUpKeyPressed = true;
                this.keyboardLaunch = true;
                break;
            }
            case -2: 
            case 56: {
                if (!this.isLandscape()) break;
                this.angleDownKeyPressed = true;
                this.keyboardLaunch = true;
                break;
            }
            case -3: 
            case 52: {
                if (this.isLandscape()) break;
                this.angleUpKeyPressed = true;
                this.keyboardLaunch = true;
                break;
            }
            case -4: 
            case 54: {
                if (this.isLandscape()) break;
                this.angleDownKeyPressed = true;
                this.keyboardLaunch = true;
                break;
            }
            case -5: 
            case 53: {
                if (!this.flightInProgress) {
                    this.launchPlane((int)this.planeX, (int)this.planeY);
                    break;
                }
                this.windBoostActive = true;
            }
        }
    }

    protected void keyReleased(int n) {
        System.out.println("Key released " + n);
        switch (n) {
            case -1: 
            case 50: {
                this.angleUpKeyPressed = false;
                break;
            }
            case -2: 
            case 56: {
                this.angleDownKeyPressed = false;
                break;
            }
            case -3: 
            case 52: {
                this.angleUpKeyPressed = false;
                break;
            }
            case -4: 
            case 54: {
                this.angleDownKeyPressed = false;
                break;
            }
            case -5: 
            case 53: {
                this.windBoostActive = false;
            }
        }
    }

    public boolean isLandscape() {
        return this.getWidth() > this.getHeight();
    }

    public int getLandscapeWidth() {
        int n;
        int n2 = this.getWidth();
        return n2 > (n = this.getHeight()) ? n2 : n;
    }

    public int getLandscapeHeight() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        return n2 < n ? n2 : n;
    }

    public static double asin(double d) {
        double d2 = d;
        while (Math.abs(Math.sin(d2 -= (Math.sin(d2) - d) / Math.cos(d2)) - d) > 0.001) {
        }
        return d2;
    }
}

