/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.game;

import bbs.framework.helper.BBSFunctions;
import bbs.framework.interfaces.BBSIGame;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSObjectFactory;
import bbs.framework.models.BBSSmartSprite;
import bbs.framework.starter.BBSStarter;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class BBSSmartGame
extends BBSGame
implements BBSIGame {
    public BBSSmartSprite[] smarts;
    private Vector smrt = new Vector();
    public BBSObjectFactory factory = this.getObjectFactory();

    public BBSSmartGame(BBSStarter inst) {
        super(inst);
    }

    protected abstract BBSObjectFactory getObjectFactory();

    protected final void doSmarts(int time) {
        if (this.gameState != 6 && this.smarts != null) {
            for (int cnt = 0; cnt < this.smarts.length; ++cnt) {
                this.smarts[cnt].doAnimation(this, time);
            }
        }
    }

    public final void classAnimation(int time) {
        this.doSmarts(time);
    }

    protected final void drawSmarts(BBSSmartSprite[] series, Graphics g, int zorder, int tx, int ty) {
        if (series != null) {
            for (int cnt = 0; cnt < series.length; ++cnt) {
                if (series[cnt].zorder != zorder || series[cnt].rSprite == null) continue;
                for (int subcnt = 0; subcnt < series[cnt].rSprite.length; ++subcnt) {
                    if (zorder == 0 && (zorder != 0 || tx != series[cnt].rSprite[subcnt].x / this.tileSet.tileWidth || ty != series[cnt].rSprite[subcnt].y / this.tileSet.tileHeight)) continue;
                    series[cnt].draw(this, g, subcnt);
                }
            }
        }
    }

    protected final void drawSmartSeries(BBSSmartSprite[] series, Graphics g) {
        if (series != null) {
            for (int cnt = 0; cnt < series.length; ++cnt) {
                if (series[cnt].rSprite == null) continue;
                for (int subcnt = 0; subcnt < series[cnt].rSprite.length; ++subcnt) {
                    series[cnt].draw(this, g, subcnt);
                }
            }
        }
    }

    public final int interract(BBSSmartSprite sprite, int action) {
        int ret = 0;
        if (this.smarts != null) {
            for (int cnt = 0; cnt < this.smarts.length && (this.smarts[cnt].id == sprite.id || (ret = this.smarts[cnt].interract(this, sprite, action)) <= 0); ++cnt) {
            }
        }
        return ret;
    }

    protected final String[][] loadObjects(int level) {
        String[] cols;
        byte[] content = BBSFunctions.loadData(this, "objects/stage" + String.valueOf(level) + ".lev");
        for (int cnt = 0; cnt < content.length; ++cnt) {
            content[cnt] = content[cnt];
        }
        String[] rows = BBSFunctions.splitString(new String(content), new String(new char[]{'\r', '\n'}));
        content = null;
        String[][] objs = new String[rows.length][];
        for (int cnt = 0; cnt < rows.length; ++cnt) {
            cols = BBSFunctions.splitString(rows[cnt], ",");
            objs[cnt] = new String[cols.length];
            System.arraycopy(cols, 0, objs[cnt], 0, cols.length);
        }
        cols = null;
        rows = null;
        return objs;
    }

    public void addSmart(BBSSmartSprite smart) {
        this.smrt.addElement(smart);
    }

    public BBSSmartSprite getSmart(int id) {
        return (BBSSmartSprite)this.smrt.elementAt(id - 1);
    }

    protected final void createSmarts() {
        this.smarts = new BBSSmartSprite[this.smrt.size()];
        this.smrt.copyInto(this.smarts);
        this.smrt.removeAllElements();
    }

    public void clearCache() {
        this.smarts = null;
        super.clearCache();
    }

    public final void drawSpriteLayerSprites(Graphics g, int tx, int ty) {
        this.drawSmarts(this.smarts, g, 0, tx, ty);
    }

    public final void drawLayerSprites(Graphics g, int zorder) {
        this.drawSmarts(this.smarts, g, zorder, 0, 0);
    }
}

