/*
 * Decompiled with CFR 0.152.
 */
package com.downjoy.j2me.smspack.util;

import com.downjoy.j2me.smspack.util.SMSPackInfoVO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RmsUtil {
    private static final int recordId = 1;

    private static RecordStore getRecordStore(String cpId, String gameId, String actionId) {
        if (actionId == null || actionId.length() == 0) {
            actionId = "00";
        }
        RecordStore rms = null;
        try {
            rms = RecordStore.openRecordStore((String)RmsUtil.getRecordStoreName(cpId, gameId, actionId), (boolean)true, (int)1, (boolean)true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return rms;
    }

    public static String getRecordStoreName(String cpId, String gameId, String actionId) {
        StringBuffer sb = new StringBuffer();
        sb.append("dcn").append(cpId).append(gameId).append(actionId);
        return sb.toString();
    }

    public static boolean isPayFinish(String cpId, String gameId, String actionId, int fee) {
        RecordStore recordStore = RmsUtil.getRecordStore(cpId, gameId, actionId);
        if (recordStore == null) {
            return false;
        }
        try {
            if (recordStore.getNumRecords() == 0) {
                return false;
            }
            byte[] buf = new byte[recordStore.getRecordSize(1)];
            int len = recordStore.getRecord(1, buf, 0);
            ByteArrayInputStream bis = new ByteArrayInputStream(buf, 0, len);
            DataInputStream dis = new DataInputStream(bis);
            int payedMoney = dis.readInt();
            bis.close();
            dis.close();
            boolean bl = payedMoney >= fee;
            return bl;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        return false;
    }

    public static SMSPackInfoVO loadFromRecordStore(String cpId, String gameId, String actionId, int fee) {
        RecordStore recordStore = RmsUtil.getRecordStore(cpId, gameId, actionId);
        if (recordStore == null) {
            return null;
        }
        try {
            if (recordStore.getNumRecords() == 0) {
                return null;
            }
            byte[] buf = new byte[recordStore.getRecordSize(1)];
            int len = recordStore.getRecord(1, buf, 0);
            ByteArrayInputStream bis = new ByteArrayInputStream(buf, 0, len);
            DataInputStream dis = new DataInputStream(bis);
            SMSPackInfoVO smsPackInfo = new SMSPackInfoVO();
            int payedMoney = dis.readInt();
            smsPackInfo.setPayedMoney(payedMoney);
            if (payedMoney < fee && buf.length > 4) {
                smsPackInfo.setFeeSMSUnitPrice(dis.readInt());
                smsPackInfo.setFeeSMSNum(dis.readUTF());
                smsPackInfo.setFeeSMSContent(dis.readUTF());
                smsPackInfo.setFeeSMSTitle(dis.readUTF());
                smsPackInfo.setFeeSMSCnt(dis.readInt());
                smsPackInfo.setFreeSMSNum(dis.readUTF());
                smsPackInfo.setFreeSMSContent(dis.readUTF());
                smsPackInfo.setNeedConfirm(dis.readBoolean());
                smsPackInfo.setSendedCnt(dis.readInt());
                smsPackInfo.setLastSendFreeTime(dis.readLong());
            }
            bis.close();
            dis.close();
            SMSPackInfoVO sMSPackInfoVO = smsPackInfo;
            return sMSPackInfoVO;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        return null;
    }

    public static void savePayResult(SMSPackInfoVO smsPackInfo, String cpId, String gameId, String actionId, int fee) {
        block17: {
            RecordStore recordStore = RmsUtil.getRecordStore(cpId, gameId, actionId);
            if (recordStore != null) {
                try {
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        DataOutputStream dos = new DataOutputStream(bos);
                        dos.writeInt(smsPackInfo.getPayedMoney());
                        if (smsPackInfo.getPayedMoney() < fee) {
                            dos.writeInt(smsPackInfo.getFeeSMSUnitPrice());
                            dos.writeUTF(smsPackInfo.getFeeSMSNum());
                            dos.writeUTF(smsPackInfo.getFeeSMSContent());
                            dos.writeUTF(smsPackInfo.getFeeSMSTitle());
                            dos.writeInt(smsPackInfo.getFeeSMSCnt());
                            dos.writeUTF(smsPackInfo.getFreeSMSNum());
                            dos.writeUTF(smsPackInfo.getFreeSMSContent());
                            dos.writeBoolean(smsPackInfo.isNeedConfirm());
                            dos.writeInt(smsPackInfo.getSendedCnt());
                            dos.writeLong(smsPackInfo.getLastSendFreeTime());
                        }
                        byte[] data = bos.toByteArray();
                        if (recordStore.getNumRecords() == 0) {
                            recordStore.addRecord(data, 0, data.length);
                            break block17;
                        }
                        recordStore.setRecord(1, data, 0, data.length);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        try {
                            recordStore.closeRecordStore();
                        }
                        catch (RecordStoreNotOpenException e3) {
                            e3.printStackTrace();
                        }
                        catch (RecordStoreException e4) {
                            e4.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        recordStore.closeRecordStore();
                    }
                    catch (RecordStoreNotOpenException e5) {
                        e5.printStackTrace();
                    }
                    catch (RecordStoreException e6) {
                        e6.printStackTrace();
                    }
                }
            }
        }
    }
}

