import javax.microedition.lcdui.*;
import java.io.*;

/**
 * <p>Title: GameMap</p>
 * <p>Description: GameMap</p>
 * <p>Copyright: Copyright (c) 2009-12-09</p>
 * <p>Company: songge</p>
 * @version 1.0
 */

public final class GameMap {
  static int screenWidth; //Ļ
  static int screenHeight; //Ļ߶
  static byte tileWidth; //ƬĿ
  static byte tileHight; //Ƭĸ߶
  static int[] mapSize = new int[2]; //ͼС :[gameRank][0] ->ͼƬ [gameRank][1] ->ͼߵƬ

//  short[][] tileProperties = new short[2][];
//  String[][] name = new String[2][];
//  static byte[][] mapData = new byte[2][]; //ͼ

  static int setOffX; //Ļ
  static int setOffY;

  static GameEngine engine;
  //  ͼ
  public static final short L_TILE = 20; //ر
  public static final short L_ROLESD = 30; //ӰӲ
  public static final short L_LEV = 31; //лϵͼ
  public static final short L_HIGH = 2000; //߲װ
  public static final short L_TALK = 5000; // ԻӲ
  public static final short L_MAX = 9000; // ߲
  public static final short L_BBG = 10; // ս
  public static final short L_OVERBBG = 20; // ս
  public static final short L_BFLASH = 350; // ս

  public static final short L_EFF = 40; // ս
  public static final short L_LOOK = 3000; // Ұɰ

  public GameMap(GameEngine en, int sw, int sh) {
    screenWidth = sw;
    screenHeight = sh;
    setOff(0, 0);
    engine = en;
  }

  //ͷԴ
  public void free() {
    mData = null;
    mProperties = null;
    mName = null;
    stopStar();
    rainFree();
  }

  /****************************ͨűϢؿͼ******************************/
  short mapID;
  short mapName;
  short fileName;
  static short BGM;
  short enemys;
//  int enemyLevel;
  static short battleBg;
  short openEffect;
  short closeEffect;
  static short weather; //

  public void init(short[] dat) {
    mapID = (short) Event.getInt(dat[0]);
    mapName = dat[1];
    fileName = dat[2];
    weather = (short) Event.getInt(dat[3]);
    battleBg = (short) Event.getInt(dat[4]);
    BGM = (short) Event.getInt(dat[5]);
    enemys = dat[6];
  }

//  public void init(String dat) {
//    String[] param = Event.splitString(dat, " ");
//    if (param[0].equals("id")) {
//      mapID = (byte) Event.sToi(param[1]);
//    }
//    else if (param[0].equals("name")) {
//      mapName = param[1];
//    }
//    else if (param[0].equals("dat")) {
//      fileName = param[1];
//    }
//    else if (param[0].equals("weather")) {
//      weather = Event.sToi(param[1]);
//    }
//    else if (param[0].equals("BGM")) {
//      BGM = Event.sToi(param[1]);
//    }
//    else if (param[0].equals("enemys")) {
//      if (param[1].equals("null")) {
//        enemys = null;
//      }
//      else {
//        String[] s = Event.splitString(param[1], ",");
//        enemys = new short[s.length];
//        for (int j = 0; j < enemys.length; j++) {
//          enemys[j] = (byte) Event.sToi(s[j]);
//        }
//      }
//    }
//    else if (param[0].equals("battleBg")) {
//      battleBg = (short) Event.sToi(param[1]);
//    }
//  }

  /****************************SETOFFXY******************************/
  public static void setOff(int x, int y) {
    setOffX = x;
    setOffY = y;
  }

  /****************************ͼװ******************************/
  public static final byte ITEM_TYPE = 0;
  public static final byte ITEM_X = 1;
  public static final byte ITEM_Y = 2;
  public static final byte ITEM_TR = 3;

  public static final byte OBJ_ID = 0;
  public static final byte OBJ_IMG = 1;
  public static final byte OBJ_ADDX = 2;
  public static final byte OBJ_ADDY = 3;
  public static final byte OBJ_W = 4;
  public static final byte OBJ_H = 5;
  public static final byte OBJ_DL = 6;

//  short[][] objData = {
//      {
//      -1, Tools.IMG_D0, -16, 0, 48, 32, 0} /* (0)  0.png*/
//      , {
//      1, Tools.IMG_D1, -32, 0, 32, 32, 0} /* (1)  1.png*/
//      , {
//      2, Tools.IMG_D2, -16, 0, 48, 32, 0} /* (2)  2.png*/
//      , {
//      3, Tools.IMG_D3, 0, 0, 48, 32,0} /* (3)  3.png*/
//      , {
//      4, Tools.IMG_D4, 0, 0, 48, 48,0} /* (4)  4.png*/
//      , {
//      5, Tools.IMG_D5, 0, 0, 32, 64,0} /* (5)  5.png*/
//      , {
//      6, Tools.IMG_D6, 0, 0, 32, 96,0} /* (6)  6.png*/
//      , {
//      7, Tools.IMG_D7, 0, 0, 32, 96,0} /* (7)  7.png*/
//      , {
//      8, Tools.IMG_D8, 0, 0, 32, 96,0} /* (8)  8.png*/
//      , {
//      9, Tools.IMG_D9, 0, 0, 16, 16,0} /* (9)  9.png*/
//      , {
//      10, Tools.IMG_D10, 0, 0, 48, 16,0} /* (10)  10.png*/
//      , {
//      11, Tools.IMG_D11, 0, 0, 48, 16,0} /* (11)  11.png*/
//      , {
//      12, Tools.IMG_D12, 0, 0, 48, 16,0} /* (12)  12.png*/
//      , {
//      13, Tools.IMG_D13, 0, 0, 64, 16,0} /* (13)  13.png*/
//      , {
//      14, Tools.IMG_D14, 0, 0, 64, 16,0} /* (14)  14.png*/
//      , {
//      15, Tools.IMG_D15, 0, 0, 64, 16,0} /* (15)  15.png*/
//      , {
//      16, Tools.IMG_D16, 0, 0, 64, 16,0} /* (16)  16.png*/
//      , {
//      17, Tools.IMG_D17, 0, 0, 32, 64,0} /* (17)  17.png*/
//      , {
//      18, Tools.IMG_D18, 0, 0, 32, 64,0} /* (18)  18.png*/
//      , {
//      19, Tools.IMG_D19, 0, 0, 32, 64,0} /* (19)  19.png*/
//      , {
//      20, Tools.IMG_D20, 0, 0, 32, 64,0} /* (20)  20.png*/
//      , {
//      21, Tools.IMG_D21, 0, 0, 16, 48,0} /* (21)  21.png*/
//      , {
//      22, Tools.IMG_D22, 0, 0, 0, 0,0} /* (22)  22.png*/
//      , {
//      23, Tools.IMG_D23, 0, 0, 0, 0,0} /* (23)  23.png*/
//      , {
//      24, Tools.IMG_D24, 0, 0, 0, 0,0} /* (24)  24.png*/
//      , {
//      25, Tools.IMG_D25, 0, 0, 32, 48,0} /* (25)  25.png*/
//      , {
//      26, Tools.IMG_D26, 0, 0, 32, 80,0} /* (26)  26.png*/
//      , {
//      27, Tools.IMG_D27, 0, 0, 32, 26,0} /* (27)  27.png*/
//      , {
//      28, Tools.IMG_D28, 0, 0, 32, 64,0} /* (28)  28.png*/
//      , {
//      29, Tools.IMG_D29, 0, 0, 64, 80,0} /* (29)  29.png*/
//      , {
//      30, Tools.IMG_D30, 0, 0, 32, 16, 0} /* (30)  30.png*/
//      , {
//      31, Tools.IMG_D31, 0, 0, 32, 48, 0} /* (31)  31.png*/
//      , {
//      56, Tools.IMG_D56, 3, -2, 0, 0, 0} /* (56)  .png*/
//
//};
  short[][] objData = {
      {
      -1, Tools.IMG_D0, -16, 0, 48, 32, 0} /* (0)  0.png*/
      , {
      1, Tools.IMG_D1, -16, 0, 48, 32, 0} /* (1)  1.png*/
      , {
      2, Tools.IMG_D2, -16, 0, 48, 32, 0} /* (2)  2.png*/
      , {
      3, Tools.IMG_D3, 0, 0, 48, 32, 0} /* (3)  3.png*/
      , {
      4, Tools.IMG_D4, 0, 0, 48, 48, 0} /* (4)  4.png*/
      , {
      5, Tools.IMG_D5, 0, 0, 32, 64, 0} /* (5)  5.png*/
      , {
      6, Tools.IMG_D6, 0, 0, 32, 16, 0} /* (6)  6.png*/
      , {
      7, Tools.IMG_D6, 0, 0, 32, 16, 0} /* (7)  7.png*/
      , {
      8, Tools.IMG_D6, 0, 0, 32, 16, 0} /* (8)  8.png*/
      , {
      9, Tools.IMG_D9, 0, 0, 16, 16, 0} /* (9)  9.png*/
      , {
      10, Tools.IMG_D10, 0, 0, 0, 0, 1} /* (10)  10.png*/
      , {
      11, Tools.IMG_D11, 0, 0, 0, 0, 1} /* (11)  11.png*/
      , {
      12, Tools.IMG_D12, 0, 0, 0, 0, 1} /* (12)  12.png*/
      , {
      13, Tools.IMG_D13, 0, 0, 0, 0, 1} /* (13)  13.png*/
      , {
      14, Tools.IMG_D14, 0, 0, 0, 0, 1} /* (14)  14.png*/
      , {
      15, Tools.IMG_D15, 0, 0, 0, 0, 1} /* (15)  15.png*/
      , {
      16, Tools.IMG_D16, 0, 0, 0, 0, 1} /* (16)  16.png*/
      , {
      17, Tools.IMG_D17, 0, 0, 32, 64, 1} /* (17)  17.png*/
      , {
      18, Tools.IMG_D18, 0, 0, 32, 64, 1} /* (18)  18.png*/
      , {
      19, Tools.IMG_D19, 0, 0, 32, 64, 1} /* (19)  19.png*/
      , {
      20, Tools.IMG_D20, 0, 0, 32, 64, 1} /* (20)  20.png*/
      , {
      21, Tools.IMG_D21, 0, 0, 16, 48, -1} /* (21)  21.png*/
      , {
      22, Tools.IMG_D22, 0, 0, 0, 0, 0} /* (22)  22.png*/
      , {
      23, Tools.IMG_D23, 0, 0, 0, 0, 0} /* (23)  23.png*/
      , {
      24, Tools.IMG_D24, 0, 0, 0, 0, 0} /* (24)  24.png*/
      , {
      25, Tools.IMG_D25, 0, 0, 32, 16, 0} /* (25)  25.png*/
      , {
      26, Tools.IMG_D26, 0, 0, 32, 16, 0} /* (26)  26.png*/
      , {
      27, Tools.IMG_D27, 0, 0, 32, 26, 0} /* (27)  27.png*/
      , {
      28, Tools.IMG_D28, 0, 0, 32, 16, 0} /* (28)  28.png*/
      , {
      29, Tools.IMG_D29, 0, 0, 64, 80, 0} /* (29)  29.png*/
      , {
      30, Tools.IMG_D30, 0, 0, 32, 16, 0} /* (30)  30.png*/
//      , {
//      31, Tools.IMG_D31, 0, 0, 32, 48, 0} /* (31)  31.png*/
      , {
      32, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (32)  pb011.png*/
      , {
      33, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (33)  pb021.png*/
      , {
      34, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (34)  pb022.png*/
      , {
      35, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (35)  pb031.png*/
      , {
      36, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (36)  pb032.png*/
      , {
      37, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (37)  pb033.png*/
      , {
      38, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (38)  pb034.png*/
      , {
      39, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (39)  pb051.png*/
      , {
      40, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (40)  pb052.png*/
      , {
      41, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (41)  pb101.png*/
      , {
      42, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (42)  pb102.png*/
      , {
      43, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (43)  pb103.png*/
      , {
      44, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (44)  pb035.png*/
      , {
      45, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (45)  pb111.png*/
      , {
      46, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (46)  pb211.png*/
      , {
      47, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (47)  pb212.png*/
      , {
      48, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (48)  pb221.png*/
      , {
      49, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (49)  pb241.png*/
      , {
      50, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (50)  pb331.png*/
      , {
      51, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (51)  pb521.png*/
      , {
      52, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (52)  pb222.png*/
      , {
      53, Tools.IMG_D53, 0, 0, 16, 7, 0} /* (53)  33.png*/
      , {
      54, Tools.IMG_D54, 0, 0, 96, 80, -1} /* (54)  54.png*/
      , {
      55, Tools.IMG_D32, 0, 0, 0, 0, 0} /* (55)  PB591.png*/
      , {
      56, Tools.IMG_D56, 4, -8, 0, 0, 0} /* (56)  .png*/
      , {
      57, Tools.IMG_D32, 0, 0, 0, 0, 0}
      , {
      58, Tools.IMG_D58, -16, 0, 32, 32, 0} /* (58)  ¯.png*/
      , {
      59, Tools.IMG_D59, 0, 0, 0, 0, 0} /* (59)  .png*/
  };

  static short decData[][];
  int[][] lightArray = {
      {
      0, 0, 26, 90}
      ,
      /*ͼƬ˵*/{
      26, 13, 39, 73}
      ,
      /*ͼƬ˵*/{
      65, 15, 35, 75}
  }; /*ͼƬ˵*/

  int[][] fishArray = {
      {
      0, 0, 16, 7}
      ,
      /*ͼƬ˵*/{
      0, 8, 16, 6}
      ,
      /*ͼƬ˵*/{
      1, 14, 13, 9}
      ,
      /*ͼƬ˵*/{
      16, 0, 9, 13}
  }; /*ͼƬ˵*/
  int[][] waterArray = {
      {
      0, 0, 14, 23}
      ,
      /*ͼƬ˵*/{
      14, 0, 19, 31}
      ,
      /*ͼƬ˵*/{
      33, 0, 22, 38}
      ,
      /*ͼƬ˵*/{
      55, 0, 29, 46}
  }; /*ͼƬ˵*/
  int[][] waterIndent = {
      {
      0, 0}
      , {
      5, 4}
      , {
      8, 7}
      , {
      14, 12}
  };
  byte transArray[];
  byte[] off = {
      0, 1, 2, 1};
  int rad = 4;
  int offIndex;
  public void drawDecorations() {
    if (decData == null) {
      return;
    }
    if (++offIndex > Integer.MAX_VALUE) {
      offIndex = Integer.MAX_VALUE;
    }
    int index = GameMIDlet.gameIndex;
    byte[] motion;
    for (int i = 0; i < decData.length; i++) {
      short type = decData[i][ITEM_TYPE];
      short x = decData[i][ITEM_X];
      short y = decData[i][ITEM_Y];
      byte trans = (byte) decData[i][ITEM_TR];
      int id = getObjIndex(type);
      if (id != -1) {
        short addx = objData[id][OBJ_ADDX];
        short addy = objData[id][OBJ_ADDY];
        short img = objData[id][OBJ_IMG];
        short dl = objData[id][OBJ_DL];
        short drawLevel = y;
        switch (dl) {
          case -1:
            drawLevel = L_TILE;
            break;
          case 0:
            drawLevel = (short) (y + L_LEV);
            break;
          case 1:
            drawLevel = L_HIGH;
            break;
//          case 23:
//          case 24:
//
//            drawLevel = (short)(y + 9000);
//            break;
        }
        if (id == 23 || id == 24) {
          drawLevel = (short) (y + 64);
        }
        else
        if (id == 53) {
          drawLevel = (short) (y - 80);
        }

        switch (objData[id][OBJ_ID]) {
          case 6:
            motion = new byte[] {
                0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 3,
                3, 3, 3, 4,
                4, 4, 4, 3, 3, 3, 3};
            Tools.drawFrame(img, GameData.offset_d6, GameData.imgDat_d6, x, y,
                            motion[index % motion.length], trans == 1,
                            drawLevel);
            break;
          case 7:
            motion = new byte[] {
                5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9,
                9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11};
            int temp = index % motion.length;
            if (temp < motion.length) {
              Tools.drawFrame(img, GameData.offset_d6,
                              GameData.imgDat_d6, x + 16 -
                              GameData.indent_d6[motion[temp]][3], y,
                              motion[temp], trans == 1, drawLevel);

            }
            break;
          case 8:
            motion = new byte[] {
                12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14,
                15, 15, 15, 15, 16, 16, 16, 16, 17,
                17, 17, 17, 18, 18, 18, 18};
            temp = index % motion.length;
            if (temp < motion.length) {
              Tools.drawFrame(img, GameData.offset_d6,
                              GameData.imgDat_d6, x + 16 -
                              GameData.indent_d6[motion[temp]][3], y,
                              motion[temp], trans == 1, drawLevel);
            }
            break;
          case 13:
          case 14:
          case 15:
          case 16:
            drawPaiBian(x + 8, y, trans, drawLevel, img);
            break;
          case 10:
          case 11:
          case 12:
            drawPaiBian(x, y, trans, drawLevel, img);
            break;
          case 17:
          case 18:
          case 19:
          case 20:
            Tools.addImage(Tools.IMG_D8, x + addx,
                           y + addy, Tools.BOTTOM, trans, drawLevel
                           );
            Tools.addImage(Tools.IMG_D8, x + addx + 16,
                           y + addy, Tools.BOTTOM, Tools.TRANS_HORIZONTAL,
                           drawLevel
                           );
            Tools.addImage(img,
                           x + addx + 16 - Tools.getImage(img).getWidth() / 2,
                           y + addy - 10, Tools.BOTTOM, trans, drawLevel
                           );
            break;
          case 22:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            Tools.addImage(img, x + addx + 16,
                           y + addy - 26,
                           Tools.BOTTOM, trans, drawLevel
                           );
            Tools.addImage(Tools.IMG_D35, x + addx - 5 + 16,
                           y + addy + 18 - 26,
                           motion[index % motion.length] * 25, 0,
                           24, 21,
                           Tools.BOTTOM, trans, drawLevel
                           );

            break;
          case 23:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            Tools.addImage(img, x + addx,
                           y + addy + 4,
                           motion[index % motion.length] * 8, 0, 8, 11,
                           Tools.BOTTOM, trans, drawLevel
                           );
            break;
          case 24:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            Tools.addImage(img, x + addx,
                           y + addy + 2,
                           motion[index % motion.length] * 8, 0, 8, 11,
                           Tools.BOTTOM, trans, drawLevel);

            break;
          case 25:
          case 26:
          case 29:
            Tools.addImage(img, x + addx, y + addy, Tools.BOTTOM, trans,
                           drawLevel
                           );
            Tools.addImage(img, x + addx + Tools.getImage(img).getWidth(),
                           y + addy, Tools.BOTTOM, Tools.TRANS_HORIZONTAL,
                           drawLevel
                           );
            break;
          case 28:
            motion = new byte[] {
                0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1};
            Tools.addImage(img, x + addx, y + addy, Tools.BOTTOM,
                           trans, drawLevel);
            Tools.addImage(Tools.IMG_D36, x + addx + 8, y + addy - 34, 0,
                           motion[index % motion.length] * 8, 15, 8,
                           Tools.BOTTOM,
                           trans, drawLevel);
            Tools.addImage(Tools.IMG_D36, x + addx + 18, y + addy - 18, 16,
                           motion[index % motion.length] * 8, 6, 8,
                           Tools.BOTTOM,
                           trans, drawLevel);
            break;
          case 32:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 160, 112, false, true, false,
                          trans, drawLevel, motion[index % motion.length]);

            break;
          case 33:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 80, 112, true, true, true, trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 34:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 64, 192, false, false, false,
                          trans,
                          drawLevel, motion[index % motion.length]);

            break;
          case 35:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy - 32, 48, 64, false, false, false,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 36:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy - 32, 32, 64, false, false, false,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 37:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy + 16, 48, 128, false, false, false,
                          trans,
                          drawLevel, motion[index % motion.length]);

            break;
          case 38:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy + 48, 32, 160, false, false, false,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 39:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 96, 144, true, true, true,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 40:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 64, 240, false, false, false,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 41:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 48, 416, false, false, false,
                          trans,
                          drawLevel, motion[index % motion.length]);

            break;
          case 42:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 96, 112, true, true, true,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 43:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 48, 256, false, false, false,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 44:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy + 32, 32, 208, false, false, false,
                          trans,
                          drawLevel, motion[index % motion.length]);

            break;
          case 45:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 80, 112, true, true, true,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 46:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 48, 128, false, true, true,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 47:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 48, 128, true, true, false,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 48:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 80, 112, true, true, true,
                          trans,
                          drawLevel, motion[index % motion.length]);

            break;
          case 49:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 96, 128, true, true, true,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 50:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 64, 144, true, true, true,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 51:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 80, 128, true, true, true,
                          trans,
                          drawLevel, motion[index % motion.length]);

            break;
          case 52:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 112, 112, false, true, true,
                          trans, (short) (y - 200), motion[index % motion.length]);
            break;
          case 53:
            if ( (i + rad) % 3 == 0) {
              motion = new byte[] {
                  0, 0, 0, 0, 0,
                  1, 1, 1, 1, 1,
                  0, 0, 0, 0, 0,
                  2, 2, 2, 2, 2,
                  3, 3, 3, 4, 4,
                  4, 5, 5, 5, 5,
                  5, 7, 7, 7, 7,
                  7, 5, 5, 5, 5,
                  5, 6, 6, 6, 6,
                  6, 8, 8, 8, 9,
                  9, 0};
            }
            else
            if ( (i + rad) % 3 == 1) {

              motion = new byte[] {
                  0, 0, 0, 0, 0,
                  1, 1, 1, 1, 1,
                  0, 0, 0, 0, 0,
                  2, 2, 2, 2, 2,
                  0, 0, 0, 0, 0,
                  1, 1, 1, 1, 1,
                  0, 0, 0, 0, 0,
                  2, 2, 2, 2, 2,
                  0, 0, 0, 0, 0,
                  1, 1, 1, 1, 1,
                  0, 0
              };
            }
            else if ( (i + rad) % 3 == 2) {
              motion = new byte[] {
                  0, 0, 0, 0, 0,
                  1, 1, 1, 1, 1,
                  0, 0, 0, 0, 0,
                  2, 2, 2, 2, 2,
                  3, 3, 3, 4, 4,
                  4, 5, 5, 5, 5,
                  5, 7, 7, 7, 7,
                  7, 5, 5, 5, 5,
                  5, 6, 6, 6, 6,
                  6, 8, 8, 8, 9,
                  9, 0};

            }
            else {
              motion = new byte[] {
                  0, 0, 0, 0, 0,
                  1, 1, 1, 1, 1,
                  0, 0, 0, 0, 0,
                  2, 2, 2, 2, 2,
                  0, 0, 0, 0, 0,
                  1, 1, 1, 1, 1,
                  0, 0, 0, 0, 0,
                  2, 2, 2, 2, 2,
                  0, 0, 0, 0, 0,
                  1, 1, 1, 1, 1,
                  0, 0
              };
            }
            temp = index % motion.length;
            if (temp < motion.length) {
              Tools.drawFrame(img, GameData.offset_d53,
                              GameData.imgDat_d53, x + addx -
                              GameData.indent_d53[motion[temp]][3],
                              y + addy - GameData.indent_d53[motion[temp]][5],
                              motion[temp], false, 0);
            }
            if (temp == 51) {
              rad = engine.nextInt(1, 5);
              temp = 0;
//              System.out.println("һ֡");
            }

            break;
          case 54:
            Tools.addImage(img, x + addx, y + addy, Tools.BOTTOM, trans,
                           drawLevel);
            Tools.addImage(img, x + addx + 48, y + addy, Tools.BOTTOM,
                           Tools.TRANS_HORIZONTAL,
                           drawLevel);
            if (engine.on) {
              motion = new byte[] {
                  0, 0, 1, 1};
              if (offIndex > 0) {
                Tools.drawFrame(Tools.IMG_D38, GameData.offset_d54,
                                GameData.imgDat_d54, x + 21, y - 44,
                                motion[index % motion.length], false,
                                drawLevel);
              }
              motion = new byte[] {
                  0, 0, 1, 1, 2, 2, 3, 3};
              Tools.addImage(Tools.IMG_D37, x + addx + 25 + 7 -
                             waterIndent[motion[index % motion.length]][0] + 2,
                             y + addy - 50 -
                             waterIndent[motion[index % motion.length]][1] - 2,
                             waterArray[motion[index % motion.length]],
                             Tools.TOP, trans,
                             drawLevel);
              Tools.addImage(Tools.IMG_D37, x + addx + 25 - 7 + 28 + 2,
                             y + addy - 50 -
                             waterIndent[motion[index % motion.length]][1] - 2,
                             waterArray[motion[index % motion.length]],
                             Tools.TOP, Tools.TRANS_HORIZONTAL,
                             drawLevel);

              if (offIndex > 30) {
                short a[][] = {
                    {
                    -64, -43} //13//13
                    , {
                    144, -43}
                    , {
                    -48, -107}
                    , {
                    128, -107}
                    , {
                    0, -123}
                    , {
                    80, -123}
                };
                for (int j = 0; j < a.length; j++) {
                  Tools.addImage(Tools.IMG_WZ, x + a[j][0], y + a[j][1],
                                 16 * (MyGameCanvas.gameTime % 6 / 2), 0, 16,
                                 33, Tools.TOP, Tools.TRANS_NONE, drawLevel);
                }
              }
              if (offIndex > 60) {
                if (MyGameCanvas.gameTime % 6 == 0) {
                  Effect.AddEffectList(x - 35 - 16, y - 46 + 16,
                                       Effect.EFFECT_DIAN1, 0,
                                       drawLevel);
                  Effect.AddEffectList(x - 35 + 165 + 16, y - 46 + 16,
                                       Effect.EFFECT_DIAN1, 1,
                                       drawLevel);
                  Effect.AddEffectList(x - 32 + 13 - 16, y - 91 - 1,
                                       Effect.EFFECT_DIAN2, 0,
                                       drawLevel);
                  Effect.AddEffectList(x - 32 + 13 + 132 + 16, y - 91 - 1,
                                       Effect.EFFECT_DIAN2, 1,
                                       drawLevel);
                  Effect.AddEffectList(x + 13, y - 123 + 15,
                                       Effect.EFFECT_DIAN3, 0,
                                       drawLevel);
                  Effect.AddEffectList(x + 32 + 13 + 37, y - 123 + 15,
                                       Effect.EFFECT_DIAN3, 1,
                                       drawLevel);
                }
              }

            }
            else {
              offIndex = 0;
            }

            break;

          case 55:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 64, 112, true, true, true,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 56:
            motion = new byte[] {
                0, 0, 1, 1, 0, 0, 1, 1};
            Tools.addImage(img, x + addx,
                           y + addy,
                           26 * (motion[index % motion.length]), 0, 26, 46,
                           Tools.BOTTOM,
                           index % motion.length < 4 ? Tools.TRANS_NONE :
                           Tools.TRANS_HORIZONTAL, 0);
            break;
          case 57:
            motion = new byte[] {
                0, 0, 1, 1, 2, 2};
            drawWaterfall(x + addx, y + addy, 32, 144, false, true, false,
                          trans,
                          drawLevel, motion[index % motion.length]);
            break;
          case 58:
            motion = new byte[] {
                0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, -1,
                -1, -1, -1, -1};
            Tools.addImage(img, x + addx + 5, y + addy - 2, Tools.BOTTOM, trans,
                           drawLevel
                           );
            Tools.addImage(img, x + addx + Tools.getImage(img).getWidth() + 5,
                           y + addy - 2, Tools.BOTTOM, Tools.TRANS_HORIZONTAL,
                           drawLevel
                           );
            if (motion[index % motion.length] != -1) {
              Tools.addImage(Tools.IMG_D39, x + addx + 15 + 5,
                             y + addy - 45 - 2, 0,
                             7 * motion[index % motion.length], 24, 7,
                             Tools.BOTTOM,
                             trans,
                             drawLevel
                             );
              Tools.addImage(Tools.IMG_D40, x + addx + 17 + 5,
                             y + addy - 64 - 2, 0,
                             9 * motion[index % motion.length], 20, 9,
                             Tools.BOTTOM,
                             trans,
                             drawLevel
                             );

            }

            break;
          case 59:
            if (i % 2 == 0) {
              motion = new byte[] {
                  0, 1, 2, 3};
            }
            else {
              motion = new byte[] {
                  0, 0, 1, 1, 2, 2, 3, 3, -1, -1};
            }
            if (motion[index % motion.length] != -1) {
              Tools.addImage(img, x + addx, y + addy,
                             1 + motion[index % motion.length] * 27, 1, 26, 23,
                             Tools.BOTTOM, trans, drawLevel - 300);
            }
            break;
//          case 2: //
//            Tools.addImage(img, x + addx, y + addy, Tools.BOTTOM,
//                           trans, drawLevel);
//            motion = new byte[] {
//                0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7};
//            int temp = (index + i * 20) % 80;
//            if (temp < motion.length) {
//              Tools.drawFrame(Tools.IMG_LEAF, GameData.offset_leaf,
//                              GameData.imgDat_Leaf, x -
//                              GameData.indent_leaf[motion[temp]][trans == 0 ? 0 :
//                              1], y + GameData.indent_leaf[motion[temp]][3],
//                              motion[temp], false, drawLevel);
//            }
//
//            break;
//          case 4: //̨
//            Tools.addImage(img, x + addx, y + addy, 12 * (index % 2), 0, 12, 17,
//                           Tools.BOTTOM, trans, drawLevel);
//            break;
//          case 7: //
//            motion = new byte[] {
//                0, 1, 2, 1};
//            Tools.addImage(img, x + addx, y + addy,
//                           21 * motion[index % motion.length], 0, 21,
//                           31, Tools.BOTTOM, trans, drawLevel);
//            break;
//          case 12: //
//            Tools.addImage(img, x + addx, y + addy, 42 * ( (index % 4) / 2), 0,
//                           42, 42, Tools.BOTTOM, trans, drawLevel);
//            break;
//          case 14: //
//            motion = new byte[] {
//                2, 2, 1, 1, 0, 0};
//            Tools.addImage(img, x + addx, y + addy,
//                           16 * motion[index % motion.length], 0, 16, 16,
//                           Tools.BOTTOM, trans, drawLevel);
//            break;
//          case 15: //
//            motion = new byte[] {
//                0, 1, 2, 3, 4, 5};
//            temp = (index + i * 7) % 80;
//            if (temp < motion.length) {
//              Tools.drawFrame(img, GameData.offset_d15,
//                              GameData.imgDat_d15, x + addx -
//                              GameData.indent_d15[motion[temp]][trans == 0 ? 0 :
//                              1],
//                              y + addy + GameData.indent_d15[motion[temp]][3],
//                              motion[temp], trans == 1, drawLevel);
//            }
//            break;

//          case 17: //
//            motion = new byte[] {
//                0, 1, 2, 3, 4, 5, 6, 7};
//            temp = (index + i * 7) % motion.length;
//
//            Tools.drawFrame(img, GameData.offset_d17,
//                            GameData.imgDat_d17, x + addx -
//                            GameData.indent_d17[motion[temp]][trans == 0 ? 0 :
//                            1],
//                            y + addy + GameData.indent_d17[motion[temp]][3],
//                            motion[temp], trans == 1, drawLevel);
//
//            break;
//          case 18: //
//            Tools.addImage(img, x + addx, y + addy, 23 * ( (index % 4) / 2), 0,
//                           23, 20, Tools.BOTTOM, trans, drawLevel);
//            break;
//          case 20: //ҩ
//            motion = new byte[] {
//                0, 1, 2, 3, 4, 5, 6};
//            temp = (index % (motion.length * 3)) / 3;
//            Tools.drawFrame(img, GameData.offset_d20,
//                            GameData.imgDat_d20, x + addx + 14 -
//                            GameData.indent_d20[motion[temp]][trans == 0 ? 0 :
//                            1],
//                            y + addy + GameData.indent_d20[motion[temp]][3],
//                            motion[temp], trans == 1, drawLevel);
//            break;
//          case 21: //
//            motion = new byte[] {
//                14, 15, 16, 15, 14, 17, 18, 17};
//            temp = (index % (motion.length * 3)) / 3;
//            Tools.drawFrame(img, GameData.offset_d20,
//                            GameData.imgDat_d20, x + addx + 14 -
//                            GameData.indent_d20[motion[temp]][trans == 0 ? 0 :
//                            1],
//                            y + addy + GameData.indent_d20[motion[temp]][3],
//                            motion[temp], trans == 1, drawLevel);
//            break;
//          case 22: //
//            motion = new byte[] {
//                7, 8, 9, 10, 11, 12, 13};
//            temp = (index % (motion.length * 3)) / 3;
//            Tools.drawFrame(img, GameData.offset_d20,
//                            GameData.imgDat_d20, x + addx + 14 -
//                            GameData.indent_d20[motion[temp]][trans == 0 ? 0 :
//                            1],
//                            y + addy + GameData.indent_d20[motion[temp]][3],
//                            motion[temp], trans == 1, drawLevel);
//            break;
//          case 56: //ͼͷ
//            motion = new byte[] {
//                1, 1, 0, 0, 2, 2, 3, 3};
//            temp = index % (motion.length);
//            Tools.addImage(img, x + addx, y + addy, 26 * (motion[temp] / 2), 0,
//                           26, 46, Tools.BOTTOM,
//                           motion[temp] % 2 == 0 ? Tools.TRANS_NONE :
//                           Tools.TRANS_HORIZONTAL, drawLevel);
//            break;
          default:
            Tools.addImage(img, x + addx, y + addy, Tools.BOTTOM,
                           trans, drawLevel);
            break;
        }
      }
    }
  }

  void drawPaiBian(int x, int y, byte trans, int drawLevel, int img) {
    Tools.addImage(Tools.IMG_D7, x,
                   y, Tools.BOTTOM, trans, drawLevel
                   );
    Tools.addImage(Tools.IMG_D7, x + 24,
                   y, Tools.BOTTOM, Tools.TRANS_HORIZONTAL,
                   drawLevel
                   );
    Tools.addImage(img,
                   x + 24 - Tools.getImage(img).getWidth() / 2,
                   y - 3, Tools.BOTTOM, trans, drawLevel
                   );

  }

  int[][] waterfallClip = {
      {
      0, 0, 16, 32}
      ,
      /*ͼƬ˵*/{
      0, 33, 16, 32}
      ,
      /*ͼƬ˵*/{
      0, 33, 16, 16}
      ,
      /*ͼƬ˵*/{
      50, 0, 16, 16}
      ,
      /*ͼƬ˵*/{
      70, 0, 16, 16}
      ,
      /*ͼƬ˵*/{
      95, 0, 16, 16}
      ,
      /*ͼƬ˵*/{
      17, 0, 16, 32}
      ,
      /*ͼƬ˵*/{
      17, 33, 16, 32}
      ,
      /*ͼƬ˵*/{
      17, 33, 16, 16}
      ,
      /*ͼƬ˵*/{
      50, 17, 16, 16}
      ,
      /*ͼƬ˵*/{
      66, 17, 16, 16}
      ,
      /*ͼƬ˵*/{
      95, 17, 16, 16}
      ,
      /*ͼƬ˵*/{
      34, 0, 16, 32}
      ,
      /*ͼƬ˵*/{
      34, 33, 16, 32}
      ,
      /*ͼƬ˵*/{
      34, 33, 16, 16}
      ,
      /*ͼƬ˵*/{
      50, 34, 16, 16}
      ,
      /*ͼƬ˵*/{
      66, 34, 16, 16}
      ,
      /*ͼƬ˵*/{
      95, 34, 16, 16}
  }; /*ͼƬ˵*/

  //ٲ
  void drawWaterfall(int x, int y, int w, int h, boolean left, boolean center,
                     boolean right, byte trans, short drawLevel, int index) {
    if (left && center && right) {
      Tools.addImage(Tools.IMG_D32, x, y, waterfallClip[3 + index * 6],
                     Tools.BOTTOM,
                     trans, drawLevel);
      Tools.addImage(Tools.IMG_D32, x + w - 16, y, waterfallClip[5 + index * 6],
                     Tools.BOTTOM,
                     trans, drawLevel);
      int w1 = w - 32;
      for (int i = 0; i < w1 / 16; i++) {
        Tools.addImage(Tools.IMG_D32, x + 16 + i * 16, y,
                       waterfallClip[4 + index * 6],
                       Tools.BOTTOM,
                       trans, drawLevel);
      }
      for (int i = 0; i < w1 / 16; i++) {
        Tools.addImage(Tools.IMG_D32, x + 16 + i * 16, y - h + 32,
                       waterfallClip[0 + index * 6],
                       Tools.BOTTOM,
                       trans, drawLevel);
      }
      for (int i = 0; i < w1 / 16; i++) {
        for (int j = 0; j < (h - 48) / 32; j++) {
          Tools.addImage(Tools.IMG_D32, x + 16 + i * 16, y - h + 32 + j * 32,
                         waterfallClip[1 + index * 6],
                         Tools.TOP,
                         trans, drawLevel);
          if (j == (h - 48) / 32 - 1 && (h - 48) % 32 != 0) {
            Tools.addImage(Tools.IMG_D32, x + 16 + i * 16,
                           y - h + 32 + (j + 1) * 32,
                           waterfallClip[2 + index * 6],
                           Tools.TOP,
                           trans, drawLevel);
          }

        }
      }
    }
    else if (left && center && right == false) {
      Tools.addImage(Tools.IMG_D32, x, y, waterfallClip[3 + index * 6],
                     Tools.BOTTOM,
                     trans, drawLevel);
      int w1 = w - 16;
      for (int i = 0; i < w1 / 16; i++) {
        Tools.addImage(Tools.IMG_D32, x + 16 + i * 16, y,
                       waterfallClip[4 + index * 6],
                       Tools.BOTTOM,
                       trans, drawLevel);
      }
      for (int i = 0; i < w1 / 16; i++) {
        Tools.addImage(Tools.IMG_D32, x + 16 + i * 16, y - h + 32,
                       waterfallClip[0 + index * 6],
                       Tools.BOTTOM,
                       trans, drawLevel);
      }
      for (int i = 0; i < w1 / 16; i++) {
        for (int j = 0; j < (h - 48) / 32; j++) {
          Tools.addImage(Tools.IMG_D32, x + 16 + i * 16, y - h + 32 + j * 32,
                         waterfallClip[1 + index * 6],
                         Tools.TOP,
                         trans, drawLevel);
          if (j == (h - 48) / 32 - 1 && (h - 48) % 32 != 0) {
            Tools.addImage(Tools.IMG_D32, x + 16 + i * 16,
                           y - h + 32 + (j + 1) * 32,
                           waterfallClip[2 + index * 6],
                           Tools.TOP,
                           trans, drawLevel);
          }
        }
      }
    }
    else if (left == false && center && right) {
      Tools.addImage(Tools.IMG_D32, x + w - 16, y, waterfallClip[5 + index * 6],
                     Tools.BOTTOM,
                     trans, drawLevel);
      int w1 = w - 16;
      for (int i = 0; i < w1 / 16; i++) {
        Tools.addImage(Tools.IMG_D32, x + i * 16, y,
                       waterfallClip[4 + index * 6],
                       Tools.BOTTOM,
                       trans, drawLevel);
      }
      for (int i = 0; i < w1 / 16; i++) {
        Tools.addImage(Tools.IMG_D32, x + i * 16, y - h + 32,
                       waterfallClip[0 + index * 6],
                       Tools.BOTTOM,
                       trans, drawLevel);
      }
      for (int i = 0; i < w1 / 16; i++) {
        for (int j = 0; j < (h - 48) / 32; j++) {
          Tools.addImage(Tools.IMG_D32, x + i * 16, y - h + 32 + j * 32,
                         waterfallClip[1 + index * 6],
                         Tools.TOP,
                         trans, drawLevel);
          if (j == (h - 48) / 32 - 1 && (h - 48) % 32 != 0) {
            Tools.addImage(Tools.IMG_D32, x + i * 16,
                           y - h + 32 + (j + 1) * 32,
                           waterfallClip[2 + index * 6],
                           Tools.TOP,
                           trans, drawLevel);
          }
        }
      }
    }
    else if (left == false && center && right == false) {
      for (int i = 0; i < w / 16; i++) {
        Tools.addImage(Tools.IMG_D32, x + i * 16, y,
                       waterfallClip[4 + index * 6],
                       Tools.BOTTOM,
                       trans, drawLevel);
      }
      for (int i = 0; i < w / 16; i++) {
        Tools.addImage(Tools.IMG_D32, x + i * 16, y - h + 32,
                       waterfallClip[0 + index * 6],
                       Tools.BOTTOM,
                       trans, drawLevel);
      }

      for (int i = 0; i < w / 16; i++) {
        for (int j = 0; j < (h - 48) / 32; j++) {
          Tools.addImage(Tools.IMG_D32, x + i * 16, y - h + 32 + j * 32,
                         waterfallClip[1 + index * 6],
                         Tools.TOP,
                         trans, drawLevel);
          if (j == (h - 48) / 32 - 1 && (h - 48) % 32 != 0) {
            Tools.addImage(Tools.IMG_D32, x + i * 16, y - h + 32 + (j + 1) * 32,
                           waterfallClip[2 + index * 6],
                           Tools.TOP,
                           trans, drawLevel);
          }
        }
      }
    }
    else if (!left && !center && !right) {
      for (int i = 0; i < w / 16; i++) {
        Tools.addImage(Tools.IMG_D32, x + i * 16, y - h + 32,
                       waterfallClip[0 + index * 6],
                       Tools.BOTTOM,
                       trans, drawLevel);
      }

      for (int i = 0; i < w / 16; i++) {
        for (int j = 0; j < h / 32; j++) {
          Tools.addImage(Tools.IMG_D32, x + i * 16, y - h + 32 + j * 32,
                         waterfallClip[1 + index * 6],
                         Tools.TOP,
                         trans, drawLevel);
          if (j == h / 32 - 1 && h % 32 != 0) {
            Tools.addImage(Tools.IMG_D32, x + i * 16, y - h + 32 + (j + 1) * 32,
                           waterfallClip[2 + index * 6],
                           Tools.TOP,
                           trans, drawLevel);
          }
        }
      }

    }
  }

  /****************************ȡװ******************************/
  void loadDecorationDat() {
    decData = null;
//    decData = engine.readItemData("/deck/" + (mapID < 10 ? "0" : "") + mapID +
//                                  ".bin");
    decData = engine.readItemData2((mapID < 10 ? "0" : "") + mapID);
  }

  /****************************ȡͼ******************************/
  void loadMapDat() {
//    System.out.println("fileName = "+fileName);
    loadMap(Event.getString(fileName));
    for (int i = 0; i < layer; i++) {
      Tools.createImage(mName[i], i + 1);
    }
  }

  /****************************ʼͼ******************************/
  public void initMap() {
    free();
    initMapBuff();
    decData = null;
    adjustX = screenWidth / 2;
    adjustY = screenHeight / 2 + 20;
    loadMapDat();
    loadDecorationDat();
//    setWeather(weather);
  }

  /****************************ͼ******************************/
  public void drawMapBG(Graphics g) {
    g.setColor(0);
    g.fillRect(setOffX, setOffY, MyGameCanvas.SCREEN_WIDTH,
               MyGameCanvas.SCREEN_HEIGHT);
  }

  /****************************ͼǰ******************************/
  public void drawMapFG() {
    drawDecorations();
  }

  /****************************ͼ******************************/
  static boolean blackBG; //ɫͼ
  public void setMap(Graphics g) {
    if (mData != null) {
      if (blackBG) {
        engine.drawColorScreenBG(0, 0);
      }
      else {
        byte motion[];
        int index = GameMIDlet.gameIndex;
        switch (mapID) {
          case 0:
            motion = new byte[] {
                0, 0, 0, 1, 1, 1, 2, 2, 2};
            Tools.addImage(Tools.IMG_CG_XUANYUANTAI, 0,
                           0, Tools.TOP, Tools.TRANS_NONE, 0);
            engine.drawFlame(39, 251, 0, 0);
            engine.drawFlame(266, 251, 0, 0);
            engine.drawFlame(76, 84, 1, 0);
            engine.drawFlame(233, 84, 1, 0);

            break;
          case 13:
            engine.canvas.drawCleanScreen(g, 0);
            Tools.addImage(Tools.IMG_CG_RIVER, setOffX,
                           setOffY +
                           (MyGameCanvas.SCREEN_HEIGHT -
                            Tools.getImage(Tools.IMG_CG_RIVER).getHeight()) /
                           2, index % 56, 0,
                           56 - index % 56,
                           163,
                           Tools.TOP,
                           Tools.TRANS_NONE, 0);

            for (int i = 0; i < 4; i++) {
              Tools.addImage(Tools.IMG_CG_RIVER,
                             setOffX + 56 - index % 56 +
                             Tools.getImage(Tools.IMG_CG_RIVER).getWidth() *
                             i,
                             setOffY +
                             (MyGameCanvas.SCREEN_HEIGHT -
                              Tools.getImage(Tools.IMG_CG_RIVER).getHeight()) /
                             2, Tools.TOP, Tools.TRANS_NONE, 0);
            }
            if (index % 56 > 40) {
              Tools.addImage(Tools.IMG_CG_RIVER,
                             setOffX + 56 - index % 56 +
                             Tools.getImage(Tools.IMG_CG_RIVER).getWidth() * 4,
                             setOffY +
                             (MyGameCanvas.SCREEN_HEIGHT -
                              Tools.getImage(Tools.IMG_CG_RIVER).getHeight()) /
                             2, 0, 0, 16 - (56 - index % 56), 163,
                             Tools.TOP, Tools.TRANS_NONE, 0);
            }

            Tools.addImage(Tools.IMG_CG_BOAT,
                           setOffX + MyGameCanvas.SCREEN_WIDTH -
                           Tools.getImage(Tools.IMG_CG_BOAT).getWidth(),
                           setOffY +
                           (MyGameCanvas.SCREEN_HEIGHT -
                            Tools.getImage(Tools.IMG_CG_BOAT).getHeight()) /
                           2, Tools.TOP, Tools.TRANS_NONE, 0);

            break;
          case 14:
            engine.canvas.drawCleanScreen(g, 0);
            Tools.addImage(Tools.IMG_CG_RIVER, setOffX,
                           setOffY +
                           (MyGameCanvas.SCREEN_HEIGHT -
                            Tools.getImage(Tools.IMG_CG_RIVER).getHeight()) /
                           2, index % 56, 0,
                           56 - index % 56,
                           163,
                           Tools.TOP,
                           Tools.TRANS_NONE, 0);

            for (int i = 0; i < 4; i++) {
              Tools.addImage(Tools.IMG_CG_RIVER,
                             setOffX + 56 - index % 56 +
                             Tools.getImage(Tools.IMG_CG_RIVER).getWidth() *
                             i,
                             setOffY +
                             (MyGameCanvas.SCREEN_HEIGHT -
                              Tools.getImage(Tools.IMG_CG_RIVER).getHeight()) /
                             2, Tools.TOP, Tools.TRANS_NONE, 0);
            }
            if (index % 56 > 40) {
              Tools.addImage(Tools.IMG_CG_RIVER,
                             setOffX + 56 - index % 56 +
                             Tools.getImage(Tools.IMG_CG_RIVER).getWidth() * 4,
                             setOffY +
                             (MyGameCanvas.SCREEN_HEIGHT -
                              Tools.getImage(Tools.IMG_CG_RIVER).getHeight()) /
                             2, 0, 0, 16 - (56 - index % 56), 163,
                             Tools.TOP, Tools.TRANS_NONE, 0);
            }

            Tools.addImage(Tools.IMG_CG_BOAT,
                           setOffX, setOffY + (MyGameCanvas.SCREEN_HEIGHT -
                                               Tools.getImage(Tools.IMG_CG_BOAT).
                                               getHeight()) /
                           2, Tools.TOP, Tools.TRANS_HORIZONTAL, 0);
            break;
//          case 58:
//            Tools.addImage(Tools.IMG_MOON, 0, 0, Tools.TOP, Tools.TRANS_NONE, 0);
//          drawProtechny(setOffX + screenWidth, setOffY);
//            break;
//          case 96:
//            int posx = 228, posy = 117;
//            Tools.addImage(Tools.IMG_SW0, 0, 0, Tools.TOP, Tools.TRANS_NONE, 0);
//            break;
          default:
            drawMap(g, setOffX, setOffY);
            if (!engine.showHole) {
              if (GameEngine.gameRank != 0) {
                setTile(g);
              }
            }
            break;
        }
        drawMapFG();
        drawTaskFlag(200);
        if (openMini) {
          drawMiniMap(setOffX, setOffY);
        }
      }
    }
  }

//  static boolean isLookMode; //۲ģʽ
//  void drawLookArea(int posx, int posy) {
//    if (!isLookMode) {
//      return;
//    }
//    int w = (GameMIDlet.gameIndex % 4) / 2 == 0 ? 90 : 92;
//    int startx = posx - w / 2;
//    int starty = posy - w / 2;
//    Tools.addImage(Tools.IMG_LOOK, startx, starty, Tools.TOP, Tools.TRANS_NONE,
//                   L_LOOK);
//    Tools.addImage(Tools.IMG_LOOK, startx + w, starty,
//                   Graphics.TOP | Graphics.RIGHT, Tools.TRANS_HORIZONTAL,
//                   L_LOOK);
//    Tools.addImage(Tools.IMG_LOOK, startx, starty + w,
//                   Graphics.BOTTOM | Graphics.LEFT, Tools.TRANS_VERTICAL,
//                   L_LOOK);
//    Tools.addImage(Tools.IMG_LOOK, startx + w, starty + w,
//                   Graphics.BOTTOM | Graphics.RIGHT, Tools.TRANS_CENTER, L_LOOK);
//    if (startx > setOffX) { //
//      Tools.addRect(Tools.TYPE_RECT, setOffX, setOffY, startx - setOffX,
//                    screenHeight, true, Tools.TOP, 0, L_LOOK);
//    }
//    if (startx + w < setOffX + screenWidth) { //
//      Tools.addRect(Tools.TYPE_RECT, startx + w, setOffY,
//                    setOffX + screenWidth - startx - w, screenHeight, true,
//                    Tools.TOP, 0, L_LOOK);
//    }
//    if (starty > setOffY) { //
//      Tools.addRect(Tools.TYPE_RECT, setOffX, setOffY, screenWidth,
//                    starty - setOffY, true, Tools.TOP, 0, L_LOOK);
//    }
//    if (starty + w < setOffY + screenHeight) { //
//      Tools.addRect(Tools.TYPE_RECT, setOffX, starty + w, screenWidth,
//                    setOffY + screenHeight - starty - w, true, Tools.TOP, 0,
//                    L_LOOK);
//    }
//
//  }

  /****************************setoffX******************************/
  public void adjustSrceen(int x, int y) {
    setOffX = (x - adjustX);
    setOffX = Math.max(setOffX, 0);
    setOffX = Math.min(setOffX, mapSize[0] * tileWidth - screenWidth);

    setOffY = (short) (y - adjustY);
    setOffY = (short) Math.min(setOffY, mapSize[1] * tileHight - screenHeight);
    setOffY = (short) Math.max(setOffY, 0);

  }

//  public int getSetOffX(int x) {
//    short dx = (short) (x - adjustX);
//    dx = (short) Math.max(dx, 0);
//    dx = (short) Math.min(dx,
//                          mapSize[0] * tileWidth - screenWidth);
//    return dx;
//  }
//
//  /****************************setoffY******************************/
//  public int getSetOffY(int y) {
//    short dy = (short) (y - adjustY);
//    dy = (short) Math.max(dy, 0);
//    dy = (short) Math.min(dy,
//                          mapSize[1] * tileHight - screenHeight);
//    return dy;
//  }

  /****************************Ļͷƶ******************************/
  public static byte SCEEN_MOVE = 10;
  int adjustX;
  int adjustY;
  static boolean isMoveScreen;
  public void moveSrceen(int x, int y) {
    if (Math.abs(x - setOffX - adjustX) > SCEEN_MOVE) {
      if (x - setOffX - adjustX >= SCEEN_MOVE) {
        setOffX += SCEEN_MOVE;
      }
      else {
        setOffX -= SCEEN_MOVE;
      }
    }
    else {
      setOffX = (short) (x - adjustX);
    }
    setOffX = (short) Math.max(setOffX, 0);
    setOffX = (short) Math.min(setOffX, mapSize[0] * tileWidth -
                               screenWidth);
    if (Math.abs(y - setOffY - adjustY) > SCEEN_MOVE) {
      if (y - setOffY - adjustY >= SCEEN_MOVE) {
        setOffY += SCEEN_MOVE;
      }
      else {
        setOffY -= SCEEN_MOVE;
      }
    }
    else {
      setOffY = (short) (y - adjustY);
    }
    setOffY = (short) Math.max(setOffY, 0);
    setOffY = (short) Math.min(setOffY,
                               mapSize[1] * tileHight -
                               screenHeight);
    if (isMoveScreen) {
      if (checkMoveScreen(x, y)) {

        isMoveScreen = false;
        finish();
      }
    }
  }

  /****************************ĻǷƶX,Y******************************/
  public boolean checkMoveScreen(int x, int y) {
    int tempx;
    tempx = (short) (x - adjustX);
    tempx = (short) Math.max(tempx, 0);
    tempx = (short) Math.min(tempx, mapSize[0] * tileWidth - screenWidth);
    int tempy;
    tempy = (short) (y - adjustY);
    tempy = (short) Math.max(tempy, 0);
    tempy = (short) Math.min(tempy, mapSize[1] * tileHight - screenHeight);

    return setOffX == tempx && setOffY == tempy;
  }

  static Event event;
  static int path;
  static public void sender(Event event1, int pathIndex) {
    finish();
    event = event1;
    path = pathIndex;
  }

  static public void finish() {
    if (event == null) {
      return;
    }
    event.setEnd(path);
    event = null;
  }

//ͼж Ƿͨ

//  public boolean canRun(int x, int y) {
//    if (x < 0 || x > mapSize[0] * tileHight - tileHight ||
//        y < tileHight - 1 || y > mapSize[1] * tileHight) {
//      return false;
//    }
//
//    for (int i = layer - 1; i >= 0; i--) {
//      if (inMapData(x, y, i) == (byte) 0xff) {
//        continue;
//      }
//      else {
//        return canRun(x, y, i);
//      }
//    }
//    return true;
//  }
  public boolean canRun(int x, int y) {
    if (x < 0 || x > mapSize[0] * tileHight - tileHight ||
        y < tileHight - 1 || y > mapSize[1] * tileHight) {
      return false;
    }
    for (int i = layer - 1; i >= 0; i--) {
      if (inMapData(x, y, i) == (byte) 0xff) {
        if (i == 0) {
          return false;
        }
        else {
          continue;
        }
      }
      else {
        return canRun(x, y, i);
      }
    }
    return true;
  }

  public boolean canRun(int x, int y, int lay) {

    if (inMapData(x, y, lay) == (byte) 0xff) {
      return false;
    }
    return!Tools.getProperties(mProperties[lay][getLow(inMapData(x, y, lay))],
                               Tools.TILE_LT_PASS_LR);
  }

  public int repaint(int data) {
    if (data == (byte) 0xff) {
      return 0;
    }
    else if (!Tools.getProperties(mProperties[1][getLow(data)], Tools.TILE_TOP)) {
      return 1;
    }
    else if (!Tools.getProperties(mProperties[1][getLow(data)], Tools.TILE_LEV)) {
      return 2;
    }
    return 0;
  }

  /******************
   /㴫x,yڵͼеλ
   /******************/

   public static byte inMapData(int x, int y, int index) {
     int n = ( (x / tileWidth) * mapSize[1] +
              (y / tileHight));
     if (n < 0 || n >= mData[index].length) {
       return (byte) 0xff;
     }
     return mData[index][n];
   }

  int miniSize = 2;
  int miniColor[] = {
      0xBCDAAD, 0, 0xFF0000, 0x00FF03}; //0ͨ1赲2
  static boolean openMini = false;
  public void drawMiniMap(int x, int y) {
    Tools.addRect(Tools.TYPE_RECT, x + screenWidth - mapSize[0] * miniSize - 2,
                  y, mapSize[0] * miniSize + 2, mapSize[1] * miniSize + 2, false,
                  Tools.TOP, 0xFFFFFF, 9999);
    for (int i = 0; i < mapSize[1]; i++) {
      for (int j = 0; j < mapSize[0]; j++) {
        if (canRun(j * 16, i * 16)) {
          Tools.addRect(Tools.TYPE_RECT,
                        x + screenWidth - (mapSize[0] - j) * miniSize - 1,
                        y + 1 + i * miniSize, miniSize, miniSize, true,
                        Tools.TOP, miniColor[0], 9999);
        }
        else {
          Tools.addRect(Tools.TYPE_RECT,
                        x + screenWidth - (mapSize[0] - j) * miniSize - 1,
                        y + 1 + i * miniSize, miniSize, miniSize, true,
                        Tools.TOP, miniColor[1], 9999);
        }
      }
    }

    int sx = GameEngine.sprite[GameEngine.spriteIndex].x;
    int sy = GameEngine.sprite[GameEngine.spriteIndex].y;
    Tools.addRect(Tools.TYPE_RECT,
                  x + screenWidth - (mapSize[0] - sx / 16) * miniSize - 1,
                  y + 1 + (sy / 16 - 1) * miniSize, miniSize, miniSize, true,
                  Tools.TOP, miniColor[2], 9999);
  }

  public static int getTrans(int v) {
    return ( (v >> 6) & 0x03);
  }

  public static int get2nd(int v) {
    return ( ( (v << 1) >> 7) & (byte) 0x01);
  }

  public static int getLow(int v) {
    return v & 0x3f;
  }

  static int bToi(byte byte0) {
    int i = byte0;
    if (byte0 < 0) {
      i += 256;
    }
    return i;
  }

  /****************************ս******************************/
  public void initBattleMap() {
    switch (GameMap.battleBg) {
      case 0:
        Tools.getImage(Tools.IMG_BBG1);
        Tools.getImage(Tools.IMG_BBG1_1);
        break;
      case 1:
        Tools.getImage(Tools.IMG_BBG2);
        Tools.getImage(Tools.IMG_BBG2_2);
        engine.initBirds();
        break;
      default:
        break;
    }
    Tools.getImage(Tools.IMG_BFRAME);
    Tools.getImage(Tools.IMG_01);
    Tools.getImage(Tools.IMG_27);
    Tools.getImage(Tools.IMG_28);
  }

  /****************************ȫ******************************/
  public static void drawFullScreenBG(int imgIndex, int height, int speed,
                                      int level) {
    int imgW = Tools.getImage(imgIndex).getWidth();
    int imgH = Tools.getImage(imgIndex).getHeight();
    int times = (screenWidth / imgW) + 2;
    int startPos = (setOffX * speed * 10) / 1000;
    while (setOffX - startPos >= imgW) {
      startPos += imgW;
    }
    for (int i = 0; i < times; i++) {
      Tools.addImage(imgIndex,
                     startPos + i * imgW, height, 0, 0, imgW, imgH,
                     Graphics.TOP | Graphics.LEFT, Tools.TRANS_NONE,
                     level);
    }
  }

  int getObjIndex(int id) {
    for (int i = 0; i < objData.length; i++) {
      if (objData[i][OBJ_ID] == id) {
        return i;
      }
    }
    return -1;
  }

  /****************************ͼװײ******************************/
  public int hitDecorations(int x, int y) {
    if (decData == null) {
      return -1;
    }
    for (int i = 0; i < decData.length; i++) {
      short id = decData[i][ITEM_TYPE];
      int objIndex = getObjIndex(id);
      if (objIndex != -1) {
        short w = objData[objIndex][OBJ_W];
        short h = objData[objIndex][OBJ_H];
        if (w == 0 || h == 0) {
          continue;
        }
        if (x >= decData[i][ITEM_X] &&
            (x < decData[i][ITEM_X] + w) &&
            y < decData[i][ITEM_Y] && (y > decData[i][ITEM_Y] - h)) {
          return i;
        }
      }
    }
    return -1;
  }

  public static int getIndex(int v) {
    return v & 0x3f;
  }

  public int getIndex(int x, int y, int index) {
    return getIndex(inMapData(x, y, index));
  }

  /****************************ȡͼ******************************/
  static byte[][] mData;
  static short[][] mProperties;
  static String[][] mName;
  static int layer;


  public void loadMap(String file) {
//    InputStream is = getClass().getResourceAsStream(file);
//    if (is == null) {
//      return;
//    }

    byte[] array=Tools.getDat("/map.dat",file);
    if (array == null) {
      System.out.println("map file is null!");
      return;
    }
    ByteArrayInputStream bais=new ByteArrayInputStream(array);
    DataInputStream in = new DataInputStream(bais);
    try {
      layer = bToi(in.readByte());
      mData = new byte[layer][];
      mProperties = new short[layer][];
      mName = new String[layer][];
      for (int i = 0; i < layer; i++) {
        //ȡͼ
        mapSize[0] = bToi(in.readByte());
        mapSize[1] = bToi(in.readByte());
        tileWidth = in.readByte();
        tileHight = in.readByte();
        int size = (int) (mapSize[0] * mapSize[1]);
        mData[i] = new byte[size];
        in.read(mData[i]);
        //******************
         //ȡtile
         //******************
        int len = in.readShort();
        mName[i] = new String[len];
        mProperties[i] = new short[len];
        for (int j = 0; j < len; j++) {
          int nameLen = in.readByte();
          byte[] names = new byte[nameLen];
          in.read(names);
          mName[i][j] = new String(names);
          mProperties[i][j] = in.readShort();
        }
      }
      in.close();
      bais.close();
    }
    catch (IOException ex) {
      System.out.println("************* Read Map Error !!! ******************");
    }
  }

//  public void loadMap(String file) {
//    InputStream is = getClass().getResourceAsStream("/map/" + file);
//    DataInputStream in = new DataInputStream(is);
//    try {
//      layer = bToi(in.readByte());
//      mData = new byte[layer][];
//      mProperties = new short[layer][];
//      mName = new String[layer][];
//      for (int i = 0; i < layer; i++) {
//        //ȡͼ
//        mapSize[0] = bToi(in.readByte());
//        mapSize[1] = bToi(in.readByte());
//        tileWidth = in.readByte();
//        tileHight = in.readByte();
//        int size = (int) (mapSize[0] * mapSize[1]);
//        mData[i] = new byte[size];
//        in.read(mData[i]);
//        //******************
//         //ȡtile
//         //******************
//        int len = in.readShort();
//        mName[i] = new String[len];
//        mProperties[i] = new short[len];
//        for (int j = 0; j < len; j++) {
//          int nameLen = in.readByte();
//          byte[] names = new byte[nameLen];
//          in.read(names);
//          mName[i][j] = new String(names);
//          mProperties[i][j] = in.readShort();
//        }
//      }
//      in.close();
//    }
//    catch (IOException ex) {
//      System.out.println("************* Read Map Error !!! ******************");
//    }
//  }

  /****************************ͼ******************************/
  public void setTile(Graphics g) {
    //
    int n = ( (setOffX / tileWidth) *
             mapSize[1] +
             (setOffY / tileHight));
    //
    int nw = (screenWidth / tileWidth) + 2;
    int nh = (screenHeight / tileHight) + 2;

    for (int j = 0; j < nw; j++) {
      int s = n + j * mapSize[1];
      for (int i = s; i < s + nh; i++) {
        if (i >= mData[1].length || i < 0) {
          continue;
        }
        int dataTemp = getLow(mData[1][i]);
        int temp = repaint(mData[1][i]);
        if (temp == 0) {
          continue;
        }
        int x = (i / mapSize[1]) * tileHight;
        int y = (i % mapSize[1]) * tileWidth;

        Tools.addImage(Tools.GRUOP_MAX * 2 + dataTemp,
                       x, y, 0, 0, tileWidth, tileHight,
                       Graphics.TOP | Graphics.LEFT,
                       (byte) getTrans(mData[1][i]),
                       temp == 1 ? L_HIGH : (y + L_LEV + 32));

      }
    }
  }

  /****************************ͼbuff******************************/

  Image mapBuff;
  int buffWidth;
  int buffHeight;
  void initMapBuff() {
//    mapBuff = null;
    isBuffNull = true;
    if (mapBuff == null) {
      tileWidth = 16;
      tileHight = 16;
      buffWidth = screenWidth - (screenWidth % tileWidth) + tileWidth * 2;
      buffHeight = screenHeight - (screenHeight % tileHight) + tileHight * 2;
      mapBuff = Image.createImage(buffWidth, buffHeight);
      g1 = mapBuff.getGraphics();
    }
  }

  void drawBuff(Graphics g, int clipX, int clipY, int clipW, int clipH,
                int x, int y) {
    g.setClip(x, y, clipW, clipH);
    g.drawImage(mapBuff, x - clipX, y - clipY, 20);
    g.setClip(0, 0, screenWidth, screenHeight);
  }

  boolean isBuffNull;
  int lastStartX;
  int lastStartY;
  int lastEndX;
  int lastEndY;
  Graphics g1 ;
  void drawMap(Graphics g, int setOffX, int setOffY) {
    int startX = setOffX / tileWidth;
    int endX = startX + screenWidth / tileWidth + 1;
    int startY = setOffY / tileHight;
    int endY = startY + screenHeight / tileHight + 1;
    if (isBuffNull) {
      isBuffNull = false;
      updateBuff(g1, startX, startY, endX, endY);
      lastStartX = startX;
      lastStartY = startY;
      lastEndX = endX;
      lastEndY = endY;
    }
    if (lastStartX != startX) {
      int tmp1;
      int tmp2;
      if (lastStartX < startX) {
        tmp1 = lastEndX + 1;
        tmp2 = endX;
      }
      else {
        tmp1 = startX;
        tmp2 = lastStartX - 1;
      }
      updateBuff(g1, tmp1, startY, tmp2, endY);
      lastStartX = startX;
      lastEndX = endX;
    }
    if (lastStartY != startY) {
      int tmp3;
      int tmp4;
      if (lastStartY < startY) {
        tmp3 = lastEndY + 1;
        tmp4 = endY;
      }
      else {
        tmp3 = startY;
        tmp4 = lastStartY - 1;
      }
      updateBuff(g1, startX, tmp3, endX, tmp4);
      lastStartY = startY;
      lastEndY = endY;
    }
    int t1 = setOffX % buffWidth;
    int t2 = setOffY % buffHeight;
    int t3 = (setOffX + screenWidth) % buffWidth;
    int t4 = (setOffY + screenHeight) % buffHeight;
    if (t3 > t1) {
      if (t4 > t2) {
        drawBuff(g, t1, t2, screenWidth, screenHeight, 0, 0);
      }
      else {
        drawBuff(g, t1, t2, screenWidth, screenHeight - t4, 0, 0);
        drawBuff(g, t1, 0, screenWidth, t4, 0, screenHeight - t4);
      }
    }
    else
    if (t4 > t2) {
      drawBuff(g, t1, t2, screenWidth - t3, screenHeight, 0, 0);
      drawBuff(g, 0, t2, t3, screenHeight, screenWidth - t3, 0);
    }
    else {
      drawBuff(g, t1, t2, screenWidth - t3, screenHeight - t4, 0, 0);
      drawBuff(g, t1, 0, screenWidth - t3, t4, 0, screenHeight - t4);
      drawBuff(g, 0, t2, t3, screenHeight - t4, screenWidth - t3, 0);
      drawBuff(g, 0, 0, t3, t4, screenWidth - t3, screenHeight - t4);
    }
  }

  void updateBuff(Graphics g, int startX, int startY, int endX, int endY) {
    int y = (startY * tileHight) % buffHeight;
    for (int i = startY; i <= endY; i++) {
      int x = (startX * tileWidth) % buffWidth;
      for (int j = startX; j <= endX; j++) {

        for (int k = 0; k < layer; k++) {
          int mapIndex = inMapData(j * tileWidth, i * tileHight, k); //getMapData(j, i);

          int dataTemp = getIndex(mapIndex);
          int transData = getTrans(mapIndex);
          if ( (byte) mapIndex != (byte) 0xff) {
            g.setClip(x, y, tileWidth, tileHight);
            Tools.drawClipImage(g, Tools.GRUOP_MAX * (k + 1) + dataTemp, x, y,
                                0, 0, tileWidth,
                                tileHight, Graphics.LEFT | Graphics.TOP,
                                transData);
            g.setClip(0, 0, buffWidth, buffHeight);
          }
          else if (k == 0) {
            g.setClip(x, y, tileWidth, tileHight);
            g.setColor(0);
            g.fillRect(x, y, tileWidth, tileHight);
            g.setClip(0, 0, buffWidth, buffHeight);
          }
        }
        x += tileWidth;
        if (x >= buffWidth) {
          x -= buffWidth;
        }
      }
      y += tileHight;
      if (y >= buffHeight) {
        y -= buffHeight;
      }
    }
  }

  static int flagMap = -1, flagX, flagY;

  public void drawTaskFlag(int lev) {
    if (flagMap == -1 || GameEngine.gameRank != flagMap ||
        MyGameCanvas.gameStatus == MyGameCanvas.ST_PASS_EFFECT) {
      return;
    }
//    if (flagImgIndex == 0) {
    Tools.addImage(Tools.IMG_TASKFLAG, flagX + 1 - 30, flagY+ GameMIDlet.gameIndex % 4,
                   0, 0, 55, 60, Tools.BOTTOM, Tools.TRANS_NONE, lev + flagY);
    Tools.addImage(Tools.IMG_TASKFLAG, flagX + 1 + 22 - 30,
                   flagY - 9 + GameMIDlet.gameIndex % 4,
                   55, 0, 17, 36, Tools.BOTTOM, Tools.TRANS_NONE, lev + flagY);

//    }
//    else {
//      Tools.addImage(Tools.IMG_TASKFLAG2,
//                      flagX - 17 - (GameMIDlet.gameIndex % 4) / 2, flagY,
//                      49 * ( (GameMIDlet.gameIndex % 4) / 2), 0, 49, 49,
//                      Tools.BOTTOM, Tools.TRANS_NONE, lev + flagY);
//
//    }

  }

  //####################################

  public static short[][] starPos;
  public static byte[][] starSpeed;
  public static byte[] starTypes; //ࣨСࣩ
  public static short[] starTimes;

//  public  int STARNUM = 20;
//  public static int speedOfScroll = 8; //ٶȵģǸֵԽٶȸԽǿ
//  int mapYPix = MyGameCanvas.SCREEN_HEIGHT; //mapYPixĻĸ߶
//  int topScrollPos = 0; //ҲoffsetYΪ0 ,ҲoffsetYΪ0

  static int starType; //Чࣩࣨ
  static int baseSpeedX, baseSpeedY;
  static int starNum;
  static int showStarTime;

  static void stopStar() {
    starPos = null;
    starSpeed = null;
    starTypes = null;
    starTimes = null;
    showStarTime = 0;
  }

  public static void initStar(int type, int speedX, int speedY, int num,
                              int time) {

    starType = type;
    baseSpeedX = speedX;
    baseSpeedY = speedY;
    starNum = num;

    starPos = new short[starNum][2];
    starSpeed = new byte[starNum][2];
    starTypes = new byte[starNum];
    starTimes = new short[starNum];
    for (int i = 0; i < starNum; i++) {
      starPos[i][0] = (short) ( (engine.nextInt(10000) %
                                 MyGameCanvas.SCREEN_WIDTH) + setOffX);
      starPos[i][1] = (short) ( (engine.nextInt(10000) %
                                 MyGameCanvas.SCREEN_HEIGHT) + setOffY);
      starSpeed[i][0] = (byte) (baseSpeedX == 0 ? 0 :
                                ( (engine.nextInt(10000) % 3) *
                                 (baseSpeedX > 0 ? 1 : -1) + baseSpeedX));
      starSpeed[i][1] = (byte) (baseSpeedY == 0 ? 0 :
                                ( (engine.nextInt(10000) % 3) + baseSpeedY));

      switch (starType) {
        case 1: //
          starTypes[i] = (byte) engine.nextInt(20);
          starTimes[i] = (short) (engine.nextInt(MyGameCanvas.SCREEN_HEIGHT /
                                                 starSpeed[i][1] - 2) + 2);
          break;
        case 2: //
          starTypes[i] = (byte) engine.nextInt(1);
          starTimes[i] = (short) (engine.nextInt(MyGameCanvas.SCREEN_HEIGHT /
                                                 starSpeed[i][1] - 2) + 2);
          break;
        case 3: //
          starTypes[i] = (byte) engine.nextInt(2);
          break;
      }

    }
    showStarTime = time; //-1,ѭţ0-ֹͣ>0һ
  }

  private static void refreshStarAllMap(int id) {

    starSpeed[id][0] = (byte) (baseSpeedX == 0 ? 0 :
                               ( (engine.nextInt(10000) % 3) *
                                (baseSpeedX > 0 ? 1 : -1) + baseSpeedX));
    starSpeed[id][1] = (byte) (baseSpeedY == 0 ? 0 :
                               ( (engine.nextInt(10000) % 3) + baseSpeedY));

    switch (starType) {

      case 1: //
        starPos[id][0] = (short) (engine.nextInt(10000) %
                                  (mapSize[0] * tileHight));
        starPos[id][1] = (short) (setOffY);
        starTypes[id] = (byte) engine.nextInt(20);
        starTimes[id] = (short) (engine.nextInt(MyGameCanvas.SCREEN_HEIGHT /
                                                starSpeed[id][1] - 2) + 2);
        break;
      case 2: //
        starPos[id][0] = (short) (engine.nextInt(10000) %
                                  (mapSize[0] * tileHight));
        starPos[id][1] = (short) (setOffY);
        starTypes[id] = (byte) engine.nextInt(1);
        starTimes[id] = (short) (engine.nextInt(MyGameCanvas.SCREEN_HEIGHT /
                                                starSpeed[id][1] - 2) + 2);
        break;
      case 3: //
        starPos[id][0] = (short) (setOffX + screenWidth);
        starPos[id][1] = (short) ( (engine.nextInt(10000) %
                                    MyGameCanvas.SCREEN_HEIGHT * 2) -
                                  MyGameCanvas.SCREEN_HEIGHT / 2);
        starTypes[id] = (byte) engine.nextInt(2);
//        starTimes[id] = (short) ((MyGameCanvas.SCREEN_WIDTH+206) / Math.abs(starSpeed[id][0]));
        break;

    }

  }

  public static void moveStar() { //moveStarÿ֡
    if (showStarTime == 0) {
      return;
    }

    if (starType == 3) {
      for (int i = 0; i < starNum; i++) {
        if (starPos[i][0] < setOffX - 210) {
          refreshStarAllMap(i);
        }
        else {
          starPos[i][0] += starSpeed[i][0];
          starPos[i][1] += starSpeed[i][1];
        }
      }
      return;
    }
    for (int i = 0; i < starNum; i++) {
      if (starTimes[i] <= 0) {
        refreshStarAllMap(i);
      }
      else {
        starPos[i][0] += starSpeed[i][0];
        starPos[i][1] += starSpeed[i][1];
        starTimes[i]--;
      }

    }
  }

  static short[] fogImg = {
      Tools.IMG_FOG1, Tools.IMG_FOG2, Tools.IMG_FOG3};
  public static void drawStar(int x, int y, int drawLevel) {
    if (showStarTime == 0) {
      return;
    }
    for (int i = 0; i < starNum; i++) {
      switch (starType) {

        case 1:
          Tools.addLine(Tools.TYPE_LINE, x + starPos[i][0], y + starPos[i][1],
                        x + starPos[i][0] - 2,
                        y + starPos[i][1] + starTypes[i] + 10, 0xffffff,
                        drawLevel);
          break;
        case 2:
          Tools.addImage(Tools.IMG_HUA, x + starPos[i][0], y + starPos[i][1],
                         GameData.imgDatHua[starTypes[i] * 4 +
                         (starTimes[i] % 8) / 2], Tools.TOP,
                         Tools.TRANS_NONE, drawLevel);

          break;

        case 3:
          Tools.addImage(fogImg[starTypes[i]], starPos[i][0], starPos[i][1],
                         Tools.TOP, Tools.TRANS_NONE, drawLevel);
          break;

//        case 2:
//          Tools.addObject(Tools.TYPE_ARC, x + starPos[i][0], y + starPos[i][1],
//                          starTypes[i] * 2 + 1, starTypes[i] * 2 + 1, 0, 360, true,
//                          Tools.TOP, 0xffffff, drawLevel);
//          break;
      }
    }
    if (showStarTime > 0) {
      showStarTime--;
    }
  }

  public void drawWeather(int lev) {
//    if (weather == 4) {
//      drawStone(lev);
//      return;
//    }
    moveStar();
    drawStar(0, 0, lev);
    if (weather == 3) {
      for (int i = 0; i < 8; i++) {
        Tools.addImage(Tools.IMG_FOGMODE, setOffX, setOffY + 40 * i,
                       Tools.TOP, Tools.TRANS_NONE, lev);
      }
    }
//    drawRain(L_TALK - 2);
//    drawFlower(L_TALK - 2);
    switch (weather) {
      case 0: //
        break;
      case 1: //
        drawRain(L_TALK - 2);
        break;
      case 2: //
        drawFlower(L_TALK - 2);
        break;
      case 3: //

//        drawStar(GameMap.setOffX, GameMap.setOffY, L_TALK - 2);
        if (clouds == null) {
          GameMap.initClouds( -1);
        }
        drawCloud(L_TALK - 2);
        break;
      case 4: //
        if (clouds == null) {
          GameMap.initClouds( -1);
        }
        drawCloud(L_TALK - 2);
        break;
    }
  }

  static int clouds[][];
  static void initClouds(int time) {
    showStarTime = time;
    clouds = new int[2][4];
    for (int i = 0; i < clouds.length; i++) {
      if ( (GameMIDlet.gameIndex + i % 2) == 0) {
        clouds[i][0] = GameEngine.nextInt(0, 260);
        clouds[i][1] = GameEngine.nextInt(0, -100);
      }
      else {
        clouds[i][0] = GameEngine.nextInt(240, 260);
        clouds[i][1] = GameEngine.nextInt(0, 160);
      }
      clouds[i][2] = -GameEngine.nextInt(2, 3);
      clouds[i][3] = 1;
    }
  }

  void drawCloud(int lev) {
    for (int i = 0; i < clouds.length; i++) {
      Tools.addImage(Tools.IMG_CLOUD, setOffX + clouds[i][0], setOffY + clouds[i][1],
                     Tools.TOP, Tools.TRANS_NONE, lev);
      clouds[i][0] += clouds[i][2];
      clouds[i][1] += clouds[i][3];
      if (clouds[i][0] < -199 || clouds[i][1] > 400) {
        if ( (GameMIDlet.gameIndex % 2 + i) == 0) {
          clouds[i][0] = GameEngine.nextInt(0, 120);
          clouds[i][1] = GameEngine.nextInt(0, -100);
        }
        else {
          clouds[i][0] = GameEngine.nextInt(100, 240);
          clouds[i][1] = GameEngine.nextInt( -50, 50);
        }
        clouds[i][2] = -GameEngine.nextInt(2, 3);
        clouds[i][3] = 1;

      }
    }
  }

//  static short stoneData[][];
//  static void initStone(int time) {
//    showStarTime = time;
//    stoneData = new short[15][6];
//    for (int i = 0; i < stoneData.length; i++) {
//      stoneData[i][0] = (short) GameEngine.nextInt(screenWidth);
//      stoneData[i][1] = (short) GameEngine.nextInt(screenHeight);
//      stoneData[i][2] = (short) GameEngine.nextInt(2);
//      stoneData[i][3] = (short) GameEngine.nextInt(3);
//      stoneData[i][4] = (short) GameEngine.nextInt(2, 8);
//      stoneData[i][5] = (short) GameEngine.nextInt(10);
//    }
//  }
//
//  private byte clipData[][] = {
//      {
//      0, 0, 44, 51}
//      , {
//      44, 0, 13, 14}
//      , {
//      44, 14, 18, 21}
//  };
//  private void drawStone(int lev) {
//    if (showStarTime == 0) {
//      return;
//    }
//    for (int i = 0; i < stoneData.length; i++) {
//      stoneData[i][1] -= stoneData[i][4];
//      Tools.addImage(Tools.IMG_STONE, setOffX + stoneData[i][0],
//                     setOffY + stoneData[i][1],
//                     clipData[stoneData[i][2]], Tools.BOTTOM,
//                     (byte) stoneData[i][3],
//                     stoneData[i][5] + lev);
//
//      if (stoneData[i][1] < 0) {
//        stoneData[i][0] = (short) GameEngine.nextInt(screenWidth);
//        stoneData[i][1] = (short) (setOffY + screenHeight +
//                                   GameEngine.nextInt(40));
//        stoneData[i][2] = (short) GameEngine.nextInt(2);
//        stoneData[i][3] = (short) GameEngine.nextInt(3);
//        stoneData[i][4] = (short) GameEngine.nextInt(2, 8);
//        stoneData[i][5] = (short) GameEngine.nextInt(10);
//      }
//    }
//  }

  int weatherIndex; // ʼ
  /**------------------------------------*/
  short rainData[][];
  int rainIndex;
  public void initRainData() {
    rainData = new short[20][3];
    weatherIndex = 0;
    for (int i = 0; i < rainData.length; i++) {
      rainData[i][0] = (short) (setOffX + GameEngine.nextInt(MyGameCanvas.SCREEN_WIDTH));
      rainData[i][1] = (short) (setOffY + GameEngine.nextInt(MyGameCanvas.SCREEN_HEIGHT));
      rainData[i][2] = (short) (GameEngine.nextInt(2));
    }
    rndNum = new byte[] { //Ϊ
        1, 1, 1, 1, 2, 2, 2, 2
    };
//     bjIndex = 0; //Ϊ
  }

  public void drawRain(int dl) { //GameMap.drawWeather()-->
    if (weatherIndex == 0) {
      initRainData();
    }
    for (int i = 0; i < rainData.length; i++) {
      rainData[i][0] += 6;
      rainData[i][1] += 12;
      if (rainData[i][0] >= setOffX + screenWidth + 10 ||
          rainData[i][1] >= setOffY + screenHeight + 20) { // rainData[i][0] <= map.setOffX - 10
        rainData[i][0] = (short) (setOffX + GameEngine.nextInt(MyGameCanvas.SCREEN_WIDTH));
        rainData[i][1] = (short) (setOffY + GameEngine.nextInt(MyGameCanvas.SCREEN_HEIGHT));
        rainData[i][2] = (short) (GameEngine.nextInt(2));
        Effect.AddEffectList(rainData[i][0], rainData[i][1],
                             Effect.EFFECT_RAINFLOWER, 0, dl);
      }
      Tools.addImage(Tools.IMG_RAIN, rainData[i][0], rainData[i][1],
                     6 * rainData[i][2], 0, 6, 12,
                     Tools.BOTTOM, Tools.TRANS_HORIZONTAL, dl);
    }
    weatherIndex++;
  }

  byte[] rndNum;
//   void rainFlash() {
//     if (++bjIndex == 40) {
//       bjIndex = 0;
//       if (Tools.percent(nextInt(50))) {
//         setScreenFlash(rndNum[nextInt(7)], 0xffffff);
//       }
//     }
//   }

  void rainFree() {
    rainData = null;
    rndNum = null;
    weatherIndex = 0;
//     bjIndex = 0;
  }

  /**--------------ƮĻ------------------*/
  static byte[][] flowerClipData;
  public final byte drawAmout = 12; // ÿγֵĻ
  int[][] startPos; // ʼλ
  byte[][] rndSpeed;
  void drawFlower(int dl) { //GameMap.drawWeather()-->
    if (weatherIndex == 0) {
      initFlower(5, 2);
//       initButterFly();
    }
    for (int i = 0; i < drawAmout; i++) {
      startPos[i][0] += GameEngine.nextInt(0, rndSpeed[i][0]);
      startPos[i][1] += GameEngine.nextInt(1, rndSpeed[i][1]);
      Tools.addImage(Tools.IMG_FLOWER, startPos[i][0], startPos[i][1],
                     flowerClipData[GameEngine.nextInt(7)],
                     Tools.TOP, Tools.TRANS_NONE, dl);
    }
    for (int i = 0; i < drawAmout; i++) {
      if ( (startPos[i][0] >= setOffX + MyGameCanvas.SCREEN_WIDTH + 10 ||
            startPos[i][1] >= setOffY + MyGameCanvas.SCREEN_HEIGHT)) {
        initOneFlower(i);
      }
    }
    ++weatherIndex;
  }

  void initFlower(int xSpeed, int ySpeed) { // ʼ
    startPos = new int[drawAmout][2];
    rndSpeed = new byte[drawAmout][2];
    for (int i = 0; i < drawAmout; i++) {
      rndSpeed[i][0] = (byte) xSpeed;
      rndSpeed[i][1] = (byte) ySpeed;
      initOneFlower(i);
      startPos[i][0] += xSpeed * GameEngine.nextInt(5, 20);
      startPos[i][1] += ySpeed * GameEngine.nextInt(5, 25);
    }
    flowerClipData = new byte[][] {
        {
        0, 0, 6, 5}
        , {
        6, 0, 6, 5}
        , {
        12, 0, 6, 5}
        , {
        18, 0, 6, 5}
        , {
        24, 0, 6, 5}
        , {
        30, 0, 6, 5}
        , {
        36, 0, 6, 5}
        , {
        42, 0, 6, 5}
    };
  }

  void initOneFlower(int ind) {
    byte rndHB = (byte) GameEngine.nextInt(0, 1);
    if (rndHB == 0) { // ĻϷ
      startPos[ind][0] = setOffX + GameEngine.nextInt(0, MyGameCanvas.SCREEN_WIDTH / 2);
      startPos[ind][1] = setOffY - GameEngine.nextInt(0, MyGameCanvas.SCREEN_HEIGHT / 8);
    }
    else { // Ļ󷽳
      startPos[ind][0] = setOffX - GameEngine.nextInt(0, MyGameCanvas.SCREEN_WIDTH / 8);
      startPos[ind][1] = setOffY + GameEngine.nextInt(0, MyGameCanvas.SCREEN_HEIGHT / 2);
    }
  }

  void flowerFree() {
    startPos = null;
    rndSpeed = null;
    flowerClipData = null;
//     bfPos = null;
  }

  public static void setWeather(int type) {
    weather = (short) type;
    switch (type) {
      case 0: //
        showStarTime = 0;
        break;
      case 1: //

//        initStar(type, -7, 15, 50, -1);
        break;
      case 2: //

//        initStar(type, -1, 2, 20, -1);

        break;
      case 3: //
        initStar(type, -2, 0, 20, -1);
        break;
      case 4: //

//        initStone( -1);
        initClouds( -1);
        break;
    }
  }

}
