/*
 * Decompiled with CFR 0.152.
 */
package ObjCtrl;

import ObjCtrl.iPoint;
import javax.microedition.lcdui.Graphics;

public class TouchSection {
    private iPoint position = new iPoint();
    private iPoint size = new iPoint();

    public TouchSection() {
    }

    public TouchSection(iPoint point, int w, int h) {
        this.position.x = point.x;
        this.position.y = point.y;
        this.size.x = w;
        this.size.y = h;
    }

    public TouchSection(int x, int y, int w, int h) {
        this.position.x = x;
        this.position.y = y;
        this.size.x = w;
        this.size.y = h;
    }

    public void setWH(int w, int h) {
        this.size.x = w;
        this.size.y = h;
    }

    public void setPosition(iPoint newPoint) {
        this.position.x = newPoint.x;
        this.position.y = newPoint.y;
    }

    public void setPosition(int x, int y) {
        this.position.x = x;
        this.position.y = y;
    }

    public int getX() {
        return this.position.x;
    }

    public int getY() {
        return this.position.y;
    }

    public int getWidth() {
        return this.size.x;
    }

    public int getHeight() {
        return this.size.y;
    }

    public void paint(Graphics g) {
        g.drawRect(this.position.x, this.position.y, this.size.x, this.size.y);
    }

    public boolean touch(int x, int y) {
        return x >= this.position.x & x <= this.position.x + this.size.x && y >= this.position.y & y <= this.position.y + this.size.y;
    }

    public boolean touch(iPoint point) {
        return point.x >= this.position.x & point.x <= this.position.x + this.size.x && point.y >= this.position.y & point.y <= this.position.y + this.size.y;
    }

    public boolean touch(TouchSection ts) {
        if (this.touch(ts.position)) {
            return true;
        }
        if (this.touch(ts.position.x, ts.position.y + ts.size.y)) {
            return true;
        }
        if (this.touch(ts.position.x + ts.size.x, ts.position.y + ts.size.y)) {
            return true;
        }
        if (this.touch(ts.position.x + ts.size.x, ts.position.y)) {
            return true;
        }
        if (ts.touch(this.position)) {
            return true;
        }
        if (ts.touch(this.position.x, this.position.y + this.size.y)) {
            return true;
        }
        if (ts.touch(this.position.x + this.size.x, this.position.y + this.size.y)) {
            return true;
        }
        return ts.touch(this.position.x + this.size.x, this.position.y);
    }
}

