/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.imagecontent;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import kiwi.database.imagecontent.FileCombo;
import kiwi.database.imagecontent.PalettedImage;

public class ImageContent {
    public static byte[] crc;
    public short[] cutdata;
    public byte w_unit;
    public byte h_unit;
    public byte[] type;
    public Image image;
    public Image[] cimage;
    public short wcount;
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[12];
        byArray[4] = 73;
        byArray[5] = 69;
        byArray[6] = 78;
        byArray[7] = 68;
        byArray[8] = -82;
        byArray[9] = 66;
        byArray[10] = 96;
        byArray[11] = -126;
        crc = byArray;
    }

    public ImageContent(String id, DataInputStream dis, String path) {
        this.readData(id, dis, path);
    }

    public void readData(String id, DataInputStream dis, String path) {
        block24: {
            try {
                if (dis.readByte() == 0) {
                    byte transform;
                    byte[] temp = new byte[12];
                    dis.read(temp);
                    String filename = String.valueOf(path) + "images/" + dis.readUTF();
                    int count = dis.readShort() * 4;
                    if (count > 0) {
                        this.cutdata = new short[count];
                        int i = 0;
                        while (i < this.cutdata.length) {
                            this.cutdata[i] = dis.readShort();
                            ++i;
                        }
                    }
                    int plet_index = 0;
                    byte[] plet_color = null;
                    if (dis.readBoolean()) {
                        plet_index = dis.readInt();
                        plet_color = new byte[dis.readInt()];
                        int i = 0;
                        while (i < plet_color.length) {
                            plet_color[i] = dis.readByte();
                            ++i;
                        }
                    }
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        bos.write(temp);
                        InputStream is = filename.getClass().getResourceAsStream(filename);
                        int ch = 0;
                        while ((ch = is.read()) != -1) {
                            bos.write(ch);
                        }
                        is.close();
                        bos.write(crc);
                        if (plet_color == null) {
                            byte[] b = bos.toByteArray();
                            this.image = Image.createImage((byte[])b, (int)0, (int)b.length);
                            b = null;
                        } else {
                            PalettedImage pi = new PalettedImage();
                            pi.setImageSrc(bos.toByteArray(), plet_index, plet_color);
                            this.image = pi.getImage();
                            pi = null;
                        }
                        bos.close();
                    }
                    catch (IOException e) {
                        System.out.println(String.valueOf(filename) + " \u5716\u7247\u627e\u4e0d\u5230");
                    }
                    this.w_unit = dis.readByte();
                    this.h_unit = dis.readByte();
                    if (this.w_unit == 0) {
                        this.w_unit = 1;
                    }
                    if (this.h_unit == 0) {
                        this.h_unit = 1;
                    }
                    this.wcount = (short)(this.image.getWidth() / this.w_unit);
                    if (dis.readBoolean()) {
                        int wcount = this.image.getWidth() / this.w_unit;
                        int hcount = this.image.getHeight() / this.h_unit;
                        this.type = new byte[hcount * wcount];
                        int i = 0;
                        while (i < hcount) {
                            int j = 0;
                            while (j < wcount) {
                                this.type[i * wcount + j] = dis.readByte();
                                ++j;
                            }
                            ++i;
                        }
                    }
                    if ((transform = dis.readByte()) == 4) {
                        this.image = Image.createImage((Image)this.image, (int)0, (int)0, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)2);
                    }
                    break block24;
                }
                this.cimage = new Image[dis.readByte()];
                String filename = String.valueOf(path) + "images/" + id + ".bin";
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("kiwi.database.imagecontent.ImageContent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InputStream is = clazz.getResourceAsStream(filename);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                if (is != null) {
                    int ch = 0;
                    while ((ch = is.read()) != -1) {
                        bos.write(ch);
                    }
                    byte[] data = bos.toByteArray();
                    bos.close();
                    int startindex = 0;
                    int i = 0;
                    while (i < this.cimage.length) {
                        int length = dis.readInt();
                        this.cimage[i] = Image.createImage((byte[])data, (int)startindex, (int)length);
                        startindex += length;
                        ++i;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Image getImage(int cutid) {
        if (this.image == null) {
            return this.cimage[cutid];
        }
        return this.image;
    }

    public int getX(int id) {
        return this.cutdata[id * 4];
    }

    public int getY(int id) {
        return this.cutdata[id * 4 + 1];
    }

    public int getWidth(int id) {
        return this.cutdata[id * 4 + 2];
    }

    public int getHeight(int id) {
        return this.cutdata[id * 4 + 3];
    }

    public boolean paint(Graphics g, int x, int y, int sx, int sy) {
        if (this.isRegion(g, x, y, this.w_unit, this.h_unit)) {
            g.drawRegion(this.image, sx, sy, (int)this.w_unit, (int)this.h_unit, 0, x, y, 0);
            return true;
        }
        return false;
    }

    boolean isRegion(Graphics g, int x, int y, int w, int h) {
        return x >= g.getClipX() - w && x < g.getClipX() + g.getClipWidth() && y >= g.getClipY() - h && y < g.getClipY() + g.getClipHeight();
    }

    public static ImageContent getImageContent(String id, String path) {
        InputStream is;
        path = String.valueOf(path) + "imagecontent/";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("kiwi.database.imagecontent.ImageContent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((is = clazz.getResourceAsStream(String.valueOf(path) + id)) != null) {
            DataInputStream dis = new DataInputStream(is);
            ImageContent w = new ImageContent(id, dis, path);
            try {
                dis.close();
                dis = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return w;
        }
        System.out.println("imagecontent error " + path + id);
        return null;
    }

    public static ImageContent getCImageContent(String id, String path) {
        InputStream is;
        path = String.valueOf(path) + "imagecontent/";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("kiwi.database.imagecontent.ImageContent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((is = clazz.getResourceAsStream(String.valueOf(path) + "cf.bin")) != null) {
            FileCombo fc = new FileCombo(new DataInputStream(is), id);
            ImageContent w = new ImageContent(id, fc.dis, path);
            fc.close();
            return w;
        }
        System.out.println("imagecontent error " + path + id);
        return null;
    }
}

