/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.map;

import java.io.DataInputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.TiledLayer;
import kiwi.database.imagecontent.ImageContent;
import kiwi.database.newsprite.NewSprite;

public class MapLayer {
    public static short screenwidth = (short)240;
    public static short screenheight = (short)320;
    public static short mapwidth = 0;
    public static short mapheight = 0;
    TiledLayer layer;
    public byte scrolltype;
    public short scrollrate;
    public short scrollx;
    public short scrolly;
    ImageContent ic;
    public NewSprite[] mapthing;
    int wt;

    public MapLayer(DataInputStream dis, String path, Hashtable v, boolean iscombine) {
        this.readData(dis, path, v, iscombine);
    }

    public void readData(DataInputStream dis, String path, Hashtable v, boolean iscombine) {
        try {
            short id = dis.readShort();
            String key = "layer" + String.valueOf(id);
            if (v.containsKey(key)) {
                this.ic = (ImageContent)v.get(key);
            } else {
                this.ic = iscombine ? ImageContent.getCImageContent(String.valueOf(id), path) : ImageContent.getImageContent(String.valueOf(id), path);
                v.put(key, this.ic);
            }
            int map_height = dis.readShort();
            int map_width = dis.readShort();
            this.layer = new TiledLayer(map_width, map_height, this.ic.getImage(-1), (int)this.ic.w_unit, (int)this.ic.h_unit);
            int i = 0;
            while (i < map_height) {
                int j = 0;
                while (j < map_width) {
                    int value = dis.readShort() + 1;
                    if (value > 1) {
                        this.layer.setCell(j, i, value);
                    }
                    ++j;
                }
                ++i;
            }
            this.scrolltype = dis.readByte();
            this.scrollrate = dis.readShort();
            this.scrollx = dis.readShort();
            this.scrolly = dis.readShort();
            int count = dis.readShort();
            if (count > 0) {
                NewSprite ns = null;
                this.mapthing = new NewSprite[count];
                int i2 = 0;
                while (i2 < count) {
                    String mid = dis.readUTF();
                    short frameseq = dis.readShort();
                    short x = dis.readShort();
                    short y = dis.readShort();
                    key = "mapthing" + mid;
                    if (v.containsKey(key)) {
                        ns = (NewSprite)v.get(key);
                    } else {
                        ns = NewSprite.getNewSprite(mid, path);
                        v.put(key, ns);
                    }
                    this.mapthing[i2] = new NewSprite(ns);
                    this.mapthing[i2].setPosition(x, y);
                    if (frameseq >= 0) {
                        this.mapthing[i2].setFrameSequenceData(frameseq);
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void draw(Graphics g, int offx, int offy, long time) {
        switch (this.scrolltype) {
            case 0: {
                this.layer.setPosition(offx, offy);
                break;
            }
            case 1: {
                this.autoScroll(time);
                break;
            }
            case 2: {
                this.layer.setPosition(this.getMScrollX(offx), this.getMScrollY(offy));
            }
        }
        this.layer.paint(g);
        if (this.mapthing != null) {
            int i = 0;
            while (i < this.mapthing.length) {
                this.mapthing[i].paint(g, this.layer.getX(), this.layer.getY());
                this.mapthing[i].nextFrame(time);
                ++i;
            }
        }
    }

    public int getType(int x, int y) {
        return this.getType(x, y, this.ic.w_unit, this.ic.h_unit);
    }

    public int getType(int x, int y, int w_unit, int h_unit) {
        if (x < 0 || x > this.getWidth() || y < 0 || y > this.getHeight()) {
            return 0;
        }
        int tx = x / w_unit;
        int ty = y / h_unit;
        if (tx < this.layer.getColumns() && ty < this.layer.getRows()) {
            int value = this.layer.getCell(tx, ty);
            if (value <= 0) {
                return 0;
            }
            return this.ic.type[this.layer.getCell(tx, ty) - 1];
        }
        return 0;
    }

    boolean isRegion(Graphics g, int x, int y, int w, int h) {
        return x >= g.getClipX() - w && x < g.getClipX() + g.getClipWidth() && y >= g.getClipY() - h && y < g.getClipY() + g.getClipHeight();
    }

    public int getWidth() {
        return this.layer.getWidth();
    }

    public int getHeight() {
        return this.layer.getHeight();
    }

    public int getRows() {
        return this.layer.getRows();
    }

    public int getColumns() {
        return this.layer.getColumns();
    }

    public int getCellWidth() {
        return this.layer.getCellWidth();
    }

    public int getCellHeight() {
        return this.layer.getCellHeight();
    }

    public void autoScroll(long addtime) {
        this.wt = (int)((long)this.wt + addtime);
        if (this.wt > this.scrollrate) {
            this.wt %= this.scrollrate;
            this.layer.move((int)this.scrollx, (int)this.scrolly);
        }
    }

    public int getMScrollX(int offsetx) {
        return offsetx * (screenwidth - this.getWidth()) / (screenwidth - mapwidth);
    }

    public int getMScrollY(int offsety) {
        return offsety * (screenheight - this.getHeight()) / (screenheight - mapheight);
    }
}

