/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.newsprite;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class MusicPlayer
implements PlayerListener {
    public Player player;
    public InputStream is;
    public byte playtime = 1;
    public static int volume = 60;
    public static boolean iswav = true;
    public String name;

    public MusicPlayer(String name) {
        this.name = name;
    }

    public void createPlayer(int looptime) {
        int vol = volume;
        String format = null;
        String s = this.name.substring(this.name.indexOf(".") + 1, this.name.length());
        if (s.endsWith("mid")) {
            format = "audio/midi";
        } else if (s.endsWith("wav")) {
            format = "audio/x-wav";
            if (vol != 0) {
                vol += 20;
            }
            if (!iswav) {
                return;
            }
        } else if (s.endsWith("mp3")) {
            format = "audio/mpeg";
        } else if (s.endsWith("amr")) {
            format = "audio/amr";
        }
        InputStream is = this.getClass().getResourceAsStream(this.name);
        try {
            if (is != null) {
                this.closeMusic();
                this.player = Manager.createPlayer((InputStream)is, (String)format);
                this.player.realize();
                this.player.prefetch();
                this.player.setLoopCount(looptime);
                if (looptime == 1) {
                    this.player.addPlayerListener((PlayerListener)this);
                }
                VolumeControl c = (VolumeControl)this.player.getControl("VolumeControl");
                c.setLevel(vol);
                c = null;
                is.close();
                is = null;
            } else {
                System.out.println("no find/music/" + this.name);
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.name) + "error");
        }
    }

    public void setVolume(int vol) {
        try {
            volume = vol;
            if (this.player != null && (this.player.getState() != 0 || this.player.getState() != 100)) {
                VolumeControl c = (VolumeControl)this.player.getControl("VolumeControl");
                c.setLevel(volume);
                c = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startMusic() {
        try {
            if (this.player != null) {
                this.player.start();
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public void stopMusic() {
        try {
            if (this.player != null && this.player.getState() == 400) {
                this.player.stop();
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public void closeMusic() {
        try {
            if (this.player != null) {
                if (this.player.getState() == 400) {
                    this.player.stop();
                }
                this.player.close();
                this.player = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getPlayMin() {
        if (this.player != null && this.player.getState() != 0) {
            return (int)(this.player.getMediaTime() / 1000000L / 60L);
        }
        return 0;
    }

    public int getPlaySec() {
        if (this.player != null && this.player.getState() != 0) {
            return (int)(this.player.getMediaTime() / 1000000L % 60L);
        }
        return 0;
    }

    public int getAllMin() {
        if (this.player != null && this.player.getState() != 0) {
            return (int)(this.player.getDuration() / 1000000L / 60L);
        }
        return 0;
    }

    public int getAllSec() {
        if (this.player != null && this.player.getState() != 0) {
            return (int)(this.player.getDuration() / 1000000L % 60L);
        }
        return 0;
    }

    public void playerUpdate(Player p, String arg1, Object arg2) {
        if ("endOfMedia".equals(arg1)) {
            p.close();
        }
    }
}

