/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.imagecontent;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;
import kiwi.database.imagecontent.CRCUtil;

public class PalettedImage {
    private byte[] imgData;
    private int paletteOffset;
    private int CRCOffset;
    private int paletteColors;

    public void setImageData(byte[] data) {
        this.imgData = data;
        this.analyze();
    }

    public void setImageSrc(String filename) {
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        try {
            is = filename.getClass().getResourceAsStream(filename);
            if (is == null) {
                System.out.println(String.valueOf(filename) + "no find");
            }
            baos = new ByteArrayOutputStream();
            int ch = 0;
            while ((ch = is.read()) != -1) {
                baos.write(ch);
            }
            this.setImageData(baos.toByteArray());
            is.close();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setImageSrc(String filename, int index, byte[] b) {
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        try {
            is = filename.getClass().getResourceAsStream(filename);
            if (is == null) {
                System.out.println(String.valueOf(filename) + "no find");
            }
            baos = new ByteArrayOutputStream();
            int ch = 0;
            int count = 0;
            while ((ch = is.read()) != -1) {
                baos.write(ch);
                ++count;
            }
            byte[] bb = baos.toByteArray();
            int i = 0;
            while (i < b.length) {
                bb[index + i] = b[i];
                ++i;
            }
            this.setImageData(bb);
            baos.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setImageSrc(byte[] bb, int index, byte[] b) {
        int i = 0;
        while (i < b.length) {
            bb[index + i] = b[i];
            ++i;
        }
        this.setImageData(bb);
    }

    public void setPalette(int[] colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        if (colors.length != this.paletteColors) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        int offset = this.paletteOffset;
        while (i < colors.length) {
            this.imgData[offset] = (byte)(colors[i] >> 16 & 0xFF);
            this.imgData[offset + 1] = (byte)(colors[i] >> 8 & 0xFF);
            this.imgData[offset + 2] = (byte)(colors[i] & 0xFF);
            ++i;
            offset += 3;
        }
    }

    public int getColorCount() {
        return this.paletteColors;
    }

    public void setColor(int index, byte[] color) {
        int i = 0;
        while (i < color.length) {
            this.imgData[index + i] = color[i];
            ++i;
        }
    }

    public void setColor(int index, int color) {
        if (index < 0 || index >= this.paletteColors) {
            throw new IllegalArgumentException();
        }
        int offset = this.paletteOffset + index * 3;
        this.imgData[offset] = (byte)(color >> 16 & 0xFF);
        this.imgData[offset + 1] = (byte)(color >> 8 & 0xFF);
        this.imgData[offset + 2] = (byte)(color & 0xFF);
    }

    public void replaceColor(int oldColor, int newColor) {
        byte rr = (byte)(oldColor >> 16 & 0xFF);
        byte gg = (byte)(oldColor >> 8 & 0xFF);
        byte bb = (byte)(oldColor & 0xFF);
        int i = 0;
        int offset = this.paletteOffset;
        while (i < this.paletteColors) {
            if (rr == this.imgData[offset] && gg == this.imgData[offset + 1] && bb == this.imgData[offset + 2]) {
                this.imgData[offset] = (byte)(newColor >> 16 & 0xFF);
                this.imgData[offset + 1] = (byte)(newColor >> 8 & 0xFF);
                this.imgData[offset + 2] = (byte)(newColor & 0xFF);
                break;
            }
            ++i;
            offset += 3;
        }
    }

    public int getColor(int index) {
        if (index < 0 || index >= this.paletteColors) {
            throw new IllegalArgumentException();
        }
        int offset = this.paletteOffset + index * 3;
        return (this.imgData[offset] & 0xFF) << 16 | (this.imgData[offset + 1] & 0xFF) << 8 | this.imgData[offset + 2] & 0xFF;
    }

    public Image getImage() {
        this.CRCChecksum();
        Image image = Image.createImage((byte[])this.imgData, (int)0, (int)this.imgData.length);
        this.imgData = null;
        return image;
    }

    private void analyze() {
        int offset = 8;
        int chunkLen = 0;
        while (this.imgData[offset + 4] != 80 || this.imgData[offset + 5] != 76 || this.imgData[offset + 6] != 84 || this.imgData[offset + 7] != 69) {
            chunkLen = this.readInt(offset);
            offset += 8 + chunkLen + 4;
        }
        chunkLen = this.readInt(offset);
        this.paletteColors = chunkLen / 3;
        this.paletteOffset = offset + 8;
        this.CRCOffset = offset + 8 + chunkLen;
    }

    private int readInt(int offset) {
        return (this.imgData[offset] & 0xFF) << 24 | (this.imgData[offset + 1] & 0xFF) << 16 | (this.imgData[offset + 2] & 0xFF) << 8 | this.imgData[offset + 3] & 0xFF;
    }

    private void CRCChecksum() {
        int checksum = CRCUtil.checksum(this.imgData, this.paletteOffset - 4, this.paletteColors * 3 + 4);
        this.imgData[this.CRCOffset] = (byte)(checksum >> 24 & 0xFF);
        this.imgData[this.CRCOffset + 1] = (byte)(checksum >> 16 & 0xFF);
        this.imgData[this.CRCOffset + 2] = (byte)(checksum >> 8 & 0xFF);
        this.imgData[this.CRCOffset + 3] = (byte)(checksum & 0xFF);
    }
}

