/*
 * Decompiled with CFR 0.152.
 */
package kiwi.database.map;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import kiwi.database.imagecontent.FileCombo;
import kiwi.database.map.Event;
import kiwi.database.map.MapLayer;
import kiwi.database.newsprite.Colide;
import kiwi.database.newsprite.NewSprite;
import kiwi.database.newsprite.NewSpriteFrame;

public class Map {
    public static final byte UP = 0;
    public static final byte DOWN = 1;
    public static final byte LEFT = 2;
    public static final byte RIGHT = 3;
    public MapLayer[] maplayers;
    public MapLayer basiclayer;
    public Event[] eventlayer;
    public int offx;
    public int offy;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Map(DataInputStream dis, String path, int screenwidth, int screenheight, boolean iscombine) {
        this.readData(dis, path, screenwidth, screenheight, iscombine);
    }

    public void readData(DataInputStream dis, String path, int screenwidth, int screenheight, boolean iscombine) {
        try {
            Hashtable v = new Hashtable();
            int layers = dis.readByte();
            this.maplayers = new MapLayer[layers];
            int i = 0;
            while (i < layers) {
                this.maplayers[i] = new MapLayer(dis, path, v, iscombine);
                ++i;
            }
            this.basiclayer = this.maplayers[dis.readByte()];
            v = null;
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics g, int offx, int offy, long time) {
        this.offx = offx;
        this.offy = offy;
        int i = this.maplayers.length - 1;
        while (i >= 0) {
            this.maplayers[i].draw(g, offx, offy, time);
            --i;
        }
    }

    public void setPosition(int x, int y) {
        int i = this.maplayers.length - 1;
        while (i >= 0) {
            this.maplayers[i].layer.setPosition(x, y);
            --i;
        }
    }

    public void move(int x, int y) {
        int i = this.maplayers.length - 1;
        while (i >= 0) {
            this.maplayers[i].layer.move(x, y);
            --i;
        }
    }

    public int getX() {
        return this.basiclayer.layer.getX();
    }

    public int getY() {
        return this.basiclayer.layer.getY();
    }

    public int getWidth() {
        return this.basiclayer.getWidth();
    }

    public int getHeight() {
        return this.basiclayer.getHeight();
    }

    public Event getEvent(Graphics g, int x, int y, int w, int h) {
        if (this.eventlayer == null) {
            return null;
        }
        int i = 0;
        while (i < this.eventlayer.length) {
            Event e = this.eventlayer[i];
            if (this.isRegion(g, x, y, w, h) && e.isColide(x, y, w, h)) {
                return e;
            }
            ++i;
        }
        return null;
    }

    public Event getColideEvent(Graphics g, NewSprite ns) {
        if (this.eventlayer == null) {
            return null;
        }
        NewSpriteFrame nsf = ns.getNewSpriteFrame();
        if (nsf.colides == null) {
            return null;
        }
        int i = 0;
        while (i < this.eventlayer.length) {
            Event e = this.eventlayer[i];
            if (this.isRegion(g, e.x, e.y, e.w, e.h)) {
                int j = 0;
                while (j < nsf.colides.length) {
                    Colide c = nsf.colides[j];
                    if (e.isColide(ns.getX() + c.x, ns.getY() + c.y, c.w, c.h)) {
                        return e;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public int getColideType(Graphics g, NewSprite ns) {
        if (this.eventlayer == null) {
            return -1;
        }
        NewSpriteFrame nsf = ns.getNewSpriteFrame();
        if (nsf.colides == null) {
            return -1;
        }
        int i = 0;
        while (i < this.eventlayer.length) {
            Event e = this.eventlayer[i];
            if (this.isRegion(g, e.x, e.y, e.w, e.h)) {
                int j = 0;
                while (j < nsf.colides.length) {
                    Colide c = nsf.colides[j];
                    if (e.isColide(ns.getX() + c.x, ns.getY() + c.y, c.w, c.h)) {
                        return c.type;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1;
    }

    boolean isRegion(Graphics g, int x, int y, int w, int h) {
        return (x += this.offx) >= g.getClipX() - w && x < g.getClipX() + g.getClipWidth() && (y += this.offy) >= g.getClipY() - h && y < g.getClipY() + g.getClipHeight();
    }

    public static Map getMap(String name, String path, int screenwidth, int screenheight) {
        InputStream is;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("kiwi.database.newsprite.NewSprite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((is = clazz.getResourceAsStream(String.valueOf(path) + name)) != null) {
            DataInputStream dis = new DataInputStream(is);
            Map w = new Map(dis, path, screenwidth, screenheight, false);
            try {
                dis.close();
                dis = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return w;
        }
        System.out.println("newsprite error " + name);
        return null;
    }

    public static Map getCMap(String name, String path, int screenwidth, int screenheight) {
        try {
            InputStream is;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("kiwi.database.imagecontent.ImageContent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((is = clazz.getResourceAsStream(String.valueOf(path) + "cf.bin")) != null) {
                FileCombo fc = new FileCombo(new DataInputStream(is), name);
                Map w = new Map(fc.dis, path, screenwidth, screenheight, true);
                fc.close();
                return w;
            }
            System.out.println("newsprite error " + name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

