/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import main.YTCanvas;

public class YTUtils {
    public static final void doGC() {
        System.gc();
        Thread.currentThread();
        Thread.yield();
        YTUtils.threadSleep(10L);
    }

    public static final void threadSleep(long time) {
        try {
            Thread.currentThread();
            Thread.sleep(time);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public static final long getTime() {
        return System.currentTimeMillis();
    }

    public static final void vibrate(YTCanvas _canvas, int _time) {
        _canvas.m_midlet.getDisplay().vibrate(_time);
    }

    public static final void flash(YTCanvas _canvas, int _time) {
        _canvas.m_midlet.getDisplay().flashBacklight(_time);
    }

    public static final void printOut(String str) {
        System.out.println(str);
    }

    public static int readInt(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getByteArrayFromFile(String _path) {
        if (_path == null) {
            YTUtils.printOut("load file to byte array error");
            return null;
        }
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        try {
            is = _path.getClass().getResourceAsStream(_path);
            if (is == null) {
                YTUtils.printOut("load file to byte array error");
                byte[] byArray = null;
                return byArray;
            }
            baos = new ByteArrayOutputStream();
            int ch = 0;
            while ((ch = is.read()) != -1) {
                baos.write(ch);
            }
        }
        catch (IOException ioe) {
            YTUtils.printOut("load file to byte array error");
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return baos.toByteArray();
    }

    public static final byte[] readDataByte(DataInputStream dis, int length) throws Exception {
        byte[] data = new byte[length];
        dis.read(data, 0, length);
        return data;
    }

    public static void readDataShort(DataInputStream dis, short[] data, int off, int length) {
        for (int i = 0; i < length; ++i) {
            try {
                data[i + off] = dis.readShort();
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

