/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import utils.YTGraphics;

public class YTFont {
    private int charSpacing;
    private int lineSpacing;
    private int fontHeight;
    private Font textFont = null;

    public YTFont(Font font) {
        this.textFont = null == font ? Font.getDefaultFont() : font;
        this.charSpacing = 0;
        this.lineSpacing = 2;
        this.fontHeight = this.textFont.getHeight();
    }

    public int getCharacterWidth(char character) {
        return this.textFont.charWidth(character);
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public int getCharSpacing() {
        return this.charSpacing;
    }

    public int getSpaceSize() {
        return this.textFont.charWidth(' ');
    }

    public int getLineHeight() {
        return this.getLineSpacing() + this.getFontHeight();
    }

    public int stringWidth(String _str) {
        return this.textFont != null ? this.textFont.stringWidth(_str) : 0;
    }

    public Font getFont() {
        return this.textFont;
    }

    public void drawChar(YTGraphics _g, char _c, int _x, int _y, int _anchor) {
        _g.getGraphics().drawChar(_c, _x, _y, _anchor);
    }

    public void drawSingleLine(YTGraphics _g, String _str, int _x, int _y, int _anchor, int _maincolor, int _outcolor) {
        int tx = _x;
        int ty = _y;
        int ax = 4;
        int ay = 16;
        if ((_anchor & 1) != 0) {
            ax = 1;
        } else if ((_anchor & 8) != 0) {
            ax = 8;
        }
        if ((_anchor & 2) != 0) {
            ay = 16;
            ty -= this.getFontHeight() >> 1;
        } else if ((_anchor & 0x20) != 0) {
            ay = 32;
        }
        _g.setFont(this);
        if (_outcolor != -1) {
            _g.setColor(_outcolor);
            _g.drawString(_str, tx - 1, ty, ax | ay);
            _g.drawString(_str, tx + 1, ty, ax | ay);
            _g.drawString(_str, tx, ty - 1, ax | ay);
            _g.drawString(_str, tx, ty + 1, ax | ay);
        }
        _g.setColor(_maincolor);
        _g.drawString(_str, tx, ty, ax | ay);
    }

    public void drawStringInArea(YTGraphics _g, String _str, int _x, int _y, int _w, int _h, int _anchor, int _maincolor, int _outcolor) {
        int clipx = _g.getClipX();
        int clipy = _g.getClipY();
        int clipwidth = _g.getClipWidth();
        int clipheight = _g.getClipHeight();
        int tx = _x;
        int ty = _y;
        int ax = 4;
        int ay = 16;
        int sw = this.stringWidth(_str);
        int[][] linedata = null;
        if (sw > _w) {
            linedata = this.splitString(_str, _w);
            int linenum = linedata.length;
            int height = linenum * this.getLineHeight();
            int cap = _h / this.getLineHeight();
            if (cap == 0) {
                cap = 1;
            }
            if ((_anchor & 8) != 0) {
                ax = 8;
                tx += _w;
            } else if ((_anchor & 1) != 0) {
                ax = 1;
                tx += _w >> 1;
            }
            if ((_anchor & 0x20) != 0) {
                ty = _y + _h - height;
            } else if ((_anchor & 2) != 0) {
                ty = _y + (_h >> 1) - (height >> 1);
            }
            ay = 16;
            _g.clipArea(_x, _y, _w, _h);
            for (int i = 0; i < linenum; ++i) {
                this.drawSingleLine(_g, _str.substring(linedata[i][0], linedata[i][1]), tx, ty + i * this.getLineHeight(), ax | ay, _maincolor, _outcolor);
            }
        } else {
            _g.clipArea(_x, _y, _w, _h);
            if ((_anchor & 8) != 0) {
                tx += _w;
            } else if ((_anchor & 1) != 0) {
                tx += _w >> 1;
            }
            if ((_anchor & 0x20) != 0) {
                ty += _h;
            } else if ((_anchor & 2) != 0) {
                ty += _h >> 1;
            }
            this.drawSingleLine(_g, _str, tx, ty, _anchor, _maincolor, _outcolor);
        }
        _g.clipArea(clipx, clipy, clipwidth, clipheight);
    }

    public int drawStringsAtXY(YTGraphics _g, String _str, int _x, int _y, int _w, int _anchor, int _maincolor, int _outcolor) {
        int tx = _x;
        int ty = _y;
        int ax = 4;
        int ay = 16;
        int sw = this.stringWidth(_str);
        int[][] linedata = null;
        if (sw > _w) {
            linedata = this.splitString(_str, _w);
            int linenum = linedata.length;
            int height = linenum * this.getLineHeight();
            if ((_anchor & 8) != 0) {
                ax = 8;
                tx += _w;
            } else if ((_anchor & 1) != 0) {
                ax = 1;
                tx += _w >> 1;
            }
            if ((_anchor & 0x20) != 0) {
                ty = _y - height;
            } else if ((_anchor & 2) != 0) {
                ty = _y - (height >> 1);
            }
            ay = 16;
            for (int i = 0; i < linenum; ++i) {
                this.drawSingleLine(_g, _str.substring(linedata[i][0], linedata[i][1]), tx, ty + i * this.getLineHeight(), ax | ay, _maincolor, _outcolor);
            }
            return height;
        }
        if ((_anchor & 8) != 0) {
            ax = 8;
            tx += _w;
        } else if ((_anchor & 1) != 0) {
            ax = 1;
            tx += _w >> 1;
        }
        if ((_anchor & 0x20) != 0) {
            ty -= this.getLineHeight();
        } else if ((_anchor & 2) != 0) {
            ty -= this.getLineHeight() >> 1;
        }
        ay = 16;
        this.drawSingleLine(_g, _str, tx, ty, ax | ay, _maincolor, _outcolor);
        return this.getLineHeight();
    }

    public int[][] splitString(String _in, int _width) {
        int[][] out = null;
        Vector<int[]> temp = new Vector<int[]>();
        int begin = 0;
        int end = 0;
        int linewidth = 0;
        int strlen = _in.length();
        int i = 0;
        while (i <= strlen) {
            boolean cut = false;
            char ch = '\n';
            if (i < strlen) {
                ch = _in.charAt(i);
            }
            if (ch == '\n') {
                cut = true;
            } else if (linewidth + this.getCharacterWidth(ch) >= _width) {
                cut = true;
            } else {
                linewidth += this.getCharacterWidth(ch);
            }
            if (cut) {
                end = i++;
                if (ch == '\n') {
                    // empty if block
                }
                int[] temp_store = new int[]{begin, end, end - begin};
                temp.addElement(temp_store);
                begin = i;
                linewidth = 0;
                continue;
            }
            ++i;
        }
        int length = temp.size();
        out = new int[length][3];
        for (i = 0; i < length; ++i) {
            out[i] = (int[])temp.elementAt(i);
        }
        return out;
    }
}

