/*
 * Decompiled with CFR 0.152.
 */
package utils;

import javax.microedition.lcdui.Graphics;
import utils.YTFont;
import utils.YTImage;

public class YTGraphics {
    public Graphics m_g = null;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int VCENTER = 2;
    public static final int HCENTER = 1;
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int COLOR_RED = 0xFF0000;
    public static final int COLOR_YELLOW = 0xFFFF00;
    public static final int COLOR_ORANGE = 16729344;
    public static final int COLOR_PINK = 0xFF00FF;
    public static final int COLOR_BROWN = 8399402;
    public static final int COLOR_BLUE = 255;
    public static final int COLOR_GREEN = 65280;
    public static final int COLOR_PURPLE = 10494192;
    private static boolean m_fading;
    private static int m_fadeLevel;
    private static int m_fadeColor;
    private static int m_fadeDir;
    private static int m_fadeStep;
    public static final int FADE_STEP = 0x202020;
    private static int m_fadeTime;
    private static final int FADE_IMAGE_WIDTH = 44;
    private static final int FADE_IMAGE_HEIGHT = 44;
    private static final int[] m_fadeRGB;

    public Graphics getGraphics() {
        return this.m_g;
    }

    public void setGraphics(Graphics _g) {
        if (null == this.m_g && null != _g) {
            this.m_g = _g;
        }
    }

    public void endGraphics() {
        this.m_g = null;
    }

    public void drawRect(int _color, int _style, int _x, int _y, int _w, int _h) {
        this.m_g.setColor(_color);
        if (_style == 1 || _style == 0) {
            this.m_g.setStrokeStyle(_style);
        }
        this.m_g.drawRect(_x, _y, _w, _h);
    }

    public void drawLine(int _color, int _style, int _sx, int _sy, int _ex, int _ey) {
        this.m_g.setColor(_color);
        if (_style == 1 || _style == 0) {
            this.m_g.setStrokeStyle(_style);
        }
        this.m_g.drawLine(_sx, _sy, _ex, _ey);
    }

    public void drawArc(int _color, int _style, int _x, int _y, int _w, int _h, int _sa, int _da) {
        this.m_g.setColor(_color);
        if (_style == 1 || _style == 0) {
            this.m_g.setStrokeStyle(_style);
        }
        this.m_g.drawArc(_x, _y, _w, _h, _sa, _da);
    }

    public void drawRoundRect(int _color, int _style, int _x, int _y, int _w, int _h, int _hw, int _vh) {
        this.m_g.setColor(_color);
        if (_style == 1 || _style == 0) {
            this.m_g.setStrokeStyle(_style);
        }
        this.m_g.drawRoundRect(_x, _y, _w, _h, _hw, _vh);
    }

    public void fillRect(int _color, int _x, int _y, int _w, int _h) {
        this.m_g.setColor(_color);
        this.m_g.fillRect(_x, _y, _w, _h);
    }

    public void fillArc(int _color, int _x, int _y, int _w, int _h, int _sa, int _da) {
        this.m_g.setColor(_color);
        this.m_g.fillArc(_x, _y, _w, _h, _sa, _da);
    }

    public void fillRoundRect(int _color, int _x, int _y, int _w, int _h, int _hw, int _vh) {
        this.m_g.setColor(_color);
        this.m_g.fillRoundRect(_x, _y, _w, _h, _hw, _vh);
    }

    public void clipArea(int _x, int _y, int _w, int _h) {
        this.m_g.setClip(_x, _y, _w, _h);
    }

    public void clipAll() {
        this.clipArea(0, 0, 240, 320);
    }

    public int getClipX() {
        return this.m_g.getClipX();
    }

    public int getClipY() {
        return this.m_g.getClipY();
    }

    public int getClipWidth() {
        return this.m_g.getClipWidth();
    }

    public int getClipHeight() {
        return this.m_g.getClipHeight();
    }

    public void drawImage(YTImage _image, int _x, int _y, int _anchor) throws Exception {
        if (null != _image) {
            this.m_g.drawImage(_image.m_image, _x, _y, _anchor);
        }
    }

    public void drawString(String _str, int _x, int _y, int _anchor) {
        this.m_g.drawString(_str, _x, _y, _anchor);
    }

    public void drawRGB(int[] _data, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
        this.m_g.drawRGB(_data, offset, scanlength, x, y, width, height, processAlpha);
    }

    public void renderAlphaRect(int x, int y, int width, int height, int alpha) {
        int[] colorArray = new int[width];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = alpha;
        }
        this.m_g.drawRGB(colorArray, 0, 0, x, y, width, height, true);
    }

    public void drawRegion(YTImage _image, int _distx, int _disty, int _w, int _h, int _x, int _y, int _anchor) throws Exception {
        int clipx = this.getClipX();
        int clipy = this.getClipY();
        int clipwidth = this.getClipWidth();
        int clipheight = this.getClipHeight();
        if ((_anchor & 8) == 8) {
            _x -= _w;
        } else if ((_anchor & 1) == 1) {
            _x -= _w >> 1;
        }
        if ((_anchor & 0x20) == 32) {
            _y -= _h;
        } else if ((_anchor & 2) == 2) {
            _y -= _h >> 1;
        }
        this.clipArea(_x, _y, _w, _h);
        this.drawImage(_image, _x - _distx, _y - _disty, 20);
        this.clipArea(clipx, clipy, clipwidth, clipheight);
    }

    public void drawRegion(YTImage _image, int _distx, int _disty, int _w, int _h, int _x, int _y, int _trans, int _anchor) throws Exception {
        if (_trans == 0) {
            this.drawRegion(_image, _distx, _disty, _w, _h, _x, _y, _anchor);
        } else {
            this.m_g.drawRegion(_image.m_image, _distx, _disty, _w, _h, _trans, _x, _y, _anchor);
        }
    }

    public void setColor(int _color) {
        this.m_g.setColor(_color);
    }

    public void setFont(YTFont _font) {
        this.m_g.setFont(_font.getFont());
    }

    public void drawNumber(String _str, int _x, int _y, int _align, YTImage _image) {
        if (_str == null) {
            return;
        }
        int _len = _str.length();
        int _w = _image.m_width / 12;
        int _h = _image.m_height;
        if ((_align & 0x20) == 32) {
            _y -= _h;
        } else if ((_align & 2) == 2) {
            _y -= _h / 2;
        }
        if ((_align & 1) == 1) {
            _x -= _w * _len / 2;
        } else if ((_align & 8) == 8) {
            _x -= _w * _len;
        }
        for (int i = 0; i < _len; ++i) {
            char c = _str.charAt(i);
            int _nShift = -1;
            if (c >= '/' && c <= ':') {
                _nShift = c - 47;
            }
            if (_nShift < 0) continue;
            this.clipArea(_x + _w * i, _y, _w, _h);
            try {
                this.drawImage(_image, _x + _w * i - _nShift * _w, _y, 20);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.clipAll();
    }

    public int getMultiTrans(int _trans, boolean flip_x, boolean flip_y) {
        if (!flip_x && !flip_y) {
            return _trans;
        }
        if (flip_x && !flip_y) {
            switch (_trans) {
                case 0: {
                    return 2;
                }
                case 2: {
                    return 0;
                }
                case 1: {
                    return 3;
                }
                case 3: {
                    return 1;
                }
            }
        } else if (!flip_x && flip_y) {
            switch (_trans) {
                case 0: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
                case 3: {
                    return 2;
                }
            }
        } else {
            switch (_trans) {
                case 0: {
                    return 3;
                }
                case 2: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 3: {
                    return 0;
                }
            }
        }
        return 0;
    }

    public static void startFadeOut() {
        m_fadeLevel = 0xFFFFFF;
        m_fadeDir = -1;
        m_fading = true;
    }

    public static void startFadeIn() {
        m_fadeLevel = 0;
        m_fadeDir = 1;
        m_fading = true;
    }

    public static void stopFade() {
        m_fadeLevel = 0xFFFFFF;
        m_fadeDir = -1;
        m_fading = false;
    }

    public static boolean fadeColourReached() {
        return m_fadeDir > 0 && m_fadeLevel >= 0xFFFFFF || m_fadeDir < 0 && m_fadeLevel <= 0;
    }

    public static void setFadeColor(int c) {
        m_fadeColor = c;
    }

    public static boolean isFading() {
        return m_fading;
    }

    public static boolean isFadingOut() {
        return YTGraphics.isFading() && m_fadeDir == -1;
    }

    public static boolean isFadingIn() {
        return YTGraphics.isFading() && m_fadeDir == 1;
    }

    public static int getFadeDir() {
        return m_fadeDir;
    }

    public static void setFadeStep(int step) {
        m_fadeStep = step;
    }

    public static int getFadeStep() {
        return m_fadeStep;
    }

    public static void updateFading(int _timeStep) {
        if (m_fading && (m_fadeTime += _timeStep) >= 100) {
            m_fadeTime = 0;
            if (m_fadeDir > 0 && (m_fadeLevel += m_fadeDir * m_fadeStep) >= 0xFFFFFF) {
                m_fadeLevel = 0xFFFFFF;
            } else if (m_fadeDir < 0 && m_fadeLevel <= 0) {
                m_fadeLevel = 0;
            }
        }
    }

    public void renderFade(int _x, int _y, int _w, int _h) {
        if (this.m_g == null) {
            return;
        }
        int COLOR = 255 - (m_fadeLevel & 0xFF) << 24 | m_fadeColor;
        System.out.println(COLOR);
        if (COLOR != m_fadeRGB[0]) {
            int NUM = m_fadeRGB.length;
            for (int i = 0; i < NUM; ++i) {
                YTGraphics.m_fadeRGB[i] = COLOR;
            }
        }
        int START_X = _x;
        int START_Y = _y;
        int END_X = START_X + _w;
        int END_Y = START_Y + _h;
        for (int x = START_X; x <= END_X; x += 44) {
            for (int y = START_Y; y <= END_Y; y += 44) {
                this.m_g.drawRGB(m_fadeRGB, 0, 44, x, y, 44, 44, true);
            }
        }
    }

    public static final void drawShadeRect(Graphics g, int color, int x, int y, int width, int height) {
        int[] rgb = YTGraphics.getShadeColor(color, width);
        for (int by = y; by < y + 20; by += 4) {
            int nTemp = y + 20 - (by - y);
            nTemp = nTemp > 4 ? 4 : nTemp;
            g.drawRGB(rgb, 0, width, x, by, width, nTemp, true);
        }
    }

    public static final int[] getShadeColor(int color, int width) {
        int shadeWidth = width;
        int nRgbData = shadeWidth * 4;
        int[] rgb = new int[nRgbData];
        int alpha = -127;
        for (int i = 0; i < shadeWidth; ++i) {
            int col;
            alpha = -127 + i;
            rgb[i] = col = color | 128 - alpha << 24;
            rgb[i + shadeWidth] = col;
            rgb[i + shadeWidth * 2] = col;
            rgb[i + shadeWidth * 3] = col;
        }
        return rgb;
    }

    static {
        m_fadeTime = 0;
        m_fadeRGB = new int[1936];
    }
}

