/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.IOException;
import javax.microedition.lcdui.Image;

public class YTRGBImage {
    private int m_width = 0;
    private int m_height = 0;
    private int[] m_rgbdata = null;
    private int curAlpha;
    private int[] m_orginalrgbdata = null;
    private final int[] FADE_SPEED = new int[]{0x3000000, 0x6000000, 0x9000000};

    public YTRGBImage(Image _img) throws IOException {
        this.m_width = _img.getWidth();
        this.m_height = _img.getHeight();
        this.m_rgbdata = new int[this.m_width * this.m_height];
        this.m_orginalrgbdata = new int[this.m_width * this.m_height];
        _img.getRGB(this.m_orginalrgbdata, 0, this.m_width, 0, 0, this.m_width, this.m_height);
    }

    public void fade(int alpha) {
        for (int i = 0; i < this.m_rgbdata.length; ++i) {
            if ((this.m_orginalrgbdata[i] & 0xFF000000) == 0) continue;
            this.m_rgbdata[i] = this.m_orginalrgbdata[i] & alpha + 0xFFFFFF;
        }
    }

    public int getFadeSpeed(int type) {
        if (type < 0) {
            return this.FADE_SPEED[0];
        }
        if (type > 2) {
            return this.FADE_SPEED[2];
        }
        return this.FADE_SPEED[type];
    }

    public void setAlpha(int _in) {
        this.curAlpha = _in;
    }

    public void startFadeIn() {
        this.setAlpha(0);
    }

    public boolean fadein(int speed) {
        if (this.curAlpha == -67108864) {
            return true;
        }
        this.curAlpha += this.getFadeSpeed(speed);
        this.fade(this.curAlpha);
        return false;
    }

    public void resetRGBData(boolean show) {
        this.m_rgbdata = null;
        this.m_rgbdata = new int[this.m_width * this.m_height];
        if (show) {
            System.arraycopy(this.m_orginalrgbdata, 0, this.m_rgbdata, 0, this.m_rgbdata.length);
        }
    }

    public void startFadeOut() {
        this.setAlpha(-67108864);
    }

    public boolean fadeout(int speed) {
        if (this.curAlpha == 0) {
            return true;
        }
        this.curAlpha -= this.getFadeSpeed(speed);
        this.fade(this.curAlpha);
        return false;
    }

    public void negative() {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        for (int i = 0; i < this.m_height; ++i) {
            for (int ii = 0; ii < this.m_width; ++ii) {
                int argb = this.m_orginalrgbdata[i * this.m_width + ii];
                a = (argb & 0xFF000000) >> 24;
                r = 255 - ((argb & 0xFF0000) >> 16);
                g = 255 - ((argb & 0xFF00) >> 8);
                b = 255 - (argb & 0xFF);
                this.m_rgbdata[i * this.m_width + ii] = a << 24 | r << 16 | g << 8 | b;
            }
        }
    }

    public Image getRGBImage() {
        return Image.createRGBImage((int[])this.m_rgbdata, (int)this.m_width, (int)this.m_height, (boolean)true);
    }

    public Image getOrginalImage() {
        return Image.createRGBImage((int[])this.m_orginalrgbdata, (int)this.m_width, (int)this.m_height, (boolean)true);
    }
}

