/*
 * Decompiled with CFR 0.152.
 */
package utils;

import main.YTCanvas;
import utils.YTGraphics;
import utils.YTUtils;

public abstract class YTScene {
    public static final byte SCENE_NONE = 0;
    public static final byte SCENE_LOGO = 1;
    public static final byte SCENE_MENU = 2;
    public static final byte SCENE_GAME = 3;
    public final YTCanvas m_canvas;
    protected int m_loadingProgress = 0;
    protected int m_initialState = 0;
    protected int m_iCount = 0;
    protected int m_state = 0;
    protected boolean m_inited = false;

    protected YTScene(YTCanvas canvas, int state) {
        this.m_canvas = canvas;
        this.m_initialState = state;
        this.m_loadingProgress = 0;
    }

    protected abstract void start();

    public abstract void pause();

    public abstract void resume();

    public abstract void end();

    public abstract void render(YTGraphics var1);

    public abstract void update(int var1);

    public abstract void updateLoading(int var1);

    public final void setState(int _state) {
        this.m_state = _state;
    }

    public final int getState() {
        return this.m_state;
    }

    public final int getLoadingProgress() {
        return this.m_loadingProgress;
    }

    public boolean IsInited() {
        return this.m_inited;
    }

    public void loadScene() {
        YTUtils.doGC();
        this.start();
        YTUtils.doGC();
    }
}

