/*
 * Decompiled with CFR 0.152.
 */
package com.studio.motionwelder;

import com.studio.motionwelder.MSpriteData;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import wolverine.Box;

public abstract class MPlayer {
    private MSpriteData data;
    private int animation;
    private int frame;
    private int frameCount;
    private int loopOffset;
    private int mwFrameTablePointer;
    private int[] rect = new int[4];
    private final byte ELLIPSE_FLAG_NONE;
    private final byte ELLIPSE_FLAG_FILLED = (byte)3;
    private final byte LINE_FLAG = (byte)5;
    private final byte RECTANGLE_FLAG_NONE = (byte)7;
    private final byte RECTANGLE_FLAG_FILLED = (byte)9;
    private final byte ROUNDEDRECTANGLE_FLAG_NONE = (byte)11;
    private final byte ROUNDEDRECTANGLE_FLAG_FILLED = (byte)13;
    private final byte POSITIONRECTANGLE_FLAG = (byte)15;
    private final byte COLLISIONRECTANGLE_FLAG = (byte)17;
    public long lastFrameChange;
    public int slowTimes = 1;
    public int cycleTotal;
    public boolean isActFrame;
    public boolean isMovFrame;
    public boolean isEffFrame;
    public boolean effShake;
    public boolean effColor;
    public boolean isAddFrame;
    public boolean isInsFrame;
    public boolean isInaFrame;
    public boolean isSloFrame;
    public int actType;
    public int dirMove;
    public int disMove;
    public int shakeT;
    public int shakeD;
    public int colorT;
    public int addIdx;
    public int insIdx;
    public int sloDura;
    public int sloInfo;
    public int scrLen = 10;
    public int scrPosId;
    public int scrId;
    public int[] scrFrames = new int[this.scrLen];
    public static final int nonFlip = 0;
    public static final int horFlip = 2;
    public static final int verFlip = 1;
    public static final int rotate1 = 5;
    public static final int rotate2 = 3;
    public static final int rotate3 = 6;
    public static final int rotate4 = 7;
    public static final int rotate5 = 4;

    public MPlayer(MSpriteData mSpriteData) {
        this.ELLIPSE_FLAG_NONE = 1;
        this.data = mSpriteData;
    }

    public void setAnimation(int n) {
        this.animation = n;
        int n2 = n << 1;
        this.frameCount = this.data.mwAnimaTable[n2 + 1] - this.data.mwAnimaTable[n2] + 1;
        this.setFrame(0);
        this.notifyStartOfAnimation();
    }

    public int getAnimation() {
        return this.animation;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int n) {
        this.frame = n;
        int n2 = this.data.mwAnimaTable[this.animation << 1] + n;
        this.mwFrameTablePointer = this.data.mwFrameTable[n2 << 2];
    }

    public void setLoopOffset(int n) {
        this.loopOffset = n;
    }

    public int getAnimationCount() {
        return this.data.mwAnimaTable.length >> 1;
    }

    public int getNumberOfPositionRect() {
        int n = 0;
        int n2 = this.data.mwFrameClipIndexTable[this.mwFrameTablePointer << 1];
        short s = this.data.mwFrameClipIndexTable[(this.mwFrameTablePointer << 1) + 1];
        while (n2 < s) {
            n2 += 3;
            if ((byte)this.data.mwClipTable[n2++] != 15) continue;
            ++n;
        }
        return n;
    }

    public int[] getPositionRect(int n) {
        int n2 = -1;
        int n3 = this.data.mwFrameClipIndexTable[this.mwFrameTablePointer << 1];
        short s = this.data.mwFrameClipIndexTable[(this.mwFrameTablePointer << 1) + 1];
        while (n3 < s) {
            int n4 = this.data.mwClipTable[n3++];
            int n5 = this.data.mwClipTable[n3++];
            int n6 = this.data.mwClipTable[n3++];
            if ((byte)this.data.mwClipTable[n3++] != 15 || ++n2 != n) continue;
            this.rect[2] = this.data.mwPositionRectangleClipLib[n4 <<= 1];
            this.rect[3] = this.data.mwPositionRectangleClipLib[n4 + 1];
            byte by = this.getSpriteOrientation();
            if (by == 1) {
                n5 = -n5 - this.rect[2];
            } else if (by == 2) {
                n6 = -n6 - this.rect[3];
            } else if (by == 3) {
                n5 = -n5 - this.rect[2];
                n6 = -n6 - this.rect[3];
            }
            this.rect[0] = n5;
            this.rect[1] = n6;
            return this.rect;
        }
        return null;
    }

    public int getNumberOfCollisionRect() {
        int n = 0;
        int n2 = this.data.mwFrameClipIndexTable[this.mwFrameTablePointer << 1];
        short s = this.data.mwFrameClipIndexTable[(this.mwFrameTablePointer << 1) + 1];
        while (n2 < s) {
            n2 += 3;
            if ((byte)this.data.mwClipTable[n2++] != 17) continue;
            ++n;
        }
        return n;
    }

    public int[] getCollisionRect(int n) {
        int n2 = -1;
        int n3 = this.data.mwFrameClipIndexTable[this.mwFrameTablePointer << 1];
        short s = this.data.mwFrameClipIndexTable[(this.mwFrameTablePointer << 1) + 1];
        while (n3 < s) {
            int n4 = this.data.mwClipTable[n3++];
            int n5 = this.data.mwClipTable[n3++];
            int n6 = this.data.mwClipTable[n3++];
            if ((byte)this.data.mwClipTable[n3++] != 17 || ++n2 != n) continue;
            this.rect[2] = this.data.mwPositionRectangleClipLib[n4 <<= 1];
            this.rect[3] = this.data.mwPositionRectangleClipLib[n4 + 1];
            byte by = this.getSpriteOrientation();
            if (by == 1) {
                n5 = -n5 - this.rect[2];
            } else if (by == 2) {
                n6 = -n6 - this.rect[3];
            } else if (by == 3) {
                n5 = -n5 - this.rect[2];
                n6 = -n6 - this.rect[3];
            }
            this.rect[0] = n5;
            this.rect[1] = n6;
            return this.rect;
        }
        return null;
    }

    public void update() {
        int n = this.data.mwAnimaTable[this.animation << 1] + this.frame;
        long l = System.currentTimeMillis() - this.lastFrameChange;
        if (l > (long)(this.data.mwFrameTable[(n << 2) + 1] * this.slowTimes * 100)) {
            this.lastFrameChange = System.currentTimeMillis();
            if (this.frame >= this.frameCount - 1) {
                if (this.loopOffset < 0) {
                    this.notifyEndOfAnimation();
                    return;
                }
                this.frame = this.loopOffset - 1;
                ++this.cycleTotal;
            }
            this.setFrame(this.frame + 1);
            n = this.data.mwAnimaTable[this.animation << 1] + this.frame;
            short s = this.data.mwFrameTable[(n << 2) + 2];
            short s2 = this.data.mwFrameTable[(n << 2) + 3];
            this.updateSpritePositionBy(this.getSpriteOrientation() == 1 ? -s : s, this.getSpriteOrientation() == 2 ? -s2 : s2);
            this.isActFrame = false;
            this.isMovFrame = false;
            this.isEffFrame = false;
            this.effShake = false;
            this.effColor = false;
            this.isAddFrame = false;
            this.isInsFrame = false;
            this.isInaFrame = false;
            this.isSloFrame = false;
            this.actType = 0;
            this.dirMove = 0;
            this.disMove = 0;
            this.shakeT = 0;
            this.shakeD = 0;
            this.colorT = 0;
            this.addIdx = 0;
            this.insIdx = 0;
            this.sloDura = 0;
            this.sloInfo = 0;
            this.scrPosId = 0;
            this.scrId = 0;
            this.scrFrames = new int[this.scrLen];
            int n2 = this.data.mwFrameClipIndexTable[this.mwFrameTablePointer << 1];
            short s3 = this.data.mwFrameClipIndexTable[(this.mwFrameTablePointer << 1) + 1];
            while (n2 < s3) {
                int n3;
                short s4 = this.data.mwClipTable[n2++];
                short s5 = this.data.mwClipTable[n2++];
                short s6 = this.data.mwClipTable[n2++];
                if ((n3 = (int)this.data.mwClipTable[n2++]) != 13) break;
                int n4 = s4 * 5;
                int n5 = this.data.mwRoundedRectangleClipLib[n4 + 4] & 0xFFFFFF;
                int n6 = n5 >> 16;
                int n7 = (n5 & 0xFFFF) >> 8;
                int n8 = n5 & 0xFF;
                switch (n6) {
                    case 1: {
                        this.isMovFrame = true;
                        this.dirMove = n7;
                        this.disMove = n8;
                        break;
                    }
                    case 2: {
                        this.isActFrame = true;
                        this.actType = n7;
                        break;
                    }
                    case 3: {
                        this.isEffFrame = true;
                        if (n7 < 9) {
                            this.effShake = true;
                            this.shakeT = n7;
                            this.shakeD = n8;
                            break;
                        }
                        if (n7 <= 10) break;
                        this.effColor = true;
                        this.colorT = n7;
                        break;
                    }
                    case 4: {
                        this.isAddFrame = true;
                        this.addIdx = n7;
                        break;
                    }
                    case 5: {
                        this.isInsFrame = true;
                        this.insIdx = n7;
                        break;
                    }
                    case 6: {
                        this.isInaFrame = true;
                        break;
                    }
                    case 7: {
                        this.isSloFrame = true;
                        this.sloDura = n7;
                        this.sloInfo = n8;
                        break;
                    }
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: {
                        this.scrPosId = (n6 - 1) % 100 / 10;
                        this.scrId = n7;
                        this.scrFrames[(n6 - 1) % 10] = n8;
                    }
                }
                n3 = 11;
            }
        }
    }

    public void drawFrame(Graphics graphics, int n, int n2) {
        this.setSpriteX(n);
        this.setSpriteY(n2);
        int n3 = this.data.mwFrameClipIndexTable[this.mwFrameTablePointer << 1];
        short s = this.data.mwFrameClipIndexTable[(this.mwFrameTablePointer << 1) + 1];
        while (n3 < s) {
            byte by;
            short s2 = this.data.mwClipTable[n3++];
            short s3 = this.data.mwClipTable[n3++];
            short s4 = this.data.mwClipTable[n3++];
            if ((by = (byte)this.data.mwClipTable[n3++]) == 11) continue;
            this.drawClip(graphics, s3, s4, s2, by);
        }
    }

    public void drawFrame(Graphics graphics) {
        int n = this.data.mwFrameClipIndexTable[this.mwFrameTablePointer << 1];
        short s = this.data.mwFrameClipIndexTable[(this.mwFrameTablePointer << 1) + 1];
        while (n < s) {
            byte by;
            short s2 = this.data.mwClipTable[n++];
            short s3 = this.data.mwClipTable[n++];
            short s4 = this.data.mwClipTable[n++];
            if ((by = (byte)this.data.mwClipTable[n++]) == 11) continue;
            this.drawClip(graphics, s3, s4, s2, by);
        }
    }

    protected void drawClip(Graphics graphics, int n, int n2, int n3, byte by) {
        if ((by & 1) == 0) {
            byte by2 = (byte)((by & 0x38) >> 3);
            byte by3 = (byte)(((by & 0xC0) >> 4) + ((by & 6) >> 1));
            this.drawImageClip(graphics, n, n2, by2, n3, by3);
        } else if (by == 1 || by == 3) {
            int n4 = n3 * 5;
            this.drawEllipseClip(graphics, n, n2, this.data.mwEllipseClipLib[n4], this.data.mwEllipseClipLib[n4 + 1], this.data.mwEllipseClipLib[n4 + 2], this.data.mwEllipseClipLib[n4 + 3], this.data.mwEllipseClipLib[n4 + 4], by == 3);
        } else if (by == 5) {
            int n5 = n3 * 3;
            this.drawLineClip(graphics, n, n2, this.data.mwLineClipLib[n5], this.data.mwLineClipLib[n5 + 1], this.data.mwLineClipLib[n5 + 2]);
        } else if (by == 7 || by == 9) {
            int n6 = n3 * 3;
            this.drawRectangleClip(graphics, n, n2, this.data.mwRectangleClipLib[n6], this.data.mwRectangleClipLib[n6 + 1], this.data.mwRectangleClipLib[n6 + 2], by == 9);
        }
    }

    protected void drawImageClip(Graphics graphics, int n, int n2, byte by, int n3, byte by2) {
        int n4 = n3 * 4;
        short s = this.data.mwImageClipLib[n4++];
        short s2 = this.data.mwImageClipLib[n4++];
        short s3 = this.data.mwImageClipLib[n4++];
        short s4 = this.data.mwImageClipLib[n4++];
        byte by3 = this.getSpriteOrientation();
        int n5 = 0;
        switch (by2) {
            case 0: {
                n5 = 0;
                break;
            }
            case 1: {
                n5 = 2;
                break;
            }
            case 2: {
                n5 = 1;
                break;
            }
            case 3: {
                n5 = 5;
                n = n + s3 / 2 - s4 / 2;
                n2 = n2 + s4 / 2 - s3 / 2;
                break;
            }
            case 4: {
                n5 = 3;
                break;
            }
            case 5: {
                n5 = 6;
                n = n + s3 / 2 - s4 / 2;
                n2 = n2 + s4 / 2 - s3 / 2;
                break;
            }
            case 6: {
                n5 = 7;
                n = n + s3 / 2 - s4 / 2;
                n2 = n2 + s4 / 2 - s3 / 2;
                break;
            }
            case 7: {
                n5 = 4;
                n = n + s3 / 2 - s4 / 2;
                n2 = n2 + s4 / 2 - s3 / 2;
            }
        }
        block10 : switch (by3) {
            case 1: {
                switch (by2) {
                    case 0: {
                        n5 = 2;
                        n = -n - s3;
                        break;
                    }
                    case 1: {
                        n5 = 0;
                        n = -n - s3;
                        break;
                    }
                    case 2: {
                        n5 = 3;
                        n = -n - s3;
                        break;
                    }
                    case 3: {
                        n5 = 4;
                        n = -n - s4;
                        break;
                    }
                    case 4: {
                        n5 = 1;
                        n = -n - s3;
                        break;
                    }
                    case 5: {
                        n5 = 7;
                        n = -n - s4;
                        break;
                    }
                    case 6: {
                        n5 = 6;
                        n = -n - s4;
                        break;
                    }
                    case 7: {
                        n5 = 5;
                        n = -n - s4;
                    }
                }
                break;
            }
            case 2: {
                switch (by2) {
                    case 0: {
                        n5 = 1;
                        n2 = -n2 - s4;
                        break;
                    }
                    case 1: {
                        n5 = 3;
                        n2 = -n2 - s4;
                        break;
                    }
                    case 2: {
                        n5 = 0;
                        n2 = -n2 - s4;
                        break;
                    }
                    case 3: {
                        n5 = 7;
                        n2 = -n2 - s3;
                        break;
                    }
                    case 4: {
                        n5 = 2;
                        n2 = -n2 - s4;
                        break;
                    }
                    case 5: {
                        n5 = 4;
                        n2 = -n2 - s3;
                        break;
                    }
                    case 6: {
                        n5 = 5;
                        n2 = -n2 - s3;
                        break;
                    }
                    case 7: {
                        n5 = 6;
                        n2 = -n2 - s3;
                    }
                }
                break;
            }
            case 3: {
                switch (by2) {
                    case 0: {
                        n5 = 3;
                        n = -n - s3;
                        n2 = -n2 - s4;
                        break block10;
                    }
                    case 1: {
                        n5 = 1;
                        n = -n - s3;
                        n2 = -n2 - s4;
                        break block10;
                    }
                    case 2: {
                        n5 = 2;
                        n = -n - s3;
                        n2 = -n2 - s4;
                        break block10;
                    }
                    case 3: {
                        n5 = 6;
                        n = -n - s4;
                        n2 = -n2 - s3;
                        break block10;
                    }
                    case 4: {
                        n5 = 0;
                        n = -n - s3;
                        n2 = -n2 - s4;
                        break block10;
                    }
                    case 5: {
                        n5 = 5;
                        n = -n - s4;
                        n2 = -n2 - s3;
                        break block10;
                    }
                    case 6: {
                        n5 = 4;
                        n = -n - s4;
                        n2 = -n2 - s3;
                        break block10;
                    }
                    case 7: {
                        n5 = 7;
                        n = -n - s4;
                        n2 = -n2 - s3;
                    }
                }
            }
        }
        int n6 = n + this.getSpriteX();
        int n7 = n2 + this.getSpriteY();
        if (this.data.splitImageClip) {
            Image image = ((Image[][])this.data.imageVector.elementAt(by))[n3 - this.data.mwImageClipIndexTable[by]][0];
            Box.drawRegion(graphics, image, 0, 0, s3, s4, n5, n6, n7);
        } else {
            Image image = ((Image[])this.data.imageVector.elementAt(by))[0];
            Box.drawRegion(graphics, image, s, s2, s3, s4, n5, n6, n7);
        }
    }

    protected void drawEllipseClip(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        byte by = this.getSpriteOrientation();
        if (by == 1) {
            n = -n - n3;
        } else if (by == 2) {
            n2 = -n2 - n4;
        } else if (by == 3) {
            n = -n - n3;
            n2 = -n2 - n4;
        }
        int n8 = n + this.getSpriteX();
        int n9 = n2 + this.getSpriteY();
        graphics.setColor(n7);
        if (bl) {
            graphics.fillArc(n8, n9, n3, n4, n5, n6);
        } else {
            graphics.drawArc(n8, n9, n3, n4, n5, n6);
        }
    }

    protected void drawLineClip(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        byte by = this.getSpriteOrientation();
        if (by == 1) {
            n = -n;
            n3 = -n3;
        } else if (by == 2) {
            n2 = -n2;
            n4 = -n4;
        } else if (by == 3) {
            n = -n;
            n3 = -n3;
            n2 = -n2;
            n4 = -n4;
        }
        int n6 = n + this.getSpriteX();
        int n7 = n3 + this.getSpriteX();
        int n8 = n2 + this.getSpriteY();
        int n9 = n4 + this.getSpriteY();
        graphics.setColor(n5);
        graphics.drawLine(n6, n8, n7, n9);
    }

    protected void drawRectangleClip(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        byte by = this.getSpriteOrientation();
        if (by == 1) {
            n = -n - n3;
        } else if (by == 2) {
            n2 = -n2 - n4;
        } else if (by == 3) {
            n = -n - n3;
            n2 = -n2 - n4;
        }
        int n6 = n + this.getSpriteX();
        int n7 = n2 + this.getSpriteY();
        graphics.setColor(n5);
        if (bl) {
            graphics.fillRect(n6, n7, n3, n4);
        } else {
            graphics.drawRect(n6, n7, n3, n4);
        }
    }

    protected void drawRoundedRectangleClip(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        byte by = this.getSpriteOrientation();
        if (by == 1) {
            n = -n - n3;
        } else if (by == 2) {
            n2 = -n2 - n4;
        } else if (by == 3) {
            n = -n - n3;
            n2 = -n2 - n4;
        }
        int n8 = n + this.getSpriteX();
        int n9 = n2 + this.getSpriteY();
        graphics.setColor(n7);
        if (bl) {
            graphics.fillRoundRect(n8, n9, n3, n4, n5, n6);
        } else {
            graphics.drawRoundRect(n8, n9, n3, n4, n5, n6);
        }
    }

    protected abstract void notifyEndOfAnimation();

    protected abstract byte getSpriteOrientation();

    protected abstract void setSpriteX(int var1);

    protected abstract void setSpriteY(int var1);

    protected abstract int getSpriteX();

    protected abstract int getSpriteY();

    protected abstract void updateSpritePositionBy(int var1, int var2);

    protected abstract void notifyStartOfAnimation();
}

