/*
 * Decompiled with CFR 0.152.
 */
package wolverine;

import wolverine.Actor;

public class ActorPool {
    private Actor firstFree;
    private Actor lastFree;
    private Actor firstUsed;
    private Actor lastUsed;
    private Actor oldestUsed;

    public ActorPool(Actor[] actorArray) {
        if (actorArray == null || actorArray.length < 2) {
            return;
        }
        this.firstFree = actorArray[0];
        this.lastFree = actorArray[actorArray.length - 1];
        for (int i = 0; i < actorArray.length; ++i) {
            if (i < actorArray.length - 1) {
                actorArray[i].setNextLinked(actorArray[i + 1]);
            } else {
                actorArray[i].setNextLinked(null);
            }
            if (i > 0) {
                actorArray[i].setPrevLinked(actorArray[i - 1]);
                continue;
            }
            actorArray[i].setPrevLinked(null);
        }
    }

    public Actor getNextFree() {
        if (this.firstFree != null) {
            if (this.firstFree.getNextLinked() != null) {
                this.firstFree.getNextLinked().setPrevLinked(null);
            }
            Actor actor = this.firstFree.getNextLinked();
            this.firstFree.setNextLinked(null);
            if (this.lastUsed != null) {
                this.firstFree.setPrevLinked(this.lastUsed);
                this.lastUsed.setNextLinked(this.firstFree);
            }
            this.lastUsed = this.firstFree;
            if (this.oldestUsed == null) {
                this.oldestUsed = this.firstFree;
            }
            if (this.firstUsed == null) {
                this.firstUsed = this.firstFree;
            }
            if (this.lastFree == this.firstFree) {
                this.lastFree = null;
            }
            Actor actor2 = this.firstFree;
            this.firstFree = actor;
            return actor2;
        }
        Actor actor = this.oldestUsed;
        if (this.oldestUsed == null) {
            actor = this.oldestUsed = this.firstUsed;
        }
        this.oldestUsed = this.oldestUsed.getNextLinked();
        return actor;
    }

    public void dump() {
        Actor actor;
        System.out.print("Free List: ");
        for (actor = this.firstFree; actor != null; actor = actor.getNextLinked()) {
            System.out.print("{" + actor + "}");
        }
        System.out.println("");
        System.out.print("Used List: ");
        for (actor = this.firstUsed; actor != null; actor = actor.getNextLinked()) {
            System.out.print("{" + actor + "}");
        }
        System.out.println("");
        System.out.println("First Free: " + this.firstFree);
        System.out.println("Last Free: " + this.lastFree);
        System.out.println("First Used: " + this.firstUsed);
        System.out.println("Last Used: " + this.lastUsed);
        System.out.println("Oldest Used: " + this.oldestUsed);
    }

    public void release(Actor actor) {
        if (actor.getPrevLinked() != null) {
            actor.getPrevLinked().setNextLinked(actor.getNextLinked());
        }
        if (actor.getNextLinked() != null) {
            actor.getNextLinked().setPrevLinked(actor.getPrevLinked());
        }
        if (this.oldestUsed == actor) {
            this.oldestUsed = actor.getNextLinked();
        }
        if (this.firstUsed == actor) {
            this.firstUsed = actor.getNextLinked();
        }
        if (this.lastUsed == actor) {
            this.lastUsed = actor.getPrevLinked();
        }
        actor.setNextLinked(null);
        if (this.firstFree == null) {
            this.firstFree = actor;
            actor.setPrevLinked(null);
        }
        if (this.lastFree != null) {
            actor.setPrevLinked(this.lastFree);
            this.lastFree.setNextLinked(actor);
        } else {
            actor.setPrevLinked(null);
        }
        this.lastFree = actor;
    }

    public Actor getFirstUsed() {
        return this.firstUsed;
    }
}

