/*
 * Decompiled with CFR 0.152.
 */
package wolverine;

import com.studio.motionwelder.MSpriteLoader;
import wolverine.Goblin;
import wolverine.ResourceLoader;
import wolverine.Role;
import wolverine.Screen;
import wolverine.World;

class Lib {
    public Screen screen;
    public World world;
    public String[] methods;

    Lib(Screen screen, World world) {
        this.screen = screen;
        this.world = world;
        this.methods = new String[]{"dialog", "gamePend", "gameSaveWin", "gameMoveWin", "gameMoveWinBack", "battleEndScript", "battleLock", "battleUnlock", "roleMoveWin", "rolePosWin", "roleBorn", "rolePos", "roleFace", "roleTurn", "roleMove", "roleGoal", "roleState", "roleAction", "roleHook", "roleDone", "roleScena", "openGates", "shutGates", "mapPatrol", "mapSteady", "returnHome", "scriptDone", "scriptPaused", "showGTip", "showGuide", "hideGuide", "showFore", "hideFore", "showForeTip", "hideForeTip", "showETip", "reload", "OPEN1"};
    }

    public void call(String string) {
        String string2 = string.substring(0, string.indexOf(40));
        String string3 = string.substring(string.indexOf(40) + 1, string.lastIndexOf(41));
        String[] stringArray = this.parsePara(string3);
        switch (this.getMethod(string2)) {
            case 0: {
                this.dialog(stringArray);
                break;
            }
            case 1: {
                this.gamePend(stringArray);
                break;
            }
            case 2: {
                this.gameSaveWin(stringArray);
                break;
            }
            case 3: {
                this.gameMoveWin(stringArray);
                break;
            }
            case 4: {
                this.gameMoveWinBack(stringArray);
                break;
            }
            case 5: {
                this.battleEndScript(stringArray);
                break;
            }
            case 6: {
                this.battleLock(stringArray);
                break;
            }
            case 7: {
                this.battleUnlock(stringArray);
                break;
            }
            case 8: {
                this.roleMoveWin(stringArray);
                break;
            }
            case 9: {
                this.rolePosWin(stringArray);
                break;
            }
            case 10: {
                this.roleBorn(stringArray);
                break;
            }
            case 11: {
                this.rolePos(stringArray);
                break;
            }
            case 12: {
                this.roleFace(stringArray);
                break;
            }
            case 13: {
                this.roleTurn(stringArray);
                break;
            }
            case 14: {
                this.roleMove(stringArray);
                break;
            }
            case 15: {
                this.roleGoal(stringArray);
                break;
            }
            case 16: {
                this.roleState(stringArray);
                break;
            }
            case 17: {
                this.roleAction(stringArray);
                break;
            }
            case 18: {
                this.roleHook(stringArray);
                break;
            }
            case 19: {
                this.roleDone(stringArray);
                break;
            }
            case 20: {
                this.roleScena(stringArray);
                break;
            }
            case 21: {
                this.openGates(stringArray);
                break;
            }
            case 22: {
                this.shutGates(stringArray);
                break;
            }
            case 23: {
                this.mapPatrol(stringArray);
                break;
            }
            case 24: {
                this.mapSteady(stringArray);
                break;
            }
            case 25: {
                this.returnHome(stringArray);
                break;
            }
            case 26: {
                this.scriptDone(stringArray);
                break;
            }
            case 27: {
                this.scriptPaused(stringArray);
                break;
            }
            case 28: {
                this.showGTip(stringArray);
                break;
            }
            case 29: {
                this.showGuide(stringArray);
                break;
            }
            case 30: {
                this.hideGuide(stringArray);
                break;
            }
            case 31: {
                this.showFore(stringArray);
                break;
            }
            case 32: {
                this.hideFore(stringArray);
                break;
            }
            case 33: {
                this.showForeTip(stringArray);
                break;
            }
            case 34: {
                this.hideForeTip(stringArray);
                break;
            }
            case 35: {
                this.showETip(stringArray);
                break;
            }
            case 36: {
                this.reload(stringArray);
                break;
            }
            case 37: {
                this.OPEN1(stringArray);
            }
        }
    }

    private String[] parsePara(String string) {
        int n;
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (n != 44) continue;
            ++n3;
        }
        String[] stringArray = new String[n3];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == ',') {
                stringArray[n] = stringBuffer.toString();
                ++n;
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(c);
        }
        stringArray[n] = stringBuffer.toString();
        return stringArray;
    }

    private int getMethod(String string) {
        for (int i = 0; i < this.methods.length; ++i) {
            if (!string.equals(this.methods[i])) continue;
            return i;
        }
        return -1;
    }

    private void dialog(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        this.screen.scriptState = 2;
        this.screen.scriptDialogIdx = this.world.genAryIdx(n, this.world.scriptDialogIds);
        this.screen.scriptLineIdx = 0;
        this.screen.scriptFive = false;
        this.screen.scriptDialogDone = false;
        this.screen.scriptDialogWord = 1;
        this.screen.scriptDialogTime = System.currentTimeMillis();
        if (this.world.scriptDialogs[this.screen.scriptDialogIdx].roleHead > 0) {
            int n2 = Screen.genAryIdx(this.world.scriptDialogs[this.screen.scriptDialogIdx].roleHead, this.world.roleHeads) + 1;
            String string = "";
            if (n2 < 10) {
                string = "0";
            }
            try {
                this.screen.halfSpriteData = MSpriteLoader.loadMSprite(this.screen.dataPath + "half_" + string + n2 + ".anu", false, ResourceLoader.getInstance());
                this.screen.halfGoblin = new Goblin(this.screen.halfSpriteData, 0, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void gamePend(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        this.screen.scriptSpan = false;
        this.screen.scriptSpanTime = System.currentTimeMillis();
        this.screen.scriptSpanDura = n;
    }

    private void gameSaveWin(String[] stringArray) {
        this.world.winXSave = this.world.winX;
        this.world.winYSave = this.world.winY;
    }

    private void gameMoveWin(String[] stringArray) {
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            this.world.actorPtrLib[i].actorMoveWin = false;
        }
        this.screen.scriptState = 1;
        this.screen.scriptWinX = Integer.parseInt(stringArray[0]);
        this.screen.scriptWinY = Integer.parseInt(stringArray[1]);
        this.screen.scriptDone = false;
    }

    private void gameMoveWinBack(String[] stringArray) {
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            this.world.actorPtrLib[i].actorMoveWin = false;
        }
        this.screen.scriptState = 1;
        this.screen.scriptWinX = this.world.winXSave;
        this.screen.scriptWinY = this.world.winYSave;
        this.screen.scriptDone = false;
    }

    private void battleEndScript(String[] stringArray) {
        this.world.mapBattleEndScriptId = Integer.parseInt(stringArray[0]);
        this.world.mapBattleEndScript = true;
    }

    private void battleLock(String[] stringArray) {
        this.world.mapLockX1 = Integer.parseInt(stringArray[0]);
        this.world.mapLockY1 = Integer.parseInt(stringArray[1]);
        this.world.mapLockX2 = Integer.parseInt(stringArray[2]);
        this.world.mapLockY2 = Integer.parseInt(stringArray[3]);
        if (this.world.mapLockX1 == -1) {
            this.world.mapLockX1 = 0;
        }
        if (this.world.mapLockY1 == -1) {
            this.world.mapLockY1 = 0;
        }
        if (this.world.mapLockX2 == -1) {
            this.world.mapLockX2 = this.world.mapW;
        }
        if (this.world.mapLockY2 == -1) {
            this.world.mapLockY2 = this.world.mapH;
        }
        this.world.mapBattleLock = true;
        this.world.mapBattleEnable = false;
    }

    private void battleUnlock(String[] stringArray) {
        this.world.mapLockX1 = 0;
        this.world.mapLockY1 = 0;
        this.world.mapLockX2 = 0;
        this.world.mapLockY2 = 0;
        this.world.mapBattleLock = false;
        this.world.mapBattleEnable = true;
    }

    private void roleMoveWin(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            this.world.actorPtrLib[i].actorMoveWin = this.world.actorPtrLib[i].id == n;
        }
    }

    private void rolePosWin(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            if (!this.world.actorPtrLib[i].isPlayer() && !this.world.actorPtrLib[i].isEnemy()) continue;
            Role role = (Role)this.world.actorPtrLib[i];
            if (role.id != n) continue;
            this.world.setWin(role);
            break;
        }
    }

    private void roleBorn(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[3]);
        int n5 = Integer.parseInt(stringArray[4]);
        int n6 = Integer.parseInt(stringArray[5]);
        if (n6 == 0) {
            if (this.world.player.xFace == 1) {
                n6 = 2;
            } else if (this.world.player.xFace == 2) {
                n6 = 1;
            }
        }
        this.world.roleBorn(n, n2, n3, n4, n5, n6);
        ++this.screen.scoreEnemyNum;
    }

    private void rolePos(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            if (!this.world.actorPtrLib[i].isPlayer() && !this.world.actorPtrLib[i].isEnemy()) continue;
            Role role = (Role)this.world.actorPtrLib[i];
            if (role.id != n) continue;
            role.setPos(n2, n3);
            break;
        }
    }

    private void roleFace(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            if (!this.world.actorPtrLib[i].isPlayer() && !this.world.actorPtrLib[i].isEnemy()) continue;
            Role role = (Role)this.world.actorPtrLib[i];
            if (role.id != n) continue;
            if (n2 == 1) {
                role.xFace = 1;
            } else if (n2 == 2) {
                role.xFace = 2;
            }
            role.curFace = n2;
            break;
        }
    }

    private void roleTurn(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            if (!this.world.actorPtrLib[i].isPlayer() && !this.world.actorPtrLib[i].isEnemy()) continue;
            Role role = (Role)this.world.actorPtrLib[i];
            if (role.id != n) continue;
            if (n2 == 1) {
                if (role.xFace == 2) {
                    role.xFace = 1;
                } else if (role.xFace == 1) {
                    role.xFace = 2;
                }
                role.curFace = role.xFace;
                break;
            }
            if (n2 != 2) break;
            int n3 = 0;
            int n4 = this.world.mapW;
            if (this.world.mapBattleLock) {
                n3 = this.world.mapLockX1;
                n4 = this.world.mapLockX2;
            }
            if (role.x - n3 < this.world.winMoveW && role.xFace == 2) {
                role.xFace = 1;
            } else if (n4 - role.x < this.world.winMoveW && role.xFace == 1) {
                role.xFace = 2;
            }
            role.curFace = role.xFace;
            break;
        }
    }

    private void roleMove(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[3]);
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            if (!this.world.actorPtrLib[i].isPlayer() && !this.world.actorPtrLib[i].isEnemy()) continue;
            Role role = (Role)this.world.actorPtrLib[i];
            if (role.id != n) continue;
            if (role.xFace == 2) {
                n2 = -n2;
            }
            this.world.roleTake(role, n2, n3);
            role.scriptDone = n4;
            if (role.scriptDone != 1) break;
            this.screen.scriptDone = false;
            break;
        }
    }

    private void roleGoal(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[3]);
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            if (!this.world.actorPtrLib[i].isPlayer() && !this.world.actorPtrLib[i].isEnemy()) continue;
            Role role = (Role)this.world.actorPtrLib[i];
            if (role.id != n) continue;
            this.world.roleTake(role, n2 - role.x, n3 - role.y);
            role.scriptDone = n4;
            if (role.scriptDone != 1) break;
            this.screen.scriptDone = false;
            break;
        }
    }

    private void roleState(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            if (!this.world.actorPtrLib[i].isPlayer() && !this.world.actorPtrLib[i].isEnemy()) continue;
            Role role = (Role)this.world.actorPtrLib[i];
            if (role.id != n) continue;
            role.roleState = n2;
            role.isActing = false;
            role.setVel(0, 0);
            role.scriptDone = n3;
            if (role.scriptDone != 1) break;
            this.screen.scriptDone = false;
            break;
        }
    }

    private void roleAction(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            if (!this.world.actorPtrLib[i].isPlayer() && !this.world.actorPtrLib[i].isEnemy()) continue;
            Role role = (Role)this.world.actorPtrLib[i];
            if (role.id != n) continue;
            role.preAction = role.roleState;
            role.roleState = 101;
            role.isActing = false;
            role.setVel(0, 0);
            role.roleAction = n2;
            role.scriptDone = n3;
            if (role.scriptDone != 1) break;
            this.screen.scriptDone = false;
            break;
        }
    }

    private void roleHook(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            if (!this.world.actorPtrLib[i].isPlayer() && !this.world.actorPtrLib[i].isEnemy()) continue;
            Role role = (Role)this.world.actorPtrLib[i];
            if (role.id != n) continue;
            this.world.roleTake(role, this.world.player.x - role.x, this.world.player.y - role.y);
            role.scriptDone = n2;
            if (role.scriptDone != 1) break;
            this.screen.scriptDone = false;
            break;
        }
    }

    private void roleDone(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        for (int i = 0; i < this.world.actorPtrLib.length && this.world.actorPtrLib[i] != null; ++i) {
            if (!this.world.actorPtrLib[i].isPlayer() && !this.world.actorPtrLib[i].isEnemy()) continue;
            Role role = (Role)this.world.actorPtrLib[i];
            if (role.id != n) continue;
            this.world.releaseRole(role);
            --this.screen.scoreEnemyNum;
            break;
        }
    }

    private void roleScena(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        this.world.roleScenaId = n;
        this.world.roleScenaTrig = n2;
        this.world.roleScenaScript = n3;
    }

    private void openGates(String[] stringArray) {
        this.world.openGates();
    }

    private void shutGates(String[] stringArray) {
        this.world.shutGates();
    }

    private void mapPatrol(String[] stringArray) {
        this.world.mapPatrol = true;
    }

    private void mapSteady(String[] stringArray) {
        this.world.mapPatrol = false;
    }

    private void returnHome(String[] stringArray) {
        this.screen.returnDura = Integer.parseInt(stringArray[0]);
        this.screen.returnHome = true;
    }

    private void scriptDone(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        for (int i = 0; i < this.world.scriptDoneIds.length; ++i) {
            if (this.world.scriptDoneIds[i] != 0) continue;
            this.world.scriptDoneIds[i] = n;
            break;
        }
    }

    private void scriptPaused(String[] stringArray) {
        this.screen.scriptDone = false;
    }

    private void showGTip(String[] stringArray) {
        this.screen.showGTip = true;
    }

    private void showGuide(String[] stringArray) {
        if (this.screen.showGuide) {
            this.screen.guideId = Integer.parseInt(stringArray[0]);
            this.screen.gameTip = this.screen.guideTips[this.screen.guideId - 1];
            this.screen.showSTip = true;
        }
    }

    private void hideGuide(String[] stringArray) {
        if (!this.screen.showGuide) {
            int n = Integer.parseInt(stringArray[0]);
            for (int i = 0; i < this.world.scriptDoneIds.length; ++i) {
                if (this.world.scriptDoneIds[i] != 0) continue;
                this.world.scriptDoneIds[i] = n;
                break;
            }
        }
    }

    private void showFore(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0].substring(2), 16);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        this.screen.showFore = true;
        this.screen.foreTime = System.currentTimeMillis();
        this.screen.foreDura = n2;
        this.screen.foreColor = n;
        if (n3 == 1) {
            this.screen.scriptDone = false;
        }
    }

    private void hideFore(String[] stringArray) {
        this.screen.showFore = false;
    }

    private void showForeTip(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0].substring(2), 16);
        int n2 = Integer.parseInt(stringArray[1]);
        this.screen.showForeTip = true;
        this.screen.foreTipIdx = n2;
        this.screen.foreTipColor = n;
    }

    private void hideForeTip(String[] stringArray) {
        this.screen.showForeTip = false;
    }

    private void showETip(String[] stringArray) {
        this.screen.showETip = true;
    }

    private void reload(String[] stringArray) {
        try {
            int n;
            int n2 = this.screen.menuQuestIdx;
            for (n = 0; n < this.world.roleImageIds[n2].length; ++n) {
                if (this.world.roleImageLoads[n2][n] != 1) continue;
                this.world.roleImageLibs[n] = null;
            }
            System.gc();
            for (n = 0; n < this.world.roleImageIds[n2].length; ++n) {
                if (this.world.roleImageLoads[n2][n] != 2) continue;
                String string = this.screen.dataPath + "mp" + this.world.roleImageIds[n2][n] + ".anu";
                this.world.roleImageLibs[n] = MSpriteLoader.loadMSprite(string, false, ResourceLoader.getInstance());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void OPEN1(String[] stringArray) {
        System.out.println("\u6d4b\u8bd5\u811a\u672c\u2014\u2014\u8fdb\u5165\uff01");
        if (this.screen.buyLogs[1] != this.screen.buyLens[1]) {
            this.screen.pause();
            this.screen.goMenu(Screen.MENU_STATE_OPEN1, 0);
        }
    }
}

