/*
 * Decompiled with CFR 0.152.
 */
package com.rovio.nfscarbon;

import com.rovio.rtool.mobile.CanvasController;
import com.rovio.rtool.mobile.Core;
import com.rovio.rtool.mobile.Resources;
import com.rovio.rtool.mobile.ui.ContentItem;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class NFSSplashScreen
extends CanvasController {
    private static int sm_currentTime;
    private boolean m_needsRepaint = true;
    private boolean m_showLoadingBar;
    public static int sm_barLength;
    public static final int LOADING_BAR_LENGTH = 80;
    public static final int LOADING_BAR_HEIGHT = 10;
    public static final int LOADING_BAR_FILL_TIME = 4000;
    private int m_screenAction = -1;
    private int m_actionTriggerTime = -1;
    public static final int ACTION_TIME_DISABLED = -1;
    private int m_sprite = -1;
    private ContentItem m_contentItem;
    private int m_bgColor = 0;
    int loadStep = 0;
    static Image bg;

    private NFSSplashScreen() {
    }

    public static NFSSplashScreen createNFSSplashScreen(int n) {
        NFSSplashScreen nFSSplashScreen = new NFSSplashScreen();
        nFSSplashScreen.m_sprite = n;
        return nFSSplashScreen;
    }

    public static NFSSplashScreen createNFSSplashScreen(int n, int n2) {
        NFSSplashScreen nFSSplashScreen = new NFSSplashScreen();
        nFSSplashScreen.m_sprite = n;
        nFSSplashScreen.m_bgColor = n2;
        return nFSSplashScreen;
    }

    public static NFSSplashScreen createAutoLoadingBarScreen(int n) {
        NFSSplashScreen nFSSplashScreen = new NFSSplashScreen();
        nFSSplashScreen.m_sprite = n;
        nFSSplashScreen.m_showLoadingBar = true;
        return nFSSplashScreen;
    }

    public static NFSSplashScreen createAutoLoadingBarScreen(int n, int n2) {
        NFSSplashScreen nFSSplashScreen = new NFSSplashScreen();
        nFSSplashScreen.m_sprite = n;
        nFSSplashScreen.m_showLoadingBar = true;
        nFSSplashScreen.m_bgColor = n2;
        return nFSSplashScreen;
    }

    public static NFSSplashScreen createLoadingBarScreen(int n, int n2) {
        NFSSplashScreen nFSSplashScreen = new NFSSplashScreen();
        nFSSplashScreen.m_sprite = n;
        nFSSplashScreen.m_showLoadingBar = true;
        return nFSSplashScreen;
    }

    public static NFSSplashScreen createLoadingBarScreen(int n, int n2, int n3) {
        NFSSplashScreen nFSSplashScreen = new NFSSplashScreen();
        nFSSplashScreen.m_sprite = n;
        nFSSplashScreen.m_showLoadingBar = true;
        nFSSplashScreen.m_bgColor = n3;
        return nFSSplashScreen;
    }

    public void setAction(int n) {
        this.m_screenAction = n;
    }

    public void setSprite(int n) {
        this.m_sprite = n;
        this.m_needsRepaint = true;
    }

    public void setActionTriggerTime(int n) {
        sm_currentTime = 0;
        this.m_actionTriggerTime = n;
    }

    public void setText(String string) {
        this.m_contentItem = string != null ? new ContentItem(string, 240, 2) : null;
        this.m_needsRepaint = true;
    }

    public void focusChange(boolean bl) {
        this.m_needsRepaint = true;
    }

    public void mainLoopIteration(int n) {
        if (this.m_screenAction != -1 && this.m_actionTriggerTime != -1 && (sm_currentTime += n) > this.m_actionTriggerTime) {
            Core.postAction(this.m_screenAction, this);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        int n = 0;
        if (this.m_sprite != -1) {
            n += Resources.getSpriteAttribute(this.m_sprite, 1) + 3;
        }
        if (this.m_contentItem != null) {
            n += this.m_contentItem.m_height + 3;
        }
        int n2 = 320 - n >> 1;
        graphics.setColor(this.m_bgColor);
        graphics.fillRect(0, 0, 240, 320);
        if (this.m_showLoadingBar) {
            if (bg == null) {
                try {
                    bg = Image.createImage((String)"/lb.png");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            graphics.drawImage(bg, 0, 0, 0);
            graphics.setColor(0xFFFF00);
            switch (this.loadStep) {
                case 0: {
                    graphics.drawString("\u52a0\u8f7d\u4e2d", 3, 317, 4 | 0x20);
                    break;
                }
                case 1: {
                    graphics.drawString("\u52a0\u8f7d\u4e2d.", 3, 317, 4 | 0x20);
                    break;
                }
                case 2: {
                    graphics.drawString("\u52a0\u8f7d\u4e2d..", 3, 317, 4 | 0x20);
                    break;
                }
                case 3: {
                    graphics.drawString("\u52a0\u8f7d\u4e2d...", 3, 317, 4 | 0x20);
                }
            }
            ++this.loadStep;
            if (this.loadStep >= 4) {
                this.loadStep = 0;
            }
        }
        this.m_needsRepaint = false;
    }
}

