/*
 * Decompiled with CFR 0.152.
 */
package com.rovio.rtool.mobile;

import com.rovio.rtool.mobile.Core;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import javax.microedition.rms.RecordStore;

public class Debug
implements CommandListener {
    public static final boolean DEBUG = false;
    private static final boolean DEBUG_DISPLAY_EXCEPTIONS = false;
    public static final boolean API_DEBUG = false;
    public static final boolean API_ASSERT = false;
    private static final boolean PRINT_LOG_MESSAGES = true;
    static final boolean MEMORY_MONITOR = false;
    private static final boolean USE_TIMESTAMP = false;
    private static final boolean USE_LIST = true;
    private static final int MAX_LIST_ENTRIES = 100;
    private static final boolean REVERSE_LIST = false;
    private static final boolean USE_LIST_FILTER = true;
    public static final int CAT_INFO = 1;
    public static final int CAT_ERROR = 2;
    public static final int CAT_EXCEPTION = 3;
    public static final int CAT_ASSERT = 4;
    private static final String DEBUG_RMS_RECORD_NAME = "debug";
    private static StringBuffer m_debugBufferString = new StringBuffer();
    private static Vector m_debugBufferList = new Vector();
    public static String[] m_logFilters = new String[0];
    private final Displayable m_parentDisplay;
    private final Form m_debugForm;
    private final Command m_cmdApplyFilters = new Command("Back", 2, 1);
    private final Command m_cmdExitDebug = new Command("Back", 2, 1);
    private final Command m_cmdDebugShowLog = new Command("Show Log", 1, 1);
    private final Command m_cmdDebugClearLog = new Command("Clear Log", 1, 2);
    private final Command m_cmdDebugClearLogRMS = new Command("Clear Log in RMS", 1, 3);
    private final Command m_cmdDebugSetFilters = new Command("Set filters", 1, 4);
    private static final int COMMAND_PRIORITY_SHOW_LOG = 1;
    private static final int COMMAND_PRIORITY_CLEAR_LOG = 2;
    private static final int COMMAND_PRIORITY_CLEAR_LOG_RMS = 3;
    private static final int COMMAND_PRIORITY_SET_FILTERS = 4;

    public static void logMessage(String string) {
        System.out.println("DEBUG: " + string);
        m_debugBufferList.addElement(string);
        if (m_debugBufferList.size() > 100) {
            m_debugBufferList.removeElementAt(0);
        }
    }

    public static void logException(Throwable throwable, String string) {
        Debug.logMessage(Debug.getExceptionData(throwable, string));
        throwable.printStackTrace();
    }

    public static void printAlert(String string) {
        System.out.println("DEBUG CRITICAL ALERT:");
        System.out.println(string);
    }

    public static void print(String string) {
        System.out.print(string);
        System.out.flush();
    }

    public static void println(String string) {
        System.out.println(string);
    }

    private static String getExceptionData(Throwable throwable, String string) {
        String string2 = "";
        if (string != null) {
            string2 = string2 + string + "\n";
        }
        if (throwable.getMessage() != null) {
            string2 = string2 + throwable.getMessage() + "\n";
        }
        string2 = string2 + throwable.getClass().getName() + "\n";
        return string2;
    }

    private static String getTimeStamp(long l) {
        String string = String.valueOf(l);
        for (int i = string.length(); i < 10; ++i) {
            string = "0" + string;
        }
        return string.substring(string.length() - 8, string.length() - 4) + "." + string.substring(string.length() - 4, string.length() - 2);
    }

    public static void apiLog(int n, int n2, Object object) {
        if (n == 3) {
            Debug.logException((Throwable)object, "EXC:MAPI" + String.valueOf(n2));
        } else {
            String string = "DBG:MAPI" + String.valueOf(n2);
            if (object != null) {
                string = string + " " + object.toString();
            }
            Debug.logMessage(string);
        }
    }

    static void drawMemoryMeter(Graphics graphics) {
    }

    public static void showDebugMenu() {
        Debug.showMessage(null);
    }

    public static void showMessage(String string) {
        Debug debug = new Debug(Core.display.getCurrent());
        if (string != null) {
            string = string.replace('.', ' ');
            debug.m_debugForm.append(string);
        }
        if (Core.sm_allowCanvasHideStatus == 1) {
            Core.sm_allowCanvasHideStatus = 3;
        }
        Core.display.setCurrent((Displayable)debug.m_debugForm);
    }

    public static void showException(Throwable throwable, String string) {
        Debug.showMessage(Debug.getExceptionData(throwable, string));
        System.out.println("DEBUG: " + string);
        throwable.printStackTrace();
    }

    public static void saveDebugData() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(m_debugBufferList.size());
            Enumeration enumeration = m_debugBufferList.elements();
            while (enumeration.hasMoreElements()) {
                dataOutputStream.writeUTF(enumeration.nextElement().toString());
            }
            Core.saveRMSData(byteArrayOutputStream.toByteArray(), DEBUG_RMS_RECORD_NAME);
        }
        catch (Exception exception) {
            Debug.showException(exception, "Debug data save failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resotreDebugData() {
        byte[] byArray = null;
        try {
            byArray = Core.loadRMSData(DEBUG_RMS_RECORD_NAME);
        }
        catch (Exception exception) {
            if (byArray == null) {
                return;
            }
        }
        finally {
            if (byArray == null) {
                return;
            }
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readInt();
            m_debugBufferList = new Vector(n);
            for (int i = 0; i < n; ++i) {
                m_debugBufferList.addElement(dataInputStream.readUTF());
            }
        }
        catch (Exception exception) {
            Debug.showException(exception, "Debug data load failed");
        }
    }

    private Debug(Displayable displayable) {
        this.m_debugForm = new Form("Debug");
        this.m_parentDisplay = displayable;
        this.m_debugForm.addCommand(this.m_cmdExitDebug);
        this.m_debugForm.addCommand(this.m_cmdDebugShowLog);
        this.m_debugForm.addCommand(this.m_cmdDebugClearLogRMS);
        this.m_debugForm.addCommand(this.m_cmdDebugClearLog);
        this.m_debugForm.addCommand(this.m_cmdDebugSetFilters);
        this.m_debugForm.setCommandListener((CommandListener)this);
    }

    private boolean filterLine(String string) {
        if (m_logFilters.length == 0) {
            return true;
        }
        int n = 0;
        for (int i = 0; i < m_logFilters.length; ++i) {
            if (m_logFilters[i].startsWith("-")) {
                if (!string.startsWith(m_logFilters[i].substring(1))) continue;
                return false;
            }
            if (m_logFilters[i].startsWith("?") ? string.indexOf(m_logFilters[i].substring(1)) >= 0 : string.startsWith(m_logFilters[i])) {
                return true;
            }
            ++n;
        }
        return n == 0;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.m_cmdExitDebug) {
            Core.display.setCurrent(this.m_parentDisplay);
            if (Core.sm_allowCanvasHideStatus == 3) {
                Core.sm_allowCanvasHideStatus = 1;
            }
        } else {
            while (this.m_debugForm.size() > 0) {
                this.m_debugForm.delete(0);
            }
            if (command == this.m_cmdDebugShowLog) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                if (m_debugBufferList.size() > 100) {
                    n = m_debugBufferList.size() - 100;
                }
                Enumeration enumeration = m_debugBufferList.elements();
                while (enumeration.hasMoreElements()) {
                    if (n <= 0) {
                        boolean bl = true;
                        String string = (String)enumeration.nextElement() + "\n";
                        bl = this.filterLine(string);
                        if (!bl) continue;
                        stringBuffer.append(string);
                        continue;
                    }
                    --n;
                }
                this.m_debugForm.append(stringBuffer.toString());
            } else if (command == this.m_cmdDebugClearLog) {
                this.m_debugForm.append("Debug log cleared!");
                m_debugBufferList = new Vector();
            } else if (command == this.m_cmdDebugClearLogRMS) {
                this.m_debugForm.append("Debug log in RMS cleared!");
                try {
                    RecordStore.deleteRecordStore((String)DEBUG_RMS_RECORD_NAME);
                }
                catch (Exception exception) {}
            } else if (command == this.m_cmdDebugSetFilters) {
                String string = "";
                if (m_logFilters.length > 0) {
                    string = m_logFilters[0];
                    for (int i = 1; i < m_logFilters.length; ++i) {
                        string = string + ", " + m_logFilters[i];
                    }
                }
                TextBox textBox = new TextBox("Set log filters", string, 100, 0);
                textBox.addCommand(this.m_cmdApplyFilters);
                textBox.setCommandListener((CommandListener)this);
                Core.display.setCurrent((Displayable)textBox);
            } else if (command == this.m_cmdApplyFilters) {
                TextBox textBox = (TextBox)displayable;
                String string = textBox.getString().trim();
                if (string.length() < 1) {
                    m_logFilters = new String[0];
                } else {
                    Vector<String> vector = new Vector<String>();
                    for (int i = 0; i < string.length(); ++i) {
                        int n = i;
                        if ((i = string.indexOf(44, i)) == -1) {
                            i = string.length();
                        }
                        vector.addElement(string.substring(n, i).trim());
                    }
                    int n = 0;
                    m_logFilters = new String[vector.size()];
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Debug.m_logFilters[n] = (String)enumeration.nextElement();
                        ++n;
                    }
                }
                Core.display.setCurrent((Displayable)this.m_debugForm);
            }
        }
    }
}

