/*
 * Decompiled with CFR 0.152.
 */
package com.rovio.rtool.mobile.ui;

import com.RMIDlet;
import com.rovio.nfscarbon.AppMain;
import com.rovio.nfscarbon.Game;
import com.rovio.rtool.mobile.CanvasController;
import com.rovio.rtool.mobile.Core;
import com.rovio.rtool.mobile.Resources;
import com.rovio.rtool.mobile.ui.ContentItem;
import com.rovio.rtool.mobile.ui.MenuItem;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuPage
extends CanvasController {
    private static final int NUMBER_OF_PAGE_ACTIONS = 2;
    public static final int ACTION_MENU_ITEM_ACTION = -2;
    public static final int ACTION_FOLLOW_LINK = -3;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int NO_ITEM = -1;
    public static final int MENU_PAGE_DEFAULT_INPUT_MODE = 2;
    private static final int TITLE_SCROLL_SPEED = 20;
    private static final int TITLE_SCROLL_WAIT = 3000;
    private static final int SPACING_TO_ARROWS = 1;
    private static final Font SOFTKEY_FONT = Font.getFont((int)32, (int)0, (int)0);
    public static AppMain sm_menuCustomizer = null;
    private static int[] sm_lastSelection = new int[14];
    private static int[] sm_lastScrollOffset = new int[14];
    public int m_pageId = -1;
    private Vector m_items = new Vector();
    private int m_selectedItem = -1;
    private int m_scrollY = 0;
    public int[] m_formattingBlockA = null;
    public int[] m_formattingBlockB = null;
    private ContentItem m_titleCi = null;
    private int m_titleImage = -1;
    private int m_titleTime = 0;
    private int m_titleOffset = 0;
    private int m_titleScrollFactor = 1;
    private int[] m_pageActionData = new int[2];
    private static final int PAGE_ACTION_REF_MASK = 65535;
    private static final int PAGE_ACTION_AVAILABLE_BIT = 65536;
    private static final int PAGE_ACTION_FUNCTIONKEY_BIT = 131072;
    private static final int PAGE_ACTION_ISACTION_BIT = 262144;
    private static final int PAGE_ACTION_ISLINK_BIT = 524288;
    private static final int PAGE_ACTION_LABELVISIBLE_BIT = 0x100000;
    private String[] m_pageActionLabels = new String[2];
    public boolean m_wrapPageScroll = false;
    private int m_queuedKeyPress = -1;
    private int m_queuedKeyPressCount = 0;
    private int m_actionToWaitFor = -1;
    private boolean m_itemSelectionChanged;
    public CanvasController backgroundCanvasController = null;
    private static Image[] mi;
    private static final int[] ITEM_CLIP_BUFFER;
    public static boolean isInMainMenu;
    public static final int FORMATTING_BLOCK_A = 1;
    public static final int FORMATTING_BLOCK_B = 2;
    private static final int FB_FLAGS_OFFSET = 0;
    private static final int FB_ENUM_FIELD_OFFSET = 1;
    private static final int FB_NUMBER_FIELDS_OFFSET = 2;
    private static final int[] FB_A_ENUMERATION_MASKS;
    public static final int[] FB_A_DEFAULTS;
    private static final int[] FB_B_ENUMERATION_MASKS;
    public static final int[] FB_B_DEFAULTS;
    public static final int FB_A_MAX_SIZE = 12;
    public static final int FB_B_MAX_SIZE = 17;
    private static final int FB_A_RGB555_START = 12;
    private static final int FB_A_RGB555_END = 19;
    private static final int FB_B_RGB555_START = 15;
    private static final int FB_B_RGB555_END = 21;

    public MenuPage() {
        this.setInputMode(2);
    }

    public void addItem(MenuItem menuItem) {
        this.addItem(menuItem, this.m_items.size());
    }

    public void addItem(MenuItem menuItem, int n) {
        this.m_items.insertElementAt(menuItem, n);
        menuItem.page = this;
        if (this.m_selectedItem == -1 && this.isItemVisible(n)) {
            this.setSelectedItem(n);
        }
    }

    public void removeItem(int n) {
        int n2 = this.m_selectedItem;
        if (this.m_selectedItem == n && (n2 = this.getSelectableItemAbove(this.m_selectedItem)) == -1) {
            n2 = this.getSelectableItemBelow(this.m_selectedItem);
        }
        if (n2 != -1 && n2 > n) {
            --n2;
        }
        this.setSelectedItem(-1);
        MenuItem menuItem = (MenuItem)this.m_items.elementAt(n);
        this.m_items.removeElementAt(n);
        menuItem.page = null;
        this.setSelectedItem(n2);
    }

    public void clear() {
        this.m_items.removeAllElements();
        this.m_scrollY = 0;
        this.m_selectedItem = -1;
        this.setCorrectSoftkeyLabels();
    }

    public int getItemCount() {
        return this.m_items.size();
    }

    public MenuItem getItemAt(int n) {
        return (MenuItem)this.m_items.elementAt(n);
    }

    public boolean isItemVisible(int n) {
        MenuItem menuItem = (MenuItem)this.m_items.elementAt(n);
        int n2 = this.getItemTop(n);
        return n2 >= this.m_scrollY && n2 + menuItem.getHeight() <= this.m_scrollY + this.getContentVisibleHeight();
    }

    public int getSelectedIndex() {
        return this.m_selectedItem;
    }

    public void setSelectedItem(int n) {
        this.m_itemSelectionChanged = true;
        if (n >= this.m_items.size()) {
            n = this.m_items.size() - 1;
        }
        if (n == this.m_selectedItem) {
            return;
        }
        if (this.m_selectedItem != -1) {
            ((MenuItem)this.m_items.elementAt(this.m_selectedItem)).focusChange(false);
        }
        if (n != -1) {
            MenuItem menuItem = (MenuItem)this.m_items.elementAt(n);
            if (menuItem.isSelectable()) {
                menuItem.focusChange(true);
                this.m_selectedItem = n;
            }
        } else {
            this.m_selectedItem = -1;
        }
        this.scrollToSelectedItem();
        if (this.m_pageId >= 0 && this.m_pageId < 14) {
            MenuPage.sm_lastSelection[this.m_pageId] = n;
        }
        this.setCorrectSoftkeyLabels();
    }

    public MenuItem getActiveItem() {
        MenuItem menuItem;
        MenuItem menuItem2 = menuItem = this.m_selectedItem != -1 ? (MenuItem)this.m_items.elementAt(this.m_selectedItem) : null;
        if (menuItem != null && menuItem.enabled) {
            return menuItem;
        }
        return null;
    }

    public void setTitle(String string, int n) {
        int n2 = 0;
        n2 |= this.getFBBValue(5) >> 0;
        this.m_titleCi = string != null ? new ContentItem(string, Integer.MAX_VALUE, n2 |= this.getFBBValue(6) >> 0) : null;
        this.setFBBValue(19, 8368895);
        this.m_titleImage = n;
        this.m_titleOffset = 0;
    }

    public void setPageAction(int n, String string, int n2, int n3, boolean bl) {
        this.m_pageActionData[n] = 0x110000;
        if (n2 == -3) {
            int n4 = n;
            this.m_pageActionData[n4] = this.m_pageActionData[n4] | 0x80000;
            int n5 = n;
            this.m_pageActionData[n5] = this.m_pageActionData[n5] | (short)n3 & 0xFFFF;
        } else {
            int n6 = n;
            this.m_pageActionData[n6] = this.m_pageActionData[n6] | 0x40000;
            int n7 = n;
            this.m_pageActionData[n7] = this.m_pageActionData[n7] | (short)n2 & 0xFFFF;
        }
        if (bl) {
            int n8 = n;
            this.m_pageActionData[n8] = this.m_pageActionData[n8] | 0x20000;
        }
        this.m_pageActionLabels[n] = string;
        this.setCorrectSoftkeyLabels();
    }

    public void setPageActionLabel(int n, String string) {
        if (this.m_pageActionData[n] == 65536) {
            this.m_pageActionLabels[n] = string;
            this.setCorrectSoftkeyLabels();
        }
    }

    public void setPageActionLabelsVisible(boolean bl) {
        for (int i = 0; i < 2; ++i) {
            if (bl) {
                int n = i;
                this.m_pageActionData[n] = this.m_pageActionData[n] | 0x100000;
                continue;
            }
            int n = i;
            this.m_pageActionData[n] = this.m_pageActionData[n] & 0xFFEFFFFF;
        }
    }

    public void removePageAction(int n) {
        this.m_pageActionLabels[n] = null;
        this.m_pageActionData[n] = 0;
        this.setCorrectSoftkeyLabels();
    }

    public void setCorrectSoftkeyLabels() {
        for (int i = 0; i < 2; ++i) {
            MenuItem menuItem;
            this.setSoftkeyLabel(null, 0 + i);
            if ((this.m_pageActionData[i] & 0x10000) == 0 || (this.m_pageActionData[i] & 0x100000) == 0 || (this.m_pageActionData[i] & 0x40000) != 0 && (short)(this.m_pageActionData[i] & 0xFFFF) == -2 && (menuItem = this.getActiveItem()) == null) continue;
            this.setSoftkeyLabel(this.m_pageActionLabels[i], 0 + i);
        }
    }

    private int getItemTop(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += ((MenuItem)this.m_items.elementAt(i)).getHeight() + this.getFBBValue(14);
        }
        return n2;
    }

    private int getSelectableItemAbove(int n) {
        for (int i = n - 1; i >= 0; --i) {
            if (!((MenuItem)this.m_items.elementAt(i)).isSelectable()) continue;
            return i;
        }
        return -1;
    }

    private int getSelectableItemBelow(int n) {
        for (int i = n + 1; i < this.m_items.size(); ++i) {
            if (!((MenuItem)this.m_items.elementAt(i)).isSelectable()) continue;
            return i;
        }
        return -1;
    }

    public final int getContentAreaWidth() {
        int n = this.getFBBValue(12);
        if (n > 0) {
            return n;
        }
        return CanvasController.sm_screenWidth - this.getFBBValue(10) + n;
    }

    public final int getContentAreaHeight() {
        int n = this.getFBBValue(13);
        if (n <= 0) {
            return CanvasController.sm_screenHeight - this.getTitleHeight() - (SOFTKEY_FONT.getHeight() + 4) - this.getFBBValue(11) + n;
        }
        return n;
    }

    public int getContentHeight() {
        if (this.m_items.size() > 0) {
            return this.getItemTop(this.m_items.size() - 1) + ((MenuItem)this.m_items.lastElement()).getHeight();
        }
        return 0;
    }

    public int getContentVisibleHeight() {
        int n = this.getContentAreaHeight();
        if (this.getContentHeight() > n) {
            return n - (1 + Resources.getSpriteAttribute(668, 1)) - (1 + Resources.getSpriteAttribute(666, 1));
        }
        return n;
    }

    public int getTitleHeight() {
        if (this.getFBBValue(2) == 4 && this.backgroundCanvasController == null) {
            int n;
            int n2 = n = this.m_titleCi != null ? this.m_titleCi.m_height : 0;
            if (this.m_titleImage != -1) {
                n = Math.max(n, Resources.getSpriteAttribute(this.m_titleImage, 1));
            }
            return n + (this.getFBBValue(7) << 1);
        }
        return 0;
    }

    public int getScrollY() {
        return this.m_scrollY;
    }

    public void scrollUp() {
        int n;
        if (this.m_items.size() == 0) {
            return;
        }
        if (this.m_selectedItem != -1) {
            int n2;
            n = this.getSelectableItemAbove(this.m_selectedItem);
            if (n != -1 && (n2 = this.getItemTop(n) + ((MenuItem)this.m_items.elementAt(n)).getHeight()) < this.m_scrollY - 20) {
                n = -1;
            }
        } else {
            n = -1;
            for (int i = 0; i < this.m_items.size(); ++i) {
                MenuItem menuItem = (MenuItem)this.m_items.elementAt(i);
                int n3 = this.getItemTop(i);
                int n4 = n3 + menuItem.getHeight();
                if (n3 >= this.m_scrollY) break;
                if (!menuItem.isSelectable() || n4 <= this.m_scrollY - 20) continue;
                n = i;
            }
        }
        if (n == -1) {
            if (this.m_wrapPageScroll && this.m_scrollY <= 0) {
                this.scrollToBottom();
                return;
            }
            this.m_scrollY -= 20;
            if (this.m_scrollY < 0) {
                this.m_scrollY = 0;
            }
            if (this.m_selectedItem != -1 && !this.isItemVisible(this.m_selectedItem)) {
                this.setSelectedItem(-1);
            }
        } else {
            this.setSelectedItem(n);
        }
    }

    public void scrollDown() {
        int n;
        if (this.m_items.size() == 0) {
            return;
        }
        int n2 = this.getContentHeight();
        int n3 = this.getContentVisibleHeight();
        if (this.m_selectedItem != -1) {
            int n4;
            n = this.getSelectableItemBelow(this.m_selectedItem);
            if (n != -1 && (n4 = this.getItemTop(n)) > this.m_scrollY + n3 + 20) {
                n = -1;
            }
        } else {
            n = -1;
            for (int i = this.m_items.size() - 1; i >= 0; --i) {
                MenuItem menuItem = (MenuItem)this.m_items.elementAt(i);
                int n5 = this.getItemTop(i);
                int n6 = n5 + menuItem.getHeight();
                if (n6 < this.m_scrollY + n3) break;
                if (!menuItem.isSelectable() || n6 > this.m_scrollY + n3 + 20) continue;
                n = i;
            }
        }
        if (n == -1) {
            if (this.m_wrapPageScroll && this.m_scrollY >= n2 - n3) {
                this.scrollToTop();
                return;
            }
            this.m_scrollY += 20;
            if (n2 <= n3) {
                this.m_scrollY = 0;
            } else if (this.m_scrollY > n2 - n3) {
                this.m_scrollY = n2 - n3;
            }
            if (this.m_selectedItem != -1 && !this.isItemVisible(this.m_selectedItem)) {
                this.setSelectedItem(-1);
            }
        } else {
            this.setSelectedItem(n);
        }
    }

    public void scrollToTop() {
        this.m_scrollY = 0;
        for (int i = 0; i < this.m_items.size() - 1; ++i) {
            MenuItem menuItem = (MenuItem)this.m_items.elementAt(i);
            if (!this.isItemVisible(i)) {
                this.setSelectedItem(-1);
                break;
            }
            if (!menuItem.isSelectable()) continue;
            this.setSelectedItem(i);
            break;
        }
    }

    public void scrollToBottom() {
        int n = this.getContentHeight();
        int n2 = this.getContentVisibleHeight();
        this.m_scrollY = n - n2;
        if (n < this.getContentAreaHeight()) {
            this.m_scrollY = 0;
        }
        for (int i = this.m_items.size() - 1; i > 0; --i) {
            if (!this.isItemVisible(i)) {
                this.setSelectedItem(-1);
                break;
            }
            if (!((MenuItem)this.m_items.elementAt(i)).isSelectable()) continue;
            this.setSelectedItem(i);
            break;
        }
    }

    private void scrollToSelectedItem() {
        if (this.m_selectedItem == -1) {
            return;
        }
        int n = this.getItemTop(this.m_selectedItem);
        int n2 = n + ((MenuItem)this.m_items.elementAt(this.m_selectedItem)).getHeight();
        int n3 = this.getContentVisibleHeight();
        if (n < this.m_scrollY) {
            this.m_scrollY = n;
        } else if (n2 > this.m_scrollY + n3) {
            this.m_scrollY = n2 - n3;
        }
        if (this.m_pageId >= 0 && this.m_pageId < 14) {
            MenuPage.sm_lastScrollOffset[this.m_pageId] = this.m_scrollY;
        }
    }

    public void keyPressed(int n) {
        if (this.m_queuedKeyPress == -1) {
            this.m_queuedKeyPress = n;
            this.m_queuedKeyPressCount = 1;
        } else if (this.m_queuedKeyPress == n) {
            ++this.m_queuedKeyPressCount;
        }
    }

    public void typingInput(int n, int n2, char c2) {
        MenuItem menuItem = this.getActiveItem();
        if (menuItem != null) {
            menuItem.typingInput(n, n2, c2);
        }
    }

    public void mainLoopIteration(int n) {
        int n2;
        int n3;
        if (this.m_titleCi != null) {
            int n4 = this.m_titleImage != -1 ? Resources.getSpriteAttribute(this.m_titleImage, 0) + this.getFBBValue(8) : 0;
            n3 = CanvasController.sm_screenWidth - this.getFBBValue(8) * 2;
            n2 = n3 - n4;
            if (n2 < this.m_titleCi.m_widestLine) {
                if (this.m_titleTime >= 3000) {
                    if (this.m_titleScrollFactor > 0) {
                        this.m_titleOffset = (this.m_titleTime - 3000) * 20 / 1000;
                        if (this.m_titleOffset > this.m_titleCi.m_widestLine - n2) {
                            this.m_titleOffset = this.m_titleCi.m_widestLine - n2;
                            this.m_titleTime = 0;
                            this.m_titleScrollFactor = -1;
                        }
                    } else {
                        this.m_titleOffset = this.m_titleCi.m_widestLine - n2 - (this.m_titleTime - 3000) * 20 / 1000;
                        if (this.m_titleOffset <= 0) {
                            this.m_titleOffset = 0;
                            this.m_titleTime = 0;
                            this.m_titleScrollFactor = 1;
                        }
                    }
                }
                this.m_titleTime += n;
            }
        }
        if (!Core.isActionCompleted(this.m_actionToWaitFor)) {
            this.m_queuedKeyPress = -1;
        }
        if (this.m_queuedKeyPress != -1) {
            MenuItem menuItem = this.getActiveItem();
            if (menuItem != null && menuItem.keyPressed(this.m_queuedKeyPress)) {
                return;
            }
            n3 = -1;
            switch (this.m_queuedKeyPress) {
                case 7: {
                    if ((this.m_pageActionData[0] & 0x20000) == 0) break;
                }
                case 5: {
                    if (this.m_selectedItem == AppMain.sm_mainMenuMoreGamesItem && this.m_items.size() >= 6 && isInMainMenu) {
                        RMIDlet.menuShowMoreGame = true;
                        break;
                    }
                    n3 = 0;
                    break;
                }
                case 24: {
                    if ((this.m_pageActionData[1] & 0x20000) == 0) break;
                }
                case 6: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    for (n2 = 0; n2 < this.m_queuedKeyPressCount; ++n2) {
                        this.scrollUp();
                    }
                    break;
                }
                case 2: {
                    for (n2 = 0; n2 < this.m_queuedKeyPressCount; ++n2) {
                        this.scrollDown();
                    }
                    break;
                }
            }
            if (n3 != -1 && (this.m_pageActionData[n3] & 0x10000) != 0) {
                n2 = (short)(this.m_pageActionData[n3] & 0xFFFF);
                if ((this.m_pageActionData[n3] & 0x40000) != 0) {
                    if (n2 == -2) {
                        if (menuItem != null) {
                            this.m_actionToWaitFor = menuItem.performAction();
                        }
                    } else {
                        this.m_actionToWaitFor = Core.postAction(n2, this);
                    }
                } else if ((this.m_pageActionData[n3] & 0x80000) != 0) {
                    Core.setCanvasController(MenuPage.getMenuPage(n2), false);
                }
            }
            this.m_queuedKeyPress = -1;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.getTitleHeight();
        int n9 = SOFTKEY_FONT.getHeight() + 4;
        int n10 = this.getFBBValue(10);
        int n11 = n8 + this.getFBBValue(11);
        int n12 = this.getContentAreaWidth();
        int n13 = this.getContentAreaHeight();
        if (this.getFBBValue(0) == 1) {
            if (this.backgroundCanvasController == null) {
                graphics.setColor(this.getFBBValue(17));
                graphics.fillRect(0, 0, CanvasController.sm_screenWidth, CanvasController.sm_screenHeight);
            } else {
                n7 = this.getFBBValue(9);
                this.backgroundCanvasController.paint(graphics);
                graphics.setClip(0, 0, CanvasController.sm_screenWidth, CanvasController.sm_screenHeight);
                graphics.setColor(this.getFBBValue(17));
                graphics.fillRect(n10 - n7, n11 - n7, n12 + n7 * 2, n13 + n7 * 2);
                graphics.setColor(this.getFBBValue(18));
                graphics.drawRect(n10 - n7, n11 - n7, n12 + n7 * 2 - 1, n13 + n7 * 2 - 1);
            }
        }
        if (sm_menuCustomizer != null) {
            sm_menuCustomizer.drawMenuBackground(graphics, this, n10, n11, n12, n13);
        }
        graphics.setClip(0, 0, CanvasController.sm_screenWidth, CanvasController.sm_screenHeight);
        if (n8 > 0) {
            n7 = this.getFBBValue(8);
            n6 = this.getFBBValue(7);
            n5 = 0;
            n4 = this.m_titleImage != -1 ? Resources.getSpriteAttribute(this.m_titleImage, 0) + this.getFBBValue(8) : 0;
            n3 = this.m_titleCi != null ? this.m_titleCi.m_widestLine : 0;
            n2 = CanvasController.sm_screenWidth - n7 * 2;
            n = n2 - n4;
            if (this.getFBBValue(3) == 8) {
                graphics.setColor(this.getFBBValue(15));
                graphics.fillRect(n5, 0, CanvasController.sm_screenWidth, n8);
            }
            int n14 = n7;
            if (this.getFBBValue(4) == 32) {
                n14 += n2 - n4 - Math.min(n3, n) >> 1;
            }
            if (this.m_titleImage != -1) {
                Resources.drawSprite(n14 + Resources.getSpriteAttribute(this.m_titleImage, 2), n5 + n6 + Resources.getSpriteAttribute(this.m_titleImage, 3), this.m_titleImage, graphics);
            }
            if (this.m_titleCi != null) {
                graphics.setClip(n14 - 1, n5 - 1, n + 2, n8 + 2);
                this.m_titleCi.draw(graphics, n14 + n4 - this.m_titleOffset, n5 + n6, this.getFBBValue(19), this.getFBBValue(20));
            }
        }
        graphics.setClip(0, 0, CanvasController.sm_screenWidth, CanvasController.sm_screenHeight);
        if (this.getFBBValue(1) == 2) {
            graphics.setColor(this.getFBBValue(16));
            graphics.fillRect(0, CanvasController.sm_screenHeight - n9, CanvasController.sm_screenWidth, n9);
        }
        if (this.m_pageId == 0) {
            if (mi == null) {
                mi = new Image[4];
                try {
                    MenuPage.mi[0] = Core.loadImage("/da.png");
                    MenuPage.mi[1] = Core.loadImage("/db.png");
                    MenuPage.mi[2] = Core.loadImage("/dc.png");
                    MenuPage.mi[3] = Core.loadImage("/dd.png");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int n15 = 0;
            n6 = 120;
            n5 = 276;
            graphics.drawImage(mi[1], n6, n5, 1 | 0x10);
            if (Game.sm_levelCareer >= AppMain.LEVEL_NAMES.length || Game.sm_gameMode == 0 && Game.sm_newGameMode == 0 && Game.sm_oldGameMode == 0) {
                n15 = 1;
            }
            n6 = 60;
            n5 = 285;
            n4 = 0;
            n3 = 0;
            n2 = 9;
            n = 5;
            if (this.m_selectedItem == 0) {
                n4 = 9;
            }
            graphics.setClip(n6, n5, n2, n);
            graphics.drawImage(mi[0], n6 - n4, n5 - n3, 0);
            n3 = 5;
            if (this.m_selectedItem < this.m_items.size() - 1) {
                n4 = 9;
            }
            graphics.setClip(n6, n5 += 11, n2, n);
            graphics.drawImage(mi[0], n6 - n4, n5 - n3, 0);
            n6 = 80;
            n5 = 280;
            graphics.setClip(n6, n5, 145, 23);
            if (this.m_selectedItem == AppMain.sm_mainMenuMoreGamesItem) {
                graphics.drawImage(mi[3], n6, n5, 0);
            } else if (this.m_selectedItem < AppMain.sm_mainMenuMoreGamesItem) {
                graphics.drawImage(mi[2], n6, n5 - (this.m_selectedItem + n15) * 23, 0);
            } else {
                graphics.drawImage(mi[2], n6, n5 - (this.m_selectedItem + n15 - 1) * 23, 0);
            }
            graphics.setClip(0, 0, CanvasController.sm_screenWidth, CanvasController.sm_screenHeight);
        } else {
            this.drawContentArea(graphics, n10, n11);
        }
    }

    public void drawContentArea(Graphics graphics, int n, int n2) {
        int n3 = this.getContentAreaWidth();
        int n4 = this.getContentVisibleHeight();
        int n5 = this.getContentHeight();
        graphics.setClip(n, n2, n3, this.getContentAreaHeight());
        if (this.m_scrollY > 0) {
            Resources.drawSprite(n + Resources.getSpriteAttribute(668, 2) + (n3 - Resources.getSpriteAttribute(668, 0) >> 1), n2 + Resources.getSpriteAttribute(668, 3), 668, graphics);
        }
        if (n4 < n5) {
            n2 += 1 + Resources.getSpriteAttribute(668, 1);
        }
        if (this.m_scrollY < n5 - n4) {
            Resources.drawSprite(n + Resources.getSpriteAttribute(666, 2) + (n3 - Resources.getSpriteAttribute(666, 0) >> 1), n2 + n4 + 1 + Resources.getSpriteAttribute(666, 3), 666, graphics);
        }
        for (int i = 0; i < this.m_items.size(); ++i) {
            MenuItem menuItem = (MenuItem)this.m_items.elementAt(i);
            int n6 = this.getItemTop(i);
            if (n6 > this.m_scrollY + n4) break;
            int n7 = menuItem.getHeight();
            int n8 = menuItem.getWidth();
            int n9 = n6 + n7;
            if (n9 < this.m_scrollY) continue;
            int n10 = n2 + n6 - this.m_scrollY;
            int n11 = n;
            int n12 = menuItem.getFBAValue(7);
            if (n12 == 1024) {
                n11 += n3 - n8;
            } else if (n12 == 2048) {
                n11 += n3 - n8 >> 1;
            }
            if (i == this.m_selectedItem) {
                graphics.setClip(0, 0, CanvasController.sm_screenWidth, CanvasController.sm_screenHeight);
                if (menuItem.getFBAValue(8) == 4096) {
                    graphics.setColor(menuItem.getFBAValue(18));
                    graphics.fillRect(n11, n10, n8, n7);
                    graphics.setColor(menuItem.getFBAValue(19));
                    graphics.drawRect(n11, n10, n8 - 1, n7 - 1);
                } else if (sm_menuCustomizer != null) {
                    sm_menuCustomizer.drawMenuSelectionMarker(graphics, this, menuItem, n11, n10, n8, n7);
                }
            }
            graphics.setClip(n, n2, n3, n4);
            Core.cutClip(graphics, n11, n10, n8, n7, ITEM_CLIP_BUFFER);
            menuItem.draw(graphics, n11, n10, i == this.m_selectedItem);
        }
    }

    public static MenuPage getMenuPage(int n) {
        isInMainMenu = n == 81;
        byte[] byArray = (byte[])Resources.getResource(n);
        boolean bl = false;
        if (byArray == null) {
            Resources.cacheResource(n);
            byArray = (byte[])Resources.getResource(n);
            bl = true;
        }
        try {
            int n2;
            int n3;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            byte by = dataInputStream.readByte();
            short s = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            int n4 = dataInputStream.readShort();
            short s3 = dataInputStream.readShort();
            int n5 = sm_lastSelection[by];
            String string = "";
            if (s >= 0) {
                string = Resources.getText(s);
            }
            MenuPage menuPage = new MenuPage();
            menuPage.m_pageId = by;
            menuPage.m_formattingBlockA = MenuPage.getFormattingBlock(dataInputStream, FB_A_ENUMERATION_MASKS, 12, 19);
            menuPage.m_formattingBlockB = MenuPage.getFormattingBlock(dataInputStream, FB_B_ENUMERATION_MASKS, 15, 21);
            menuPage.setTitle(string, s2);
            for (n3 = 0; n3 < n4; ++n3) {
                MenuItem menuItem = new MenuItem();
                menuItem.page = menuPage;
                s = dataInputStream.readShort();
                s2 = dataInputStream.readShort();
                menuItem.m_formattingBlockA = MenuPage.getFormattingBlock(dataInputStream, FB_A_ENUMERATION_MASKS, 12, 19);
                byte bl2 = dataInputStream.readByte();
                n2 = -1;
                if (bl2 == 2 || bl2 == 3) {
                    n2 = dataInputStream.readShort();
                }
                if (bl2 == 2) {
                    menuItem.action = n2;
                } else if (bl2 == 3) {
                    menuItem.pageLink = n2;
                }
                menuItem.setContent(s >= 0 ? Resources.getText(s) : null, s2);
                menuPage.addItem(menuItem, menuPage.m_items.size());
            }
            if (n == 81) {
                MenuItem menuItem = menuPage.getItemAt(5);
                menuPage.removeItem(5);
                menuPage.addItem(menuItem, 3);
            }
            for (n3 = 0; n3 < s3; ++n3) {
                String string2;
                byte by2 = dataInputStream.readByte();
                s = dataInputStream.readShort();
                boolean bl2 = dataInputStream.readBoolean();
                n2 = -1;
                byte by3 = dataInputStream.readByte();
                if (by3 == 2 || by3 == 3) {
                    n2 = dataInputStream.readShort();
                }
                String string3 = string2 = s >= 0 ? Resources.getText(s) : "";
                if (string2 == null) {
                    string2 = "";
                }
                if (by3 == 1) {
                    menuPage.setPageAction(by2, string2, -2, -1, bl2);
                    continue;
                }
                if (by3 == 2) {
                    menuPage.setPageAction(by2, string2, n2, -1, bl2);
                    continue;
                }
                if (by3 != 3) continue;
                menuPage.setPageAction(by2, string2, -3, n2, bl2);
            }
            menuPage.m_itemSelectionChanged = false;
            if (sm_menuCustomizer != null) {
                sm_menuCustomizer.prepareMenuPage(menuPage, by);
            }
            if (!menuPage.m_itemSelectionChanged) {
                if (n5 >= menuPage.m_items.size()) {
                    n5 = menuPage.m_items.size() - 1;
                }
                if (menuPage.m_items.size() == 0) {
                    n5 = -1;
                }
                menuPage.setSelectedItem(n5);
            }
            if (bl) {
                Resources.releaseResource(n);
            }
            return menuPage;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int getFBAValue(int n) {
        return MenuPage.getFormattingBlockValue(n, this.m_formattingBlockA, 1);
    }

    public int getFBBValue(int n) {
        return MenuPage.getFormattingBlockValue(n, this.m_formattingBlockB, 2);
    }

    public void setFBAValue(int n, int n2) {
        this.m_formattingBlockA = MenuPage.createFormattingBlock(n, n2, this.m_formattingBlockA, 1);
    }

    public void setFBBValue(int n, int n2) {
        this.m_formattingBlockB = MenuPage.createFormattingBlock(n, n2, this.m_formattingBlockB, 2);
    }

    private static int[] getFormattingBlock(DataInputStream dataInputStream, int[] nArray, int n, int n2) throws IOException {
        int n3;
        int n4 = dataInputStream.readInt();
        int n5 = nArray.length;
        if (n4 == 0) {
            return null;
        }
        int n6 = 0;
        int n7 = n5;
        while (n4 >>> n7 - 1 != 0) {
            n6 = n7 - n5;
            ++n7;
        }
        int[] nArray2 = new int[2 + n6];
        nArray2[0] = n4;
        nArray2[1] = 0;
        if ((n4 & -1 >>> 32 - n5) != 0) {
            nArray2[1] = dataInputStream.readInt();
        }
        for (n3 = 0; n3 < n6; ++n3) {
            if ((nArray2[0] & 1 << n3 + n5) == 0) continue;
            nArray2[2 + n3] = dataInputStream.readShort();
        }
        for (n3 = 2 + n - n5; n3 <= 2 + n2 - n5 && n3 < nArray2.length; ++n3) {
            int n8 = 0;
            n8 |= (nArray2[n3] & 0x7C00) << 9;
            n8 |= (nArray2[n3] & 0x3E0) << 6;
            nArray2[n3] = n8 |= (nArray2[n3] & 0x1F) << 3;
        }
        return nArray2;
    }

    public static int getFormattingBlockValue(int n, int[] nArray, int n2) {
        int[] nArray2;
        int[] nArray3;
        if (n2 == 1) {
            nArray3 = FB_A_DEFAULTS;
            nArray2 = FB_A_ENUMERATION_MASKS;
        } else {
            nArray3 = FB_B_DEFAULTS;
            nArray2 = FB_B_ENUMERATION_MASKS;
        }
        int n3 = nArray2.length;
        if (!MenuPage.isFormattingBlockValueSpecified(n, nArray)) {
            nArray = nArray3;
        }
        if (n < n3) {
            return nArray[1] & nArray2[n];
        }
        return nArray[2 + n - n3];
    }

    public static boolean isFormattingBlockValueSpecified(int n, int[] nArray) {
        return nArray != null && (nArray[0] & 1 << n) != 0;
    }

    public static int[] createFormattingBlock(int n, int n2, int[] nArray, int n3) {
        int[] nArray2;
        int n4;
        if (n3 == 1) {
            n4 = 12;
            nArray2 = FB_A_ENUMERATION_MASKS;
        } else {
            n4 = 17;
            nArray2 = FB_B_ENUMERATION_MASKS;
        }
        if (nArray == null) {
            nArray = new int[n4];
        } else if (nArray.length < n4) {
            int[] nArray3 = new int[n4];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            nArray = nArray3;
        }
        nArray[0] = nArray[0] | 1 << n;
        if (n < nArray2.length) {
            nArray[1] = nArray[1] & ~nArray2[n];
            nArray[1] = nArray[1] | n2 & nArray2[n];
        } else {
            nArray[2 + n - nArray2.length] = n2;
        }
        return nArray;
    }

    static {
        ITEM_CLIP_BUFFER = new int[4];
        isInMainMenu = false;
        FB_A_ENUMERATION_MASKS = new int[]{3, 12, 16, 32, 64, 384, 512, 3072, 4096, 8192};
        FB_A_DEFAULTS = new int[]{-1, 10274, -1, 1, 0xFFFFFF, 0, 0, 0xFFFF00, 3623790, 0xC0C0C0, 10272511, 0};
        FB_B_ENUMERATION_MASKS = new int[]{1, 2, 4, 8, 48, 64, 384};
        FB_B_DEFAULTS = new int[]{-1, 229, 2, 2, 6, 6, 0, -6, -3, 1, 0, 0, 0, 0xA0A0A0, 0xFFFFFF, 0, 0};
    }
}

