/*
 * Decompiled with CFR 0.152.
 */
package module.ekernel.input;

public class KeyHandler {
    private static KeyHandler _instance;
    protected int MAX_KEYBUFF_SIZE = 3;
    protected int _keyState;
    protected int _keyRear;
    protected int _keyHead;
    protected int[] _keyBuff;
    protected int _hold;
    protected int _keyCode;
    protected boolean _canReserver;

    public static KeyHandler instance() {
        if (_instance == null) {
            _instance = new KeyHandler();
        }
        return _instance;
    }

    private KeyHandler() {
        this.initKeyBuff(3);
    }

    public void keyPressed(int n) {
        int n2;
        this._keyCode = n;
        this._keyState = n2 = this.translateKeyCode(n);
        this.produceKey(n2);
    }

    public void keyReleased(int n) {
        this._keyState = 0;
        this._hold = 0;
    }

    public int getCurKey() {
        return this._keyState;
    }

    public void resetKeyBuff() {
        this._keyHead = 0;
        this._keyRear = 0;
        this._keyState = 0;
        this._canReserver = false;
    }

    public void initKeyBuff(int n) {
        this.MAX_KEYBUFF_SIZE = n;
        this._keyHead = 0;
        this._keyRear = 0;
        this._keyBuff = new int[n];
    }

    public void produceKey(int n) {
        this._keyBuff[this._keyRear] = n;
        if (++this._keyRear >= this.MAX_KEYBUFF_SIZE) {
            this._keyRear = 0;
        }
        if (this._keyRear == this._keyHead && ++this._keyHead >= this.MAX_KEYBUFF_SIZE) {
            this._keyHead = 0;
        }
    }

    protected int translateKeyCode(int n) {
        int n2 = 0;
        switch (n) {
            case -1: 
            case 1: 
            case 50: {
                n2 = 4;
                break;
            }
            case -2: 
            case 6: 
            case 56: {
                n2 = 8;
                break;
            }
            case -3: 
            case 2: 
            case 52: {
                n2 = 1;
                break;
            }
            case -4: 
            case 5: 
            case 54: {
                n2 = 2;
                break;
            }
            case -5: 
            case 53: {
                n2 = 16;
                break;
            }
            case 48: {
                n2 = 512;
                break;
            }
            case 49: {
                n2 = 1024;
                break;
            }
            case 51: {
                n2 = 4096;
                break;
            }
            case 55: {
                n2 = 32768;
                break;
            }
            case 57: {
                n2 = 131072;
                break;
            }
            case 42: {
                n2 = 128;
                break;
            }
            case 35: {
                n2 = 256;
                break;
            }
            case -6: {
                n2 = 262144;
                break;
            }
            case -7: {
                n2 = 524288;
            }
        }
        return n2;
    }
}

