/*
 * Decompiled with CFR 0.152.
 */
package module.ekernel.container;

import java.util.Stack;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import module.ekernel.container.GamePage;
import module.ekernel.input.KeyHandler;
import module.ekernel.input.PointHandler;

public class GameScreen
extends Canvas {
    private static GameScreen _instance;
    public GamePage _curPage;
    private Stack _pages = new Stack();
    private KeyHandler _keyHandler;
    private PointHandler _pointHandler;
    private boolean _painting;
    public Font _font;
    public int _ticks;

    public static GameScreen instance() {
        if (_instance == null) {
            _instance = new GameScreen();
        }
        return _instance;
    }

    private GameScreen() {
        this.setFullScreenMode(true);
        this._keyHandler = KeyHandler.instance();
        this._pointHandler = PointHandler.instance();
        this._painting = false;
    }

    protected void paint(Graphics graphics) {
        this._painting = true;
        if (this._font == null) {
            this._font = Font.getFont((int)0, (int)0, (int)8);
        }
        graphics.setFont(this._font);
        ++this._ticks;
        try {
            this._curPage = this.peekFromStack();
            if (this._curPage != null) {
                this._curPage.draw(graphics);
                this._curPage.onKey(this._keyHandler);
                this._curPage.onPoint(this._pointHandler);
                if (this._curPage.finish()) {
                    this.popFromStack();
                }
            } else {
                graphics.drawString("\u6924\u7538\u6f70\u93cd\u581c\u8d1f\u7ecc\u8f70\u7c21!!!!", 10, 10, 20);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._painting = false;
    }

    public void keyPressed(int n) {
        this._keyHandler.keyPressed(n);
    }

    public void keyRepeated(int n) {
    }

    public void keyReleased(int n) {
        this._keyHandler.keyReleased(n);
    }

    protected void pointerPressed(int n, int n2) {
        this._pointHandler.pointerPressed(n, n2);
    }

    protected void pointerReleased(int n, int n2) {
        this._pointHandler.pointerReleased(n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        this._pointHandler.pointerDragged(n, n2);
    }

    protected void hideNotify() {
        GamePage gamePage = this.peekFromStack();
        if (gamePage != null) {
            gamePage.hideNotify();
        }
    }

    public void pushPage(GamePage gamePage) {
        this._pages.push(gamePage);
    }

    public GamePage popFromStack() {
        if (this._pages.empty()) {
            return null;
        }
        return (GamePage)this._pages.pop();
    }

    public GamePage peekFromStack() {
        if (this._pages.empty()) {
            return null;
        }
        return (GamePage)this._pages.peek();
    }

    public boolean paintable() {
        return !this._painting;
    }
}

