/*
 * Decompiled with CFR 0.152.
 */
public final class Enemy
extends GameInterface {
    static GameEngine engine;
    byte curIndex;
    byte posIndex;
    boolean isHit;
    boolean isShowLife;
    public static final byte RoadLine = -5;
    static byte[][] moveMotion;
    static byte[][] AttackMotion;
    static byte[][] imgBossData;
    static byte[][] imgEnemy2Data;
    boolean startIsLeft;
    static byte[][] imgEnemy1Data;
    byte lastStatus = 0;
    int temp = 0;
    boolean isAttack = true;

    public Enemy(GameEngine GE) {
        if (engine == null) {
            engine = GE;
        }
    }

    public static final void drawLife(GameInterface emy) {
        Tools.addObject((byte)1, GameMap.setOffX, GameMap.setOffY + 200, 40, 5, true, 36, 0xFF0000, 60);
        Tools.addObject((byte)1, GameMap.setOffX, GameMap.setOffY + 200, 40 * emy.hp / emy.hp_max, 5, true, 36, 0xFFFF00, 61);
    }

    public void initEnemy(short[] enemyData) {
        this.x = enemyData[0];
        this.y = enemyData[1];
        this.type = (byte)enemyData[2];
        this.isLeft = enemyData[3] != 0;
        this.startIsLeft = this.isLeft;
        this.bound = enemyData[4];
        this.curStatus = (byte)21;
        this.startPosX = (short)this.x;
        this.startPosY = (short)this.y;
        this.isShowLife = false;
        switch (this.type) {
            case 0: {
                this.setStatus((byte)21);
                this.speed = (byte)2;
                break;
            }
            case 1: {
                this.setStatus((byte)21);
                this.speed = (byte)5;
                break;
            }
            case 2: {
                this.setStatus((byte)21);
                this.speed = (byte)2;
                break;
            }
            case 3: {
                this.setStatus((byte)9);
                this.speed = (byte)5;
                break;
            }
            case 4: {
                this.speed = (byte)2;
                break;
            }
            case 5: {
                this.speed = (byte)5;
                this.attack = 50;
            }
        }
        this.initProp(enemyData[5]);
        this.hp = this.hp_max;
    }

    public void initProp(int level) {
        this.hp_max = 60 + level * 10;
        this.mp_max = 60 + level * 10;
        this.attack = level * 10;
        this.defend = level * 10;
        this.magic_attack = 50 + level * 12;
        this.magic_defend = level * 10;
        this.exp = 5 * level;
    }

    public void setStatus(byte status) {
        this.index = 0;
        this.curStatus = status;
        if (this.curStatus == 7) {
            switch (this.type) {
                case 2: 
                case 3: {
                    break;
                }
            }
        }
    }

    public static void enemyMove(GameInterface emy, int mx, int my) {
        if (GameEngine.map.canFall(emy.x + mx + (mx < 0 ? 0 : emy.w), emy.y)) {
            emy.isLeft = !emy.isLeft;
            return;
        }
        if (GameEngine.map.canRun(emy.x + mx + (mx < 0 ? 0 : emy.w), emy.y - 12)) {
            emy.x += mx;
        } else {
            emy.isLeft = !emy.isLeft;
        }
    }

    public void AI_1(GameInterface emy, GameInterface role, int attackBound) {
        if (this.hp <= 0) {
            return;
        }
        int ex = emy.x + emy.w / 2;
        int rx = role.x + role.w / 2;
        ++this.temp;
        switch (emy.curStatus) {
            case 21: {
                Enemy.enemyMove(this, this.isLeft ? -4 : 4, 0);
                break;
            }
            case 10: {
                Enemy.enemyMove(this, this.isLeft ? -4 : 4, 0);
                break;
            }
            case 7: {
                break;
            }
            case 17: {
                if (this.index != 4) break;
                if (ex > rx) {
                    emy.isLeft = true;
                    break;
                }
                emy.isLeft = false;
                break;
            }
            case 9: {
                if (this.temp < 30) break;
                this.temp = 0;
                this.setStatus((byte)10);
            }
        }
    }

    public void AI_3(GameInterface emy, GameInterface role, int attackBound) {
        if (this.hp <= 0) {
            return;
        }
        int ex = emy.x + emy.w / 2;
        int rx = role.x + role.w / 2;
        ++this.temp;
        switch (emy.curStatus) {
            case 21: {
                if (rx <= emy.startPosX + emy.bound + 30 && rx >= emy.startPosX - emy.bound && role.y >= emy.y - 10 && role.y <= emy.y + 10 && this.isAttack && Math.abs(ex - rx) < attackBound) {
                    if (this.isLeft && ex > rx) {
                        this.setStatus((byte)10);
                        this.isAttack = false;
                        return;
                    }
                    if (!this.isLeft && ex < rx) {
                        this.isAttack = false;
                        this.setStatus((byte)10);
                        return;
                    }
                }
                if (emy.isLeft) {
                    if (ex < this.startPosX) {
                        emy.isLeft = false;
                        this.isAttack = true;
                        break;
                    }
                    emy.x -= emy.speed;
                    Enemy.enemyMove(this, -emy.speed, 0);
                    break;
                }
                if (ex > this.startPosX + this.bound) {
                    emy.isLeft = true;
                    this.isAttack = true;
                    break;
                }
                emy.x += emy.speed;
                Enemy.enemyMove(this, emy.speed, 0);
                break;
            }
            case 10: {
                break;
            }
            case 7: {
                break;
            }
            case 17: {
                if (++this.index != 4) break;
                this.isAttack = true;
                emy.isLeft = ex > rx;
                this.setStatus((byte)21);
                break;
            }
        }
    }

    public void AI_boss(GameInterface emy, GameInterface role, int attackBound) {
        if (this.hp <= 0) {
            return;
        }
        int ex = emy.x + emy.w / 2;
        int rx = role.x + role.w / 2;
        ++this.temp;
        switch (emy.curStatus) {
            case 9: {
                if (++this.index != 6) break;
                this.temp = 20;
                emy.isLeft = ex > rx;
                this.setStatus((byte)21);
                break;
            }
            case 17: {
                if (ex > rx && role.isLeft) {
                    this.setStatus((byte)9);
                    break;
                }
                if (ex < rx && !role.isLeft) {
                    this.setStatus((byte)9);
                    break;
                }
                this.setStatus((byte)21);
                break;
            }
            case 10: {
                break;
            }
            case 7: {
                break;
            }
            case 22: {
                if (Math.abs(role.y - emy.y) < 10) {
                    emy.y = role.y;
                    break;
                }
                if (emy.y - role.y > 10) {
                    emy.y -= 10;
                    break;
                }
                emy.y += 10;
                break;
            }
            case 21: {
                if (rx <= emy.startPosX + emy.bound && rx >= emy.startPosX - emy.bound && role.y >= emy.y - 10 && role.y <= emy.y + 100 && Math.abs(ex - rx) < attackBound && (this.isLeft && ex > rx || !this.isLeft && ex < rx) && this.temp > 20) {
                    this.setStatus((byte)10);
                    this.temp = 0;
                    return;
                }
                if (emy.isLeft) {
                    if (ex < GameMap.setOffX) {
                        emy.isLeft = false;
                        this.setStatus((byte)22);
                        break;
                    }
                    emy.x -= emy.speed;
                    break;
                }
                if (ex > GameMap.setOffX + 240 - 39) {
                    emy.isLeft = true;
                    this.setStatus((byte)22);
                    break;
                }
                emy.x += emy.speed;
            }
        }
    }

    public void move() {
        byte[] motion = null;
        byte[] adjustX = null;
        Object adjustY = null;
        this.sx = 0;
        this.sy = 0;
        switch (this.type) {
            case 0: {
                switch (this.curStatus) {
                    case 21: {
                        motion = new byte[]{0, 1, 2, 3};
                        this.curIndex = motion[this.index];
                        if (++this.index != motion.length) break;
                        this.index = 0;
                        break;
                    }
                    case 17: {
                        break;
                    }
                    case 7: {
                        motion = new byte[]{7, 8, 9, 10, 11, 10, 11, 12, 12, 12, 12, 12, 12};
                        this.curIndex = motion[this.index];
                        if (++this.index != motion.length) break;
                        this.setStatus((byte)19);
                        GameEngine.role.exp += this.exp;
                        GameEngine.addItem(this.x, this.y, GameEngine.time % 50, GameEngine.time % 4);
                        break;
                    }
                    case 10: {
                        motion = new byte[]{3, 4, 5, 6, 3};
                        this.curIndex = motion[this.index];
                        if (++this.index != motion.length) break;
                        this.setStatus((byte)21);
                    }
                }
                this.AI_3(this, GameEngine.role, 60);
                this.sx = this.x;
                this.sy = this.y;
                break;
            }
            case 1: {
                switch (this.curStatus) {
                    case 21: {
                        motion = new byte[]{1, 2, 3};
                        this.curIndex = motion[this.index];
                        adjustX = this.isLeft ? new byte[]{-5, 2, -2, 0} : new byte[]{0, 2, 0, 2};
                        if (++this.index == motion.length) {
                            this.index = 0;
                        }
                        this.sx = this.x;
                        this.sy = this.y;
                        break;
                    }
                    case 17: {
                        if (++this.index == 5) {
                            this.setStatus((byte)21);
                        }
                        this.sx = this.x;
                        this.sy = this.y;
                        break;
                    }
                    case 7: {
                        motion = new byte[]{0, 4, 4, 5, 5, 6, 6, 7, 7, 7, 7};
                        this.curIndex = motion[this.index];
                        adjustX = this.isLeft ? new byte[]{3, 0, 0, -7, 0, 0, 0, 0, 0, 0, 0} : new byte[]{0, 6, 0, 1, 0, -1, 0, 0, 0, 0, 0};
                        this.x += adjustX[this.index];
                        if (++this.index == motion.length) {
                            this.setStatus((byte)35);
                            this.hp = this.hp_max;
                        }
                        this.sx = this.x;
                        this.sy = this.y;
                        break;
                    }
                    case 35: {
                        this.curIndex = (byte)7;
                        if (++this.index == 50) {
                            this.setStatus((byte)36);
                        }
                        this.sx = this.x;
                        this.sy = this.y;
                        break;
                    }
                    case 36: {
                        motion = new byte[]{7, 6, 6, 5, 5, 4, 4, 0};
                        this.curIndex = motion[this.index];
                        adjustX = this.isLeft ? new byte[]{0, 0, 0, 0, -7, 0, 0, 3} : new byte[]{0, 0, -1, 0, 1, 0, 6, 0};
                        if (++this.index == motion.length) {
                            this.setStatus((byte)21);
                        }
                        this.sx = this.x;
                        this.sy = this.y;
                        break;
                    }
                }
                this.AI_1(this, GameEngine.role, 80);
                break;
            }
            case 2: {
                switch (this.curStatus) {
                    case 9: {
                        break;
                    }
                    case 10: {
                        motion = new byte[]{3, 3, 4, 4, 5, 5, 5, 5, 5};
                        this.curIndex = motion[this.index];
                        adjustX = this.isLeft ? new byte[]{0, 0, -2, 0, -8, 0, 0, 0, 0} : new byte[]{0, 0, 2, 0, 0, 0, 0, 0, 0};
                        this.x += adjustX[this.index];
                        if (++this.index != motion.length) break;
                        this.setStatus((byte)21);
                        break;
                    }
                    case 21: {
                        motion = new byte[]{0, 1, 0, 2};
                        this.curIndex = motion[this.index];
                        if (++this.index != motion.length) break;
                        this.index = 0;
                        break;
                    }
                    case 7: {
                        ++this.index;
                        this.setStatus((byte)19);
                        break;
                    }
                }
                this.AI_3(this, GameEngine.role, 80);
                this.sx += this.x;
                this.sy = this.y;
            }
        }
    }

    public void paint() {
        if (this.curStatus == 19) {
            return;
        }
        if (this.hp <= 0 && this.curStatus != 7 && this.curStatus != 19) {
            this.setStatus((byte)7);
        }
        this.lx = 0;
        this.rx = 0;
        switch (this.type) {
            case 0: {
                this.getSize(this.curIndex);
                this.sx += this.isLeft ? -this.rx : -this.lx;
                this.drawFrame(this.sx, this.sy, this.curIndex, this.isLeft);
                break;
            }
            case 1: {
                this.getSize2(this.curIndex);
                this.drawFrame2(this.sx, this.sy, this.curIndex, this.isLeft);
                break;
            }
            case 2: {
                this.getSize3(this.curIndex);
                this.drawFrame3(this.sx, this.sy, this.curIndex, this.isLeft);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    private void drawFrame(int x, int y, int index, boolean isLeft) {
        byte[] data = null;
        switch (index) {
            case 0: {
                data = new byte[]{0, 12, -29, 10, 0, 8, 22, -20, 8, 0, 27, 8, -16, 19, 0, 13, 4, -24, 29, 0, 12, 0, -38, 35, 0, 35, 22, -9, 8, 0, 29, 13, 0, 18, 0, 24, 27, 0, 0, 0};
                break;
            }
            case 1: {
                data = new byte[]{0, 12, -31, 4, 0, 8, 22, -22, 2, 0, 27, 8, -18, 13, 0, 13, 4, -26, 23, 0, 12, 0, -40, 29, 0, 6, 21, 0, 0, 0};
                break;
            }
            case 2: {
                data = new byte[]{0, 12, -29, 10, 0, 8, 22, -20, 8, 0, 27, 8, -16, 19, 0, 13, 4, -24, 29, 0, 12, 0, -38, 35, 0, 32, 20, -10, 9, 0, 30, 13, 0, 19, 0, 22, 27, 0, 0, 0};
                break;
            }
            case 3: {
                data = new byte[]{0, 12, -31, 3, 0, 8, 22, -22, 1, 0, 27, 8, -18, 12, 0, 13, 4, -26, 22, 0, 12, 0, -40, 28, 0, 10, 20, 0, 0, 0};
                break;
            }
            case 4: {
                data = new byte[]{0, 4, -27, 48, 0, 11, 16, -9, 42, 0, 25, 0, -22, 55, 0, 9, 29, -14, 26, 0, 15, 45, -6, 0, 0, 28, 12, 0, 49, 0, 23, 28, 0, 32, 0};
                break;
            }
            case 5: {
                data = new byte[]{14, 0, -18, 45, 0, 1, 50, -18, 4, 0, 21, 69, -9, 10, 0, 31, 64, -1, 21, 0, 23, 84, 0, 0, 0};
                break;
            }
            case 6: {
                data = new byte[]{14, 0, -18, 45, 0, 1, 50, -18, 4, 0, 21, 69, -9, 10, 0, 31, 64, -1, 21, 0, 23, 84, 0, 0, 0, 18, 0, -12, 48, 0, 17, 47, -11, 2, 0};
                break;
            }
            case 7: {
                data = new byte[]{0, 0, -21, 11, 0, 3, 19, -11, 0, 0, 19, 19, 0, 0, 0};
                break;
            }
            case 8: {
                data = new byte[]{0, 0, -22, 12, 0, 3, 19, -12, 1, 0, 34, 18, 0, 0, 0};
                break;
            }
            case 9: {
                data = new byte[]{0, 0, -25, 16, 0, 7, 15, 0, 0, 0, 33, 25, -17, 1, 0};
                break;
            }
            case 10: {
                data = new byte[]{0, 0, -28, 16, 0, 2, 15, 0, 0, 0};
                break;
            }
            case 11: {
                data = new byte[]{4, 0, -24, 18, 0, 2, 13, 0, 0, 0};
                break;
            }
            case 12: {
                data = new byte[]{2, 9, 0, 0, 0, 5, 0, -10, 15, 0};
            }
        }
        int i = 0;
        while (i < data.length) {
            Tools.addObject(600 + data[i], x + data[i + (!isLeft ? 3 : 1)], y + data[i + 2], 0, 0, imgEnemy1Data[data[i]][2], imgEnemy1Data[data[i]][3], 36, !isLeft ? (data[i + 4] == 0 ? (byte)1 : 0) : (data[i + 4] == 0 ? (byte)0 : 1), 21);
            i += 5;
        }
    }

    private void getSize(int index) {
        int[][] indent = new int[][]{{9, 8, 6, 0}, {9, 2, 8, 0}, {9, 8, 6, 0}, {9, 1, 8, 0}, {8, 39, -2, 0}, {60, 11, -9, 1}, {60, 11, -9, 1}, {7, -1, -7, -1}, {7, 0, -7, 0}, {9, 2, -4, 0}, {10, 1, -3, 2}, {8, 1, -3, 2}, {4, 1, -22, 2}};
        this.lx = indent[this.curIndex][1];
        this.rx = indent[this.curIndex][0];
        this.w = 24;
        this.h = 45;
    }

    private void drawFrame2(int x, int y, int index, boolean isLeft) {
        byte[] data = null;
        switch (index) {
            case 0: {
                data = new byte[]{4, 0, -22, 8, 0, 5, 7, -11, 7, 0, 6, 6, -8, 7, 0, 7, 6, -3, 1, 0, 8, 7, 0, 0, 0, 10, 5, -10, 13, 0, 12, 5, -20, 6, 0};
                break;
            }
            case 1: {
                data = new byte[]{4, 7, -27, 8, 0, 5, 14, -16, 7, 0, 6, 13, -13, 7, 0, 7, 12, -8, 2, 0, 8, 13, -5, 1, 0, 11, 15, 0, 9, 0, 15, 12, -29, 0, 0, 9, 0, -20, 13, 0};
                break;
            }
            case 2: {
                data = new byte[]{4, 7, -27, 8, 0, 5, 14, -16, 7, 0, 6, 13, -13, 7, 0, 7, 13, -8, 1, 0, 8, 14, -5, 0, 0, 11, 15, 0, 9, 0, 13, 12, -25, 0, 0, 9, 0, -20, 13, 0};
                break;
            }
            case 3: {
                data = new byte[]{4, 7, -27, 9, 0, 5, 14, -16, 8, 0, 6, 13, -13, 8, 0, 7, 13, -8, 2, 0, 8, 15, -5, 0, 0, 11, 15, 0, 10, 0, 14, 12, -26, 0, 0, 9, 0, -20, 14, 0};
                break;
            }
            case 4: {
                data = new byte[]{0, 0, 0, 0, 0};
                break;
            }
            case 5: {
                data = new byte[]{1, 0, 0, 0, 0};
                break;
            }
            case 6: {
                data = new byte[]{2, 0, 0, 0, 0};
                break;
            }
            case 7: {
                data = new byte[]{3, 0, 0, 0, 0};
            }
        }
        int i = 0;
        while (i < data.length) {
            Tools.addObject(750 + data[i], x + data[i + (!isLeft ? 3 : 1)], y + data[i + 2], 0, 0, imgEnemy2Data[data[i]][2], imgEnemy2Data[data[i]][3], 36, !isLeft ? (data[i + 4] == 0 ? (byte)1 : 0) : (data[i + 4] == 0 ? (byte)0 : 1), 21);
            i += 5;
        }
    }

    public void getSize2(int index) {
        switch (index) {
            case 0: {
                this.w = 21;
                this.h = 33;
                break;
            }
            case 1: {
                this.w = 28;
                this.h = 38;
                break;
            }
            case 2: {
                this.w = 28;
                this.h = 38;
                break;
            }
            case 3: {
                this.w = 29;
                this.h = 38;
                break;
            }
            case 4: {
                this.w = 24;
                this.h = 36;
                break;
            }
            case 5: {
                this.w = 30;
                this.h = 23;
                break;
            }
            case 6: {
                this.w = 24;
                this.h = 13;
                break;
            }
            case 7: {
                this.w = 23;
                this.h = 4;
            }
        }
    }

    private void drawFrame3(int x, int y, int index, boolean isLeft) {
        byte[] data = null;
        switch (index) {
            case 0: {
                data = new byte[]{3, 0, -37, 2, 0, 4, 14, -27, 1, 0, 5, 13, -2, 0, 0, 13, 13, -10, 9, 0, 6, 12, 0, 5, 0};
                break;
            }
            case 1: {
                data = new byte[]{3, 0, -36, 2, 0, 4, 14, -26, 1, 0, 5, 13, -1, 0, 0, 8, 12, -10, 11, 0, 7, 8, 0, 9, 0, 11, 22, 0, 1, 0};
                break;
            }
            case 2: {
                data = new byte[]{3, 0, -35, 6, 0, 4, 14, -25, 5, 0, 5, 13, 0, 4, 0, 9, 10, -9, 15, 0, 10, 6, 0, 15, 0, 12, 24, 0, 0, 0};
                break;
            }
            case 3: {
                data = new byte[]{0, 5, -26, 0, 0, 5, 5, -1, 2, 0, 8, 4, -10, 13, 0, 7, 0, 0, 11, 0, 11, 14, 0, 3, 0};
                break;
            }
            case 4: {
                data = new byte[]{1, 0, -26, 0, 0, 5, 7, -1, 0, 0, 8, 6, -10, 11, 0, 7, 2, 0, 9, 0, 11, 16, 0, 1, 0};
                break;
            }
            case 5: {
                data = new byte[]{2, 0, -26, 0, 0, 5, 15, -1, 0, 0, 8, 14, -10, 11, 0, 7, 10, 0, 9, 0, 11, 24, 0, 1, 0};
            }
        }
        int i = 0;
        while (i < data.length) {
            Tools.addObject(900 + data[i], x + data[i + (!isLeft ? 3 : 1)], y + data[i + 2], 0, 0, imgBossData[data[i]][2], imgBossData[data[i]][3], 36, !isLeft ? (data[i + 4] == false ? (byte)1 : 0) : (data[i + 4] == false ? (byte)0 : 1), 21);
            i += 5;
        }
    }

    public void getSize3(int index) {
        switch (index) {
            case 0: {
                this.w = 26;
                this.h = 49;
                break;
            }
            case 1: {
                this.w = 26;
                this.h = 48;
                break;
            }
            case 2: {
                this.w = 30;
                this.h = 47;
                break;
            }
            case 3: {
                this.w = 20;
                this.h = 55;
                break;
            }
            case 4: {
                this.w = 20;
                this.h = 48;
                break;
            }
            case 5: {
                this.w = 28;
                this.h = 42;
            }
        }
    }

    static {
        moveMotion = new byte[12][];
        AttackMotion = new byte[12][];
        imgBossData = new byte[][]{{0, 0, 15, 29}, {15, 0, 20, 22}, {35, 0, 28, 16}, {36, 16, 24, 12}, {50, 29, 11, 10}, {63, 0, 13, 25}, {0, 29, 9, 10}, {11, 29, 9, 10}, {22, 29, 3, 10}, {27, 29, 5, 10}, {34, 30, 9, 9}, {45, 32, 3, 7}, {63, 27, 6, 12}, {71, 28, 4, 11}};
        imgEnemy2Data = new byte[][]{{0, 0, 24, 36}, {24, 0, 30, 23}, {26, 23, 24, 13}, {35, 36, 23, 4}, {0, 37, 13, 11}, {13, 37, 7, 11}, {20, 37, 8, 3}, {20, 40, 14, 5}, {21, 45, 14, 3}, {36, 40, 15, 8}, {58, 34, 3, 14}, {52, 41, 4, 5}, {61, 34, 10, 12}, {54, 0, 16, 13}, {54, 13, 17, 12}, {54, 25, 16, 9}};
        imgEnemy1Data = new byte[][]{{0, 0, 19, 16}, {20, 0, 41, 19}, {61, 0, 20, 18}, {82, 0, 11, 21}, {0, 16, 15, 20}, {15, 17, 14, 15}, {29, 20, 14, 22}, {44, 20, 20, 17}, {66, 19, 11, 17}, {77, 22, 16, 15}, {0, 37, 14, 22}, {15, 33, 13, 26}, {29, 44, 6, 13}, {35, 44, 8, 14}, {43, 37, 50, 6}, {43, 43, 26, 10}, {69, 43, 24, 11}, {45, 54, 46, 4}, {0, 59, 47, 12}, {48, 58, 11, 12}, {60, 58, 12, 10}, {74, 59, 16, 9}, {0, 71, 14, 10}, {15, 71, 11, 9}, {27, 71, 14, 9}, {41, 71, 16, 9}, {58, 72, 10, 8}, {69, 69, 14, 8}, {0, 81, 10, 9}, {11, 81, 10, 9}, {22, 80, 9, 10}, {32, 82, 10, 8}, {43, 80, 12, 10}, {55, 83, 9, 6}, {69, 43, 13, 10}, {82, 43, 11, 11}};
    }
}

