/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.obstacles;

import at.emini.physics2D.util.FXVector;
import com.ximad.pvn.engine.Application;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.XBody;
import com.ximad.pvn.screens.GameScreen;
import com.ximad.pvn.utils.ArrayList;
import javax.microedition.lcdui.Graphics;

public class GameLandscape
extends PhysicalGameObject {
    private int scenarioIndex;
    private static int[] xx = new int[4];
    private static int[] yy = new int[4];

    public void draw(Graphics g) {
        if (this.nFrames <= 0) {
            return;
        }
        XBody b = this.box2dId;
        FXVector[] vertices = b.getVertices();
        GameLandscape.xx[0] = vertices[0].xAsInt() - Camera.position;
        GameLandscape.yy[0] = vertices[0].yAsInt();
        GameLandscape.xx[1] = vertices[1].xAsInt() - Camera.position;
        GameLandscape.yy[1] = vertices[1].yAsInt();
        GameLandscape.xx[2] = vertices[2].xAsInt() - Camera.position;
        GameLandscape.yy[2] = vertices[2].yAsInt();
        GameLandscape.xx[3] = vertices[3].xAsInt() - Camera.position;
        GameLandscape.yy[3] = vertices[3].yAsInt();
        int minX = xx[0];
        int minY = yy[0];
        int maxX = xx[0];
        int maxY = yy[0];
        for (int i = 1; i < 4; ++i) {
            if (minX > xx[i]) {
                minX = xx[i];
            }
            if (minY > yy[i]) {
                minY = yy[i];
            }
            if (maxX < xx[i]) {
                maxX = xx[i];
            }
            if (maxY >= yy[i]) continue;
            maxY = yy[i];
        }
        this.frames[this.scenarioIndex].drawTexture(g, minX, minY, maxX, maxY);
    }

    public static void createLandscape(int X1, int Y1, int X2, int Y2, int X3, int Y3, int X4, int Y4, float angle) {
        int offset = 0;
        GameLandscape obj = new GameLandscape();
        obj.nFrames = 1;
        obj.typeDinamicalObjects = 101;
        obj.isStatic = true;
        obj.restitution = 2;
        obj.friction = 50;
        obj.density = 10;
        obj.angle = (int)angle;
        obj.shape = new ArrayList();
        obj.shape.add(new Point(X1, offset + Y1));
        obj.shape.add(new Point(X2, offset + Y2));
        obj.shape.add(new Point(X3, offset + Y3));
        obj.shape.add(new Point(X4, offset + Y4));
        obj.scenarioIndex = GameParameters.indexCurrentScenario;
        obj.frames = Textures.landsscapes;
        obj.setShape(obj.shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.box2dId.setParent(obj);
    }

    public static void createGroundBox() {
        GameScreen.world.setSimulationArea(0, 2200);
        GameScreen.world.setGravity(new FXVector(0, 163840));
        MyWorld.floor = Application.screenHeight - 42;
        GameLandscape obj = new GameLandscape();
        obj.nFrames = 0;
        obj.typeDinamicalObjects = 101;
        obj.isStatic = true;
        obj.restitution = 100;
        obj.friction = 99;
        obj.density = 10;
        obj.shape = new ArrayList();
        obj.shape.add(new Point(0, MyWorld.floor));
        obj.shape.add(new Point(2200, MyWorld.floor));
        obj.shape.add(new Point(2200, Application.screenHeight));
        obj.shape.add(new Point(0, Application.screenHeight));
        obj.frames = null;
        obj.setShape(obj.shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.box2dId.setParent(obj);
    }
}

