/*
 * Decompiled with CFR 0.152.
 */
package MG.Engin.J2ME;

import MG.Engin.J2ME.PointF;

public class MGMathEngin {
    private static float[] a;

    public static void initTab() {
        a = new float[91];
        for (int i = 0; i <= 90; ++i) {
            MGMathEngin.a[i] = (float)Math.sin(Math.toRadians(i));
        }
    }

    public static float arcTan(double d) {
        double d2 = 0.0;
        if (Math.abs(d) <= 1.0) {
            d2 = d / (1.0 + 0.3 * (d * d));
        } else {
            d2 = -d / (d * d + 0.295);
            d2 = d < -1.0 ? (d2 -= 1.5707963267948966) : (d2 += 1.5707963267948966);
        }
        return (float)d2;
    }

    public static double arcTan2(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return 0.0;
        }
        if (d2 > 0.0) {
            return MGMathEngin.arcTan(d / d2);
        }
        if (d2 < 0.0) {
            if (d < 0.0) {
                return -(Math.PI - (double)MGMathEngin.arcTan(d / d2));
            }
            return Math.PI - (double)MGMathEngin.arcTan(-d / d2);
        }
        return 1.5707963267948966;
    }

    public static float m_tan(int n) {
        return MGMathEngin.m_sin(n) / MGMathEngin.m_cos(n);
    }

    public static float m_atan(float f) {
        return 1.0f / f - 0.0f * (f * f * f) + 0.0f * (f * f * f * f * f) - 0.0f * (f * f * f * f * f * f * f);
    }

    public static float m_cos(int n) {
        if (n < 90) {
            return a[90 - n];
        }
        if (n < 180) {
            return -a[n - 90];
        }
        if (n < 270) {
            return -a[270 - n];
        }
        return a[n - 270];
    }

    public static float m_sin(int n) {
        if (n < 90) {
            return a[n];
        }
        if (n < 180) {
            return a[180 - n];
        }
        if (n < 270) {
            return -a[n - 180];
        }
        return -a[360 - n];
    }

    public static float computAng(float f, float f2, float f3, float f4) {
        float f5 = f2 - f4;
        float f6 = f - f3;
        f5 = (float)Math.toDegrees(MGMathEngin.arcTan(f5 / f6));
        f5 = f < f3 ? (f5 += 270.0f) : (f5 += 90.0f);
        if (Float.isNaN(f5)) {
            f5 = f2 > f4 ? 180.0f : 0.0f;
        }
        return f5;
    }

    public static PointF pointMul(PointF pointF, float f) {
        return new PointF(pointF.a * f, pointF.b * f);
    }

    public static PointF pointAdd(PointF pointF, PointF pointF2) {
        return new PointF(pointF.a + pointF2.a, pointF.b + pointF2.b);
    }

    public static float pointMul(PointF pointF, PointF pointF2) {
        return pointF.a * pointF2.b - pointF.b * pointF2.a;
    }

    public static boolean pointEqual(PointF pointF, PointF pointF2) {
        return pointF.a == pointF2.a && pointF.b == pointF2.b;
    }

    public static boolean pointBigMatch(PointF pointF, PointF pointF2) {
        return pointF.a > pointF2.a || pointF.a == pointF2.a && pointF.b > pointF2.b;
    }
}

