/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.ingame;

import com.jarbull.mgs.game.ingame.GolfCourse;
import com.jarbull.mgs.math.MathEx;
import com.jarbull.mgs.math.Vector2D;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

public class Ball
extends Sprite {
    public static final double GROUND_FRICTION_VALUE = 0.01;
    private static final int SPRITE_WIDTH = 10;
    private static final int SPRITE_HEIGHT = 10;
    private static final int BALL_RADIUS = 5;
    public double velocity = 0.0;
    public double angle = 0.0;
    public double stepX = 0.0;
    public double stepY = 0.0;
    private int previousStepX = 0;
    private int previousStepY = 0;

    public Ball(GolfCourse golfCourse, int x, int y) throws IOException {
        super(Image.createImage((String)"/res/image/ingame/ball.png"), 10, 10);
        golfCourse.append((Layer)this);
        this.setPosition(x, y);
        this.setFrame(0);
    }

    private double getVX() {
        return this.velocity * Math.cos(Math.toRadians(this.angle));
    }

    private double getVY() {
        return this.velocity * Math.sin(Math.toRadians(this.angle));
    }

    public boolean hasPoint(int x, int y) {
        return Math.sqrt(MathEx.sqr(x - this.getX() - 5) + MathEx.sqr(y - this.getY() - 5)) <= 5.0;
    }

    public void move() {
        this.velocity = this.velocity > 0.01 ? (this.velocity -= 0.01) : 0.0;
        this.stepX += this.getVX();
        this.stepY += this.getVY();
        int roundedStepX = (int)this.stepX;
        int roundedStepY = (int)this.stepY;
        if (roundedStepX != 0 || roundedStepY != 0) {
            this.previousStepX = roundedStepX;
            this.previousStepY = roundedStepY;
            this.move(roundedStepX, roundedStepY);
            this.stepX %= 1.0;
            this.stepY %= 1.0;
        }
    }

    public void moveBack() {
        this.move(-this.previousStepX, -this.previousStepY);
    }

    public void reflect(Vector2D normalVector) {
        Vector2D velocityVector = new Vector2D(this.velocity, this.angle, true);
        double projection = Vector2D.dotProduct(velocityVector, normalVector);
        Vector2D projectionVectorX2 = new Vector2D(normalVector.x * projection * 2.0, normalVector.y * projection * 2.0);
        velocityVector = Vector2D.subtract(velocityVector, projectionVectorX2);
        this.angle = Math.toDegrees(MathEx.atan(velocityVector.y, velocityVector.x));
        if (this.angle < 0.0) {
            this.angle += 360.0;
        }
        this.velocity *= 0.9;
    }
}

