/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.tools;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class MusicPlayer {
    private static final MusicPlayer instance = new MusicPlayer();
    private Player player;
    private boolean on = false;
    private int volume = 100;

    private MusicPlayer() {
    }

    public static MusicPlayer getInstance() {
        return instance;
    }

    public void open() {
        this.on = true;
    }

    public void close() {
        this.on = false;
    }

    public void setVolume(int volume) {
        this.volume = volume < 0 ? 0 : (volume > 100 ? 100 : volume);
    }

    public void playMusic() {
        if (this.on) {
            try {
                this.player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/res/midi/minigolf.mid"), (String)"audio/midi");
                this.player.prefetch();
                VolumeControl volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
                volumeControl.setLevel(this.volume);
                this.player.setLoopCount(-1);
                this.player.start();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void stopMusic() {
        if (this.player != null && this.on) {
            this.player.deallocate();
            this.player.close();
        }
    }
}

