/*
 * Decompiled with CFR 0.152.
 */
package zrong.game;

import javax.microedition.lcdui.Graphics;
import zrong.res.Res;
import zrong.res.ResManager;
import zrong.res.SpriteInfo;

public class Sprite {
    Res spInfo;
    public boolean isShowNow = true;
    public boolean isVisable;
    public int curTime;
    public int maxTime;
    public int width;
    public int height;
    public int vX;
    public int vY;
    public int aX;
    public int aY;
    public int centiX;
    public int centiY;
    private int curFrame;
    private int curSeries;
    public int resExIndex;
    public int color;
    public int trans;
    public short showX;
    public short showY;
    private boolean off;
    public long lastChangeTime = System.currentTimeMillis();

    public Sprite(Res res, int n, int n2) {
        this.init(n, n2);
        this.spInfo = res;
    }

    public Sprite(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        this.init(n4, n5);
        this.resExIndex = n;
        this.isShowNow = bl2;
        this.spInfo = ResManager.getRes(n, bl2);
        this.off = bl;
        this.color = n3;
        this.trans = n6;
        this.curSeries = n2;
    }

    public Sprite(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.init(n3, n4);
        this.off = bl;
        this.color = n2;
        this.trans = n5;
        this.curSeries = n;
    }

    public void setSpInfo(Res res, int n) {
        this.spInfo = res;
        this.resExIndex = n;
    }

    private void init(int n, int n2) {
        this.isVisable = true;
        this.setShowXY(n, n2);
        this.centiX = 100 * this.showX;
        this.centiY = 100 * this.showY;
    }

    public void draw(Graphics graphics) {
        Res.draw(graphics, this.getSpInfo(), (int)this.showX, (int)this.showY, this.curSeries, this.color, this.curFrame, this.trans, 0);
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.getSpInfo() == null || !this.isVisable) {
            return;
        }
        this.setShowXY(n, n2);
        Res.draw(graphics, this.spInfo, (int)this.showX, (int)this.showY, this.curSeries, this.color, this.curFrame, this.trans, 0);
    }

    public int autoRunSprite() {
        long l = System.currentTimeMillis();
        int n = Res.autoRunSprite(this.getSpInfo(), this.curSeries, this.curFrame, this.lastChangeTime, l, 100L);
        if (n >= 0) {
            if (this.curFrame != n) {
                this.curFrame = (byte)n;
            }
            this.lastChangeTime = l;
            if (n == 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public int autoRunSprite(long l) {
        long l2 = System.currentTimeMillis();
        int n = Res.autoRunSprite(this.getSpInfo(), this.curSeries, this.curFrame, this.lastChangeTime, l2, l);
        if (n >= 0) {
            if (this.curFrame != n) {
                this.curFrame = (byte)n;
            }
            this.lastChangeTime = l2;
            if (n == 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public void nextCycFrame() {
        long l = System.currentTimeMillis();
        int n = Res.autoRunSprite(this.getSpInfo(), this.curSeries, this.curFrame, this.lastChangeTime, l);
        if (n >= 0) {
            this.curFrame = (byte)n;
            this.lastChangeTime = l;
        }
    }

    public boolean nextFrame() {
        long l = System.currentTimeMillis();
        int n = Res.autoRunSprite(this.getSpInfo(), this.curSeries, this.curFrame, this.lastChangeTime, l);
        if (n > 0) {
            this.curFrame = (byte)n;
            this.lastChangeTime = l;
            return false;
        }
        return n >= 0;
    }

    public int getCurFrame() {
        return this.curFrame;
    }

    public int getCurSeries() {
        return this.curSeries;
    }

    public void setCurFrame(int n) {
        this.curFrame = (byte)n;
    }

    public void setCurSeries(int n) {
        this.curSeries = (byte)n;
    }

    public int getcurSeriesbaseX() {
        return Res.getOffX(this.getSpInfo(), this.curSeries);
    }

    public int getcurSeriesbaseY() {
        return Res.getOffY(this.getSpInfo(), this.curSeries);
    }

    public int getRefreshX() {
        return this.showX - (this.off ? Res.getOffX(this.getSpInfo(), this.curSeries) : 0);
    }

    public int getRefreshY() {
        return this.showY - (this.off ? Res.getOffY(this.getSpInfo(), this.curSeries) : 0);
    }

    public int getRefreshWidth() {
        return Res.getWidth(this.getSpInfo(), this.curSeries);
    }

    public int getRefreshHeight() {
        return Res.getHeight(this.getSpInfo(), this.curSeries);
    }

    public int getFrameSize(int n) {
        SpriteInfo spriteInfo = this.getSpriteInfo();
        if (spriteInfo == null) {
            return -1;
        }
        return spriteInfo.getSeriesSize(n);
    }

    public int getSeriesSize() {
        SpriteInfo spriteInfo = this.getSpriteInfo();
        if (spriteInfo == null) {
            return -1;
        }
        if (spriteInfo.baseX_Series == null) {
            return -1;
        }
        return spriteInfo.baseX_Series.length;
    }

    public Res getSpInfo() {
        if (this.spInfo == null) {
            this.spInfo = ResManager.getRes(this.resExIndex, this.isShowNow);
        }
        return this.spInfo;
    }

    public SpriteInfo getSpriteInfo() {
        Res res = this.getSpInfo();
        if (res == null || !(res instanceof SpriteInfo)) {
            return null;
        }
        return (SpriteInfo)res;
    }

    public void setShowXY(int n, int n2) {
        this.showX = (short)n;
        this.showY = (short)n2;
    }

    public void release() {
        ResManager.clearRes(this.spInfo.id);
        this.spInfo = null;
    }
}

