/*
 * Decompiled with CFR 0.152.
 */
package HG.Game;

import HG.Animation.ColRect;
import HG.Animation.PWPifLifeAnimations;
import HG.Game.GameBonus;
import HG.Main.MainCanvas;
import HG.Public.Constant;
import HG.Scene.GameScene;
import HG.Tool.GraphicsTool;
import HG.Tool.MathTool;
import javax.microedition.lcdui.Graphics;

public abstract class GameActor {
    protected MainCanvas canvas = null;
    protected GameScene game = null;
    public int GameActor_Type = 0;
    public int GameActor_SubType = 0;
    public static final int UNKNOWN = -1;
    public static final int PLAYER = 0;
    public static final int ENEMY = 1;
    public static final int HURT_BY_COMMON_BULLET = 0;
    public static final int HURT_BY_PLAYER_HIT0 = 1;
    public static final int HURT_BY_PLAYER_HIT1 = 2;
    public static final int HURT_BY_PLAYER_HIT2 = 3;
    public static final int HURT_BY_PLAYER_HIT3 = 4;
    public static final int HURT_BY_PLAYER_HIT4 = 5;
    public static final int HURT_BY_PLAYER_HIT5 = 6;
    public static final int HURT_BY_ENEMY_HIT = 7;
    public static final int HURT_BY_BUMP_RIGHT = 8;
    public static final int HURT_BY_BUMP_TOP = 9;
    public static final int HURT_BY_SUPER_ATT = 10;
    public static final int HURT_BY_SPIDER_HIT = 11;
    public static final int HURT_BY_CANNIBALPLANT = 12;
    public static final int HURT_BY_VENOM = 13;
    public static final int SUPER_ATTACK_PLAYER_SPLITTER = 0;
    public static final int SUPER_ATTACK_PLAYER_CALL_MASTER = 1;
    public static final int SUPER_ATTACK_PLAYER_CALL_GOD = 2;
    public static final int SUPER_ATTACK_PLAYER_INVINCIBLE = 3;
    public static final int SUPER_ATTACK_PLAYER_KING_ADVENT = 4;
    public static final int PLAYER_LEVEL_UP = 5;
    public static final int PLAYER_DEAD = 6;
    public static final int CHAIN_BY_SPIDER = 7;
    public static final int CHAIN_BY_SPIDER_WEB = 8;
    public static final int CHAIN_BY_CANNIBALPLANT = 9;
    public static final int CHAIN_BY_PALSY = 10;
    public static final int CHAIN_BY_CONFUSE = 11;
    protected short mInstanceId = (short)-1;
    protected int x = 0;
    protected int y = 0;
    protected int x_last = 0;
    protected int y_last = 0;
    protected int vx = 0;
    protected int vy = 0;
    protected int ax = 0;
    protected int ay = 0;
    private int life = 0;
    private int maxlife = 0;
    protected int powerNewton = 0;
    public static int playerHitLevel = 0;
    protected GameActor relatePlayer = null;
    protected boolean inUse = false;
    protected PWPifLifeAnimations animation = null;
    protected int animID = 0;
    protected boolean animCyclic = false;
    protected byte state_current = 0;
    protected long time_stateStart = 0L;
    protected byte state_last = 0;
    protected int lastAnimId = 0;
    protected boolean lastAnimCyclic = false;
    protected static final int SHIELD_STATE_APPEAR = 0;
    protected static final int SHIELD_STATE_NORMAL = 1;
    protected static final int SHIELD_STATE_DISAPPEAR = 2;
    private int life_shield = -1;
    public boolean stopProcessing = false;
    public long time_stopProcessing = 0L;
    public static ColRect crSelf = null;
    public static ColRect crOther = null;

    public GameActor(MainCanvas mc) {
        this.canvas = mc;
        if (crSelf == null) {
            crSelf = new ColRect();
        }
        if (crOther == null) {
            crOther = new ColRect();
        }
    }

    public int getInstanceID() {
        return this.mInstanceId;
    }

    public void setInstanceID(int id) {
        this.mInstanceId = (short)id;
    }

    public byte getCurState() {
        return this.state_current;
    }

    public void setCurState(byte newState, long time) {
        this.state_current = newState;
        this.time_stateStart = time;
    }

    public void saveLastState() {
        this.state_last = this.state_current;
        this.lastAnimId = this.animID;
        this.lastAnimCyclic = this.animCyclic;
    }

    public void recoveryLastState(long time) {
        this.setCurState(this.state_last, time);
        this.setRenderContent(this.lastAnimId, this.lastAnimCyclic, time);
    }

    public int getX() {
        return MathTool.F2I(this.x);
    }

    public int getY() {
        return MathTool.F2I(this.y);
    }

    public int getLastX() {
        return MathTool.F2I(this.x_last);
    }

    public int getLastY() {
        return MathTool.F2I(this.y_last);
    }

    public void setX(int aValue) {
        this.x_last = this.x;
        this.x = MathTool.I2F(aValue);
    }

    public void setY(int aValue) {
        this.y_last = this.y;
        this.y = MathTool.I2F(aValue);
    }

    public void setRenderContent(int anId, boolean loop, long time) {
        this.animID = anId;
        this.animCyclic = loop;
        this.time_stateStart = time;
    }

    public boolean inUse() {
        return this.inUse;
    }

    public void setInUse(boolean aValue) {
        this.inUse = aValue;
    }

    public void setAnimation(PWPifLifeAnimations anim) {
        this.animation = anim;
    }

    public PWPifLifeAnimations getAnimation() {
        return this.animation;
    }

    protected boolean isAnimationOver(long gameTime) {
        return this.getAnimation().animationIsOver(this.animID, (int)(gameTime - this.time_stateStart));
    }

    public void renderGameActor(Graphics g, long gameTime) {
        GraphicsTool.restClip(g);
        this.basicRenderGameActor(g, gameTime);
    }

    public final void basicRenderGameActor(Graphics g, long gameTime) {
        this.animation.drawAnimation(g, this.animID, gameTime - this.time_stateStart, this.getX(), this.getY() - Constant.Camera_y, this.animCyclic);
    }

    public ColRect getColRect(long gameTime, int type) {
        return this.getAnimation().GetColRect(this.animID, gameTime - this.time_stateStart, this.animCyclic, type);
    }

    public boolean isCollide(long gameTime, GameActor other, int typeSelf, int typeOther) {
        return this.isCollide(gameTime, other, typeSelf, typeOther, 0, 0);
    }

    public boolean isCollide(long gameTime, GameActor other, int typeSelf, int typeOther, int offsetX, int offsetY) {
        crSelf.Copy(this.getX() + offsetX, this.getY() + offsetY, this.getColRect(gameTime, typeSelf));
        crOther.Copy(other.getX(), other.getY(), other.getColRect(gameTime, typeOther));
        return ColRect.RectIntersect(crSelf, crOther);
    }

    public ColRect getIntersectRect(long gameTime, GameActor other, int typeSelf, int typeOther) {
        this.getIntersectRect(gameTime, other, typeSelf, typeOther, 0, 0);
        return crSelf;
    }

    public ColRect getIntersectRect(long gameTime, GameActor other, int typeSelf, int typeOther, int offsetX, int offsetY) {
        crSelf.Copy(this.getX() + offsetX, this.getY() + offsetY, this.getColRect(gameTime, typeSelf));
        crOther.Copy(other.getX(), other.getY(), other.getColRect(gameTime, typeOther));
        return this.getIntersectRect(crSelf, crOther);
    }

    public ColRect getIntersectRect(ColRect cr1, ColRect cr2) {
        ColRect min_x_col_rect = cr1.x < cr2.x ? cr1 : cr2;
        ColRect max_x_col_rect = cr1.x > cr2.x ? cr1 : cr2;
        ColRect min_y_col_rect = cr1.y < cr2.y ? cr1 : cr2;
        ColRect max_y_col_rect = cr1.y > cr2.y ? cr1 : cr2;
        cr1.x = max_x_col_rect.x;
        cr1.y = max_y_col_rect.y;
        cr1.w = min_x_col_rect.x + min_x_col_rect.w < max_x_col_rect.x + max_x_col_rect.w ? min_x_col_rect.x + min_x_col_rect.w - cr1.x : max_x_col_rect.w;
        cr1.h = min_y_col_rect.y + min_y_col_rect.h < max_y_col_rect.y + max_y_col_rect.h ? min_y_col_rect.y + min_y_col_rect.h - cr1.y : max_y_col_rect.h;
        return cr1;
    }

    public void setType(int type) {
        this.GameActor_Type = type;
    }

    public int getType() {
        return this.GameActor_Type;
    }

    public void setSubType(int subType) {
        this.GameActor_SubType = subType;
    }

    public int getSubType() {
        return this.GameActor_SubType;
    }

    public int getVx() {
        return MathTool.F2I(this.vx);
    }

    public void setVx(int vx) {
        this.vx = MathTool.I2F(vx);
    }

    public void setRawVx(int vx) {
        this.vx = vx;
    }

    public int getVy() {
        return MathTool.F2I(this.vy);
    }

    public void setRawVy(int vy) {
        this.vy = vy;
    }

    public void setVy(int vy) {
        this.vy = MathTool.I2F(vy);
    }

    public int getAx() {
        return MathTool.F2I(this.ax);
    }

    public void setAx(int ax) {
        this.ax = MathTool.I2F(ax);
    }

    public int getAy() {
        return MathTool.F2I(this.ay);
    }

    public void setAy(int ay) {
        this.ay = MathTool.I2F(ay);
    }

    public void setLife(int templife) {
        this.life = templife;
    }

    public int getLife() {
        return this.life;
    }

    public void setMaxlife(int max) {
        this.maxlife = max;
    }

    public int getMaxlife() {
        return this.maxlife;
    }

    protected boolean moveToArea(int endx, int endy, int v, int areaw, int areah, boolean explictDES, long gameTime, boolean nooutscreen) {
        int temp_vy;
        int temp_vx;
        if (nooutscreen) {
            ColRect crself = this.getColRect(gameTime, 0);
            int newEndX = endx;
            int newEndY = endy;
            if (endx != this.getX()) {
                if (endx < 0 + (crself.w >> 1)) {
                    newEndX = 0 + (crself.w >> 1);
                    endy = (endy - this.getY()) * (newEndX - this.getX()) / (endx - this.getX()) + this.getY();
                    endx = newEndX;
                } else if (endx > 240 - (crself.w >> 1)) {
                    newEndX = 240 - (crself.w >> 1);
                    endy = (endy - this.getY()) * (newEndX - this.getX()) / (endx - this.getX()) + this.getY();
                    endx = newEndX;
                }
            }
            if (endy != this.getY()) {
                if (endy < 55 + crself.h) {
                    newEndY = 55 + crself.h;
                    endx = (endx - this.getX()) * (newEndY - this.getY()) / (endy - this.getY()) + this.getX();
                    endy = newEndY;
                } else if (endy > 295) {
                    newEndY = 295;
                    endx = (endx - this.getX()) * (newEndY - this.getY()) / (endy - this.getY()) + this.getX();
                    endy = newEndY;
                }
            }
        }
        int xDiff = endx - this.getX();
        int yDiff = endy - this.getY();
        int absdifx = Math.abs(xDiff);
        int absdify = Math.abs(yDiff);
        if (absdify != 0 || absdifx != 0) {
            if (absdify > absdifx) {
                temp_vx = v * absdifx / absdify;
                if (!explictDES && temp_vx == 0) {
                    temp_vx = 1;
                }
                temp_vy = v;
            } else if (absdify < absdifx) {
                temp_vx = v;
                temp_vy = v * absdify / absdifx;
                if (!explictDES && temp_vy == 0) {
                    temp_vy = 1;
                }
            } else {
                temp_vx = v;
                temp_vy = v;
            }
        } else {
            return true;
        }
        boolean retx = false;
        if (endx - (areaw >> 1) <= this.getX() && endx + (areaw >> 1) >= this.getX()) {
            retx = true;
        }
        boolean rety = false;
        if (endy - (areah >> 1) <= this.getY() && endy + (areah >> 1) >= this.getY()) {
            rety = true;
        }
        if (!retx || explictDES) {
            if (xDiff != 0) {
                if (Math.abs(xDiff) <= temp_vx) {
                    this.setX(endx);
                } else {
                    this.setX(this.getX() + (xDiff > 0 ? temp_vx : -temp_vx));
                }
            }
            if (nooutscreen && this.checkIsOutScreenX(gameTime)) {
                xDiff = 0;
            }
        }
        if (!rety || explictDES) {
            if (yDiff != 0) {
                if (Math.abs(yDiff) <= temp_vy) {
                    this.setY(endy);
                } else {
                    this.setY(this.getY() + (yDiff > 0 ? temp_vy : -temp_vy));
                }
            }
            if (nooutscreen && this.checkIsOutScreenY(gameTime)) {
                yDiff = 0;
            }
        }
        if (retx && rety) {
            return true;
        }
        return yDiff == 0 && xDiff == 0;
    }

    protected boolean checkIsOutScreenX(long gameTime) {
        ColRect crself = this.getColRect(gameTime, 0);
        if (this.getX() - (crself.w >> 1) <= 0) {
            this.setX(crself.w >> 1);
            return true;
        }
        if (this.getX() + (crself.w >> 1) >= 240) {
            this.setX(240 - (crself.w >> 1));
            return true;
        }
        return false;
    }

    protected boolean checkIsOutScreenY(long gameTime) {
        ColRect crself = this.getColRect(gameTime, 0);
        if (this.getY() - crself.h <= 55) {
            this.setY(55 + crself.h);
            return true;
        }
        if (this.getY() >= 295) {
            this.setY(295);
            return true;
        }
        return false;
    }

    public abstract void reduceLife(int var1, int var2, ColRect var3, long var4);

    public abstract void process(long var1, GameActor[] var3);

    public abstract void initGameActor(long var1, int var3);

    public abstract void beginNotify(long var1, int var3);

    public abstract void endNotify(long var1, int var3);

    public abstract void clearGameActor();

    public void clearActor() {
        this.canvas = null;
        this.game = null;
        crSelf = null;
        crOther = null;
        this.relatePlayer = null;
        this.animation = null;
        playerHitLevel = 0;
        this.time_stopProcessing = 0L;
    }

    public void setRelatePlayer(GameActor relatePlayer) {
        this.relatePlayer = relatePlayer;
    }

    public GameActor getRelatePlayer() {
        return this.relatePlayer;
    }

    public void setPowerNewton(int power) {
        this.powerNewton = power;
        if (this.powerNewton >= 100) {
            this.powerNewton = 100;
        }
        if (this.powerNewton <= 0) {
            this.powerNewton = 0;
        }
    }

    public int getPowerNewton() {
        return this.powerNewton;
    }

    public void setShieldLife(int life) {
        this.life_shield = life;
    }

    public int getShieldLife() {
        return this.life_shield;
    }

    public boolean IsHaveShield() {
        return this.life_shield > 0;
    }

    public void reduceShieldLife(int point) {
        this.life_shield -= point;
        if (this.life_shield < 0) {
            this.life_shield = 0;
        }
    }

    protected GameActor getABonus() {
        GameActor[] bonusPool = GameScene.bonusPool;
        for (int i = 0; i < bonusPool.length; ++i) {
            if (bonusPool[i] != null && bonusPool[i].inUse()) continue;
            if (bonusPool[i] == null) {
                bonusPool[i] = new GameBonus(this.canvas);
            }
            return bonusPool[i];
        }
        return null;
    }

    public void setStopProcessing(boolean stopProcessing, long time) {
        if (stopProcessing) {
            if (time - this.time_stopProcessing > 5L) {
                this.time_stopProcessing = time;
            }
            this.stopProcessing = true;
        } else {
            this.stopProcessing = false;
        }
    }

    public boolean isStopProcessing() {
        return this.stopProcessing;
    }
}

