/*
 * Decompiled with CFR 0.152.
 */
package HG.MotionWelder;

import HG.Tool.GraphicsTool;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class AnuData {
    public int[][] m_anClipImg;
    public int[][] m_anClipEllipse;
    public int[][] m_anClipLine;
    public int[][] m_anClipRect;
    public int[][] m_anClipRoundRect;
    public int[][] m_anClipCollision;
    public int[][] m_anAniPool;
    public int[][] m_anFramePool;
    public int[][][] m_anFrameClipPool;
    public String m_sAnuName;
    private String[] m_asImgFile;
    public Image[] m_aimgSource;
    public boolean m_bSplitImg = false;
    private Vector m_vUsedClipID = new Vector();
    public Image[] m_aimgClipImgBuf = new Image[300];
    public int m_nClipImgBufCnt;
    public static final int IMAGE_FLAG_NONE = 0;
    public static final int IMAGE_FLAG_HFLIP = 2;
    public static final int IMAGE_FLAG_VFLIP = 4;
    public static final int ELLIPSE_FLAG_NONE = 1;
    public static final int ELLIPSE_FLAG_FILLED = 3;
    public static final int LINE_FLAG = 5;
    public static final int RECTANGLE_FLAG_NONE = 7;
    public static final int RECTANGLE_FLAG_FILLED = 9;
    public static final int ROUNDEDRECTANGLE_FLAG_NONE = 11;
    public static final int ROUNDEDRECTANGLE_FLAG_FILLED = 13;
    public static final int POSITIONERRECTANGLE_FLAG = 15;

    public AnuData(String sAnuFile, String[] asImgList) {
        try {
            this.m_asImgFile = asImgList;
            this.m_aimgSource = new Image[asImgList.length];
            this.loadAnu(sAnuFile);
            this.m_sAnuName = sAnuFile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getImgCnt() {
        return this.m_asImgFile.length;
    }

    public String[] getImgList() {
        return this.m_asImgFile;
    }

    public int getAnimationCnt() {
        if (this.m_anAniPool == null) {
            return 0;
        }
        return this.m_anAniPool.length;
    }

    public void loadResAnimation(int nAnimationID) {
        for (int nFrame = this.m_anAniPool[nAnimationID][0]; nFrame <= this.m_anAniPool[nAnimationID][1]; ++nFrame) {
            int nFrameID = this.m_anFramePool[nFrame][0];
            for (int i = 0; i < this.m_anFrameClipPool[nFrameID].length; ++i) {
                Integer integer = new Integer(this.m_anFrameClipPool[nFrameID][i][0]);
                this.m_vUsedClipID.addElement(integer);
            }
        }
        this.loadResAll();
    }

    public void loadResFrame(int nAnimationID, int nFrameIdx) {
        int nFrameID = this.m_anAniPool[nAnimationID][0] + nFrameIdx;
        nFrameID = this.m_anFramePool[nFrameID][0];
        for (int i = 0; i < this.m_anFrameClipPool[nFrameID].length; ++i) {
            Integer integer = new Integer(this.m_anFrameClipPool[nFrameID][i][0]);
            this.m_vUsedClipID.addElement(integer);
        }
        this.loadResAll();
    }

    public void loadResAll() {
        for (int i = 0; i < this.m_asImgFile.length; ++i) {
            boolean bNeedLoadCurrImg = this.isImgUsed(i);
            try {
                Image imgSource = null;
                if (bNeedLoadCurrImg) {
                    imgSource = GraphicsTool.loadImage(this.m_asImgFile[i]);
                }
                if (!this.m_bSplitImg) {
                    this.m_aimgSource[i] = imgSource;
                    continue;
                }
                this.createClipImgBuf(imgSource, i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.m_vUsedClipID.removeAllElements();
    }

    private boolean isImgUsed(int nImgID) {
        if (this.m_vUsedClipID.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.m_vUsedClipID.size(); ++i) {
            Integer inte = (Integer)this.m_vUsedClipID.elementAt(i);
            if (this.m_anClipImg[inte][0] != nImgID) continue;
            return true;
        }
        return false;
    }

    private boolean isClipUsed(int nClipID) {
        if (this.m_vUsedClipID.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.m_vUsedClipID.size(); ++i) {
            Integer inte = (Integer)this.m_vUsedClipID.elementAt(i);
            if (inte != nClipID) continue;
            return true;
        }
        return false;
    }

    private void createClipImgBuf(Image img, int nImgID) {
        for (int i = 0; i < this.m_anClipImg.length; ++i) {
            if (this.m_anClipImg[i][0] != nImgID) continue;
            int x = this.m_anClipImg[i][1];
            int y = this.m_anClipImg[i][2];
            int w = this.m_anClipImg[i][3];
            int h = this.m_anClipImg[i][4];
            if (img != null && this.isClipUsed(i)) {
                this.m_aimgClipImgBuf[this.m_nClipImgBufCnt] = Image.createImage((Image)img, (int)x, (int)y, (int)w, (int)h, (int)0);
            }
            this.m_anClipImg[i][5] = this.m_nClipImgBufCnt++;
        }
    }

    private void loadAnu(String sAnuFile) throws Exception {
        int i;
        DataInputStream dis = new DataInputStream(new String().getClass().getResourceAsStream(sAnuFile));
        short nUnknown = dis.readShort();
        String sUnknown = dis.readUTF();
        int nAniCnt = dis.readByte();
        this.m_anAniPool = new int[nAniCnt][];
        for (int i2 = 0; i2 < nAniCnt; ++i2) {
            this.m_anAniPool[i2] = new int[2];
            this.m_anAniPool[i2][0] = dis.readShort();
            this.m_anAniPool[i2][1] = dis.readShort();
        }
        int nFrameCnt = dis.readShort();
        this.m_anFramePool = new int[nFrameCnt][];
        for (int i3 = 0; i3 < nFrameCnt; ++i3) {
            this.m_anFramePool[i3] = new int[4];
            this.m_anFramePool[i3][0] = dis.readShort();
            this.m_anFramePool[i3][1] = dis.readByte();
            this.m_anFramePool[i3][2] = dis.readShort();
            this.m_anFramePool[i3][3] = dis.readShort();
        }
        short nArrayCnt = dis.readShort();
        nFrameCnt = dis.readShort();
        this.m_anFrameClipPool = new int[nFrameCnt][][];
        for (int i4 = 0; i4 < nFrameCnt; ++i4) {
            int nClipCnt = dis.readShort();
            this.m_anFrameClipPool[i4] = new int[nClipCnt][];
            for (int j = 0; j < nClipCnt; ++j) {
                this.m_anFrameClipPool[i4][j] = new int[4];
                this.m_anFrameClipPool[i4][j][0] = dis.readShort();
                this.m_anFrameClipPool[i4][j][1] = dis.readShort();
                this.m_anFrameClipPool[i4][j][2] = dis.readShort();
                this.m_anFrameClipPool[i4][j][3] = dis.readByte();
            }
        }
        short nTotalClipCnt = dis.readShort();
        int nImgCnt = dis.readByte();
        Vector<int[]> lsImgClip = new Vector<int[]>();
        for (i = 0; i < nImgCnt; ++i) {
            int nClipInCurrImg = dis.readShort();
            for (int j = 0; j < nClipInCurrImg; ++j) {
                int[] anClipImg = new int[6];
                anClipImg[0] = i;
                anClipImg[1] = dis.readShort();
                anClipImg[2] = dis.readShort();
                anClipImg[3] = dis.readShort();
                anClipImg[4] = dis.readShort();
                lsImgClip.addElement(anClipImg);
            }
        }
        this.m_anClipImg = new int[lsImgClip.size()][];
        for (i = 0; i < this.m_anClipImg.length; ++i) {
            this.m_anClipImg[i] = (int[])lsImgClip.elementAt(i);
        }
        int nEllipseCnt = dis.readShort();
        this.m_anClipEllipse = new int[nEllipseCnt][];
        for (int i5 = 0; i5 < nEllipseCnt; ++i5) {
            this.m_anClipEllipse[i5] = new int[5];
            this.m_anClipEllipse[i5][0] = dis.readShort();
            this.m_anClipEllipse[i5][1] = dis.readShort();
            this.m_anClipEllipse[i5][2] = dis.readShort();
            this.m_anClipEllipse[i5][3] = dis.readShort();
            this.m_anClipEllipse[i5][4] = dis.readInt();
        }
        int nLineCnt = dis.readShort();
        this.m_anClipLine = new int[nLineCnt][];
        for (int i6 = 0; i6 < nLineCnt; ++i6) {
            this.m_anClipLine[i6] = new int[3];
            this.m_anClipLine[i6][0] = dis.readShort();
            this.m_anClipLine[i6][1] = dis.readShort();
            this.m_anClipLine[i6][2] = dis.readInt();
        }
        int nRectCnt = dis.readShort();
        this.m_anClipRect = new int[nRectCnt][];
        for (int i7 = 0; i7 < nRectCnt; ++i7) {
            this.m_anClipRect[i7] = new int[3];
            this.m_anClipRect[i7][0] = dis.readShort();
            this.m_anClipRect[i7][1] = dis.readShort();
            this.m_anClipRect[i7][2] = dis.readInt();
        }
        int nRoundRectCnt = dis.readShort();
        this.m_anClipRoundRect = new int[nRoundRectCnt][];
        for (int i8 = 0; i8 < nRoundRectCnt; ++i8) {
            this.m_anClipRoundRect[i8] = new int[5];
            this.m_anClipRoundRect[i8][0] = dis.readShort();
            this.m_anClipRoundRect[i8][1] = dis.readShort();
            this.m_anClipRoundRect[i8][2] = dis.readShort();
            this.m_anClipRoundRect[i8][3] = dis.readShort();
            this.m_anClipRoundRect[i8][4] = dis.readInt();
        }
        int nCollisionCnt = dis.readShort();
        this.m_anClipCollision = new int[nCollisionCnt][];
        for (int i9 = 0; i9 < nCollisionCnt; ++i9) {
            this.m_anClipCollision[i9] = new int[2];
            this.m_anClipCollision[i9][0] = dis.readShort();
            this.m_anClipCollision[i9][1] = dis.readShort();
        }
    }
}

