/*
 * Decompiled with CFR 0.152.
 */
package HG.Tool;

import HG.Main.MainCanvas;
import HG.Public.Function;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsTool {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int LEFT_TOP = 20;
    public static final int LEFT_VCENTER = 6;
    public static final int LEFT_BOTTOM = 36;
    public static final int RIGHT_TOP = 24;
    public static final int RIGHT_VCENTER = 10;
    public static final int RIGHT_BOTTOM = 40;
    public static final int CENTER = 3;
    public static final int CENTER_BASELINE = 65;
    public static final int CENTER_TOP = 17;
    public static final int CENTER_BOTTOM = 33;
    public static int[] rgb = null;
    public static Image m_imgAlphaBk = null;

    public static Image loadImage(String path) throws IOException {
        return Image.createImage((String)path);
    }

    public static void setClip(Graphics g, int x, int y, int w, int h) {
        int nClipX = g.getClipX();
        int nClipY = g.getClipY();
        int nClipW = g.getClipWidth();
        int nClipH = g.getClipHeight();
        int clip_x = Math.max(x, nClipX);
        int clip_y = Math.max(y, nClipY);
        int clip_w = Math.min(x + w, nClipX + nClipW) - clip_x;
        int clip_h = Math.min(y + h, nClipY + nClipH) - clip_y;
        if (clip_w <= 0 || clip_h <= 0) {
            g.setClip(nClipX, nClipY, nClipW, nClipH);
            return;
        }
        g.setClip(clip_x, clip_y, clip_w, clip_h);
    }

    public static void drawLine(Graphics g, int Color, int x1, int y1, int x2, int y2) {
        GraphicsTool.restClip(g);
        g.setColor(Color);
        g.drawLine(x1, y1, x2, y2);
    }

    public static void fillRect(Graphics g, int FillColor, int StartX, int StartY, int FillWidth, int FillHeight) {
        g.setColor(FillColor);
        g.setClip(StartX, StartY, FillWidth, FillHeight);
        g.fillRect(StartX, StartY, FillWidth, FillHeight);
    }

    public static void drawRect(Graphics g, int Color, int StartX, int StartY, int RectWidth, int RectHeight) {
        g.setColor(Color);
        g.setClip(StartX, StartY, RectWidth + 5, RectHeight + 5);
        g.drawRect(StartX, StartY, RectWidth - 1, RectHeight - 1);
    }

    public static void fillRectRound(Graphics g, int FillColor, int StartX, int StartY, int FillWidth, int FillHeight, int arcWidth, int arcHeight) {
        g.setColor(FillColor);
        g.setClip(StartX, StartY, FillWidth + 5, FillHeight + 5);
        g.fillRoundRect(StartX, StartY, FillWidth, FillHeight, arcWidth, arcHeight);
    }

    public static void drawRectRound(Graphics g, int Color, int StartX, int StartY, int RectWidth, int RectHeight, int arcWidth, int arcHeight) {
        g.setColor(Color);
        g.setClip(StartX, StartY, RectWidth + 5, RectHeight + 5);
        g.drawRoundRect(StartX, StartY, RectWidth, RectHeight, arcWidth, arcHeight);
    }

    public static void fillArc(Graphics g, int Color, int StartX, int StartY, int FillWidth, int FillHeight, int arcWidth, int arcHeight) {
        g.setColor(Color);
        g.setClip(StartX, StartY, FillWidth, FillHeight);
        g.fillArc(StartX, StartY, FillWidth, FillHeight, arcWidth, arcHeight);
    }

    public static void drawArc(Graphics g, int Color, int StartX, int StartY, int RectWidth, int RectHeight, int arcWidth, int arcHeight) {
        g.setColor(Color);
        g.setClip(StartX - 5, StartY - 5, RectWidth + 10, RectHeight + 10);
        g.drawArc(StartX, StartY, RectWidth, RectHeight, arcWidth, arcHeight);
    }

    public static void restScreen(Graphics g, int color) {
        GraphicsTool.fillRect(g, color, 0, 0, 240, 320);
    }

    public static void restClip(Graphics g) {
        g.setClip(0, 0, 240, 320);
    }

    public static boolean drawTile(Graphics g, int setx, int sety, int width, int height, Image img, int x, int y, int anchor) {
        int nClipX = g.getClipX();
        int nClipY = g.getClipY();
        int nClipW = g.getClipWidth();
        int nClipH = g.getClipHeight();
        if ((anchor & 2) != 0) {
            y -= height / 2;
        }
        if ((anchor & 0x20) != 0) {
            y -= height;
        }
        if ((anchor & 1) != 0) {
            x -= width / 2;
        }
        if ((anchor & 8) != 0) {
            x -= width;
        }
        int clip_x = Math.max(x, nClipX);
        int clip_y = Math.max(y, nClipY);
        int clip_w = Math.min(x + width, nClipX + nClipW) - clip_x;
        int clip_h = Math.min(y + height, nClipY + nClipH) - clip_y;
        if (clip_w <= 0 || clip_h <= 0) {
            g.setClip(nClipX, nClipY, nClipW, nClipH);
            return false;
        }
        g.setClip(clip_x, clip_y, clip_w, clip_h);
        g.drawImage(img, x - setx, y - sety, 20);
        g.setClip(nClipX, nClipY, nClipW, nClipH);
        return true;
    }

    public static void drawTriangle(Graphics g, int colour, int x1, int y1, int x2, int y2, int x3, int y3) {
        GraphicsTool.restClip(g);
        g.setColor(colour);
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, y2, x3, y3);
        g.drawLine(x1, y1, x3, y3);
    }

    public static void fillTriangle(Graphics g, int colour, int x1, int y1, int x2, int y2, int x3, int y3) {
        GraphicsTool.restClip(g);
        g.setColor(colour);
        g.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    public static void drawPolygon(Graphics g, int colour, int[] x, int[] y) {
        if (x == null || null == y || x.length != y.length) {
            MainCanvas.debug("draw polygon error");
            return;
        }
        GraphicsTool.restClip(g);
        g.setColor(colour);
        for (int i = 0; i < x.length - 2; ++i) {
            g.drawLine(x[i], y[i], x[i + 1], y[i + 1]);
        }
        g.drawLine(x[0], y[0], x[x.length - 1], y[y.length - 1]);
    }

    public static Image createOpaqueImage(Image img_src, int width, int height, int opaque) {
        rgb = new int[width * height];
        img_src.getRGB(rgb, 0, width, 0, 0, width, height);
        if (opaque >= 255) {
            opaque = 255;
        } else if (opaque <= 0) {
            opaque = 0;
        }
        int colour = (opaque & 0xFF) << 24 | 0xFFFFFFFF;
        for (int i = 0; i < width * height; ++i) {
            if (rgb[i] != -1) continue;
            int n = i;
            rgb[n] = rgb[n] & colour;
        }
        img_src = Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)true);
        return img_src;
    }

    public static void initOpaqueData(int color, int width, int height) {
        rgb = new int[width * height];
        int i = 0;
        while (i < width * height) {
            GraphicsTool.rgb[i] = -872415232;
            int n = i++;
            rgb[n] = rgb[n] | color;
        }
    }

    public static void drawOpaqueImage(Graphics g, Image img_opaque, int x, int y, int anchor) {
        GraphicsTool.restClip(g);
        g.drawImage(img_opaque, x, y, anchor);
    }

    public static void clearOpaque() {
        rgb = null;
    }

    public static int[] createOpaqueData(int color, int opaque, int width, int height) {
        int[] data = new int[width * height];
        if (opaque >= 255) {
            opaque = 255;
        } else if (opaque <= 0) {
            opaque = 0;
        }
        color &= 0xFFFFFF;
        int opaque_rgb = (opaque & 0xFF) << 24 | 0;
        int i = 0;
        while (i < width * height) {
            data[i] = opaque_rgb;
            int n = i++;
            data[n] = data[n] | color;
        }
        return data;
    }

    public static void changeOpaqueData(int[] data, int opaque, int width, int height) {
        if (opaque >= 255) {
            opaque = 255;
        } else if (opaque <= 0) {
            opaque = 0;
        }
        int opaque_rgb = (opaque & 0xFF) << 24 | 0;
        int i = 0;
        while (i < width * height) {
            int n = i;
            data[n] = data[n] & 0xFFFFFF;
            int n2 = i++;
            data[n2] = data[n2] | opaque_rgb;
        }
    }

    public static void drawOpaqueData(Graphics g, int[] data, int x, int y, int width, int height) {
        GraphicsTool.restClip(g);
        g.drawRGB(data, 0, width, x, y, width, height, true);
    }

    public static void drawAlphaImageBK(Graphics g, Image img) {
        int nW = img.getWidth();
        int nH = img.getHeight();
        int nCntX = 240 / nW + 1;
        int nCntY = 320 / nH + 1;
        for (int i = 0; i < nCntX; ++i) {
            for (int j = 0; j < nCntY; ++j) {
                g.drawImage(img, i * nW, j * nH, 20);
            }
        }
    }

    public static void drawAlphaImageBK(Graphics g, int x, int y, int w, int h) {
        g.setClip(x, y, w, h);
        if (m_imgAlphaBk == null) {
            try {
                m_imgAlphaBk = GraphicsTool.loadImage("/alpha_block.png");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            GraphicsTool.drawAlphaImageBK(g, m_imgAlphaBk);
        }
        GraphicsTool.restClip(g);
    }

    public static int[] createTranslucentData(int width, int height) {
        int[] data_imgbk = new int[width * height];
        for (int i = 0; i < data_imgbk.length; ++i) {
            data_imgbk[i] = 0xFFFFFF;
        }
        return data_imgbk;
    }

    public static Image drawTranslucentImage(int[] data_imgbk, int data_width, int data_height, Image img_buff, int buff_x, int buff_y, int clip_x, int clip_y, int clip_w, int clip_h, int transform) {
        if (img_buff.getWidth() > data_width || img_buff.getHeight() > data_height) {
            System.out.println("\u56fe\u7247\u5c3a\u5bf8\u5927\u4e8e\u7f13\u51b2\u56fe\u5c3a\u5bf8\uff0c\u76ee\u524d\u65e0\u6cd5\u5904\u7406");
            new IllegalArgumentException().printStackTrace();
        }
        if (clip_x > img_buff.getWidth() || clip_y > img_buff.getHeight() || clip_w < 0 || clip_h < 0) {
            System.out.println("\u88c1\u5207\u533a\u57df\u5f02\u5e38");
            new IllegalArgumentException().printStackTrace();
        }
        if (clip_x < 0) {
            clip_x = 0;
        }
        if (clip_x + clip_w > img_buff.getWidth()) {
            clip_w = img_buff.getWidth() - clip_x;
        }
        if (clip_y < 0) {
            clip_y = 0;
        }
        if (clip_y + clip_h > img_buff.getWidth()) {
            clip_h = img_buff.getHeight() - clip_y;
        }
        int[] dat_img = new int[clip_w * clip_h];
        img_buff.getRGB(dat_img, 0, clip_w, clip_x, clip_y, clip_w, clip_h);
        if (transform != 0) {
            dat_img = Function.array2to1(GraphicsTool.transMatrix(Function.array1to2(dat_img, clip_h, clip_w), transform));
            switch (transform) {
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    int temp = clip_h;
                    clip_h = clip_w;
                    clip_w = temp;
                }
            }
        }
        for (int i = 0; i < dat_img.length; ++i) {
            if (buff_x + i % clip_w > data_width || buff_x + i % clip_w < 0 || buff_y + i / clip_w < 0 || buff_y + i / clip_w >= data_height) continue;
            data_imgbk[buff_x + buff_y * data_width + i % clip_w + i / clip_w * data_width] = dat_img[i];
        }
        return Image.createRGBImage((int[])data_imgbk, (int)data_width, (int)data_height, (boolean)true);
    }

    public static int[][] transMatrix(int[][] data, int transform) {
        if (data == null || data.length < 1) {
            return null;
        }
        int[][] temp_data = null;
        switch (transform) {
            case 5: {
                temp_data = new int[data[0].length][data.length];
                int transline = 0;
                int col = 0;
                while (col < data[0].length) {
                    int transcol = 0;
                    int line = data.length - 1;
                    while (line >= 0) {
                        temp_data[transline][transcol] = data[line][col];
                        --line;
                        ++transcol;
                    }
                    ++col;
                    ++transline;
                }
                break;
            }
            case 3: {
                temp_data = new int[data.length][data[0].length];
                int transline = 0;
                int line = data.length - 1;
                while (line >= 0) {
                    int transcol = 0;
                    int col = data[0].length - 1;
                    while (col >= 0) {
                        temp_data[transline][transcol] = data[line][col];
                        --col;
                        ++transcol;
                    }
                    --line;
                    ++transline;
                }
                break;
            }
            case 6: {
                temp_data = new int[data[0].length][data.length];
                int transline = 0;
                int col = data[0].length - 1;
                while (col >= 0) {
                    int transcol = 0;
                    int line = 0;
                    while (line < data.length) {
                        temp_data[transline][transcol] = data[line][col];
                        ++line;
                        ++transcol;
                    }
                    --col;
                    ++transline;
                }
                break;
            }
            case 2: {
                temp_data = new int[data.length][data[0].length];
                int transline = 0;
                int line = 0;
                while (line < data.length) {
                    int transcol = 0;
                    int col = data[0].length - 1;
                    while (col >= 0) {
                        temp_data[transline][transcol] = data[line][col];
                        --col;
                        ++transcol;
                    }
                    ++line;
                    ++transline;
                }
                break;
            }
            case 7: {
                temp_data = new int[data[0].length][data.length];
                int transline = 0;
                int col = data[0].length - 1;
                while (col >= 0) {
                    int transcol = 0;
                    int line = data.length - 1;
                    while (line >= 0) {
                        temp_data[transline][transcol] = data[line][col];
                        --line;
                        ++transcol;
                    }
                    --col;
                    ++transline;
                }
                break;
            }
            case 1: {
                temp_data = new int[data.length][data[0].length];
                int transline = 0;
                int line = data.length - 1;
                while (line >= 0) {
                    int transcol = 0;
                    int col = 0;
                    while (col < data[0].length) {
                        temp_data[transline][transcol] = data[line][col];
                        ++col;
                        ++transcol;
                    }
                    --line;
                    ++transline;
                }
                break;
            }
            case 4: {
                temp_data = new int[data[0].length][data.length];
                int transline = 0;
                int col = 0;
                while (col < data[0].length) {
                    int transcol = 0;
                    int line = 0;
                    while (line < data.length) {
                        temp_data[transline][transcol] = data[line][col];
                        ++line;
                        ++transcol;
                    }
                    ++col;
                    ++transline;
                }
                break;
            }
        }
        return temp_data;
    }

    public static void drawRegion(Graphics g, Image img_pic, int pic_x, int pic_y, int pic_width, int pic_height, int translate, int x, int y, int anchor) {
        int tmp_nSize = pic_width > pic_height ? pic_width : pic_height;
        g.setClip(x, y, tmp_nSize, tmp_nSize);
        g.drawRegion(img_pic, pic_x, pic_y, pic_width, pic_height, translate, x, y, anchor);
    }
}

