/*
 * Decompiled with CFR 0.152.
 */
package HG.Tool;

public class KeySystem {
    public static final byte FACING_UP = 0;
    public static final byte FACING_DOWN = 1;
    public static final byte FACING_LEFT = 2;
    public static final byte FACING_RIGHT = 3;
    public static final int DK_PAD_UP = 1;
    public static final int DK_PAD_DOWN = 2;
    public static final int DK_PAD_LEFT = 4;
    public static final int DK_PAD_RIGHT = 8;
    public static final int DK_NUM0 = 16;
    public static final int DK_NUM1 = 32;
    public static final int DK_NUM2 = 64;
    public static final int DK_NUM3 = 128;
    public static final int DK_NUM4 = 256;
    public static final int DK_NUM5 = 512;
    public static final int DK_NUM6 = 1024;
    public static final int DK_NUM7 = 2048;
    public static final int DK_NUM8 = 4096;
    public static final int DK_NUM9 = 8192;
    public static final int DK_STAR = 16384;
    public static final int DK_POUND = 32768;
    public static final int DK_SOFT_LEFT = 65536;
    public static final int DK_SOFT_RIGHT = 131072;
    public static final int DK_PAD_MIDDLE = 262144;
    public static final int DK_PAD_CLR = 524288;
    public static int m_keyPressed = 0;
    public static int m_keyPressedRT = 0;
    public static int m_keyPressedInStore = 0;
    public static int m_keyCurrent = 0;
    public static int m_keyHold = 0;
    public static int m_keyHoldFrame = 0;
    public static int m_keyReleased = 0;
    public static int m_keyReleasedRT = 0;
    public static int m_keyPrev = 0;
    public static int m_keyPrevFrame = 0;
    public static int m_KeyCombination = 0;
    private static final int KEY_DOUBLE_PRESSED_FRAME = 5;

    public static boolean CombinationKeyPressed(int[] combination) {
        if (KeySystem.IsKeyPressed(combination[m_KeyCombination])) {
            if (++m_KeyCombination == combination.length) {
                m_KeyCombination = 0;
                KeySystem.ClearKey();
                return true;
            }
        } else if (KeySystem.IsAnyKeyPressed()) {
            m_KeyCombination = 0;
        }
        return false;
    }

    public static void UpdateKey() {
        if (m_keyPressed != 0) {
            m_keyPrev = m_keyPressed;
            m_keyPrevFrame = 0;
        }
        ++m_keyPrevFrame;
        if (m_keyHold != m_keyCurrent) {
            m_keyHoldFrame = -1;
        }
        if (m_keyHold != 0) {
            ++m_keyHoldFrame;
        }
        m_keyHold = m_keyCurrent;
        m_keyPressed = m_keyPressedRT;
        m_keyReleased = m_keyReleasedRT;
        m_keyPressedRT = 0;
        m_keyReleasedRT = 0;
    }

    public static void keyPressed(int keyCode) {
        m_keyHold |= (m_keyPressedRT |= KeySystem.GetKeyAction(keyCode));
        m_keyCurrent |= m_keyPressedRT;
    }

    public static void keyReleased(int keyCode) {
        m_keyCurrent &= ~(m_keyReleasedRT |= KeySystem.GetKeyAction(keyCode));
    }

    public static void StoreAnyKeyPressed() {
        if (m_keyPressed != 0) {
            m_keyPressedInStore = m_keyPressed;
        }
    }

    public static boolean IsKeyPressedInStore(int gameKey) {
        return (m_keyPressedInStore & gameKey) != 0;
    }

    public static void ClearKeyPressedInStore() {
        m_keyPressedInStore = 0;
    }

    public static boolean IsKeyHold(int gameKey) {
        return (m_keyHold & gameKey) != 0;
    }

    public static boolean IsKeyPressed(int gameKey) {
        return (m_keyPressed & gameKey) != 0;
    }

    public static boolean IsKeyReleased(int gameKey) {
        return (m_keyReleased & gameKey) != 0;
    }

    public static boolean IsKeyDoublePressed(int gameKey) {
        return (m_keyPressed & gameKey) != 0 && m_keyPressed == m_keyPrev && m_keyPrevFrame < 5;
    }

    public static boolean IsAnyKeyHold() {
        return (m_keyHold & 0x1FFFF) != 0;
    }

    public static boolean IsAnyKeyPressed() {
        return m_keyPressed != 0;
    }

    public static void ClearKey() {
        m_keyCurrent = 0;
        m_keyHold = 0;
        m_keyPressed = 0;
        m_keyReleased = 0;
        m_keyPressedRT = 0;
        m_keyReleasedRT = 0;
        m_keyPressedInStore = 0;
    }

    private static int GetKeyAction(int keyCode) {
        switch (keyCode) {
            case 48: {
                return 16;
            }
            case 49: {
                return 32;
            }
            case 50: {
                return 1;
            }
            case 51: {
                return 128;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 262144;
            }
            case 54: {
                return 8;
            }
            case 55: {
                return 2048;
            }
            case 56: {
                return 2;
            }
            case 57: {
                return 8192;
            }
            case 42: {
                return 16384;
            }
            case 35: {
                return 32768;
            }
            case -8: {
                return 524288;
            }
            case -1: {
                return 1;
            }
            case -2: {
                return 2;
            }
            case -3: {
                return 4;
            }
            case -4: {
                return 8;
            }
            case -5: {
                return 262144;
            }
            case -6: {
                return 65536;
            }
            case -7: {
                return 131072;
            }
        }
        return 0;
    }

    public static byte GetDirection(int key) {
        switch (key) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        return -1;
    }

    public static byte GetDirectionFromDistance(int key) {
        switch (key) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        return -1;
    }

    public static int GetKeyFromDirection(byte facing) {
        switch (facing) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        return -1;
    }
}

