/*
 * Decompiled with CFR 0.152.
 */
package HG.Game;

import HG.Game.Enemy;
import HG.Game.GameActor;
import HG.Main.MainCanvas;
import HG.Scene.GameScene;

public class GameCommands {
    public static final int CMD_TIME = 0;
    public static final int CMD_CMDTYPE = 1;
    public static final int CMD_ENEMY_ID = 2;
    public static final int CMD_ENEMY_TYPE = 3;
    public static final int CMD_ENEMY_LEVEL = 4;
    public static final int CMD_SPEED = 5;
    public static final int CMD_SRC_X = 6;
    public static final int CMD_SRC_Y = 7;
    public static final int CMD_DES_X = 8;
    public static final int CMD_DES_Y = 9;
    public static final int CMD_MUST_DIE_ID_0 = 10;
    public static final int CMD_MUST_DIE_ID_1 = 11;
    public static final int CMD_MUST_DIE_ID_2 = 12;
    public static final int CMD_MUST_DIE_ID_3 = 13;
    public static final int CMD_MUST_DIE_ID_4 = 14;
    public static final int CMD_DROP_ID = 15;
    public static final int CMD_STATUS = 16;
    public static final int CMD_PARAMETER_COUNT = 17;
    public static final int CMD_TYPE_ADD_ENEMY = 0;
    public static final int CMD_TYPE_WAIT_KILLED_ALL_ENEMY = 1;
    public static final int CMD_TYPE_CHANGE_BG_SCROLL_SPEED = 2;
    public static final int CMD_TYPE_SET_ENEMY_RETREAT = 3;
    public static final int CMD_TYPE_CHANGE_BG = 4;
    public static final int CMD_TYPE_LEVEL_FINISHED = 5;
    public static final int CMD_TYPE_DIALOG = 6;
    private static final int CMD_NOT_PROCESS = 0;
    private static final int CMD_PROCESSED = 1;
    private static final int CMD_HOLD = 2;
    private static final int CMD_SHOULD_BE_STOP_PROCESSING = 3;
    private MainCanvas canvas = null;
    private GameScene game = null;
    public static GameActor commandInfo = null;
    public short[][] commands = null;
    public int index_curCMD = 0;
    private long time_total = 0L;
    private long time_start = -1L;
    private boolean is_initDialog = true;

    public GameCommands(MainCanvas mc) {
        this.canvas = mc;
        this.game = this.canvas.sceneMgr.scene_game;
    }

    public void loadCommands(String name) {
        this.time_total = 0L;
        this.index_curCMD = 0;
        this.commands = MainCanvas.stream.loadCommands(name);
    }

    public void clearCommand() {
        if (this.commands != null) {
            for (int i = 0; i < this.commands.length; ++i) {
                this.commands[i] = null;
            }
            this.commands = null;
        }
    }

    private GameActor getAnActor(GameActor[] actorPool) {
        for (int i = 0; i < actorPool.length; ++i) {
            if (actorPool[i] != null && actorPool[i].inUse()) continue;
            if (actorPool[i] == null) {
                actorPool[i] = new Enemy(this.canvas);
            }
            return actorPool[i];
        }
        return null;
    }

    public void process(long curFrameTime, GameActor[] actorPool) {
        if (this.time_start == -1L) {
            this.time_start = curFrameTime;
        }
        this.time_total = curFrameTime - this.time_start;
        if (this.commands != null) {
            for (int i = this.index_curCMD; i < this.commands.length; ++i) {
                long curTime = this.time_total / 1000L;
                if (this.commands[i][16] == 1) {
                    if (this.index_curCMD != i) continue;
                    ++this.index_curCMD;
                    continue;
                }
                if (GameScene.getPlayer().getCurState() == 9 || GameScene.getPlayer().getCurState() == 2 || GameScene.getPlayer().getCurState() == 4 || GameScene.getPlayer().getCurState() == 3 || GameScene.getPlayer().getCurState() == 5 || GameScene.getPlayer().getCurState() == 6) {
                    this.resetCommandTime();
                    break;
                }
                if ((long)this.commands[i][0] > curTime && this.commands[i][1] != 1) continue;
                int cmdStatus = 0;
                switch (this.commands[i][1]) {
                    case 0: {
                        cmdStatus = this.processAddEnemyCommand(curFrameTime, actorPool, i);
                        break;
                    }
                    case 1: {
                        cmdStatus = this.processWaitKilledAllEnemyCommand(curFrameTime, actorPool, i);
                        break;
                    }
                    case 2: {
                        cmdStatus = this.processChangeBGScrollSpeedCommand(curFrameTime, actorPool, i);
                        break;
                    }
                    case 3: {
                        cmdStatus = this.processSetEnemyRetreatCommand(curFrameTime, actorPool, i);
                        break;
                    }
                    case 4: {
                        if (this.checkMustDieIDs(actorPool, i) == 2) {
                            cmdStatus = 2;
                            break;
                        }
                        this.game.loadGameMap(this.commands[i][6], this.commands[i][7], this.commands[i][8]);
                        this.commands[i][16] = 1;
                        cmdStatus = 1;
                        break;
                    }
                    case 5: {
                        if (this.checkMustDieIDs(actorPool, i) == 2) {
                            cmdStatus = 2;
                            break;
                        }
                        this.game.setShakeScreen(false);
                        this.game.setLevelFinished(true);
                        this.game.initEvaluation();
                        this.commands[i][16] = 1;
                        cmdStatus = 1;
                        break;
                    }
                    case 6: {
                        if (GameScene.getPlayer().getCurState() == 0) {
                            cmdStatus = 3;
                            if (this.is_initDialog) {
                                this.game.openDialog(this.commands[i][2]);
                                this.is_initDialog = false;
                                break;
                            }
                            if (this.game.isDialog()) break;
                            this.is_initDialog = true;
                            this.commands[i][16] = 1;
                            cmdStatus = 1;
                            break;
                        }
                        cmdStatus = 2;
                        break;
                    }
                    default: {
                        System.out.println("unknown command!!!!!!!!!!!!!!!!!!");
                    }
                }
                if (cmdStatus == 3) break;
            }
        }
    }

    private int processAddEnemyCommand(long gameTime, GameActor[] actorPool, int cmdIndex) {
        if (this.checkMustDieIDs(actorPool, cmdIndex) == 2) {
            return 2;
        }
        Enemy enemy = (Enemy)this.getAnActor(actorPool);
        if (enemy == null) {
            return 0;
        }
        enemy.setSubType(this.commands[cmdIndex][3]);
        enemy.initGameActor(gameTime, 1);
        enemy.setInstanceID(this.commands[cmdIndex][2]);
        enemy.setStartEndPos(this.commands[cmdIndex][6], this.commands[cmdIndex][7], this.commands[cmdIndex][8], this.commands[cmdIndex][9], this.commands[cmdIndex][5]);
        enemy.findAttribute(this.commands[cmdIndex][3], this.commands[cmdIndex][4]);
        enemy.setDropID(this.commands[cmdIndex][15]);
        switch (this.commands[cmdIndex][3]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(1));
                enemy.setRenderContent(0, true, gameTime);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(5));
                enemy.setRenderContent(0, true, gameTime);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(10));
                enemy.setRenderContent(0, true, gameTime);
                break;
            }
            case 14: 
            case 15: 
            case 26: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(14));
                enemy.setRenderContent(0, true, gameTime);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(16));
                enemy.setRenderContent(0, true, gameTime);
                break;
            }
            case 20: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(20));
                enemy.setRenderContent(0, true, gameTime);
                break;
            }
            case 21: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(21));
                enemy.setRenderContent(0, true, gameTime);
                break;
            }
            case 22: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(21));
                enemy.setRenderContent(1, true, gameTime);
                break;
            }
            case 23: 
            case 27: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(23));
                enemy.setRenderContent(0, true, gameTime);
                break;
            }
            case 24: 
            case 28: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(23));
                enemy.setRenderContent(1, true, gameTime);
                break;
            }
            case 25: {
                GameScene.is_boss = true;
                enemy.setAnimation(Enemy.getEnemyAnimRes(25));
                enemy.setRenderContent(1, true, gameTime);
                break;
            }
            case 43: {
                GameScene.is_boss = true;
                enemy.setAnimation(Enemy.getEnemyAnimRes(43));
                enemy.setRenderContent(2, true, gameTime);
                break;
            }
            case 44: {
                GameScene.is_boss = true;
                enemy.setAnimation(Enemy.getEnemyAnimRes(44));
                enemy.setRenderContent(2, true, gameTime);
                break;
            }
            case 42: {
                GameScene.is_boss = true;
                enemy.setAnimation(Enemy.getEnemyAnimRes(42));
                enemy.setRenderContent(1, true, gameTime);
                break;
            }
            case 45: {
                GameScene.is_boss = true;
                enemy.setAnimation(Enemy.getEnemyAnimRes(45));
                enemy.setRenderContent(2, true, gameTime);
                break;
            }
            case 29: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(29));
                enemy.setRenderContent(0, true, gameTime);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(30));
                enemy.setRenderContent(2, true, gameTime);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(34));
                enemy.setRenderContent(2, true, gameTime);
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                enemy.setAnimation(Enemy.getEnemyAnimRes(38));
                enemy.setRenderContent(2, true, gameTime);
            }
        }
        this.commands[cmdIndex][16] = 1;
        return 1;
    }

    private int processWaitKilledAllEnemyCommand(long gameTime, GameActor[] actorPool, int cmdIndex) {
        if ((long)this.commands[cmdIndex][0] >= this.time_total / 1000L) {
            return 3;
        }
        for (int i = 0; i < actorPool.length; ++i) {
            if (actorPool[i] == null || !actorPool[i].inUse() || actorPool[i].getType() != 1) continue;
            return 3;
        }
        this.resetCommandTime();
        this.commands[cmdIndex][16] = 1;
        return 1;
    }

    private int processChangeBGScrollSpeedCommand(long gameTime, GameActor[] actorPool, int cmdIndex) {
        if (this.checkMustDieIDs(actorPool, cmdIndex) == 2) {
            return 2;
        }
        this.game.setXMapFrontOffsetSpeed(this.commands[cmdIndex][6]);
        this.game.setXMapMidOffsetSpeed(this.commands[cmdIndex][7]);
        this.game.setXMapBackOffsetSpeed(this.commands[cmdIndex][8]);
        this.commands[cmdIndex][16] = 1;
        return 1;
    }

    private int processSetEnemyRetreatCommand(long gameTime, GameActor[] actorPool, int cmdIndex) {
        for (int i = 0; i < actorPool.length; ++i) {
            if (actorPool[i] == null || !actorPool[i].inUse() || actorPool[i].getType() != 1 || actorPool[i].getInstanceID() == -1 || actorPool[i].getInstanceID() != this.commands[cmdIndex][10] && actorPool[i].getInstanceID() != this.commands[cmdIndex][11] && actorPool[i].getInstanceID() != this.commands[cmdIndex][12] && actorPool[i].getInstanceID() != this.commands[cmdIndex][13] && actorPool[i].getInstanceID() != this.commands[cmdIndex][14]) continue;
            ((Enemy)actorPool[i]).setRetreat(gameTime, this.commands[cmdIndex][8] * 240 / 100, 55 + this.commands[cmdIndex][9] * 240 / 100);
        }
        this.commands[cmdIndex][16] = 1;
        return 1;
    }

    private int checkMustDieIDs(GameActor[] actorPool, int cmdIndex) {
        for (int i = 0; i < actorPool.length; ++i) {
            if (actorPool[i] == null || !actorPool[i].inUse() || actorPool[i].getType() != 1) continue;
            for (int j = 10; j <= 14; ++j) {
                if (actorPool[i].getInstanceID() != this.commands[cmdIndex][j] || this.commands[cmdIndex][j] == -1) continue;
                this.commands[cmdIndex][16] = 2;
                return 2;
            }
        }
        return 0;
    }

    public void resetCommandTime() {
        this.time_total = 0L;
        this.time_start = -1L;
    }
}

