/*
 * Decompiled with CFR 0.152.
 */
package HG.Scene;

import HG.Animation.Map;
import HG.Animation.PWPifLifeAnimations;
import HG.Game.Enemy;
import HG.Game.GameActor;
import HG.Game.GameCommands;
import HG.Game.GameDialog;
import HG.Game.GamePiffList;
import HG.Game.GameWord;
import HG.Game.ItemBag;
import HG.Game.Player;
import HG.Main.MainCanvas;
import HG.MotionWelder.AnuData;
import HG.MotionWelder.AnuPlayer;
import HG.MotionWelder.MSimpleAnimationPlayer;
import HG.MotionWelder.MSpriteLoader;
import HG.Public.Constant;
import HG.Scene.Scene;
import HG.Scene.SceneManage;
import HG.Scene.ScenePublic;
import HG.Tool.DialogAnimation;
import HG.Tool.GraphicsTool;
import HG.Tool.KeySystem;
import HG.Tool.MathTool;
import HG.Tool.MusicPlayer;
import HG.Tool.TextTool;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameScene
extends Scene {
    private Image img_mapBG = null;
    private Map map_front = null;
    private Map map_mid = null;
    private int MapMidOffset_x = 0;
    private int MapMidOffset_y = 0;
    private int MapMidOffset_speed = 0;
    private int MapFrontOffset_x = 0;
    private int MapFrontOffset_y = 0;
    private int MapFrontOffset_speed = 0;
    private int MapBackOffset_x = 0;
    private int MapBackOffset_y = 0;
    private int MapBackOffset_speed = 0;
    private static int index_playerInPool = 0;
    public static GameActor[] actorPool = null;
    public static GameActor[] bulletPool = null;
    public static GameActor[] spiritPool = null;
    public static GameActor[] bonusPool = null;
    public GameCommands commands = null;
    private long time_begGame = 0L;
    private long time_curGame = 0L;
    private boolean is_shakeScreen = false;
    private boolean is_darkScreen = false;
    private boolean is_lightScreen = false;
    private boolean is_lightScreenOverlapEnemy = false;
    private boolean stopScrollBG = false;
    private boolean is_levelFinished = false;
    private Image img_bossbloodline = null;
    public static boolean is_boss = false;
    public static boolean is_bossExplode = false;
    public static boolean is_boss_alarm = false;
    public static int boss_curLife = 0;
    public static int boss_maxLife = 0;
    private MSimpleAnimationPlayer battleUI = null;
    private Image img_bloodline = null;
    private Image img_igmbloodline = null;
    private Image img_numWhite = null;
    private Image img_numBlue = null;
    private Image img_numRed = null;
    private Image img_numLevel = null;
    private Image img_enemyBG = null;
    private Image img_enemyNameIcon = null;
    private Image img_heroIcon = null;
    private Image img_hpmpexp = null;
    private Image img_softkey = null;
    private Image img_breviaryIcon = null;
    public int breviary_x = 46;
    public int breviary_y = 43;
    public int breviary_width = 145;
    public final int breviary_height;
    public int breviary_pieceNum = 0;
    public int breviary_space = 0;
    public int breviary_player = 0;
    public int breviary_playerX = 0;
    private int breviary_fadeIcon = -1;
    private int breviary_fadeIconRecord = -1;
    private int time_iconDisappear = 0;
    public int breviary_enemyPointNum = 0;
    public static final byte BREVIARY_ENEMYPOS = 0;
    public static final byte BREVIARY_ICONID = 1;
    public int[][] breviary_data = null;
    private DialogAnimation dialog_game = null;
    private GameDialog game_dialog = null;
    private GameWord game_word = null;
    private boolean is_dialog = false;
    private MSimpleAnimationPlayer resultUI = null;
    private MSimpleAnimationPlayer resultUIFont = null;
    private MSimpleAnimationPlayer LevelUp = null;
    private MSimpleAnimationPlayer effectNewItem = null;
    private Image img_numResult = null;
    private Image img_nameResult = null;
    private int step_result = 0;
    private int count_result = 0;
    private int reduce_result = 0;
    private int exp_addresult = 0;
    private int level_result = 0;
    private final int maxstep_result;
    private boolean is_resultLevelUP = false;
    private boolean is_startEffItem = false;
    private boolean is_resultTitle = false;
    private int resultTitle_x = 0;
    private int resultTitle_y = 0;
    private int resultTitle_frame = 0;
    private boolean is_showMissionItem = false;
    private boolean is_giveResultItem = false;
    public boolean is_deadMenu = false;
    private AnuPlayer lose = null;
    private Image m_imgArrow = null;
    private Image m_imgFire = null;
    public boolean[] is_tipGainItem = null;
    public int[] tip_GainItem_x = null;
    public int[] tip_GainItem_frame = null;
    public int[] tip_GainItem_lang = null;
    public int gainItemBorder_w = 0;
    public int gainItemBorder_h = 0;
    private int[][] m_anShortcutsKeyXY = null;
    private int m_nShortcutsKeyY = 302;
    private int[][] m_anVirtualKeyXY = null;
    private int m_nVirtualKeyY = 170;
    private int m_nVirtualKeySize = 40;
    public AnuPlayer bk_superAtk = null;

    public GameScene(MainCanvas mc) {
        super(mc);
        this.breviary_height = 5;
        this.maxstep_result = 7;
        this.Scene_serialID = 4L;
        actorPool = new GameActor[50];
        bulletPool = new GameActor[50];
        spiritPool = new GameActor[50];
        bonusPool = new GameActor[50];
        GameScene.actorPool[0] = new Player(this.Scene_canvas);
        actorPool[0].setType(0);
        actorPool[0].setInUse(true);
        actorPool[0].setAnimation(new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/wukong.aej"), 0, true));
        GameScene.getPlayer().resetPlayerData();
        Player.player_useMagic_0 = 0;
        Player.player_useMagic_star = (byte)-1;
        Player.player_useMagic_pound = (byte)-1;
    }

    public void loadScene() {
        try {
            GameScene.getPlayer().initGameActor(0L, 0);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.commands = new GameCommands(this.Scene_canvas);
            this.commands.loadCommands("/data/lv" + Constant.indexOfLevel + ".dat");
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.initThumbnailMap();
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            Enemy.EnemyAttribute = MainCanvas.stream.loadEnemyAttribute("/data/enemy.dat");
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            Enemy.EnemyAnimDB_Pif = new PWPifLifeAnimations[Constant.RESLIST_ENEMY_LV[Constant.indexOfLevel].length];
            for (int i = 0; i < Enemy.EnemyAnimDB_Pif.length; ++i) {
                Enemy.EnemyAnimDB_Pif[i] = this.loadEnemyAnimationRes(Constant.RESLIST_ENEMY_LV[Constant.indexOfLevel][i]);
            }
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.loadGameSceneImage();
            PWPifLifeAnimations.SetPrecalcImagePoolSize(0);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.battleUI = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/menu/battleUI.anu", true, this), 0, 0);
            this.battleUI.setAnimation(0);
            this.battleUI.setLoopOffset(0);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.resultUI = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/menu/LevelResult.anu", true, this), 0, 0);
            this.resultUI.setAnimation(0);
            this.resultUI.setLoopOffset(-1);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.resultUIFont = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/menu/LevelResultFont.anu", false, this), 0, 0);
            this.resultUIFont.setAnimation(0);
            this.resultUIFont.setLoopOffset(-1);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.LevelUp = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/menu/effect_levelup.anu", false, this), 0, 0);
            this.LevelUp.notifyEndOfAnimation();
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.effectNewItem = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/menu/effect_AddDone.anu", false, this), 0, 0);
            this.effectNewItem.notifyEndOfAnimation();
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            String[] asImgList = new String[]{"/game/UI_lose.png"};
            AnuData ad = new AnuData("/game/UI_Lose_Font.anu", asImgList);
            ad.loadResAll();
            this.lose = new AnuPlayer(ad);
            this.lose.setAnimation(0, 1);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.dialog_game = new DialogAnimation(this.Scene_canvas);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.game_dialog = new GameDialog(this, this.dialog_game);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.game_word = new GameWord(this.Scene_canvas);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.is_tipGainItem = new boolean[]{false, false};
            this.tip_GainItem_x = new int[]{0, 0};
            this.tip_GainItem_frame = new int[]{0, 0};
            this.tip_GainItem_lang = new int[]{0, 0};
            this.gainItemBorder_w = TextTool.getCharWidth() << 3;
            this.gainItemBorder_h = TextTool.getCharHeight() + 10;
            this.is_deadMenu = false;
            is_boss = false;
            is_boss_alarm = false;
            boss_curLife = 0;
            boss_maxLife = 0;
            Enemy.resetEnemyUI();
            this.setLevelFinished(false);
            this.setXMapFrontOffset(0);
            this.setXMapFrontOffsetSpeed(0);
            this.setXMapBackOffset(0);
            this.setXMapBackOffsetSpeed(0);
            this.setStopScrollBG(false);
            this.setDarkScreen(false);
            this.setShakeScreen(false);
            this.setLightScreen(false);
            this.setLightScreenOverlapEnemy(false);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            MusicPlayer.getInst().loadMusic("/music/mission.mid");
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.time_begGame = System.currentTimeMillis();
            this.Scene_canvas.sceneMgr.scene_load.refreshFullLoad();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadGameSceneImage() throws IOException {
        this.loadGameMap(Constant.MAP_ID[Constant.indexOfLevel][0], Constant.MAP_ID[Constant.indexOfLevel][1], Constant.MAP_ID[Constant.indexOfLevel][2]);
        GamePiffList.loadPifListAnimation();
        this.img_bloodline = GraphicsTool.loadImage("/menu/bloodline.png");
        this.img_igmbloodline = GraphicsTool.loadImage("/menu/igm_bloodline.png");
        this.img_numWhite = GraphicsTool.loadImage("/menu/g_num_7h_white.png");
        this.img_numBlue = GraphicsTool.loadImage("/menu/g_num_7h_blue.png");
        this.img_numRed = GraphicsTool.loadImage("/menu/g_num_7h_red.png");
        this.img_numLevel = GraphicsTool.loadImage("/menu/g_num_yellow.png");
        this.img_numResult = GraphicsTool.loadImage("/menu/imgNumber3.png");
        this.img_nameResult = GraphicsTool.loadImage("/menu/Result_name.png");
        this.img_hpmpexp = GraphicsTool.loadImage("/menu/hpmpexp.png");
        this.img_softkey = GraphicsTool.loadImage("/menu/gameSoftkey.png");
        this.img_breviaryIcon = GraphicsTool.loadImage("/menu/MiniMap_Icon.png");
        this.img_bossbloodline = GraphicsTool.loadImage("/game/bossbloodline.png");
        this.img_heroIcon = GraphicsTool.loadImage("/menu/Hero_Face.png");
        this.img_enemyBG = GraphicsTool.loadImage("/menu/EnemyFace_Bg.png");
        this.img_enemyNameIcon = GraphicsTool.loadImage("/game/enemyName.png");
    }

    private void initAllXY() {
        this.m_anShortcutsKeyXY = new int[5][];
        for (int i = 0; i < 5; ++i) {
            this.m_anShortcutsKeyXY[i] = new int[]{79 + i * 16, this.m_nShortcutsKeyY, 16, 14};
        }
        this.m_anVirtualKeyXY = new int[5][];
        this.m_anVirtualKeyXY[0] = new int[]{this.m_nVirtualKeySize, this.m_nVirtualKeyY, this.m_nVirtualKeySize, this.m_nVirtualKeySize};
        this.m_anVirtualKeyXY[1] = new int[]{this.m_nVirtualKeySize, this.m_nVirtualKeyY + (this.m_nVirtualKeySize << 1), this.m_nVirtualKeySize, this.m_nVirtualKeySize};
        this.m_anVirtualKeyXY[2] = new int[]{0, this.m_nVirtualKeyY + this.m_nVirtualKeySize, this.m_nVirtualKeySize, this.m_nVirtualKeySize};
        this.m_anVirtualKeyXY[3] = new int[]{this.m_nVirtualKeySize << 1, this.m_nVirtualKeyY + this.m_nVirtualKeySize, this.m_nVirtualKeySize, this.m_nVirtualKeySize};
        this.m_anVirtualKeyXY[4] = new int[]{240 - (this.m_nVirtualKeySize << 1), this.m_nVirtualKeyY + this.m_nVirtualKeySize, this.m_imgFire.getWidth() << 1, this.m_imgFire.getHeight() << 1};
    }

    public void render(Graphics g) {
        int i;
        GraphicsTool.restScreen(g, 0);
        int offset_x = 0;
        int offset_y = 0;
        if (this.isShakeScreen()) {
            offset_x = MathTool.getRandom(-1, 1);
            offset_y = MathTool.getRandom(-1, 1);
            offset_x = offset_x < 0 ? --offset_x : ++offset_x;
            offset_y = offset_y < 0 ? --offset_y : ++offset_y;
            g.translate(offset_x, offset_y);
        }
        if (!this.isStopScrollBG() && !this.isDarkScreen()) {
            this.MapBackOffset_x += this.MapBackOffset_speed;
            if (this.MapBackOffset_x % this.img_mapBG.getWidth() != this.MapBackOffset_x) {
                this.setXMapBackOffset(this.MapBackOffset_x % this.img_mapBG.getWidth());
            }
            if (this.map_mid != null) {
                this.MapMidOffset_x += this.MapMidOffset_speed;
                if (this.MapMidOffset_x % (this.map_mid.getTilesWide() * this.map_mid.getTileWidth()) != this.MapMidOffset_x) {
                    this.setXMapMidOffset(this.MapMidOffset_x % (this.map_mid.getTilesWide() * this.map_mid.getTileWidth()));
                }
            }
            if (this.map_front != null) {
                this.MapFrontOffset_x += this.MapFrontOffset_speed;
                if (this.MapFrontOffset_x % (this.map_front.getTilesWide() * this.map_front.getTileWidth()) != this.MapFrontOffset_x) {
                    this.setXMapFrontOffset(this.MapFrontOffset_x % (this.map_front.getTilesWide() * this.map_front.getTileWidth()));
                }
            }
        }
        GraphicsTool.restClip(g);
        g.drawImage(this.img_mapBG, -this.MapBackOffset_x, this.MapBackOffset_y, 20);
        if (this.img_mapBG.getWidth() - this.MapBackOffset_x < 240) {
            g.drawImage(this.img_mapBG, -this.MapBackOffset_x + this.img_mapBG.getWidth(), this.MapBackOffset_y, 20);
        }
        if (this.map_mid != null) {
            this.map_mid.drawMap(g, -this.MapMidOffset_x, this.MapMidOffset_y);
            if (this.map_mid.getTilesWide() * this.map_mid.getTileWidth() - this.MapMidOffset_x < 240) {
                this.map_mid.drawMap(g, -this.MapMidOffset_x + this.map_mid.getTilesWide() * this.map_mid.getTileWidth(), this.MapMidOffset_y);
            }
        }
        if (this.isDarkScreen()) {
            GraphicsTool.restScreen(g, 0);
            if (GameScene.getPlayer().getCurState() == 2 || GameScene.getPlayer().getCurState() == 4 || GameScene.getPlayer().getCurState() == 3 || GameScene.getPlayer().getCurState() == 5 || GameScene.getPlayer().getCurState() == 6) {
                GraphicsTool.restClip(g);
                this.bk_superAtk.paint(g, 120, 160);
                this.bk_superAtk.update();
                if (!this.bk_superAtk.isPlaying()) {
                    this.bk_superAtk.setAnimation(0, 1);
                }
            }
            for (i = actorPool.length - 1; i >= 0; --i) {
                if (actorPool[i] == null || !actorPool[i].inUse() || actorPool[i].getType() == 0) continue;
                actorPool[i].renderGameActor(g, this.getCurGameTime());
            }
        }
        if (this.isLightScreen() || this.isLightScreenOverlapEnemy()) {
            if (this.isLightScreen()) {
                GraphicsTool.restScreen(g, 0xFFFFFF);
            }
            for (i = actorPool.length - 1; i >= 0; --i) {
                if (actorPool[i] == null || !actorPool[i].inUse() || actorPool[i].getType() == 0) continue;
                actorPool[i].renderGameActor(g, this.getCurGameTime());
            }
            if (this.isLightScreenOverlapEnemy()) {
                GraphicsTool.restScreen(g, 0xFFFFFF);
            }
            this.setLightScreen(false);
            this.setLightScreenOverlapEnemy(false);
        }
        if (!(this.isLightScreen() || this.isLightScreenOverlapEnemy() || this.isDarkScreen())) {
            for (i = actorPool.length - 1; i >= 0; --i) {
                if (actorPool[i] == null || !actorPool[i].inUse() || actorPool[i].getType() == 0) continue;
                actorPool[i].renderGameActor(g, this.getCurGameTime());
            }
            GameScene.getPlayer().renderGameActor(g, this.getCurGameTime());
            for (i = 0; i < bulletPool.length; ++i) {
                if (bulletPool[i] == null || !bulletPool[i].inUse()) continue;
                bulletPool[i].renderGameActor(g, this.getCurGameTime());
            }
            for (i = 0; i < bonusPool.length; ++i) {
                if (bonusPool[i] == null || !bonusPool[i].inUse()) continue;
                bonusPool[i].renderGameActor(g, this.getCurGameTime());
            }
            for (i = 0; i < spiritPool.length; ++i) {
                if (spiritPool[i] == null || !spiritPool[i].inUse()) continue;
                spiritPool[i].renderGameActor(g, this.getCurGameTime());
            }
            if (this.map_front != null) {
                this.map_front.drawMap(g, -this.MapFrontOffset_x, this.MapFrontOffset_y);
                if (this.map_front.getTilesWide() * this.map_front.getTileWidth() - this.MapFrontOffset_x < 240) {
                    this.map_front.drawMap(g, -this.MapFrontOffset_x + this.map_front.getTilesWide() * this.map_front.getTileWidth(), this.MapFrontOffset_y);
                }
            }
        } else {
            for (i = 0; i < spiritPool.length; ++i) {
                if (spiritPool[i] == null || !spiritPool[i].inUse()) continue;
                spiritPool[i].renderGameActor(g, this.getCurGameTime());
            }
            GameScene.getPlayer().renderGameActor(g, this.getCurGameTime());
        }
        if (this.isLevelFinished()) {
            this.drawEvaluation(g);
        } else {
            this.drawGameUI(g);
        }
        if (this.isDialog()) {
            GraphicsTool.drawAlphaImageBK(g, 0, 0, 240, 320);
            this.game_dialog.drawDialog(g);
        } else if (this.is_deadMenu) {
            GraphicsTool.restScreen(g, 0);
            this.lose.paint(g, 120, 180);
            this.lose.update();
            if (!this.lose.isPlaying()) {
                ScenePublic.drawBottomIconCN(g, 0xFF0000, false, (byte)1, true, (byte)3);
            }
        } else if (GameScene.getPlayer().getCurState() == 13) {
            int speed = 6;
            GameScene.getPlayer().dead_colorChange = GameScene.getPlayer().dead_colorChange + speed >= 255 ? 255 : GameScene.getPlayer().dead_colorChange + speed;
            GraphicsTool.changeOpaqueData(GameScene.getPlayer().dead_colorData, GameScene.getPlayer().dead_colorChange, 240, 320);
            GraphicsTool.drawOpaqueData(g, GameScene.getPlayer().dead_colorData, 0, 0, 240, 320);
        }
        if (this.isShakeScreen()) {
            g.translate(-offset_x, -offset_y);
        } else {
            if (g.getTranslateX() != 0) {
                g.translate(-g.getTranslateX(), 0);
            }
            if (g.getTranslateY() != 0) {
                g.translate(0, -g.getTranslateY());
            }
        }
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        KeySystem.ClearKey();
    }

    public void keyPressed(int key) {
        if (SceneManage.is_phone_HangUP) {
            SceneManage.is_phone_HangUP = false;
            if (!this.isLevelFinished()) {
                this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)5, false, false);
            } else {
                MusicPlayer.getInst().playMusic();
            }
            return;
        }
        if (this.isDialog()) {
            this.game_dialog.keyDialog(key);
            if (this.game_dialog.is_dialogOver()) {
                this.endDialog();
            }
        } else if (this.is_deadMenu) {
            switch (key) {
                case -7: {
                    if (this.lose.isPlaying()) break;
                    this.is_deadMenu = false;
                    GameScene.getPlayer().dead_colorChange = 0;
                    GameScene.getPlayer().dead_colorData = null;
                    MusicPlayer.getInst().stopMusic();
                    if (Constant.indexOfLevel == 0) {
                        this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)0, false, true);
                        break;
                    }
                    this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)1, false, true);
                }
            }
        } else {
            KeySystem.ClearKey();
            KeySystem.keyPressed(key);
        }
    }

    public void keyReleased(int key) {
        KeySystem.keyReleased(key);
    }

    public void run() {
        MusicPlayer.getInst().checkMusicStat();
        KeySystem.UpdateKey();
        if (this.isLevelFinished()) {
            this.keyEvaluation();
        } else {
            long time = System.currentTimeMillis() - this.time_begGame;
            this.setCurGameTime(time);
            Constant.time_gameALL += this.getCurGameTime();
            if (this.isDialog()) {
                this.game_dialog.runDialog();
            } else {
                int i;
                this.commands.process(this.getCurGameTime(), actorPool);
                for (i = 0; i < actorPool.length; ++i) {
                    if (actorPool[i] == null || !actorPool[i].inUse()) continue;
                    actorPool[i].process(time, actorPool);
                }
                for (i = 0; i < bulletPool.length; ++i) {
                    if (bulletPool[i] == null || !bulletPool[i].inUse()) continue;
                    bulletPool[i].process(time, actorPool);
                }
                for (i = 0; i < bonusPool.length; ++i) {
                    if (bonusPool[i] == null || !bonusPool[i].inUse()) continue;
                    bonusPool[i].process(time, actorPool);
                }
                for (i = 0; i < spiritPool.length; ++i) {
                    if (spiritPool[i] == null || !spiritPool[i].inUse()) continue;
                    spiritPool[i].process(time, actorPool);
                }
                GameScene.getPlayer().adjustPosition(time, actorPool);
            }
            if (KeySystem.IsKeyPressed(131072) && !this.isDialog() && GameScene.getPlayer().getLife() > 0) {
                this.clearGameSceneImage();
                this.commands.resetCommandTime();
                this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)4, false, false);
            } else if (KeySystem.IsKeyPressed(65536) && !this.isDialog() && GameScene.getPlayer().getLife() > 0) {
                this.commands.resetCommandTime();
                MusicPlayer.getInst().stopMusic();
                SceneManage.checkReloadMusic();
                this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)5, false, false);
            }
        }
    }

    public void clearScene() {
        int i;
        for (i = 0; i < actorPool.length; ++i) {
            if (actorPool[i] != null && actorPool[i].getType() != 0) {
                actorPool[i].clearGameActor();
                GameScene.actorPool[i] = null;
                continue;
            }
            if (actorPool[i] == null || actorPool[i].getType() != 0) continue;
            actorPool[i].clearGameActor();
        }
        for (i = 0; i < bulletPool.length; ++i) {
            if (bulletPool[i] == null) continue;
            bulletPool[i].clearGameActor();
            GameScene.bulletPool[i] = null;
        }
        for (i = 0; i < spiritPool.length; ++i) {
            if (spiritPool[i] == null) continue;
            spiritPool[i].clearGameActor();
            GameScene.spiritPool[i] = null;
        }
        for (i = 0; i < bonusPool.length; ++i) {
            if (bonusPool[i] == null) continue;
            bonusPool[i].clearGameActor();
            GameScene.bonusPool[i] = null;
        }
        Map.clearMapLib();
        this.img_mapBG = null;
        this.map_front = null;
        this.map_mid = null;
        this.commands.clearCommand();
        this.commands = null;
        this.img_bossbloodline = null;
        this.battleUI = null;
        this.img_bloodline = null;
        this.img_igmbloodline = null;
        this.img_numWhite = null;
        this.img_numBlue = null;
        this.img_numRed = null;
        this.img_numLevel = null;
        this.img_enemyBG = null;
        this.img_enemyNameIcon = null;
        this.img_heroIcon = null;
        this.img_hpmpexp = null;
        this.img_softkey = null;
        this.img_breviaryIcon = null;
        this.m_imgArrow = null;
        this.m_imgFire = null;
        this.breviary_data = null;
        this.dialog_game = null;
        this.game_word = null;
        this.resultUI = null;
        this.LevelUp = null;
        this.effectNewItem = null;
        this.img_numResult = null;
        this.img_nameResult = null;
        this.lose = null;
        this.is_tipGainItem = null;
        this.tip_GainItem_x = null;
        this.tip_GainItem_frame = null;
        this.tip_GainItem_lang = null;
        this.m_anShortcutsKeyXY = null;
        this.m_anVirtualKeyXY = null;
        this.bk_superAtk = null;
        this.game_dialog.clearDialog();
        this.game_dialog = null;
        Enemy.EnemyAttribute = null;
        for (i = 0; i < Enemy.EnemyAnimDB_Pif.length; ++i) {
            Enemy.EnemyAnimDB_Pif[i] = null;
        }
        Enemy.EnemyAnimDB_Pif = null;
        GamePiffList.clearPifListAnimation();
        PWPifLifeAnimations.FreePrecalcImagePool(0);
        MSpriteLoader.releaseTmpImage();
        System.gc();
    }

    private void clearGameSceneImage() {
        Map.clearMapLib();
        this.img_mapBG = null;
        this.map_front = null;
        this.map_mid = null;
        this.img_bloodline = null;
        this.img_igmbloodline = null;
        this.img_numWhite = null;
        this.img_numBlue = null;
        this.img_numRed = null;
        this.img_numLevel = null;
        this.img_numResult = null;
        this.img_nameResult = null;
        this.img_enemyBG = null;
        this.img_enemyNameIcon = null;
        this.img_heroIcon = null;
        this.img_hpmpexp = null;
        this.img_softkey = null;
        this.img_breviaryIcon = null;
        this.img_bossbloodline = null;
        GamePiffList.clearPifListAnimation();
        System.gc();
    }

    public void showNotify() {
    }

    public void hideNotify() {
        if (this.isLevelFinished()) {
            MusicPlayer.getInst().pauseMusic();
        } else {
            if (this.isDialog()) {
                this.game_dialog.keyDialog(-7);
                if (this.game_dialog.is_dialogOver()) {
                    this.endDialog();
                }
            }
            this.commands.resetCommandTime();
            MusicPlayer.getInst().stopMusic();
            SceneManage.checkReloadMusic();
        }
    }

    public void drawGainItem(Graphics g, int index, int x, int y) {
        this.dialog_game.drawDialogBorder(g, 0, x, y, this.gainItemBorder_w, this.gainItemBorder_h);
        this.Scene_canvas.text.drawString(g, MainCanvas.lang[index], -1, x + (this.gainItemBorder_w - TextTool.stringWidth(MainCanvas.lang[index])) / 2 - 10, y + 5, 20);
    }

    public void drawGameUI(Graphics g) {
        GraphicsTool.restClip(g);
        this.battleUI.drawFrame(g, 120, 160);
        this.battleUI.update();
        int tmp_nLevelX = 30;
        int tmp_nLevelY = 37;
        int tmp_nHPLen = 82;
        int tmp_nHPX = 42;
        int tmp_nHPY = 11;
        int tmp_nMPLen = tmp_nHPLen;
        int tmp_nMPX = tmp_nHPX;
        int tmp_nMPY = 18;
        int tmp_nEXPLen = 90;
        int tmp_nEXPX = 48;
        int tmp_nEXPY = 26;
        int tmp_3ValueX = 40;
        int tmp_nSoulsX = 150;
        int tmp_nSoulsY = 5;
        int tmp_nHeadX = 9;
        int tmp_nHeadY = 6;
        switch (240) {
            case 176: 
            case 208: {
                tmp_nLevelX = 32;
                tmp_nMPLen = tmp_nHPLen = 64;
                tmp_nEXPLen = 72;
                tmp_nSoulsX = 135;
                break;
            }
            case 320: {
                tmp_nSoulsX = 175;
                break;
            }
            case 640: {
                tmp_nHPX = 54;
                tmp_nHPY = 20;
                tmp_nMPX = tmp_nHPX;
                tmp_nMPY = 27;
                tmp_nEXPX = 60;
                tmp_nEXPY = 35;
                tmp_3ValueX = 55;
                tmp_nLevelX = 38;
                tmp_nLevelY = 45;
                tmp_nSoulsX = 165;
                tmp_nSoulsY = 18;
                tmp_nHeadX = 22;
                tmp_nHeadY = 14;
            }
        }
        switch (320) {
            case 204: 
            case 208: 
            case 220: {
                tmp_nLevelY = 35;
                tmp_nHPY = 7;
                tmp_nMPY = 15;
                tmp_nEXPY = 22;
                break;
            }
            case 240: {
                tmp_nEXPY = 25;
                break;
            }
        }
        this.Scene_canvas.text.drawNumberSymbol(g, this.img_numLevel, 10, false, Player.getPlayerLevel(), tmp_nLevelX, tmp_nLevelY);
        if (Player.state_headIconShow != 0) {
            g.setClip(tmp_nHeadX, tmp_nHeadY, this.img_heroIcon.getWidth() / 3, this.img_heroIcon.getHeight() >> 1);
            g.drawImage(this.img_heroIcon, tmp_nHeadX - Player.state_headIconShow % 3 * (this.img_heroIcon.getWidth() / 3), tmp_nHeadY - Player.state_headIconShow / 3 * (this.img_heroIcon.getHeight() >> 1), 20);
        }
        int per_hp = GameScene.getPlayer().getLife() * tmp_nHPLen / GameScene.getPlayer().getMaxlife();
        g.setClip(tmp_nHPX, tmp_nHPY, per_hp, 3);
        g.drawImage(this.img_bloodline, tmp_nHPX, tmp_nHPY - 5, 20);
        int per_mp = Player.getMana() * tmp_nMPLen / Player.getMaxMana();
        g.setClip(tmp_nMPX, tmp_nMPY, per_mp, 3);
        g.drawImage(this.img_bloodline, tmp_nMPX, tmp_nMPY - 8, 20);
        int exp = Player.experience[Player.getPlayerLevel()] - Player.experience[Player.getPlayerLevel() - 1];
        int getexp = exp - Player.getPlayerPropertyArray()[9];
        int per_exp = getexp * tmp_nEXPLen / exp;
        g.setClip(tmp_nEXPX, tmp_nEXPY, per_exp, 5);
        g.drawImage(this.img_bloodline, tmp_nEXPX, tmp_nEXPY, 20);
        this.Scene_canvas.text.drawNumberSymbol(g, this.img_numRed, 15, GameScene.getPlayer().getLife(), tmp_3ValueX, tmp_nHPY - 3);
        this.Scene_canvas.text.drawNumberSymbol(g, this.img_numBlue, 15, Player.getMana(), tmp_3ValueX, tmp_nMPY - 3);
        this.Scene_canvas.text.drawNumberSymbol(g, this.img_numWhite, 15, Player.getPlayerPropertyArray()[9], tmp_3ValueX, tmp_nEXPY - 2);
        this.Scene_canvas.text.drawNumberSymbol(g, this.img_numLevel, 10, Player.getPlayerSouls(), tmp_nSoulsX, tmp_nSoulsY);
        this.drawThumbnailMap(g);
        int gainitem_speed = 5;
        for (int i = 0; i < 2; ++i) {
            if (!this.is_tipGainItem[i]) continue;
            this.drawGainItem(g, this.tip_GainItem_lang[i], this.tip_GainItem_x[i], 55 + i * this.gainItemBorder_h);
            if (this.tip_GainItem_frame[i] <= 0) {
                if (this.tip_GainItem_x[i] + gainitem_speed < 0) {
                    int n = i;
                    this.tip_GainItem_x[n] = this.tip_GainItem_x[n] + gainitem_speed;
                    continue;
                }
                int n = i;
                this.tip_GainItem_frame[n] = this.tip_GainItem_frame[n] + 1;
                this.tip_GainItem_x[i] = 0;
                continue;
            }
            if (this.tip_GainItem_frame[i] <= 20) {
                int n = i;
                this.tip_GainItem_frame[n] = this.tip_GainItem_frame[n] + 1;
                continue;
            }
            if (this.tip_GainItem_x[i] + this.gainItemBorder_w - gainitem_speed > gainitem_speed) {
                int n = i;
                this.tip_GainItem_x[n] = this.tip_GainItem_x[n] - gainitem_speed;
                continue;
            }
            this.tip_GainItem_frame[i] = 0;
            this.tip_GainItem_x[i] = 0;
            this.is_tipGainItem[i] = false;
        }
        int tmp_nStartX = 79;
        int tmp_nEnemyOffsetX = 0;
        int tmp_nEnemyOffsetY = 0;
        switch (240) {
            case 176: {
                tmp_nStartX = 47;
                break;
            }
            case 208: {
                tmp_nStartX = 64;
                break;
            }
            case 320: {
                tmp_nStartX = 120;
                tmp_nEnemyOffsetX = 66;
                break;
            }
            case 640: {
                tmp_nStartX = 279;
                tmp_nEnemyOffsetX = 378;
                tmp_nEnemyOffsetY = 9;
            }
        }
        switch (320) {
            case 204: {
                break;
            }
            case 208: {
                break;
            }
            case 220: {
                break;
            }
            case 240: {
                tmp_nEnemyOffsetY = -3;
                break;
            }
        }
        int number = GameScene.getPlayer().player_ItemBag.getIndexOfItemNum(0);
        if (number != -1) {
            g.setClip(tmp_nStartX, this.m_nShortcutsKeyY, 14, 14);
            g.drawImage(ItemBag.img_itemicon, tmp_nStartX, this.m_nShortcutsKeyY, 20);
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numWhite, 15, false, number, 14 + tmp_nStartX - 8, 320 - this.img_numWhite.getHeight() - 2);
        }
        if ((number = GameScene.getPlayer().player_ItemBag.getIndexOfItemNum(1)) != -1) {
            g.setClip(tmp_nStartX + 68, this.m_nShortcutsKeyY, 14, 14);
            g.drawImage(ItemBag.img_itemicon, tmp_nStartX + 68 - 14, this.m_nShortcutsKeyY, 20);
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numWhite, 15, false, number, 14 + tmp_nStartX + 59, 320 - this.img_numWhite.getHeight() - 2);
        }
        int iconsize = GameScene.getPlayer().img_MagicIcon.getHeight() / Player.magic_ManaCost.length;
        iconsize = GameScene.getPlayer().img_MagicIcon.getHeight() / 3;
        if (Player.player_useMagic_star != -1) {
            g.setClip(tmp_nStartX + 16, this.m_nShortcutsKeyY, 14, 14);
            int star = Player.player_useMagic_star;
            switch (Player.player_useMagic_star) {
                case 3: {
                    star = 1;
                    break;
                }
                case 4: {
                    star = 2;
                }
            }
            g.drawImage(GameScene.getPlayer().img_MagicIcon, tmp_nStartX + 16, this.m_nShortcutsKeyY - star * iconsize, 20);
        }
        if (Player.player_useMagic_0 != -1) {
            g.setClip(tmp_nStartX + 33, this.m_nShortcutsKeyY, 14, 14);
            int num0 = Player.player_useMagic_0;
            switch (Player.player_useMagic_0) {
                case 3: {
                    num0 = 1;
                    break;
                }
                case 4: {
                    num0 = 2;
                }
            }
            g.drawImage(GameScene.getPlayer().img_MagicIcon, tmp_nStartX + 33, this.m_nShortcutsKeyY - num0 * iconsize, 20);
        }
        if (Player.player_useMagic_pound != -1) {
            g.setClip(tmp_nStartX + 50, this.m_nShortcutsKeyY, 14, 14);
            int pound = Player.player_useMagic_pound;
            switch (Player.player_useMagic_pound) {
                case 3: {
                    pound = 1;
                    break;
                }
                case 4: {
                    pound = 2;
                }
            }
            g.drawImage(GameScene.getPlayer().img_MagicIcon, tmp_nStartX + 50, this.m_nShortcutsKeyY - pound * iconsize, 20);
        }
        g.setClip(212 + tmp_nEnemyOffsetX, 8 + tmp_nEnemyOffsetY, this.img_enemyBG.getWidth(), this.img_enemyBG.getHeight());
        g.drawImage(this.img_enemyBG, 212 + tmp_nEnemyOffsetX, 8 + tmp_nEnemyOffsetY, 20);
        GraphicsTool.drawRegion(g, this.img_enemyBG, 0, 0, this.img_enemyBG.getWidth(), this.img_enemyBG.getHeight(), 2, this.img_enemyBG.getWidth() + 212 + tmp_nEnemyOffsetX, 8 + tmp_nEnemyOffsetY, 20);
        if (Enemy.time_updateUI != -1L && this.getCurGameTime() - Enemy.time_updateUI <= 1000L) {
            int length = 39 - Enemy.lifeper_updateUI * 39 / 100;
            g.setClip(177 + length + tmp_nEnemyOffsetX, 28 + tmp_nEnemyOffsetY, 39, 5);
            g.drawImage(this.img_bloodline, 177 + tmp_nEnemyOffsetX, 17 + tmp_nEnemyOffsetY, 20);
            int lineH = this.img_enemyNameIcon.getHeight() / 16;
            g.setClip(175 + tmp_nEnemyOffsetX, 12 + tmp_nEnemyOffsetY, this.img_enemyNameIcon.getWidth(), lineH);
            g.drawImage(this.img_enemyNameIcon, 175 + tmp_nEnemyOffsetX, 12 - Enemy.enemyName_updateUI * lineH + tmp_nEnemyOffsetY, 20);
        }
        if (is_boss && !is_boss_alarm && !is_bossExplode) {
            int bloodlinecao_y = 275;
            switch (320) {
                case 204: {
                    bloodlinecao_y = 275;
                    break;
                }
                case 208: {
                    bloodlinecao_y = 275;
                    break;
                }
                case 220: {
                    bloodlinecao_y = 275;
                    break;
                }
                case 240: {
                    bloodlinecao_y = 275;
                    break;
                }
                case 360: {
                    bloodlinecao_y = 275;
                }
            }
            int bloodline_x = 14;
            int bloodline_y = bloodlinecao_y + 4;
            int bloodline_w = 240 - bloodline_x * 2;
            int bloodlinecao_num = bloodline_w / 20;
            int bosslife_1_3 = boss_maxLife / 3;
            int bosslife_2_3 = boss_maxLife * 2 / 3;
            int bosslife_per = 0;
            if (bosslife_1_3 != 0) {
                if (boss_curLife < bosslife_1_3) {
                    bosslife_per = boss_curLife * bloodline_w / bosslife_1_3;
                    GraphicsTool.fillRect(g, 0xFF0000, bloodline_x, bloodline_y, bosslife_per, 12);
                } else if (boss_curLife > 0) {
                    GraphicsTool.fillRect(g, 0xFF0000, bloodline_x, bloodline_y, bloodline_w, 12);
                }
                if (boss_curLife >= bosslife_1_3 && boss_curLife < bosslife_2_3) {
                    bosslife_per = (boss_curLife - bosslife_1_3) * bloodline_w / bosslife_1_3;
                    GraphicsTool.fillRect(g, 65280, bloodline_x, bloodline_y, bosslife_per, 12);
                } else if (boss_curLife >= bosslife_1_3) {
                    GraphicsTool.fillRect(g, 65280, bloodline_x, bloodline_y, bloodline_w, 12);
                }
                if (boss_curLife >= bosslife_2_3) {
                    bosslife_per = (boss_curLife - bosslife_2_3) * bloodline_w / bosslife_1_3;
                    GraphicsTool.fillRect(g, 255, bloodline_x, bloodline_y, bosslife_per, 12);
                }
            } else {
                GraphicsTool.fillRect(g, 255, bloodline_x, bloodline_y, bloodline_w, 12);
            }
            for (int i = 0; i < bloodlinecao_num; ++i) {
                g.setClip(bloodline_x + 5 + i * 20, bloodline_y, 20, 12);
                g.drawImage(this.img_bossbloodline, bloodline_x + 5 + i * 20 - 22, bloodline_y - 4, 20);
            }
            g.setClip(0, bloodlinecao_y, 21, 20);
            g.drawImage(this.img_bossbloodline, 0, bloodlinecao_y, 20);
            g.setClip(219, bloodlinecao_y, 21, 20);
            g.drawImage(this.img_bossbloodline, 176, bloodlinecao_y, 20);
        }
        int tip_y = 320 - this.img_softkey.getHeight();
        int tip_w = this.img_softkey.getWidth() >> 1;
        g.setClip(0, tip_y, tip_w, this.img_softkey.getHeight());
        g.drawImage(this.img_softkey, -tip_w, tip_y, 20);
        g.setClip(240 - tip_w, tip_y, tip_w, this.img_softkey.getHeight());
        g.drawImage(this.img_softkey, 240 - tip_w, tip_y, 20);
    }

    private void drawVirtualKey(Graphics g) {
        GraphicsTool.restClip(g);
        int tmp_imgW = this.m_imgArrow.getWidth();
        int tmp_imgH = this.m_imgArrow.getHeight();
        int tmp_nW = this.m_nVirtualKeySize >> 1;
        int tmp_nX = this.m_nVirtualKeySize + tmp_nW;
        int tmp_nY = this.m_nVirtualKeyY + this.m_nVirtualKeySize + tmp_nW;
        int tmp_OffSet = 15;
        int tmp_nW2 = tmp_imgW >> 1;
        g.drawImage(this.m_imgFire, 240 - tmp_nX, tmp_nY, 20);
        g.drawImage(this.m_imgArrow, tmp_nX, tmp_nY - tmp_OffSet, 33);
        GraphicsTool.drawRegion(g, this.m_imgArrow, 0, 0, tmp_imgW, tmp_imgH, 3, tmp_nX - tmp_nW2, tmp_nY + tmp_OffSet, 20);
        GraphicsTool.drawRegion(g, this.m_imgArrow, 0, 0, tmp_imgW, tmp_imgH, 6, tmp_nX - tmp_OffSet - tmp_imgH, tmp_nY - tmp_nW2, 20);
        GraphicsTool.drawRegion(g, this.m_imgArrow, 0, 0, tmp_imgW, tmp_imgH, 5, tmp_nX + tmp_OffSet, tmp_nY - tmp_nW2, 20);
    }

    public void initThumbnailMap() {
        switch (240) {
            case 176: {
                this.breviary_width = 100;
                break;
            }
            case 208: {
                this.breviary_width = 100;
                break;
            }
            case 320: {
                this.breviary_x = 80;
                this.breviary_width = 150;
                break;
            }
            case 640: {
                this.breviary_x = 230;
                this.breviary_width = 182;
            }
        }
        switch (320) {
            case 204: {
                this.breviary_y = 40;
                break;
            }
            case 208: {
                this.breviary_y = 40;
                break;
            }
            case 220: {
                this.breviary_y = 40;
                break;
            }
            case 360: {
                this.breviary_y = 38;
            }
        }
        this.breviary_pieceNum = this.commands.commands.length;
        this.breviary_space = this.breviary_width / this.breviary_pieceNum;
        this.breviary_enemyPointNum = 0;
        for (int i = 0; i < this.breviary_pieceNum; ++i) {
            if (this.commands.commands[i][1] != 1) continue;
            ++this.breviary_enemyPointNum;
        }
        this.breviary_data = new int[this.breviary_enemyPointNum][2];
        int index = 0;
        for (int i = 0; i < this.breviary_pieceNum; ++i) {
            if (this.commands.commands[i][1] != 1) continue;
            this.breviary_data[index][0] = i;
            this.breviary_data[index][1] = this.commands.commands[i][2];
            ++index;
        }
        this.breviary_player = 0;
        this.breviary_playerX = 0;
        this.breviary_fadeIcon = -1;
        this.breviary_fadeIconRecord = -1;
    }

    public void drawThumbnailMap(Graphics g) {
        for (int i = 0; i < this.breviary_enemyPointNum; ++i) {
            if (this.breviary_data[i][0] >= this.commands.index_curCMD) {
                this.drawBreviaryIcon(g, this.breviary_data[i][1], this.breviary_x + this.breviary_data[i][0] * this.breviary_space, this.breviary_y - 8);
                continue;
            }
            this.breviary_fadeIcon = i;
        }
        if (this.breviary_fadeIcon != this.breviary_fadeIconRecord) {
            ++this.time_iconDisappear;
            if (this.time_iconDisappear % 3 != 0) {
                this.drawBreviaryIcon(g, this.breviary_data[this.breviary_fadeIcon][1], this.breviary_x + this.breviary_data[this.breviary_fadeIcon][0] * this.breviary_space, this.breviary_y - 8);
            }
            if (this.time_iconDisappear > 15) {
                this.breviary_fadeIconRecord = this.breviary_fadeIcon;
                this.time_iconDisappear = 0;
            }
        }
        this.breviary_player = this.commands.index_curCMD;
        this.breviary_playerX = this.breviary_playerX >= this.breviary_player * this.breviary_space ? this.breviary_player * this.breviary_space : (this.breviary_playerX = this.breviary_playerX + 1);
        this.drawBreviaryIcon(g, 4, this.breviary_x + this.breviary_playerX, this.breviary_y + 5);
    }

    private void drawBreviaryIcon(Graphics g, int index, int x, int y) {
        switch (index) {
            case 0: {
                g.setClip(x, y, 12, 12);
                g.drawImage(this.img_breviaryIcon, x, y, 20);
                break;
            }
            case 1: {
                g.setClip(x, y, 12, 12);
                g.drawImage(this.img_breviaryIcon, x - 12, y, 20);
                break;
            }
            case 2: {
                g.setClip(x, y, 12, 12);
                g.drawImage(this.img_breviaryIcon, x - 24, y, 20);
                break;
            }
            case 3: {
                g.setClip(x, y, 12, 12);
                g.drawImage(this.img_breviaryIcon, x - 36, y, 20);
                break;
            }
            case 4: {
                g.setClip(x, y, 13, 14);
                g.drawImage(this.img_breviaryIcon, x, y - 12, 20);
                break;
            }
            case 5: {
                g.setClip(x, y, 16, 16);
                g.drawImage(this.img_breviaryIcon, x - 13, y - 12, 20);
            }
        }
    }

    public void initEvaluation() {
        this.resetBulletPool();
        this.level_result = Player.getPlayerLevel();
        this.exp_addresult = Player.getPlayerPropertyArray()[9];
        this.step_result = 0;
        this.count_result = 0;
        this.reduce_result = 0;
        this.resultTitle_frame = 0;
        this.resultTitle_x = 120;
        this.resultTitle_y = 160;
        this.is_resultTitle = true;
        this.is_resultLevelUP = false;
        this.is_startEffItem = false;
        this.is_showMissionItem = false;
        this.is_giveResultItem = false;
        this.resultUIFont.setAnimation(0);
        this.resultUIFont.setLoopOffset(-1);
    }

    private void drawEvaluation(Graphics g) {
        if (this.is_resultTitle) {
            int tmp_nOverTitle_y = 50;
            GraphicsTool.drawAlphaImageBK(g, 0, this.resultTitle_y - 25, 240, 25);
            GraphicsTool.restClip(g);
            this.resultUIFont.drawFrame(g, this.resultTitle_x, this.resultTitle_y);
            this.resultUIFont.update();
            if (!this.resultUIFont.isPlaying()) {
                ++this.resultTitle_frame;
                if (this.resultTitle_frame > 5) {
                    this.resultTitle_y -= 10;
                    if (this.resultTitle_y <= tmp_nOverTitle_y) {
                        this.resultTitle_y = tmp_nOverTitle_y;
                        this.is_resultTitle = false;
                    }
                }
            }
            return;
        }
        GraphicsTool.drawAlphaImageBK(g, 0, this.resultTitle_y - 25, 240, 25);
        GraphicsTool.restClip(g);
        this.resultUIFont.drawFrame(g, this.resultTitle_x, this.resultTitle_y);
        this.resultUIFont.update();
        int background_x = 10;
        int background_y = 60;
        int tmp_nOffSetX = 127;
        int tmp_nExpY = 0;
        int temp_nDesignationY = 0;
        int tmp_nResultUIY = 0;
        switch (240) {
            case 176: {
                tmp_nOffSetX = 70;
                break;
            }
            case 208: {
                tmp_nOffSetX = 86;
                break;
            }
            case 320: {
                tmp_nOffSetX = 166;
                break;
            }
            case 640: {
                tmp_nOffSetX = 325;
            }
        }
        switch (320) {
            case 204: {
                break;
            }
            case 208: {
                background_y = -16;
                tmp_nExpY = -4;
                tmp_nResultUIY = -4;
                temp_nDesignationY = -12;
                break;
            }
            case 220: {
                background_y = -15;
                tmp_nExpY = -4;
                tmp_nResultUIY = -9;
                temp_nDesignationY = -12;
                break;
            }
            case 240: {
                background_y = 18;
                tmp_nExpY = -10;
                temp_nDesignationY = -20;
                break;
            }
        }
        this.dialog_game.drawDialogBorder(g, 0, background_x, background_y, 240 - background_x * 2, 320 - background_y - 20);
        int height = this.initViewableArea(background_y);
        g.setClip(0, 0, 240, background_y + height);
        this.resultUI.drawFrame(g, 120, 160 + tmp_nResultUIY);
        int line_size = 17;
        int speed_num = 10;
        int score_kill = Player.getKilledEnemy() * 20;
        if (this.step_result <= 0) {
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, Player.getKilledEnemy(), background_x + tmp_nOffSetX, background_y + 42);
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numWhite, 15, false, 20, background_x + tmp_nOffSetX + 33, background_y + 45);
            this.count_result += speed_num;
            if (this.count_result < score_kill) {
                this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, this.count_result, background_x + tmp_nOffSetX + 73, background_y + 42);
            } else {
                this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, score_kill, background_x + tmp_nOffSetX + 73, background_y + 42);
                this.count_result = 0;
                ++this.step_result;
            }
        } else {
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, Player.getKilledEnemy(), background_x + tmp_nOffSetX, background_y + 42);
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numWhite, 15, false, 20, background_x + tmp_nOffSetX + 33, background_y + 45);
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, score_kill, background_x + tmp_nOffSetX + 73, background_y + 42);
        }
        int score_hit = Player.getMaxContinuousHits() * 30;
        if (this.step_result > 0 && this.step_result <= 1) {
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, Player.getMaxContinuousHits(), background_x + tmp_nOffSetX, background_y + 42 + line_size);
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numWhite, 15, false, 30, background_x + tmp_nOffSetX + 33, background_y + 45 + line_size);
            this.count_result += speed_num;
            if (this.count_result < score_hit) {
                this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, this.count_result, background_x + tmp_nOffSetX + 73, background_y + 42 + line_size);
            } else {
                this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, score_hit, background_x + tmp_nOffSetX + 73, background_y + 42 + line_size);
                this.count_result = 0;
                ++this.step_result;
            }
        } else if (this.step_result > 1) {
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, Player.getMaxContinuousHits(), background_x + tmp_nOffSetX, background_y + 42 + line_size);
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numWhite, 15, false, 30, background_x + tmp_nOffSetX + 33, background_y + 45 + line_size);
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, score_hit, background_x + tmp_nOffSetX + 73, background_y + 42 + line_size);
        }
        int score_life = GameScene.getPlayer().getLife();
        if (this.step_result > 1 && this.step_result <= 2) {
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, GameScene.getPlayer().getLife(), background_x + tmp_nOffSetX, background_y + 42 + line_size * 2);
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numWhite, 15, false, 1, background_x + tmp_nOffSetX + 33, background_y + 45 + line_size * 2);
            this.count_result += speed_num;
            if (this.count_result < score_life) {
                this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, this.count_result, background_x + tmp_nOffSetX + 73, background_y + 42 + line_size * 2);
            } else {
                this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, score_life, background_x + tmp_nOffSetX + 73, background_y + 42 + line_size * 2);
                this.count_result = 0;
                ++this.step_result;
            }
        } else if (this.step_result > 2) {
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, GameScene.getPlayer().getLife(), background_x + tmp_nOffSetX, background_y + 42 + line_size * 2);
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numWhite, 15, false, 1, background_x + tmp_nOffSetX + 33, background_y + 45 + line_size * 2);
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, score_life, background_x + tmp_nOffSetX + 73, background_y + 42 + line_size * 2);
        }
        int score = score_kill + score_hit + score_life;
        if (this.step_result > 2 && this.step_result <= 3) {
            this.count_result += speed_num;
            if (this.count_result < score) {
                this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, this.count_result, background_x + tmp_nOffSetX + 73, background_y + 42 + line_size * 3);
            } else {
                this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, score, background_x + tmp_nOffSetX + 73, background_y + 42 + line_size * 3);
                this.count_result = 0;
                ++this.step_result;
            }
        } else if (this.step_result > 3) {
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numResult, 11, false, score - this.reduce_result, background_x + tmp_nOffSetX + 73, background_y + 42 + line_size * 3);
        }
        int level = 0;
        int per_exp = 0;
        if (this.step_result > 3 && this.step_result <= 4) {
            this.count_result += speed_num;
            this.reduce_result += speed_num;
            if (score - this.reduce_result > 0) {
                if (this.exp_addresult <= this.count_result) {
                    int diff = this.count_result - this.exp_addresult;
                    Player.setPlayerLevel(Player.getPlayerLevel() + 1);
                    this.exp_addresult = Player.experience[Player.getPlayerLevel()] - Player.experience[Player.getPlayerLevel() - 1] - diff;
                    this.count_result = 0;
                    if (!this.LevelUp.isPlaying()) {
                        this.LevelUp.setAnimation(0);
                        this.LevelUp.setLoopOffset(-1);
                    }
                }
                int temp_exp_0 = Player.experience[Player.getPlayerLevel()] - Player.experience[Player.getPlayerLevel() - 1];
                int temp_exp_1 = temp_exp_0 - this.exp_addresult;
                per_exp = (temp_exp_1 + this.count_result) * 69 / temp_exp_0;
                g.setClip(background_x + tmp_nOffSetX + 10, background_y + 131 + tmp_nExpY, per_exp, 3);
                g.drawImage(this.img_igmbloodline, background_x + tmp_nOffSetX + 10, background_y + 125 + tmp_nExpY, 20);
            } else {
                this.reduce_result = score;
                this.count_result = 0;
                ++this.step_result;
            }
        } else if (this.step_result > 4) {
            this.reduce_result = score;
            if (!this.is_resultLevelUP) {
                int remain_exp = score - Player.getPlayerPropertyArray()[9];
                if (remain_exp < 0) {
                    int[] nArray = Player.getPlayerPropertyArray();
                    nArray[9] = nArray[9] - score;
                } else {
                    level = 1;
                    while (remain_exp >= Player.experience[this.level_result + level] - Player.experience[this.level_result + level - 1]) {
                        remain_exp -= Player.experience[this.level_result + level] - Player.experience[this.level_result + level - 1];
                        ++level;
                        if (!this.LevelUp.isPlaying()) {
                            this.LevelUp.setAnimation(0);
                            this.LevelUp.setLoopOffset(-1);
                        }
                        if (remain_exp >= Player.experience[this.level_result + level] - Player.experience[this.level_result + level - 1]) continue;
                    }
                    Player.setPlayerLevel(this.level_result + level);
                    Player.getPlayerPropertyArray()[8] = Player.getPlayerLevel();
                    Player.setPlayerPoint(Player.getPlayerPoint() + level * 2);
                    Player.getPlayerPropertyArray()[9] = Player.experience[Player.getPlayerLevel()] - Player.experience[Player.getPlayerLevel() - 1] - remain_exp;
                }
                this.is_resultLevelUP = true;
            }
            int exp = Player.experience[Player.getPlayerLevel()] - Player.experience[Player.getPlayerLevel() - 1];
            per_exp = (exp - Player.getPlayerPropertyArray()[9]) * 69 / exp;
            g.setClip(background_x + tmp_nOffSetX + 10, background_y + 131 + tmp_nExpY, per_exp, 3);
            g.drawImage(this.img_igmbloodline, background_x + tmp_nOffSetX + 10, background_y + 125 + tmp_nExpY, 20);
        }
        if (this.step_result >= 4) {
            this.Scene_canvas.text.drawNumberSymbol(g, this.img_numLevel, 10, false, Player.getPlayerLevel(), background_x + tmp_nOffSetX + 58, background_y + 117 + tmp_nExpY);
            g.setClip(background_x + tmp_nOffSetX + 3, background_y + 128 + tmp_nExpY, 22, 8);
            g.drawImage(this.img_hpmpexp, background_x + tmp_nOffSetX - 28, background_y + 128 + tmp_nExpY, 20);
            if (this.LevelUp.isPlaying()) {
                GraphicsTool.restClip(g);
                this.LevelUp.drawFrame(g, background_x + tmp_nOffSetX + 58, background_y + 128 + tmp_nExpY);
                this.LevelUp.update();
            }
        }
        int nameLevel = 0;
        score = this.reduce_result;
        switch (Constant.indexOfLevel) {
            case 0: {
                if (score >= 500) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 400 && score < 500) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 350 && score < 400) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 300 && score < 350) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 200 && score < 300) {
                    nameLevel = 2;
                    break;
                }
                if (score < 100 || score >= 200) break;
                nameLevel = 1;
                break;
            }
            case 1: {
                if (score >= 1800) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1800 && score < 1300) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 1300 && score < 1000) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 1000 && score < 700) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 700 && score < 500) {
                    nameLevel = 2;
                    break;
                }
                if (score < 500 || score >= 300) break;
                nameLevel = 1;
                break;
            }
            case 2: {
                if (score >= 1600) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1200 && score < 1600) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 900 && score < 1200) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 600 && score < 900) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 400 && score < 600) {
                    nameLevel = 2;
                    break;
                }
                if (score < 250 || score >= 400) break;
                nameLevel = 1;
                break;
            }
            case 3: {
                if (score >= 1500) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1100 && score < 1500) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 800 && score < 1100) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 650 && score < 800) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 400 && score < 650) {
                    nameLevel = 2;
                    break;
                }
                if (score < 250 || score >= 500) break;
                nameLevel = 1;
                break;
            }
            case 4: {
                if (score >= 2000) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1400 && score < 1800) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 1250 && score < 1400) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 1000 && score < 1250) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 800 && score < 1000) {
                    nameLevel = 2;
                    break;
                }
                if (score < 500 || score >= 800) break;
                nameLevel = 1;
                break;
            }
            case 5: {
                if (score >= 1400) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1200 && score < 1400) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 1000 && score < 1200) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 800 && score < 1000) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 600 && score < 800) {
                    nameLevel = 2;
                    break;
                }
                if (score < 400 || score >= 600) break;
                nameLevel = 1;
                break;
            }
            case 6: {
                if (score >= 1400) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1200 && score < 1400) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 1000 && score < 1200) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 900 && score < 1000) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 700 && score < 900) {
                    nameLevel = 2;
                    break;
                }
                if (score < 500 || score >= 700) break;
                nameLevel = 1;
                break;
            }
            case 7: {
                if (score >= 1800) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1500 && score < 1800) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 1300 && score < 1500) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 1000 && score < 1300) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 800 && score < 1000) {
                    nameLevel = 2;
                    break;
                }
                if (score < 600 || score >= 800) break;
                nameLevel = 1;
                break;
            }
            case 8: {
                if (score >= 1800) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1600 && score < 1800) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 1250 && score < 1600) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 1100 && score < 1250) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 900 && score < 1100) {
                    nameLevel = 2;
                    break;
                }
                if (score < 700 || score >= 900) break;
                nameLevel = 1;
                break;
            }
            case 9: {
                if (score >= 600) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 500 && score < 600) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 400 && score < 500) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 300 && score < 400) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 200 && score < 300) {
                    nameLevel = 2;
                    break;
                }
                if (score < 100 || score >= 200) break;
                nameLevel = 1;
                break;
            }
            case 10: {
                if (score >= 2000) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1800 && score < 2000) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 1600 && score < 1800) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 1400 && score < 1600) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 1200 && score < 1400) {
                    nameLevel = 2;
                    break;
                }
                if (score < 1000 || score >= 1200) break;
                nameLevel = 1;
                break;
            }
            case 11: {
                if (score >= 1200) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1000 && score < 1200) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 800 && score < 1000) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 600 && score < 800) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 500 && score < 600) {
                    nameLevel = 2;
                    break;
                }
                if (score < 350 || score >= 500) break;
                nameLevel = 1;
                break;
            }
            case 12: {
                if (score >= 1200) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1050 && score < 1200) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 900 && score < 1050) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 750 && score < 900) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 600 && score < 750) {
                    nameLevel = 2;
                    break;
                }
                if (score < 500 || score >= 600) break;
                nameLevel = 1;
                break;
            }
            case 13: {
                if (score >= 1800) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1600 && score < 1800) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 1400 && score < 1600) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 1200 && score < 1400) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 1000 && score < 1200) {
                    nameLevel = 2;
                    break;
                }
                if (score < 800 || score >= 1000) break;
                nameLevel = 1;
                break;
            }
            case 14: {
                if (score >= 1800) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1550 && score < 1800) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 1200 && score < 1550) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 1000 && score < 1200) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 800 && score < 1000) {
                    nameLevel = 2;
                    break;
                }
                if (score < 600 || score >= 800) break;
                nameLevel = 1;
                break;
            }
            case 15: {
                if (score >= 1500) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1200 && score < 1500) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 1000 && score < 1200) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 800 && score < 1000) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 600 && score < 800) {
                    nameLevel = 2;
                    break;
                }
                if (score < 500 || score >= 600) break;
                nameLevel = 1;
                break;
            }
            case 16: {
                if (score >= 800) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 700 && score < 800) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 650 && score < 700) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 600 && score < 650) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 550 && score < 600) {
                    nameLevel = 2;
                    break;
                }
                if (score < 500 || score >= 550) break;
                nameLevel = 1;
                break;
            }
            case 17: {
                if (score >= 1400) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1200 && score < 1400) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 1000 && score < 1200) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 800 && score < 1000) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 600 && score < 800) {
                    nameLevel = 2;
                    break;
                }
                if (score < 500 || score >= 600) break;
                nameLevel = 1;
                break;
            }
            case 18: {
                if (score >= 1500) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 1100 && score < 1500) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 900 && score < 1100) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 800 && score < 900) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 750 && score < 800) {
                    nameLevel = 2;
                    break;
                }
                if (score < 700 || score >= 750) break;
                nameLevel = 1;
                break;
            }
            case 19: {
                if (score >= 1000) {
                    nameLevel = 6;
                    break;
                }
                if (score >= 800 && score < 1000) {
                    nameLevel = 5;
                    break;
                }
                if (score >= 600 && score < 800) {
                    nameLevel = 4;
                    break;
                }
                if (score >= 500 && score < 600) {
                    nameLevel = 3;
                    break;
                }
                if (score >= 400 && score < 500) {
                    nameLevel = 2;
                    break;
                }
                if (score < 200 || score >= 400) break;
                nameLevel = 1;
            }
        }
        if (this.step_result > 4 && this.step_result <= 5) {
            this.setShakeScreen(true);
            g.setClip(0, background_y + 150 + temp_nDesignationY, 240, this.img_nameResult.getHeight() / 7);
            g.drawImage(this.img_nameResult, background_x + tmp_nOffSetX + 43, background_y + 150 - nameLevel * (this.img_nameResult.getHeight() / 7) + temp_nDesignationY, 17);
            ++this.count_result;
            if (this.count_result > 8) {
                this.setShakeScreen(false);
                this.count_result = 0;
                ++this.step_result;
            }
        } else if (this.step_result > 5) {
            this.setShakeScreen(false);
            g.setClip(0, background_y + 150 + temp_nDesignationY, 240, this.img_nameResult.getHeight() / 7);
            g.drawImage(this.img_nameResult, background_x + tmp_nOffSetX + 43, background_y + 150 - nameLevel * (this.img_nameResult.getHeight() / 7) + temp_nDesignationY, 17);
        }
        if (this.step_result >= 6) {
            int newItemIndex = -1;
            int str_index = 100;
            int temp_nRunStringY = 0;
            int temp_nMissionY = 0;
            switch (Constant.indexOfLevel) {
                case 2: {
                    if (nameLevel < 1) break;
                    newItemIndex = 0;
                    if (!Player.player_MissionItem[newItemIndex] || !Constant.LEVEL_ZONE_STATE[2][2] || this.is_showMissionItem) {
                        this.is_showMissionItem = true;
                        Player.player_MissionItem[newItemIndex] = true;
                        str_index = 93;
                        if (!this.effectNewItem.isPlaying()) {
                            boolean bl = this.is_startEffItem = !this.is_startEffItem;
                            if (!this.is_startEffItem) {
                                ++this.step_result;
                            }
                            this.effectNewItem.setAnimation(0);
                            this.effectNewItem.setLoopOffset(-1);
                        }
                    } else {
                        newItemIndex = -1;
                        this.step_result = 7;
                    }
                    if (Constant.LEVEL_ZONE_STATE[3][0] && Constant.LEVEL_ZONE_STATE[3][2]) break;
                    Constant.index_newHideLevel = 3;
                    Constant.index_newHideLevelStart = Constant.indexOfLevel;
                    Constant.LEVEL_ZONE_STATE[3][0] = true;
                    break;
                }
                case 7: {
                    newItemIndex = 1;
                    if (!(GameScene.getPlayer().getLife() < GameScene.getPlayer().getMaxlife() >> 1 || Player.player_MissionItem[newItemIndex] && Constant.LEVEL_ZONE_STATE[7][2] && !this.is_showMissionItem)) {
                        this.is_showMissionItem = true;
                        Player.player_MissionItem[newItemIndex] = true;
                        str_index = 94;
                        if (!this.effectNewItem.isPlaying()) {
                            boolean bl = this.is_startEffItem = !this.is_startEffItem;
                            if (!this.is_startEffItem) {
                                ++this.step_result;
                            }
                            this.effectNewItem.setAnimation(0);
                            this.effectNewItem.setLoopOffset(-1);
                        }
                    } else {
                        newItemIndex = -1;
                        this.step_result = 7;
                    }
                    if (!Player.player_MissionItem[1] || Constant.LEVEL_ZONE_STATE[9][0] && Constant.LEVEL_ZONE_STATE[9][2]) break;
                    Constant.index_newHideLevel = 9;
                    Constant.index_newHideLevelStart = Constant.indexOfLevel;
                    Constant.LEVEL_ZONE_STATE[9][0] = true;
                    break;
                }
                case 9: {
                    newItemIndex = 2;
                    if (!(nameLevel < 2 || Player.player_MissionItem[newItemIndex] && Constant.LEVEL_ZONE_STATE[9][2] && !this.is_showMissionItem)) {
                        this.is_showMissionItem = true;
                        Player.player_MissionItem[newItemIndex] = true;
                        str_index = 95;
                        if (!this.effectNewItem.isPlaying()) {
                            boolean bl = this.is_startEffItem = !this.is_startEffItem;
                            if (!this.is_startEffItem) {
                                ++this.step_result;
                            }
                            this.effectNewItem.setAnimation(0);
                            this.effectNewItem.setLoopOffset(-1);
                        }
                    } else {
                        newItemIndex = -1;
                        this.step_result = 7;
                    }
                    if (Constant.index_newHideLevel != 9) break;
                    Constant.index_newHideLevel = -1;
                    Constant.index_newHideLevelStart = -1;
                    break;
                }
                case 11: {
                    newItemIndex = 4;
                    if (!(nameLevel < 4 || Player.player_MissionItem[newItemIndex] && Constant.LEVEL_ZONE_STATE[11][2] && !this.is_showMissionItem)) {
                        this.is_showMissionItem = true;
                        Player.player_MissionItem[newItemIndex] = true;
                        str_index = 97;
                        if (!this.effectNewItem.isPlaying()) {
                            boolean bl = this.is_startEffItem = !this.is_startEffItem;
                            if (!this.is_startEffItem) {
                                ++this.step_result;
                            }
                            this.effectNewItem.setAnimation(0);
                            this.effectNewItem.setLoopOffset(-1);
                        }
                    } else {
                        newItemIndex = -1;
                        this.step_result = 7;
                    }
                    if (nameLevel < 4 || Constant.LEVEL_ZONE_STATE[12][0] && Constant.LEVEL_ZONE_STATE[12][2]) break;
                    Constant.index_newHideLevel = 12;
                    Constant.index_newHideLevelStart = Constant.indexOfLevel;
                    Constant.LEVEL_ZONE_STATE[12][0] = true;
                    break;
                }
                case 12: {
                    newItemIndex = 3;
                    if (!Player.player_MissionItem[newItemIndex] || !Constant.LEVEL_ZONE_STATE[12][2] || this.is_showMissionItem) {
                        this.is_showMissionItem = true;
                        Player.player_MissionItem[newItemIndex] = true;
                        str_index = 96;
                        if (!this.effectNewItem.isPlaying()) {
                            boolean bl = this.is_startEffItem = !this.is_startEffItem;
                            if (!this.is_startEffItem) {
                                ++this.step_result;
                            }
                            this.effectNewItem.setAnimation(0);
                            this.effectNewItem.setLoopOffset(-1);
                        }
                    } else {
                        newItemIndex = -1;
                        this.step_result = 7;
                    }
                    if (Constant.index_newHideLevel != 12) break;
                    Constant.index_newHideLevel = -1;
                    Constant.index_newHideLevelStart = -1;
                    break;
                }
                case 14: {
                    newItemIndex = 5;
                    if (!(nameLevel < 4 || Player.player_MissionItem[newItemIndex] && Constant.LEVEL_ZONE_STATE[14][2] && !this.is_showMissionItem)) {
                        this.is_showMissionItem = true;
                        Player.player_MissionItem[newItemIndex] = true;
                        str_index = 98;
                        if (!this.effectNewItem.isPlaying()) {
                            boolean bl = this.is_startEffItem = !this.is_startEffItem;
                            if (!this.is_startEffItem) {
                                ++this.step_result;
                            }
                            this.effectNewItem.setAnimation(0);
                            this.effectNewItem.setLoopOffset(-1);
                        }
                    } else {
                        newItemIndex = -1;
                        this.step_result = 7;
                    }
                    if (!Player.player_MissionItem[5] || Constant.LEVEL_ZONE_STATE[15][0] && Constant.LEVEL_ZONE_STATE[15][2]) break;
                    Constant.index_newHideLevel = 15;
                    Constant.index_newHideLevelStart = Constant.indexOfLevel;
                    Constant.LEVEL_ZONE_STATE[15][0] = true;
                    break;
                }
                case 16: {
                    boolean is_unlockAll = true;
                    is_unlockAll = Constant.LEVEL_ZONE_STATE[3][0] && Constant.LEVEL_ZONE_STATE[9][0] && Constant.LEVEL_ZONE_STATE[12][0] && Constant.LEVEL_ZONE_STATE[15][0];
                    newItemIndex = 6;
                    if (nameLevel >= 5 && is_unlockAll && (!Player.player_MissionItem[newItemIndex] || !Constant.LEVEL_ZONE_STATE[16][2] || this.is_showMissionItem)) {
                        this.is_showMissionItem = true;
                        Player.player_MissionItem[newItemIndex] = true;
                        str_index = 99;
                        if (this.effectNewItem.isPlaying()) break;
                        boolean bl = this.is_startEffItem = !this.is_startEffItem;
                        if (!this.is_startEffItem) {
                            ++this.step_result;
                        }
                        this.effectNewItem.setAnimation(0);
                        this.effectNewItem.setLoopOffset(-1);
                        break;
                    }
                    newItemIndex = -1;
                    this.step_result = 7;
                    break;
                }
                case 3: 
                case 15: 
                case 18: {
                    if (Constant.index_newHideLevel == 3 || Constant.index_newHideLevel == 15 || Constant.index_newHideLevel == 18) {
                        Constant.index_newHideLevel = -1;
                        Constant.index_newHideLevelStart = -1;
                    }
                    this.step_result = 7;
                    break;
                }
                default: {
                    this.step_result = 7;
                }
            }
            boolean is_collectAll = true;
            for (int i = 0; i < Player.player_MissionItem.length; ++i) {
                if (Player.player_MissionItem[i]) continue;
                is_collectAll = false;
                break;
            }
            if (!(!is_collectAll || Constant.indexOfLevel == 18 || Constant.LEVEL_ZONE_STATE[18][0] && Constant.LEVEL_ZONE_STATE[18][2])) {
                Constant.index_newHideLevel = 18;
                Constant.index_newHideLevelStart = 17;
                Constant.LEVEL_ZONE_STATE[18][0] = true;
            }
            temp_nRunStringY = background_y + 215;
            temp_nMissionY = 0;
            switch (320) {
                case 204: 
                case 208: {
                    temp_nRunStringY = background_y + 190;
                    temp_nMissionY = -17;
                    break;
                }
                case 220: {
                    temp_nRunStringY = background_y + 194;
                    temp_nMissionY = -17;
                    break;
                }
                case 240: {
                    temp_nRunStringY = background_y + 180;
                    temp_nMissionY = -30;
                    break;
                }
                case 360: {
                    temp_nRunStringY = background_y + 230;
                }
            }
            GameDialog.runSingleLineRollTip(g, MainCanvas.lang[str_index], -1, background_x + 10, temp_nRunStringY, 240 - (background_x + 10 << 1));
            if (newItemIndex != -1) {
                int icon_size = 14;
                g.setClip(background_x + tmp_nOffSetX + 39, background_y + 192 + temp_nMissionY, icon_size, icon_size);
                g.drawImage(GameScene.getPlayer().img_missionItem, background_x + tmp_nOffSetX + 39 - newItemIndex % 3 * icon_size, background_y + 192 - newItemIndex / 3 * icon_size + temp_nMissionY, 20);
            }
            if (this.step_result == 6 && this.effectNewItem.isPlaying()) {
                GraphicsTool.restClip(g);
                this.effectNewItem.drawFrame(g, background_x + tmp_nOffSetX + 45, background_y + 200 + temp_nMissionY);
                this.effectNewItem.update();
            }
        }
        if (this.step_result >= 7) {
            ScenePublic.drawBottomIconCN(g, -1, true, (byte)1, false, (byte)3);
        }
    }

    private int initViewableArea(int background_y) {
        int tmp_nStepResult = 50;
        block0 : switch (320) {
            case 204: {
                break;
            }
            case 208: 
            case 220: {
                switch (this.step_result) {
                    case 0: {
                        tmp_nStepResult = 40 - background_y;
                        break block0;
                    }
                    case 1: {
                        tmp_nStepResult = 58 - background_y;
                        break block0;
                    }
                    case 2: {
                        tmp_nStepResult = 75 - background_y;
                        break block0;
                    }
                    case 3: {
                        tmp_nStepResult = 95 - background_y;
                        break block0;
                    }
                    case 4: {
                        tmp_nStepResult = 120 - background_y;
                        break block0;
                    }
                    case 5: {
                        tmp_nStepResult = 150 - background_y;
                        break block0;
                    }
                    case 6: {
                        tmp_nStepResult = 195 - background_y;
                        break block0;
                    }
                }
                tmp_nStepResult = 220 - background_y;
                break;
            }
            case 240: {
                switch (this.step_result) {
                    case 0: {
                        tmp_nStepResult = 75 - background_y;
                        break block0;
                    }
                    case 1: {
                        tmp_nStepResult = 90 - background_y;
                        break block0;
                    }
                    case 2: {
                        tmp_nStepResult = 105 - background_y;
                        break block0;
                    }
                    case 3: {
                        tmp_nStepResult = 128 - background_y;
                        break block0;
                    }
                    case 4: {
                        tmp_nStepResult = 146 - background_y;
                        break block0;
                    }
                    case 5: {
                        tmp_nStepResult = 176 - background_y;
                        break block0;
                    }
                    case 6: {
                        tmp_nStepResult = 225 - background_y;
                        break block0;
                    }
                }
                tmp_nStepResult = 240 - background_y;
                break;
            }
            case 320: {
                switch (this.step_result) {
                    case 0: {
                        tmp_nStepResult = 52;
                        break block0;
                    }
                    case 1: {
                        tmp_nStepResult = 70;
                        break block0;
                    }
                    case 2: {
                        tmp_nStepResult = 90;
                        break block0;
                    }
                    case 3: {
                        tmp_nStepResult = 115;
                        break block0;
                    }
                    case 4: {
                        tmp_nStepResult = 140;
                        break block0;
                    }
                    case 5: {
                        tmp_nStepResult = 170;
                        break block0;
                    }
                    case 6: {
                        tmp_nStepResult = 220;
                        break block0;
                    }
                }
                tmp_nStepResult = 250;
                break;
            }
            case 360: {
                switch (this.step_result) {
                    case 0: {
                        tmp_nStepResult = 52;
                        break block0;
                    }
                    case 1: {
                        tmp_nStepResult = 70;
                        break block0;
                    }
                    case 2: {
                        tmp_nStepResult = 90;
                        break block0;
                    }
                    case 3: {
                        tmp_nStepResult = 115;
                        break block0;
                    }
                    case 4: {
                        tmp_nStepResult = 140;
                        break block0;
                    }
                    case 5: {
                        tmp_nStepResult = 170;
                        break block0;
                    }
                    case 6: {
                        tmp_nStepResult = 220;
                        break block0;
                    }
                }
                tmp_nStepResult = 250;
            }
        }
        return tmp_nStepResult;
    }

    private void keyEvaluation() {
        if (this.is_resultTitle) {
            return;
        }
        if (KeySystem.IsKeyPressed(512) || KeySystem.IsKeyPressed(262144)) {
            if (this.step_result < 7) {
                ++this.step_result;
                this.count_result = 0;
            }
        } else if (KeySystem.IsKeyPressed(65536)) {
            int nextlevel = 0;
            if (this.step_result >= 7) {
                this.step_result = 0;
                is_boss = false;
                Constant.LEVEL_ZONE_STATE[Constant.indexOfLevel][2] = true;
                switch (Constant.indexOfLevel) {
                    case 0: {
                        nextlevel = 1;
                        break;
                    }
                    case 1: {
                        nextlevel = 2;
                        break;
                    }
                    case 2: {
                        nextlevel = 4;
                        break;
                    }
                    case 4: {
                        nextlevel = 5;
                        break;
                    }
                    case 5: {
                        nextlevel = 6;
                        break;
                    }
                    case 6: {
                        nextlevel = 7;
                        break;
                    }
                    case 7: {
                        nextlevel = 8;
                        break;
                    }
                    case 8: {
                        nextlevel = 10;
                        break;
                    }
                    case 10: {
                        nextlevel = 11;
                        break;
                    }
                    case 11: {
                        nextlevel = 13;
                        break;
                    }
                    case 13: {
                        nextlevel = 14;
                        break;
                    }
                    case 14: {
                        nextlevel = 16;
                        break;
                    }
                    case 16: {
                        nextlevel = 17;
                        break;
                    }
                    case 17: {
                        nextlevel = 19;
                        break;
                    }
                    case 3: 
                    case 9: 
                    case 12: 
                    case 15: 
                    case 18: 
                    case 19: {
                        nextlevel = -1;
                    }
                }
                if (!(nextlevel == -1 || Constant.LEVEL_ZONE_STATE[nextlevel][0] && Constant.LEVEL_ZONE_STATE[nextlevel][2])) {
                    Constant.index_newLevel = nextlevel;
                    Constant.index_newLevelStart = Constant.indexOfLevel;
                    Constant.LEVEL_ZONE_STATE[nextlevel][0] = true;
                } else if (Constant.indexOfLevel == 19) {
                    Constant.index_newLevelStart = -1;
                    Constant.index_newLevel = -1;
                }
                MusicPlayer.getInst().stopMusic();
                switch (Constant.indexOfLevel) {
                    case 0: {
                        if (Constant.index_story == 1) {
                            Constant.index_story = 2;
                            this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)2, false, true);
                            break;
                        }
                        this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)1, false, true);
                        break;
                    }
                    case 2: {
                        if (Constant.index_story == 3) {
                            Constant.index_story = 4;
                            this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)2, false, true);
                            break;
                        }
                        this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)1, false, true);
                        break;
                    }
                    case 7: {
                        if (Constant.index_story == 5) {
                            Constant.index_story = 6;
                            this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)2, false, true);
                            break;
                        }
                        this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)1, false, true);
                        break;
                    }
                    case 11: {
                        if (Constant.index_story == 7) {
                            Constant.index_story = 8;
                            this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)2, false, true);
                            break;
                        }
                        this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)1, false, true);
                        break;
                    }
                    case 16: {
                        if (Constant.index_story == 8) {
                            Constant.index_story = 9;
                            this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)2, false, true);
                            break;
                        }
                        this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)1, false, true);
                        break;
                    }
                    case 19: {
                        if (Constant.index_story == 10) {
                            Constant.index_story = 11;
                            this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)8, false, true);
                            break;
                        }
                        this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)1, false, true);
                        break;
                    }
                    default: {
                        this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)1, false, true);
                    }
                }
                MainCanvas.stream.SaveGame(this.Scene_canvas);
            }
        }
    }

    public void loadGameMap(int back, int mid, int front) {
        try {
            this.img_mapBG = GraphicsTool.loadImage("/map/map_" + back + ".png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.map_mid = mid != -1 ? new Map(this.Scene_canvas, mid, false) : null;
        this.map_front = front != -1 ? new Map(this.Scene_canvas, front, false) : null;
    }

    public static Player getPlayer() {
        if (actorPool == null) {
            return null;
        }
        if (actorPool[index_playerInPool] != null && actorPool[index_playerInPool].inUse() && actorPool[index_playerInPool].getType() == 0) {
            return (Player)actorPool[index_playerInPool];
        }
        for (int i = actorPool.length - 1; i >= 0; --i) {
            if (actorPool[i] == null || !actorPool[i].inUse() || actorPool[i].getType() != 0) continue;
            index_playerInPool = i;
            return (Player)actorPool[i];
        }
        return null;
    }

    public void openDialog(int index) {
        this.setShakeScreen(false);
        this.is_dialog = true;
        this.game_word.loadGameLang(index);
        this.game_dialog.initDialog(this.game_word.data_gamelang[GameWord.index_gamelang], this.game_word.str_gamelang, this.game_word.imgicon_gamelang);
    }

    public void endDialog() {
        this.is_dialog = false;
        this.commands.resetCommandTime();
        this.game_word.resetDialogWord();
        this.game_dialog.clearDialog();
    }

    public boolean isDialog() {
        return this.is_dialog;
    }

    public void setCurGameTime(long curFrameTime) {
        this.time_curGame = curFrameTime;
    }

    public long getCurGameTime() {
        return this.time_curGame;
    }

    public void setStopScrollBG(boolean stopScrollBG) {
        this.stopScrollBG = stopScrollBG;
    }

    public boolean isStopScrollBG() {
        return this.stopScrollBG;
    }

    public boolean isShakeScreen() {
        return this.is_shakeScreen;
    }

    public void setShakeScreen(boolean shakeScreen) {
        this.is_shakeScreen = shakeScreen;
    }

    public boolean isDarkScreen() {
        return this.is_darkScreen;
    }

    public void setDarkScreen(boolean darkScreen) {
        this.is_darkScreen = darkScreen;
    }

    public boolean isLightScreen() {
        return this.is_lightScreen;
    }

    public void setLightScreen(boolean lightScreen) {
        this.is_lightScreen = lightScreen;
    }

    public void setLightScreenOverlapEnemy(boolean lightScreenOverlapEnemy) {
        this.is_lightScreenOverlapEnemy = lightScreenOverlapEnemy;
    }

    public boolean isLightScreenOverlapEnemy() {
        return this.is_lightScreenOverlapEnemy;
    }

    public void setLevelFinished(boolean levelFinished) {
        this.is_levelFinished = levelFinished;
    }

    public boolean isLevelFinished() {
        return this.is_levelFinished;
    }

    public void setXMapFrontOffset(int xMapOffset) {
        this.MapFrontOffset_x = xMapOffset;
    }

    public int getXMapFrontOffset() {
        return this.MapFrontOffset_x;
    }

    public void setXMapFrontOffsetSpeed(int xMapOffsetSpeed) {
        this.MapFrontOffset_speed = xMapOffsetSpeed;
    }

    public int getXMapFrontOffsetSpeed() {
        return this.isStopScrollBG() ? 0 : this.MapFrontOffset_speed;
    }

    public void setXMapMidOffset(int xMapOffset) {
        this.MapMidOffset_x = xMapOffset;
    }

    public int getXMapMidOffset() {
        return this.MapMidOffset_x;
    }

    public void setXMapMidOffsetSpeed(int xMapOffsetSpeed) {
        this.MapMidOffset_speed = xMapOffsetSpeed;
    }

    public int getXMapMidOffsetSpeed() {
        return this.isStopScrollBG() ? 0 : this.MapMidOffset_speed;
    }

    public void setXMapBackOffset(int xMapOffset) {
        this.MapBackOffset_x = xMapOffset;
    }

    public int getXMapBackOffset() {
        return this.MapBackOffset_x;
    }

    public void setXMapBackOffsetSpeed(int xMapOffsetSpeed) {
        this.MapBackOffset_speed = xMapOffsetSpeed;
    }

    public int getXMapBackOffsetSpeed() {
        return this.isStopScrollBG() ? 0 : this.MapBackOffset_speed;
    }

    public PWPifLifeAnimations loadEnemyAnimationRes(int enemy_id) {
        switch (enemy_id) {
            case 29: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/QuestionsMark.aej"), 0, true);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/niutou.aej"), 0, true);
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/xiaogui.aej"), 0, true);
            }
            case 14: 
            case 15: 
            case 26: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/wuya.aej"), 0, true);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/hunv.aej"), 0, true);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/baiwuchang.aej"), 0, true);
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/snake.aej"), 0, true);
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/acaleph.aej"), 0, true);
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/xiejiang.aej"), 0, true);
            }
            case 20: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/Tie.aej"), 0, true);
            }
            case 21: 
            case 22: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/Lion.aej"), 0, true);
            }
            case 23: 
            case 24: 
            case 27: 
            case 28: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/Wugong.aej"), 0, true);
            }
            case 25: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/bajie.aej"), 0, true);
            }
            case 43: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/honghaier.aej"), 0, true);
            }
            case 44: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/bullKing.aej"), 0, true);
            }
            case 42: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/bonelady.aej"), 0, true);
            }
            case 45: {
                return new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/rulaifo.aej"), 0, true);
            }
        }
        return null;
    }

    public void resetBulletPool() {
        for (int i = 0; i < bulletPool.length; ++i) {
            if (bulletPool[i] == null || !bulletPool[i].inUse()) continue;
            bulletPool[i].setInUse(false);
        }
    }

    public String getClipImgName(String spriteName, int imageId) {
        String sImgName = null;
        if (spriteName.equals("/menu/battleUI.anu")) {
            switch (imageId) {
                case 0: {
                    sImgName = "/menu/UI_01.png";
                    break;
                }
                case 1: {
                    sImgName = "/menu/g_num_7h_white.png";
                    break;
                }
                case 2: {
                    sImgName = "/menu/UI_InFighting.png";
                    break;
                }
                case 3: {
                    sImgName = "/menu/Hero_Face.png";
                    break;
                }
                case 4: {
                    sImgName = "/menu/Tower_Lv.png";
                }
            }
        } else if (spriteName.equals("/menu/LevelResult.anu")) {
            switch (imageId) {
                case 0: {
                    sImgName = "/menu/UI_01.png";
                    break;
                }
                case 1: {
                    sImgName = "/menu/g_num_7h_white.png";
                    break;
                }
                case 2: {
                    sImgName = "/menu/text_result.png";
                    break;
                }
                case 3: {
                    sImgName = "/menu/text_result2.png";
                    break;
                }
                case 4: {
                    sImgName = "/menu/Tower_Lv.png";
                }
            }
        } else if (spriteName.equals("/menu/LevelResultFont.anu")) {
            sImgName = "/menu/Result_title.png";
        } else if (spriteName.equals("/menu/effect_EatItem.anu")) {
            switch (imageId) {
                case 0: {
                    sImgName = "/menu/Icon_Bottle.png";
                    break;
                }
                case 1: {
                    sImgName = "/menu/Effect_newskill1.png";
                    break;
                }
                case 2: {
                    sImgName = "/menu/Pop_Frame.png";
                }
            }
        } else if (spriteName.equals("/menu/effect_levelup.anu")) {
            sImgName = "/menu/Effect_levelup.png";
        } else if (spriteName.equals("/menu/effect_AddDone.anu")) {
            sImgName = "/menu/Effect_newskill1.png";
        } else if (spriteName.equals("/menu/Levelup.anu")) {
            sImgName = "/menu/levelupbg.png";
        } else if (spriteName.equals("/game/Dizzy.anu")) {
            sImgName = "/game/Status_Dizzy.png";
        } else if (spriteName.equals("/game/Confuse.anu")) {
            sImgName = "/game/Status_Confuse.png";
        } else if (spriteName.equals("/game/UI_Lose_Role.anu")) {
            sImgName = "/game/UI_WK_Gray.png";
        } else if (spriteName.equals("/menu/dialog.anu")) {
            sImgName = "/menu/dialog_material.png";
        } else if (spriteName.equals("/menu/Text_skip.anu")) {
            switch (imageId) {
                case 0: {
                    sImgName = "/menu/text_skip.png";
                    break;
                }
                case 1: {
                    sImgName = "/menu/dialog_material.png";
                }
            }
        } else if (spriteName.equals("/menu/DialogPush5.anu")) {
            sImgName = "/menu/UI_PhoneKey.png";
        }
        return sImgName;
    }
}

