/*
 * Decompiled with CFR 0.152.
 */
package HG.Tool;

import HG.Tool.TextTool;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FontManager {
    public static int ASC_WIDTH;
    public static int ASC_HEIGHT;
    public static int HZK_WIDTH;
    public static int FONT_HEIGHT;
    public static int HZK_SIZE;
    public static int ASC_SIZE;
    public static final int MARGIN = 1;
    Hashtable fontMap = new Hashtable();
    private Hashtable m_htBuffer = new Hashtable();

    public FontManager(String sFileName) {
        this.loadFont(sFileName);
    }

    private short readShort(DataInputStream dis) throws Exception {
        int nHigh;
        int nLow = dis.readByte();
        if (nLow < 0) {
            nLow += 256;
        }
        if ((nHigh = dis.readByte()) < 0) {
            nHigh += 256;
        }
        return (short)(nLow + (nHigh << 8));
    }

    private int readInt(DataInputStream dis) throws Exception {
        byte nByte1 = dis.readByte();
        byte nByte2 = dis.readByte();
        byte nByte3 = dis.readByte();
        byte nByte4 = dis.readByte();
        int nRs = nByte1 + (nByte2 << 8) + (nByte3 << 16) + (nByte4 << 24);
        return nRs;
    }

    public void loadFont(String sFileName) {
        try {
            InputStream in = this.getClass().getResourceAsStream(sFileName);
            DataInputStream dataIn = new DataInputStream(in);
            int chCnt = this.readShort(dataIn);
            HZK_WIDTH = dataIn.readByte();
            FONT_HEIGHT = dataIn.readByte();
            HZK_SIZE = this.readShort(dataIn);
            ASC_WIDTH = dataIn.readByte();
            ASC_HEIGHT = dataIn.readByte();
            ASC_SIZE = this.readShort(dataIn);
            int nDataSize = this.readInt(dataIn);
            for (int chIndex = 0; chIndex < chCnt; ++chIndex) {
                byte[] ab = new byte[]{dataIn.readByte(), dataIn.readByte()};
                String s = FontManager.getStrUnicode(ab);
                char ch = s.charAt(0);
                int chSize = HZK_SIZE;
                if (ch < '\u0080') {
                    chSize = ASC_SIZE;
                }
                byte[] chBytes = new byte[chSize];
                dataIn.read(chBytes);
                this.fontMap.put(new Character(ch), chBytes);
            }
        }
        catch (Exception ex) {
            HZK_WIDTH = TextTool.font.stringWidth("\u4e2d");
            ASC_WIDTH = TextTool.font.stringWidth("w");
            ex.printStackTrace();
        }
    }

    public byte[] getBytes(char ch) {
        return (byte[])this.fontMap.get(new Character(ch));
    }

    public static int charWidth(char ch) {
        int chWidth = HZK_WIDTH;
        if (ch <= '\u0100') {
            chWidth = ASC_WIDTH;
        }
        return chWidth;
    }

    public static int stringWidth(String string) {
        int width = 0;
        for (int i = 0; i < string.length(); ++i) {
            width += FontManager.charWidth(string.charAt(i)) + 1;
        }
        return width;
    }

    public static int alignWidth(char ch) {
        int chWidth = HZK_WIDTH;
        if (ch <= '\u0100') {
            chWidth = ASC_WIDTH - 1;
        }
        return chWidth;
    }

    public void drawChar(Graphics g, char ch, int x, int y) {
        byte[] chBytes = (byte[])this.fontMap.get(new Character(ch));
        if (chBytes == null) {
            g.setFont(TextTool.font);
            g.drawChar(ch, x, y, 20);
            return;
        }
        int chWidth = FontManager.charWidth(ch);
        int row = 0;
        int col = 0;
        int byteIndex = 0;
        int bitIndex = 0;
        byte curByte = chBytes[byteIndex];
        while (byteIndex < chBytes.length) {
            int curBit = curByte & 1 << 7 - bitIndex % 8;
            if (curBit != 0) {
                g.drawLine(x + col, y + row, x + col, y + row);
            }
            ++bitIndex;
            if (++col == chWidth) {
                col = 0;
                ++row;
            }
            if (bitIndex == 8) {
                bitIndex = 0;
                ++byteIndex;
            }
            if (byteIndex >= chBytes.length) break;
            curByte = chBytes[byteIndex];
        }
    }

    public void showFont(byte[] fontBytes, int fontWidth) {
        StringBuffer buf = new StringBuffer();
        int byteIndex = 0;
        int curBitIndex = 0;
        int curByte = fontBytes[byteIndex] & 0xFF;
        while (byteIndex < fontBytes.length) {
            int curBit = curByte & 1 << 7 - curBitIndex % 8;
            if (curBit != 0) {
                buf.append("1");
            } else {
                buf.append(" ");
            }
            if (++curBitIndex == fontWidth) {
                curBitIndex = 0;
                buf.append("\n");
                curBitIndex = 0;
                if (++byteIndex >= fontBytes.length) break;
                curByte = fontBytes[byteIndex] & 0xFF;
                continue;
            }
            if (curBitIndex != 8) continue;
            if (++byteIndex >= fontBytes.length) break;
            curByte = fontBytes[byteIndex] & 0xFF;
        }
    }

    public void drawString(Graphics g, String txt, int x, int y) {
        if (txt == null) {
            return;
        }
        for (int chIndex = 0; chIndex < txt.length(); ++chIndex) {
            char ch = txt.charAt(chIndex);
            this.drawChar(g, ch, x, y);
            x += FontManager.alignWidth(ch) + 1;
        }
    }

    public void ClearHashtable() {
        this.m_htBuffer.clear();
    }

    public void drawMsgBuffer(Graphics g2, String str, int x, int y, int w, int h, boolean bGross) {
        if (str == null) {
            return;
        }
        Image imgBuffer = (Image)this.m_htBuffer.get(str + "_" + w);
        if (imgBuffer != null) {
            g2.drawImage(imgBuffer, x, y, 0);
            return;
        }
        imgBuffer = Image.createImage((int)(w + 2), (int)h);
        int nColor = g2.getColor();
        Graphics g = imgBuffer.getGraphics();
        g.setColor(0xFF00FF);
        g.fillRect(0, 0, imgBuffer.getWidth(), imgBuffer.getHeight());
        g.setColor(nColor);
        int nWordCntInLine = w / HZK_WIDTH - 1;
        int nLineCnt = FontManager.ceiling(str.length(), nWordCntInLine);
        int nLineH = FONT_HEIGHT + 4;
        int nTopMargin = (h - nLineCnt * nLineH) / 2;
        int nBufferX = 1;
        int nBufferY = 1;
        nBufferY += nTopMargin;
        for (int i = 0; i < nLineCnt; ++i) {
            String s = "";
            s = i < nLineCnt - 1 ? str.substring(i * nWordCntInLine, (i + 1) * nWordCntInLine) : str.substring(i * nWordCntInLine);
            if (bGross) {
                g.setColor(0);
                this.drawString(g, s, nBufferX + 1, nBufferY);
                this.drawString(g, s, nBufferX, nBufferY + 1);
                this.drawString(g, s, nBufferX - 1, nBufferY);
                this.drawString(g, s, nBufferX, nBufferY - 1);
                g.setColor(0xFFFFFF);
                this.drawString(g, s, nBufferX, nBufferY);
            } else {
                g.setColor(0);
                this.drawString(g, s, nBufferX + 1, nBufferY + 1);
                g.setColor(0xFFFFFF);
                this.drawString(g, s, nBufferX, nBufferY);
            }
            nBufferY += nLineH;
        }
        g2.drawImage(imgBuffer, x, y, 0);
        this.m_htBuffer.put(str + "_" + w, imgBuffer);
    }

    public void drawMsgWithFont(Graphics g, String str, int x, int y, int w, int h, boolean bGross) {
        if (str == null) {
            return;
        }
        int nWordCntInLine = w / HZK_WIDTH - 1;
        int nLineCnt = FontManager.ceiling(str.length(), nWordCntInLine);
        int nLineH = FONT_HEIGHT + 4;
        int nTopMargin = (h - nLineCnt * nLineH) / 2;
        y += nTopMargin;
        for (int i = 0; i < nLineCnt; ++i) {
            String s = "";
            s = i < nLineCnt - 1 ? str.substring(i * nWordCntInLine, (i + 1) * nWordCntInLine) : str.substring(i * nWordCntInLine);
            if (bGross) {
                g.setColor(0);
                this.drawString(g, s, x + 1, y);
                this.drawString(g, s, x, y + 1);
                this.drawString(g, s, x - 1, y);
                this.drawString(g, s, x, y - 1);
                g.setColor(0xFFFFFF);
                this.drawString(g, s, x, y);
            } else {
                g.setColor(0);
                this.drawString(g, s, x + 1, y + 1);
                g.setColor(0xFFFFFF);
                this.drawString(g, s, x, y);
            }
            y += nLineH;
        }
    }

    public void drawGrossString(Graphics g, String txt, int x, int y, int anchor, int nBgColor, int nFgColor) {
        g.setColor(nBgColor);
        this.drawString(g, txt, x + 1, y + 1, anchor);
        g.setColor(nFgColor);
        this.drawString(g, txt, x, y, anchor);
    }

    public void drawString(Graphics g, String txt, int x, int y, int anchor) {
        int w;
        int nOffset = 5;
        if ((anchor & 8) == 8) {
            w = FontManager.stringWidth(txt);
            x -= w;
        }
        if ((anchor & 0x20) == 32) {
            y -= FONT_HEIGHT;
        }
        if ((anchor & 1) == 1) {
            w = FontManager.stringWidth(txt);
            x -= w / 2;
        }
        this.drawString(g, txt, x, y);
    }

    public static String getStrUnicode(byte[] word_uni) {
        StringBuffer stringbuffer = new StringBuffer("");
        int j = 0;
        while (j < word_uni.length) {
            int l;
            int k;
            if ((k = word_uni[j++]) < 0) {
                k += 256;
            }
            if ((l = word_uni[j++]) < 0) {
                l += 256;
            }
            char c = (char)(k + (l << 8));
            stringbuffer.append(c);
        }
        String strReturn = stringbuffer.toString();
        return strReturn;
    }

    public static int ceiling(int divisor, int dividend) {
        int result = divisor / dividend;
        int product = result * dividend;
        if (product < divisor) {
            return result + 1;
        }
        return result;
    }
}

