/*
 * Decompiled with CFR 0.152.
 */
package HG.Tool;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class MusicPlayer {
    public static final byte m_nMaxSoundVolume = 100;
    public static final byte m_nMinSoundVolume = 0;
    private int m_nCurrSoundVolumeIndex = 50;
    private Player m_apPlayer = null;
    public String m_sMusicName = null;
    private static MusicPlayer m_instance;

    private MusicPlayer() {
    }

    public static MusicPlayer getInst() {
        if (m_instance == null) {
            m_instance = new MusicPlayer();
        }
        return m_instance;
    }

    public void loadMusic(String sMusicName) {
        this.m_sMusicName = sMusicName;
        if (this.m_nCurrSoundVolumeIndex != 0) {
            try {
                String sMimeType = "audio/midi";
                if (sMusicName.indexOf(".wav") > -1) {
                    sMimeType = "audio/wav";
                } else if (sMusicName.indexOf(".amr") > -1) {
                    sMimeType = "audio/amr";
                }
                this.m_apPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(sMusicName), (String)sMimeType);
                this.m_apPlayer.realize();
                this.m_apPlayer.prefetch();
                this.m_apPlayer.setLoopCount(-1);
                this.setMusicVolume(this.m_nCurrSoundVolumeIndex);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
    }

    public int getMusicVolume() {
        return this.m_nCurrSoundVolumeIndex;
    }

    public void setMusicVolume(int VolumeIndex) {
        if (VolumeIndex > 100) {
            VolumeIndex = 100;
        }
        if (VolumeIndex < 0) {
            VolumeIndex = 0;
        }
        this.m_nCurrSoundVolumeIndex = VolumeIndex;
        if (this.m_apPlayer == null) {
            return;
        }
        VolumeControl vc = (VolumeControl)this.m_apPlayer.getControl("VolumeControl");
        vc.setLevel(VolumeIndex);
    }

    public void checkMusicStat() {
        if (this.m_apPlayer == null) {
            return;
        }
        if (this.m_apPlayer.getState() > 0) {
            if (this.m_apPlayer.getState() < 400) {
                this.playMusic();
            }
        }
    }

    public int getPlayerStatus() {
        if (this.m_apPlayer == null) {
            return 9999;
        }
        return this.m_apPlayer.getState();
    }

    public void playMusic() {
        if (this.m_sMusicName == null) {
            return;
        }
        this.playMusic(this.m_sMusicName);
    }

    public void playMusic(String sMusicName) {
        this.playMusic(sMusicName, -1, this.m_nCurrSoundVolumeIndex);
    }

    public void playMusic(String sMusicName, int VolumeIndex) {
        this.playMusic(sMusicName, -1, VolumeIndex);
    }

    public void playMusic(String sMusicName, int nLoopCnt, int VolumeIndex) {
        if (VolumeIndex > 100) {
            VolumeIndex = 100;
        }
        if (VolumeIndex < 0) {
            VolumeIndex = 0;
        }
        if (VolumeIndex == 0) {
            return;
        }
        this.m_sMusicName = sMusicName;
        try {
            if (this.m_apPlayer == null) {
                this.pauseMusic();
                String sMimeType = "audio/midi";
                if (sMusicName.indexOf(".wav") > -1) {
                    sMimeType = "audio/wav";
                } else if (sMusicName.indexOf(".amr") > -1) {
                    sMimeType = "audio/amr";
                }
                this.m_apPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(sMusicName), (String)sMimeType);
                this.m_apPlayer.prefetch();
                this.m_apPlayer.setLoopCount(nLoopCnt);
            }
            VolumeControl vc = (VolumeControl)this.m_apPlayer.getControl("VolumeControl");
            vc.setLevel(VolumeIndex);
            this.m_nCurrSoundVolumeIndex = VolumeIndex;
            this.m_apPlayer.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean SoundOn() {
        if (this.m_apPlayer == null) {
            return false;
        }
        return this.m_nCurrSoundVolumeIndex != 0;
    }

    public void pauseMusic() {
        try {
            if (this.m_apPlayer != null) {
                this.m_apPlayer.close();
                this.m_apPlayer = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stopMusic() {
        this.m_sMusicName = null;
        try {
            if (this.m_apPlayer != null) {
                this.m_apPlayer.close();
                this.m_apPlayer = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

