/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public final class GameMap {
    static final int TILE_PASS = 0;
    static int SCREEN_WIDTH;
    static int SCREEN_HEIGHT;
    static byte tileWidth;
    static byte tileHight;
    static int[] mapSize;
    short[] tileProperties;
    String[] name;
    static int setOffX;
    static int setOffY;
    short roleY;
    short roleX;
    byte boardXSpeed;
    byte boardYSpeed;
    byte[] mapData;
    byte gameRank;
    short[][] deckData;
    static int shakeTime;
    int mapID;
    String mapName;
    String fileName;
    int weather;
    String music;
    static short bg;
    int BGM;
    int mapW;
    int mapH;
    int mapLen;
    short[] deck = new short[]{125, 122, 121, 124, 136, 126, 127, 128, 129, 130, 131, 137, 133, 132, 135, 123, 134, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 152, 151, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 170, 167, 166, 168, 169, 175, 172, 173, 174, 171, 176, 177, 178, 179, 201};
    static int flagMap;
    static int flagX;
    static int flagY;
    public static int[][] starPos;
    public static int[][] starSpeed;
    public static byte STARNUM;
    int[] type;
    static byte[][] imgDat_cloud;
    public static int sceen_minX;
    public static int sceen_maxX;
    public static int sceen_minY;
    public static int sceen_maxY;
    public static final byte SCEEN_MOVE = 10;
    static int adjustX;
    static int adjustY;
    static boolean isMoveScreen;
    static int autoMapV;
    static Event event;
    static String command;

    public void free() {
        this.mapData = null;
        this.deckData = null;
        System.gc();
    }

    public GameMap(int sw, int sh) {
        SCREEN_WIDTH = sw;
        SCREEN_HEIGHT = sh;
        GameMap.setOff(0, 0);
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    public static void screenShake() {
        if (shakeTime == 0) {
            return;
        }
        if (shakeTime > 0) {
            --shakeTime;
        }
        setOffY = GameMIDlet.gameIndex % 2 == 0 ? setOffY + 2 : setOffY - 2;
    }

    private void init(String[] dat) {
        int i = 0;
        while (i < dat.length) {
            String[] param = Event.splitString(dat[i], " ");
            if (param[0].equals("name")) {
                this.mapName = param[1];
            } else if (param[0].equals("dat")) {
                this.fileName = param[1];
            } else if (param[0].equals("weather")) {
                this.weather = Event.sToi(param[1]);
            } else if (param[0].equals("music")) {
                this.music = param[1];
            } else if (param[0].equals("battleBg")) {
                bg = (short)Event.sToi(param[1]);
            } else if (param[0].equals("BGM")) {
                this.BGM = Event.sToi(param[1]);
            }
            ++i;
        }
    }

    public void initMap() {
        this.free();
        this.init(Script.mapProperty);
        this.loadMap(this.fileName);
        this.mapW = tileWidth * mapSize[0];
        this.mapH = tileHight * mapSize[1];
        this.mapLen = this.mapData.length;
        String[] temp = new String[]{"map01.dat", "map02.dat", "map03.dat", "map05.dat", "map06.dat", "map07.dat", "map08.dat", "map09.dat", "map10.dat", "map11.dat", "map12.dat", "map13.dat", "map14.dat", "map15.dat", "map16.dat", "map19.dat", "map20.dat", "map21.dat", "map22.dat", "map23.dat", "map24.dat", "map25.dat", "map26.dat", "map27.dat", "map28.dat", "map31.dat"};
        int clipType = 1;
        int i = 0;
        while (i < temp.length) {
            if (this.fileName.equals(temp[i])) {
                clipType = 0;
            }
            ++i;
        }
        Tools.createImage(this.name, 1, clipType);
        GameMap.unLockSceen();
        autoMapV = -1;
        sceen_minY = 0;
        this.deckData = GameEngine.readPosData("/deck/" + this.fileName);
        if (bg == 0) {
            this.initStar();
        }
    }

    public void setTile() {
        int n = setOffX / tileWidth * mapSize[1] + setOffY / tileHight;
        int nw = SCREEN_WIDTH / tileWidth + 2;
        int nh = SCREEN_HEIGHT / tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * mapSize[1];
            while (i < s + nh) {
                if (i < this.mapData.length && i >= 0 && this.mapData[i] != -1) {
                    int dataTemp = GameMap.getLow(this.mapData[i]);
                    int x = i / mapSize[1] * tileHight;
                    int y = i % mapSize[1] * tileWidth;
                    byte trans = (byte)GameMap.getTrans(this.mapData[i]);
                    Tools.addObject(300 + dataTemp, x, y, 0, 0, tileWidth, tileHight, 20, trans, 0);
                }
                ++i;
            }
            ++j;
        }
    }

    public void setMap(Graphics g) {
        switch (GameEngine.gameRank) {
            case 61: {
                Tools.addObject(53, 0, 0, 20, (byte)0, 0);
                break;
            }
            default: {
                if (GameEngine.flashTime > 0) {
                    Tools.addObject((byte)1, setOffX, setOffY, SCREEN_WIDTH, SCREEN_HEIGHT, true, 20, 0, 0);
                    --GameEngine.flashTime;
                } else {
                    this.setMapBG();
                }
                if (this.mapData == null) break;
                this.setTile();
            }
        }
        this.drawDeck();
        this.drawTaskFlag(0);
        this.setMapFG();
    }

    public void drawDeck() {
        if (this.deckData == null) {
            return;
        }
        int i = 0;
        while (i < this.deckData.length) {
            switch (this.deckData[i][0]) {
                case 32: {
                    Tools.addObject(this.deck[this.deckData[i][0]], this.deckData[i][1], this.deckData[i][2], 36, (byte)this.deckData[i][3], 0);
                    Tools.addObject(202, this.deckData[i][1] + 1, this.deckData[i][2] - 27, 30 * ((GameMIDlet.gameIndex + i) % 4), 0, 30, 38, 36, (byte)this.deckData[i][3], 0);
                    break;
                }
                case 40: {
                    Tools.addObject(this.deck[this.deckData[i][0]], this.deckData[i][1], this.deckData[i][2] - 5, 36, (byte)this.deckData[i][3], 0);
                    int temp = (GameMIDlet.gameIndex + i) % 6;
                    if (temp >= 5) break;
                    Tools.addObject(203, this.deckData[i][1] + 3, this.deckData[i][2] - 5 - 4, 11 * temp, 0, 11, 24, 36, (byte)this.deckData[i][3], 0);
                    break;
                }
                case 59: {
                    Tools.addObject(this.deck[this.deckData[i][0]], this.deckData[i][1], this.deckData[i][2], GameMIDlet.gameIndex % 6 / 2 * 24, 0, 24, 58, 36, (byte)this.deckData[i][3], 0);
                    break;
                }
                default: {
                    Tools.addObject(this.deck[this.deckData[i][0]], this.deckData[i][1], this.deckData[i][2], 36, (byte)this.deckData[i][3], 0);
                }
            }
            ++i;
        }
    }

    public void setMapBG() {
        switch (bg) {
            case 0: {
                GameMap.drawFullScreenBG(2, setOffY, 80, 0, true, 20);
                GameMap.drawFullScreenBG(1, setOffY + SCREEN_HEIGHT, 40, 0, true, 36);
                break;
            }
            case 1: {
                GameMap.drawFullScreenBG(4, setOffY, 80, 0, true, 20);
                GameMap.drawFullScreenBG(3, setOffY, 40, 0, true, 20);
                break;
            }
            case 2: {
                GameMap.drawFullScreenBG(6, setOffY, 80, 0, true, 20);
                GameMap.drawFullScreenBG(5, setOffY, 40, 0, true, 20);
                break;
            }
            case 3: {
                GameMap.drawFullScreenBG(8, setOffY, 80, 0, true, 20);
                GameMap.drawFullScreenBG(7, setOffY + SCREEN_HEIGHT, 40, 0, true, 36);
                break;
            }
            case 4: {
                GameMap.drawFullScreenBG(10, setOffY, 80, 0, true, 20);
                GameMap.drawFullScreenBG(9, setOffY + SCREEN_HEIGHT, 40, 0, true, 36);
                break;
            }
            case 5: {
                GameMap.drawFullScreenBG(14, setOffY, 90, 0, true, 20);
                GameMap.drawFullScreenBG(13, setOffY + SCREEN_HEIGHT - 94, 80, 0, true, 36);
                GameMap.drawFullScreenBG(12, setOffY + SCREEN_HEIGHT - 26, 40, 0, true, 36);
                GameMap.drawFullScreenBG(11, setOffY + SCREEN_HEIGHT, 20, 0, true, 36);
                break;
            }
            default: {
                Tools.addObject((byte)1, setOffX, setOffY, SCREEN_WIDTH, SCREEN_HEIGHT, 20, 0, 0);
            }
        }
    }

    public void drawTaskFlag(int lev) {
        if (flagMap == -1 || GameEngine.gameRank != flagMap) {
            return;
        }
        Tools.addObject(194, flagX + tileWidth / 2 - 5, flagY, 11 * (GameMIDlet.gameIndex % 4 / 2), 0, 11, 27, 36, (byte)0, lev);
    }

    public void setMapFG() {
        switch (bg) {
            case 0: {
                this.drawStar();
            }
        }
    }

    public void drawCloud(int img, int level) {
        int i = 0;
        while (i < 2) {
            Tools.addObject(img, setOffX - GameMIDlet.gameIndex % SCREEN_WIDTH + i * SCREEN_WIDTH, setOffY + SCREEN_HEIGHT, 36, (byte)0, level);
            ++i;
        }
    }

    public static void drawFullScreenBG(int imgIndex, int y, int speed, int level, boolean isTransNone, int anchor) {
        int imgW = Tools.getImage(imgIndex).getWidth();
        int times = SCREEN_WIDTH / imgW + 2;
        int startPos = setOffX * speed / 100;
        while (setOffX - startPos >= imgW) {
            startPos += imgW;
        }
        int i = 0;
        while (i < times) {
            Tools.addObject(imgIndex, startPos + i * imgW, y, anchor, isTransNone ? (byte)0 : 1, level);
            ++i;
        }
    }

    public static int random(int r) {
        return (GameEngine.rnd.nextInt() >>> 1) % r;
    }

    public void initStar() {
        starPos = new int[STARNUM][2];
        starSpeed = new int[STARNUM][2];
        this.type = new int[STARNUM];
        int i = 0;
        while (i < STARNUM) {
            GameMap.starPos[i][0] = setOffX + GameMap.random(240) + 240;
            GameMap.starPos[i][1] = setOffY + GameMap.random(mapSize[1] * tileHight);
            GameMap.starSpeed[i][0] = Event.getRandom(5, 10);
            GameMap.starSpeed[i][1] = 0;
            this.type[i] = GameMap.random(2);
            ++i;
        }
    }

    public void drawStar() {
        int i = 0;
        while (i < STARNUM) {
            int[] nArray = starPos[i];
            nArray[0] = nArray[0] - starSpeed[i][0];
            Tools.addObject(17, starPos[i][0], starPos[i][1], imgDat_cloud[this.type[i]], 20, (byte)0, 100);
            if (starPos[i][0] < setOffX - 200) {
                GameMap.starPos[i][0] = setOffX + GameMap.random(240) + 240;
                GameMap.starPos[i][1] = setOffY + GameMap.random(mapSize[1] * tileHight);
                GameMap.starSpeed[i][0] = Event.getRandom(5, 10);
                this.type[i] = GameMap.random(2);
            }
            ++i;
        }
    }

    public static void lockSceen(int x1, int x2) {
        sceen_minX = x1;
        sceen_maxX = x2;
    }

    public static void unLockSceen() {
        sceen_minX = 0;
        sceen_maxX = mapSize[0] * tileWidth;
    }

    public static void adjustSrceen(int x, int y, boolean isLeft) {
        adjustX = isLeft ? 100 : 75;
        adjustY = 220;
        setOffX = (short)(x - adjustX);
        setOffX = (short)Math.max(setOffX, 0);
        setOffX = (short)Math.min(setOffX, mapSize[0] * tileWidth - SCREEN_WIDTH);
        setOffY = (short)(y - adjustY);
        setOffY = (short)Math.min(setOffY, mapSize[1] * tileHight - SCREEN_HEIGHT);
        setOffY = (short)Math.max(setOffY, 0);
    }

    public void moveSrceen(int x, int y, boolean isLeft) {
        if (autoMapV != -1) {
            setOffY += autoMapV;
            setOffY = (short)Math.min(setOffY, mapSize[1] * tileHight - SCREEN_HEIGHT);
            sceen_minY = setOffY = (int)((short)Math.max(setOffY, 0));
            return;
        }
        if (GameEngine.isToPoint) {
            adjustX = SCREEN_WIDTH / 2;
            adjustY = SCREEN_HEIGHT / 2;
        } else {
            adjustX = isLeft ? 100 : 75;
            adjustY = 220;
        }
        setOffX = Math.abs(x - setOffX - adjustX) > 10 ? (x - setOffX - adjustX >= 10 ? (setOffX += 10) : (setOffX -= 10)) : (int)((short)(x - adjustX));
        setOffX = (short)Math.max(setOffX, sceen_minX);
        setOffX = (short)Math.min(setOffX, sceen_maxX - SCREEN_WIDTH);
        setOffX = (short)Math.max(setOffX, 0);
        setOffX = (short)Math.min(setOffX, mapSize[0] * tileWidth - SCREEN_WIDTH);
        setOffY = Math.abs(y - setOffY - adjustY) > 10 ? (y - setOffY - adjustY >= 10 ? (setOffY += 10) : (setOffY -= 10)) : (int)((short)(y - adjustY));
        setOffY = (short)Math.min(setOffY, mapSize[1] * tileHight - SCREEN_HEIGHT);
        setOffY = (short)Math.max(setOffY, 0);
        if (isMoveScreen && this.checkMoveScreen(x, y)) {
            isMoveScreen = false;
            GameMap.finish();
        }
        GameMap.screenShake();
    }

    public boolean checkMoveScreen(int x, int y) {
        short tempx = (short)(x - adjustX);
        tempx = (short)Math.min(tempx, mapSize[0] * tileWidth - SCREEN_WIDTH);
        tempx = (short)Math.max(tempx, 0);
        short tempy = (short)(y - adjustY);
        tempy = (short)Math.max(tempy, 0);
        tempy = (short)Math.min(tempy, mapSize[1] * tileHight - SCREEN_HEIGHT);
        return setOffX == tempx && setOffY == tempy;
    }

    public static void sender(Event e, String cmd) {
        event = e;
        command = cmd;
    }

    public static void finish() {
        if (event != null) {
            event.setEnd(command);
            event = null;
            command = null;
        }
    }

    public boolean canUp(int x, int y) {
        return this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)13);
    }

    public final boolean canFall(int x, int y) {
        if (this.mapData == null) {
            return true;
        }
        return this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)14);
    }

    public boolean canRun(int x, int y) {
        if (this.mapData == null) {
            return true;
        }
        return this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)15);
    }

    public boolean canSlant_RIGHT(int x, int y) {
        if (this.mapData == null || this.inMapData(x, y) == -1) {
            return false;
        }
        return Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)12) && GameMap.getTrans(this.inMapData(x, y)) == 0;
    }

    public boolean canSlant_LEFT(int x, int y) {
        if (this.mapData == null || this.inMapData(x, y) == -1) {
            return false;
        }
        return Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)12) && GameMap.getTrans(this.inMapData(x, y)) == 1;
    }

    public final boolean isLadder(int x, int y) {
        if (this.mapData == null) {
            return false;
        }
        byte v = this.inMapData(x, y);
        if (v == -1) {
            return false;
        }
        return Tools.getProperties(this.tileProperties[GameMap.getLow(v)], (byte)11);
    }

    private byte inMapData(int x, int y) {
        if (x < 0 || x > this.mapW || y < 0 || y > this.mapH) {
            return -1;
        }
        int n = x / tileWidth * mapSize[1] + y / tileHight;
        if (n < 0 || n >= this.mapLen) {
            return -1;
        }
        return this.mapData[n];
    }

    public static int getTrans(int v) {
        return v >> 6 & 3;
    }

    public static int get2nd(int v) {
        return v << 1 >> 7 & 1;
    }

    public static int getLow(int v) {
        return v & 0x3F;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public void loadMap(String file) {
        this.mapData = null;
        this.tileProperties = null;
        DataInputStream in = new DataInputStream(this.getClass().getResourceAsStream("/mapDat/" + file));
        if (in == null) {
            return;
        }
        try {
            GameMap.mapSize[0] = Tools.bToi(in.readByte());
            GameMap.mapSize[1] = Tools.bToi(in.readByte());
            tileWidth = in.readByte();
            tileHight = in.readByte();
            int size = mapSize[0] * mapSize[1];
            this.mapData = new byte[size];
            in.read(this.mapData);
            int len = in.readShort();
            this.name = new String[len];
            this.tileProperties = new short[len];
            int i = 0;
            while (i < len) {
                byte nameLen = in.readByte();
                byte[] names = new byte[nameLen];
                in.read(names);
                this.name[i] = new String(names);
                this.tileProperties[i] = in.readShort();
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        mapSize = new int[2];
        flagMap = -1;
        STARNUM = (byte)4;
        imgDat_cloud = new byte[][]{{0, 0, 86, 40}, {86, 0, 60, 30}};
        autoMapV = -1;
    }
}

