/*
 * Decompiled with CFR 0.152.
 */
public class GameSprite {
    GameEngine engine;
    public static final byte RoadLine = 5;
    public static final int tileW = 24;
    public static final byte g = 10;
    public byte mirror;
    public byte step;
    int x;
    int y;
    int sx;
    int sy;
    int lx;
    int rx;
    int dy;
    int dir;
    int nextDir;
    int faceDir;
    int nextFaceDir;
    short w;
    short h;
    int curStates;
    int nextStates;
    int curIndex;
    int index;
    boolean isMotion = false;
    short imgIndex;
    boolean isPass;
    int ID;
    String name;
    int type;
    int mode;
    byte[] motion;
    static byte ROLE_MAX = (byte)44;
    static byte[][][] clipDat = new byte[ROLE_MAX][][];
    static byte[][][] frameDat = new byte[ROLE_MAX][][];
    static byte[][][] indent = new byte[ROLE_MAX][][];
    public byte speedX;
    public byte speedY;
    public byte ax;
    public byte ay;
    public int disX;
    public int disY;
    public int level = 1;
    public int hp;
    public int hp_max;
    public int mp;
    public int mp_max;
    public int collect;
    public int attack;
    public int defend;
    public int flash;
    public int allAtt;
    public int allDef;
    public int allFlash;
    public int allHp;
    public int allCollect;
    int getExp;
    int getMoney;
    public int exp;
    public int exp_max;
    public byte[] equips = new byte[]{-1, -1, -1};
    public byte[] skills;
    boolean isMirror;
    boolean isDead;
    boolean nextIsDead;
    short[] attArea = new short[4];
    public static final byte ST_STOP = 0;
    public static final byte ST_MOVE = 1;
    public static final byte ST_JUMP = 2;
    public static final byte ST_ATTACK = 3;
    public static final byte ST_DECLINE = 4;
    public static final byte ST_DEAD = 5;
    public static final byte ST_LEVELUP = 6;
    public static final byte ST_CUSHION = 7;
    public static final byte ST_SQUAT = 8;
    public static final byte ST_SKILL = 9;
    public static final byte ST_CALL = 10;
    public static final byte ST_JUMP_ATT = 14;
    public static final byte ST_INJURE = 15;
    public static final byte ST_DISAPPEAR = 16;
    public static final byte ST_APPEAR = 17;
    public static final byte ST_NULL = 18;
    public static final byte ST_DOWN = 19;
    public static final byte ST_UP = 20;
    public static final byte ST_WAIT = 21;
    public static final byte ST_INJURE2 = 22;
    public static final byte ST_REST = 23;
    public static final byte ST_FLOAT = 24;
    public static final byte ST_SKILL1 = 25;
    public static final byte ST_SKILL2 = 26;
    public static final byte ST_SKILL3 = 27;
    public static final byte ST_SMALLER = 28;
    public static final byte ST_SMALL = 29;
    public static final byte ST_BIGGER = 30;
    public static final byte ST_REBORN = 31;
    public static final byte ST_FLY = 32;
    public static final byte DIR_UP = 0;
    public static final byte DIR_RIGHT = 1;
    public static final byte DIR_DOWN = 2;
    public static final byte DIR_LEFT = 3;
    public static short[] roleImage = new short[]{61, 62, 73, 85, 98, 102, 103, 104, 105, 106, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 74, 75, 76, 78, 79, 80, 81, 82, 83, 84, 86, 87, 88, 89, 91, 92, 93, 95, 96, 97, 120, 99, 100, 101};
    public static final String[] DIR = new String[]{"up", "right", "down", "left"};
    boolean autoMove;
    int toX;
    int toY;
    boolean visible = true;
    public static final byte ATT_\u666e\u901a = 0;
    public static final byte ATT_\u6311\u8d77 = 1;
    public static final byte ATT_\u51fb\u98de = 2;
    int injureTime;
    int superTime;
    boolean isHit;
    boolean isConAtt;
    short[] heartPos = new short[2];
    boolean showHeart;
    int hitNum;
    byte offX;
    byte offY;
    short[] leftHand = new short[6];
    short[] rightHand = new short[6];
    short[] head = new short[5];
    static short[] tempAtt = new short[4];
    int attBound = 40;
    int attBound2 = 100;
    int startPosX;
    int startPosY;
    int bound = 100;
    static int levMax = 40;
    int lightIndex;
    int drawLev;
    static byte[][] imgDatDust = new byte[][]{{0, 0, 94, 97}, {95, 3, 97, 94}};
    int skillIndex = 0;
    boolean jumpKey;
    boolean keyIsRelease;
    int steps;
    boolean isStep;
    boolean isAction;
    boolean isDrop = false;
    int reborn_x;
    int reborn_y;
    int faceID = -1;
    int faceIndex;
    static byte[] faceMotion = new byte[]{0, 1, 2, 3, 3, 3, 3, 3, 3};
    static short[] faceImg = new short[]{27, 28, 29, 30, 31, 32, 33, 34};
    public static byte[][] allIndent = new byte[][]{{0, 8, 0, 0}, {7, 5, -8, 0}, {4, 5, 0, 0}, {4, 5, 0, 0}, {1, 2, 5, -3}, {1, 8, 0, 0}, {-2, 3, 0, 0}, {1, 1, -1, 0}, {0, 0, -6, 0}, {0, 0, -6, 0}, {0, 0, -6, 0}, {11, 3, -5, 0}, {1, 0, -7, 0}, {9, 7, 3, 0}, {14, 2, -2, 0}, {2, 2, -3, 0}, {1, 2, 1, 0}, {4, 3, -4, 0}};
    int backTime;
    int deadTime;
    Event event;
    String command;

    public static int getDir(String dir) {
        int i = 0;
        while (i < DIR.length) {
            if (dir.equals(DIR[i])) {
                return i;
            }
            ++i;
        }
        return Event.sToi(dir);
    }

    public int getRightMode(int srcMode) {
        byte[] mode = new byte[]{18, 21, 19, 20, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 0, 22, 38, 24, 23, 1, 25, 26, 27, 28, 29, 30, 2, 3, 31, 32, 33, 34, 35, 36, 37, 39, 40, 41, 42, 43};
        return mode[srcMode];
    }

    public GameSprite(GameEngine eg, int spId, String name, int state, int srcMode, int x, int y, int dir, boolean visible, boolean isPass, int type) {
        this.ID = spId;
        this.name = name;
        this.x = x;
        this.y = y;
        this.mode = this.getRightMode(srcMode);
        this.dir = this.nextDir = dir;
        this.faceDir = this.nextDir;
        this.nextFaceDir = this.nextDir;
        this.visible = visible;
        this.isPass = isPass;
        this.type = type;
        if (this.mode == 0) {
            if (GameEngine.gameRank == 61) {
                this.mode = 40;
            }
        }
        this.engine = eg;
        this.index = 0;
        this.imgIndex = roleImage[this.mode];
        this.setModeType();
        if (clipDat[this.mode] == null) {
            GameSprite.clipDat[this.mode] = this.engine.readClipData("c" + this.mode + ".dat");
        }
        if (frameDat[this.mode] == null) {
            GameSprite.frameDat[this.mode] = this.engine.readFrameData("f" + this.mode + ".dat");
        }
        if (indent[this.mode] == null) {
            GameSprite.indent[this.mode] = this.engine.readClipData("s" + this.mode + ".dat");
        }
        this.ay = (byte)4;
        this.isConAtt = false;
        this.isDead = false;
        this.nextIsDead = false;
        this.startPosX = x;
        this.startPosY = y;
        if (type > 0) {
            this.initProp(type - 1);
        }
        this.resetProp();
        if (this.mode == 33) {
            this.initDragon(x, y);
        }
        this.superTime = 0;
        this.injureTime = 0;
        this.backTime = 0;
    }

    public void initProp(int propType) {
        this.level = Data.props[propType][0];
        this.attack = Data.props[propType][1];
        this.defend = Data.props[propType][2];
        this.flash = Data.props[propType][3];
        this.getMoney = Data.props[propType][4];
        this.getExp = Data.hpExp[propType][1];
        this.hp = this.hp_max = Data.hpExp[propType][0];
        this.mp_max = 100;
        this.mp = 0;
        this.collect = 3;
        this.exp = 0;
        this.exp_max = this.getStandardExpMax(this.type, this.level);
    }

    public void setModeType() {
        this.w = (short)16;
        this.h = (short)16;
        this.step = (byte)6;
        this.attBound = 40;
        switch (this.mode) {
            case 0: {
                this.w = (short)19;
                this.h = (short)36;
                break;
            }
            case 1: {
                this.w = (short)19;
                this.h = (short)42;
                break;
            }
            case 2: {
                this.w = (short)19;
                this.h = (short)34;
                break;
            }
            case 3: {
                this.w = (short)19;
                this.h = (short)38;
                break;
            }
            case 16: {
                this.w = (short)19;
                this.h = (short)37;
                this.step = (byte)4;
                break;
            }
            case 22: {
                this.w = (short)139;
                this.h = (short)88;
                this.step = (byte)4;
                break;
            }
            case 23: {
                this.w = (short)25;
                this.h = (short)52;
                this.step = (byte)6;
                break;
            }
            case 24: {
                this.w = (short)25;
                this.h = (short)53;
                this.step = (byte)4;
                break;
            }
            case 25: {
                this.w = (short)21;
                this.h = (short)33;
                this.step = (byte)4;
                break;
            }
            case 26: {
                this.w = (short)35;
                this.h = (short)26;
                this.step = (byte)3;
                this.attBound = 20;
                break;
            }
            case 27: {
                this.w = (short)38;
                this.h = (short)33;
                this.step = (byte)5;
                break;
            }
            case 28: {
                this.w = (short)25;
                this.h = (short)49;
                this.step = (byte)4;
                break;
            }
            case 29: {
                this.w = (short)40;
                this.h = (short)60;
                this.step = (byte)5;
                break;
            }
            case 30: {
                this.w = (short)35;
                this.h = (short)26;
                this.step = (byte)3;
                this.attBound = 28;
                break;
            }
            case 31: {
                this.w = (short)91;
                this.h = (short)59;
                this.step = 1;
                break;
            }
            case 32: {
                this.w = (short)20;
                this.h = (short)52;
                this.step = (byte)6;
                break;
            }
            case 34: {
                this.w = (short)40;
                this.h = (short)35;
                this.step = (byte)4;
                break;
            }
            case 35: {
                this.w = (short)37;
                this.h = (short)28;
                this.step = (byte)4;
                break;
            }
            case 36: {
                this.w = (short)40;
                this.h = (short)69;
                this.step = 0;
                break;
            }
            case 37: {
                this.w = (short)28;
                this.h = (short)59;
                this.step = (byte)4;
                break;
            }
            case 38: {
                this.w = (short)26;
                this.h = (short)45;
                this.step = (byte)4;
                break;
            }
            case 39: {
                this.step = (byte)2;
                break;
            }
            case 40: {
                this.w = (short)30;
                this.h = (short)10;
                this.step = (byte)4;
                break;
            }
            default: {
                this.w = (short)19;
                this.h = (short)43;
                this.step = (byte)4;
            }
        }
        this.setMirror();
    }

    public void setMirror() {
        this.isMirror = this.mode < 4 || this.mode == 40 ? this.faceDir == 3 : this.faceDir == 1;
    }

    public void dealKey() {
        if (this.hp <= 0 || GameEngine.spriteIndex != this.ID || this.autoMove || !Script.isNormal) {
            return;
        }
        if (this.curStates == 22 || this.nextStates == 22) {
            return;
        }
        if (this.curStates == 0 && this.nextStates == 0) {
            if (MyGameCanvas.isPressed(52) || MyGameCanvas.isPressed(-3)) {
                this.setDir(3);
                this.setStates(1);
            } else if (MyGameCanvas.isPressed(54) || MyGameCanvas.isPressed(-4)) {
                this.setDir(1);
                this.setStates(1);
            }
        }
        if ((this.curStates == 0 && this.nextStates == 0 || this.curStates == 1 && this.nextStates == 1) && (MyGameCanvas.isPressed(56) || MyGameCanvas.isPressed(-2))) {
            this.setStates(8);
        }
        if (this.curStates == 8 && !MyGameCanvas.isPressed(56) && !MyGameCanvas.isPressed(-2)) {
            this.setStates(0);
        }
        if (this.curStates == 32) {
            this.speedY = MyGameCanvas.isPressed(56) || MyGameCanvas.isPressed(-2) ? (byte)20 : (MyGameCanvas.isPressed(50) || MyGameCanvas.isPressed(-1) ? (byte)-20 : (byte)0);
        }
        if (MyGameCanvas.isPressed(52) || MyGameCanvas.isPressed(-3)) {
            this.speedX = -this.step;
            this.jumpKey = false;
        } else if (MyGameCanvas.isPressed(54) || MyGameCanvas.isPressed(-4)) {
            this.speedX = this.step;
            this.jumpKey = false;
        } else {
            this.speedX = 0;
        }
    }

    public void getdistance() {
        this.speedY = (byte)(this.speedY + this.ay);
        this.speedY = (byte)Math.min(15, this.speedY);
        this.disX = this.speedX;
        this.disY = this.speedY - this.ay / 2;
    }

    public void checkNextState() {
        if (this.nextStates != this.curStates) {
            this.index = 0;
            this.curStates = this.nextStates;
        }
        if (this.dir != this.nextDir) {
            this.dir = this.nextDir;
        }
        if (this.faceDir != this.nextFaceDir) {
            this.faceDir = this.nextFaceDir;
        }
    }

    public void injure(int att, int attMode, boolean isFlash, boolean leftHit) {
        if (this.injureTime > 0 || this.superTime > 0) {
            return;
        }
        if (this.mode == 0) {
            this.injureTime = 15;
        }
        ++this.hitNum;
        GameEngine.AddBlastEffectList(this.x + Event.getRandom(this.w / 3, this.w * 2 / 3), this.y - Event.getRandom(this.h / 3, this.h * 2 / 3), 1, 0);
        if (this.mode == 31) {
            this.isHit = true;
            return;
        }
        int value = Math.max(1, att * Event.getRandom(90, 110) / 100 - this.defend) * (isFlash ? 2 : 1);
        GameEngine.addNumEff(isFlash ? 22 : 41, value, this.x + this.w / 2, this.y - this.h - 10);
        this.hp = Math.max(0, this.hp - value);
        switch (attMode) {
            case 0: {
                if (this.curStates == 22) {
                    this.setStates(22);
                    this.speedX = (byte)(leftHit ? 5 : -5);
                    this.speedY = (byte)-12;
                    break;
                }
                this.setStates(15);
                break;
            }
            case 1: {
                this.setStates(22);
                this.speedX = (byte)(leftHit ? 5 : -5);
                this.speedY = (byte)-12;
                break;
            }
            case 2: {
                this.setStates(22);
                this.speedX = (byte)(leftHit ? 5 : -5);
                this.speedY = (byte)-10;
            }
        }
    }

    public void dead() {
        if (this.hp > 0) {
            this.setStates(0);
        } else {
            this.setStates(5);
        }
    }

    public void move0() {
        this.dealKey();
        this.getdistance();
        if (this.hp <= 0 && this.curStates != 5) {
            this.hp = 0;
            this.setStates(5);
        }
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1, 0, 0, 2, 2};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index != this.motion.length) break;
                this.index = 0;
                break;
            }
            case 1: {
                this.motion = new byte[]{4, 5, 6, 7, 8, 9, 10, 11};
                this.curIndex = this.motion[this.index];
                if (GameEngine.spriteIndex != this.ID || this.autoMove) {
                    this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                } else {
                    this.roleMove(this.disX, this.disY);
                }
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 4: {
                this.curIndex = 37;
                if (GameEngine.spriteIndex != this.ID || this.autoMove) {
                    this.roleMove(0, 10);
                    break;
                }
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 2: {
                int n = this.curIndex = this.speedY <= 0 ? 35 : 37;
                if (GameEngine.spriteIndex != this.ID || this.autoMove || this.jumpKey) {
                    this.roleMove(this.dir == 3 ? -this.step : this.step, this.disY);
                    break;
                }
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 6: {
                this.curIndex = 0;
                this.floatMove(0, 0);
                this.drawLevUp(this.x + this.w / 2, this.y, 45, this.index);
                if (++this.index <= 7) break;
                this.setStates(0);
                break;
            }
            case 14: {
                this.motion = new byte[]{12, 13, 14, 16, 15};
                this.curIndex = this.motion[this.index];
                if (GameEngine.spriteIndex != this.ID || this.autoMove || this.jumpKey) {
                    this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                } else {
                    this.roleMove(this.disX, this.disY);
                }
                if (++this.index != this.motion.length) break;
                this.setStates(2);
                break;
            }
            case 8: {
                this.curIndex = 3;
                this.roleMove(0, 10);
                break;
            }
            case 25: {
                this.motion = new byte[]{0, 39, 40, 41, 42, 41, 42, 41, 42};
                this.curIndex = this.motion[this.index];
                this.getSize(this.curIndex);
                this.roleMove(0, 5);
                if (this.index > 2) {
                    GameEngine.drawSkillStart(this.x + (this.dir == 3 ? -25 : 20), this.y, this.skills[this.skillIndex] == 0 ? 7 : 8, this.dir == 3, this.index + 1, 60);
                }
                if (++this.index != this.motion.length) break;
                this.setStates(26);
                break;
            }
            case 26: {
                this.motion = new byte[]{0, 0, 1, 1, 0, 0, 2, 2};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(0, 5);
                switch (this.skills[this.skillIndex]) {
                    case 0: {
                        if (this.index != 1) break;
                        GameEngine.tang.visible = true;
                        GameEngine.tang.setStates(25);
                        GameEngine.tang.x = GameMap.setOffX - 30;
                        GameEngine.tang.y = this.y;
                        GameEngine.tang.setDir(1);
                        break;
                    }
                    case 1: {
                        if (this.index != 1) break;
                        GameEngine.sha.visible = true;
                        GameEngine.sha.setStates(25);
                        GameEngine.sha.setDir(this.dir);
                        GameEngine.sha.x = this.dir == 3 ? GameMap.setOffX + 240 : GameMap.setOffX - 30;
                        GameEngine.sha.y = this.y;
                    }
                }
                ++this.index;
                if (GameEngine.skillTime != 0) break;
                this.setStates(0);
                this.superTime = 0;
                break;
            }
            case 3: {
                this.motion = new byte[]{12, 13, 14, 16, 15, 17, 18, 19, 20, 21, 18, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 31};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index >= this.motion.length) {
                    this.setStates(0);
                    break;
                }
                if (this.index != 5 && this.index != 10 && this.index != 14 && this.index != 19) break;
                if (!this.isConAtt) {
                    this.setStates(0);
                    break;
                }
                this.isConAtt = false;
                break;
            }
            case 22: {
                this.curIndex = 43;
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 20: {
                this.motion = new byte[]{47, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(0);
                break;
            }
            case 5: {
                this.curIndex = 46;
                this.roleMove(this.disX, this.disY);
                if (++this.index < 10) break;
                MyGameCanvas.setST((byte)15);
                break;
            }
            case 19: {
                this.curIndex = 0;
                this.roleMove(this.disX, this.disY);
                this.dead();
                break;
            }
            case 28: {
                this.motion = new byte[]{0, -1, 49, -1, 50, -1, 51};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(29);
                break;
            }
            case 29: {
                this.curIndex = 51;
                this.roleMove(0, 10);
                break;
            }
            case 30: {
                this.motion = new byte[]{51, -1, 50, -1, 49, -1, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(0);
                break;
            }
            case 31: {
                this.curIndex = 0;
                this.floatMove(0, -20);
                if (this.y > GameMap.setOffY + 40) break;
                this.setStates(32);
                break;
            }
            case 32: {
                this.curIndex = 0;
                this.floatMove(this.speedX, this.speedY);
                if (++this.index < 100) break;
                this.setStates(0);
            }
        }
    }

    public void move1() {
        this.checkNextState();
        switch (this.curStates) {
            case 1: {
                this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 0: {
                this.motion = new byte[]{4, 4, 5, 5};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 4: {
                this.curIndex = 3;
                this.roleMove(0, 5);
                break;
            }
            case 25: {
                this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.getSize(this.curIndex);
                ++this.index;
                this.x += 10;
                if (this.x <= GameMap.setOffX + 120 - 40) break;
                this.setStates(26);
                break;
            }
            case 26: {
                this.motion = new byte[]{4, 4, 5, 5};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.getSize(this.curIndex);
                byte[] talkmotion = new byte[]{10, 10, 10, 10, 5, 5, 5, 5};
                GameEngine.drawSkillStart(this.x + (this.dir == 3 ? -65 : 20), this.y, talkmotion[this.index], this.dir == 3, this.index, 60);
                if (++this.index < talkmotion.length) break;
                this.setStates(27);
                this.lightIndex = 0;
                break;
            }
            case 27: {
                this.x += 10;
                this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.getSize(this.curIndex);
                ++this.index;
                if (this.x <= GameMap.setOffX + 240) break;
                this.drawLight(60);
                if (this.lightIndex != 11) break;
                this.visible = false;
                this.engine.lightHit();
                GameEngine.skillTime = 0;
            }
        }
    }

    public void move2() {
        this.checkNextState();
        switch (this.curStates) {
            case 1: {
                this.motion = new byte[]{2, 3, 4, 5, 6, 7, 8, 9};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 4: {
                this.curIndex = 10;
                this.roleMove(0, 10);
                break;
            }
            case 9: {
                this.motion = new byte[]{10, 11, 12, 13};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(0);
            }
        }
    }

    public void move3() {
        this.checkNextState();
        switch (this.curStates) {
            case 1: {
                this.motion = new byte[]{2, 3, 4, 5, 6, 7, 8, 9};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 4: {
                this.curIndex = 9;
                this.roleMove(0, 10);
                break;
            }
            case 25: {
                this.motion = new byte[]{2, 3, 4, 5, 6, 7, 8, 9};
                this.curIndex = this.motion[this.index % this.motion.length];
                ++this.index;
                if (this.dir == 3) {
                    this.x -= 15;
                    if (this.x >= GameEngine.sprite[0].x - 20) break;
                    this.setStates(26);
                    break;
                }
                this.x += 15;
                if (this.x <= GameEngine.sprite[0].x + 40) break;
                this.setStates(26);
                break;
            }
            case 26: {
                this.motion = new byte[]{10, 11, 12};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.getSize(this.curIndex);
                if (++this.index != this.motion.length) break;
                this.visible = false;
                GameEngine.skillTime = 22;
                GameEngine.addShot(GameEngine.roleShot, 3, this.x + this.w / 2, this.y - 34 + 5, this.dir == 3 ? -10 : 10, 0, GameEngine.sprite[0].allAtt);
            }
        }
    }

    public void move4() {
        this.checkNextState();
        switch (this.curStates) {
            case 1: {
                this.curIndex = 0;
                this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                break;
            }
            case 0: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 4: {
                this.curIndex = 0;
                this.roleMove(0, 10);
            }
        }
    }

    public void move16() {
        this.checkNextState();
        switch (this.curStates) {
            case 1: {
                this.motion = new byte[]{1, 0, 2, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 0: {
                this.curIndex = 0;
                this.roleMove(0, 10);
            }
        }
    }

    public void move22() {
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.floatMove(0, 0);
                if (this.index % 20 == 19) {
                    GameEngine.addShot(GameEngine.enemyShot, 5, this.x + this.w / 2, this.y - 110, -10, 0, 0);
                    GameEngine.addShot(GameEngine.enemyShot, 5, this.x + this.w / 2, this.y - 110, 10, 0, 0);
                    GameEngine.addShot(GameEngine.enemyShot, 6, this.x + this.w / 2, this.y - 110, 0, -10, 0);
                }
                if (++this.index < 20) break;
                this.index = 0;
                break;
            }
            case 1: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                this.floatMove(0, -this.step);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 3: {
                this.curIndex = 1;
                this.floatMove(0, -this.step * 8);
                if (++this.index < 6) break;
                this.setStates(0);
                break;
            }
            case 26: {
                this.curIndex = 0;
                this.floatMove(0, this.step * 8);
                if (++this.index < 6) break;
                this.setStates(0);
                break;
            }
            case 25: {
                this.curIndex = 1;
                this.floatMove(0, 0);
                if (this.index == 0) {
                    this.showHeart();
                }
                if (this.index < 8) {
                    this.heartPos[1] = (short)(this.heartPos[1] - 8);
                } else if (this.index > 29 && this.index < 38) {
                    this.heartPos[1] = (short)(this.heartPos[1] + 8);
                }
                if (this.index >= 8 && this.index <= 29 && this.index % 4 == 0) {
                    GameEngine.AddBlastEffectList(this.heartPos[0] + 9, this.heartPos[1] - 9, 5, 0);
                }
                if (++this.index < 38) break;
                this.showHeart = false;
                this.setStates(0);
                break;
            }
            case 5: {
                this.curIndex = 1;
                if (this.index > 30 && GameMIDlet.gameIndex % 2 == 0) {
                    this.curIndex = -1;
                }
                this.floatMove(0, 0);
                GameEngine.AddBlastEffectList(this.x + Event.getRandom(0, 110), this.y - Event.getRandom(0, 88), 3, 0);
                if (++this.index < 50) break;
                this.isDead = true;
            }
        }
    }

    public void showHeart() {
        this.showHeart = true;
        this.heartPos[0] = (short)(this.x + 25);
        this.heartPos[1] = (short)(this.y - 52);
    }

    public void drawHeart(int lev) {
        if (!this.showHeart) {
            return;
        }
        Tools.addObject(77, this.heartPos[0], this.heartPos[1], 36, (byte)0, lev);
    }

    public void AI_\u91d1\u89d2\u5927\u738b() {
        block11: {
            block10: {
                if (this.hp <= 0) break block10;
                if (this.ID != GameEngine.spriteIndex && !this.autoMove && Script.isNormal && this.backTime <= 0) break block11;
            }
            return;
        }
        int rx = GameEngine.sprite[GameEngine.spriteIndex].x + GameEngine.sprite[GameEngine.spriteIndex].w / 2;
        int ry = GameEngine.sprite[GameEngine.spriteIndex].y;
        int ex = this.x + this.w / 2;
        int ey = this.y;
        int nextPos = ex + (this.dir == 3 ? -this.step : this.step);
        switch (this.curStates) {
            case 24: {
                if (GameEngine.sprite[3].hitNum > 9) {
                    this.setStates(4);
                    this.superTime = 99;
                    break;
                }
                if (rx < ex) {
                    if (this.index < 50) break;
                    this.setStates(9);
                    GameEngine.sprite[3].setStates(3);
                    break;
                }
                this.index = 0;
                break;
            }
            case 0: {
                GameEngine.sprite[3].hitNum = 0;
                this.setStates(16);
                break;
            }
            case 3: {
                if (!this.nextAreaIsDanger(nextPos, this.y + 10)) break;
                this.setStates(23);
            }
        }
    }

    public void move23() {
        this.getdistance();
        this.checkNextState();
        switch (this.curStates) {
            case 3: {
                this.motion = new byte[]{3, 4, 5, 6};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(this.dir == 3 ? -this.step * 2 : this.step * 2, 10);
                if (++this.index < 20) break;
                this.superTime = 0;
                this.setStates(23);
                break;
            }
            case 24: {
                this.motion = new byte[]{0, 0, 1, 1, 2, 2, 1, 1};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.floatMove(0, 0);
                ++this.index;
                break;
            }
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1, 2, 2, 1, 1};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 4: {
                this.curIndex = 14;
                this.roleMove(0, 10);
                break;
            }
            case 16: {
                this.motion = new byte[]{7, 10, 11, 12, 13};
                this.curIndex = this.motion[this.index];
                this.floatMove(0, 0);
                if (++this.index < this.motion.length) break;
                this.setStates(17);
                this.superTime = 99;
                break;
            }
            case 17: {
                this.motion = new byte[]{13, 12, 11, 10, 7};
                this.curIndex = this.motion[this.index];
                if (this.index == 0) {
                    this.x = GameEngine.sprite[3].x + 50;
                    this.y = GameEngine.sprite[3].y - 55;
                    this.nextDir = 3;
                    this.dir = 3;
                }
                this.floatMove(0, 0);
                if (++this.index < this.motion.length) break;
                this.setStates(24);
                this.superTime = 0;
                break;
            }
            case 9: {
                this.motion = new byte[]{0, 7, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.floatMove(0, 0);
                if (++this.index < this.motion.length) break;
                this.setStates(24);
                break;
            }
            case 23: {
                this.motion = new byte[]{15, 16, 16, 17, 17, 16, 16, 17, 17, 16, 16, 17, 17, 16, 16, 17, 17};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(0);
                break;
            }
            case 21: {
                this.motion = new byte[]{15, 16, 16, 17, 17, 16, 16, 17, 17, 16, 16, 17, 17};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(3);
                break;
            }
            case 15: {
                this.motion = new byte[]{14, 14, 0, 0, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 22: {
                this.curIndex = 14;
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 19: {
                this.motion = new byte[]{15, 16};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 5: {
                this.motion = new byte[]{15, 16, 17, 17, 17};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.isDead = true;
            }
        }
    }

    public void move24() {
        this.checkNextState();
        switch (this.curStates) {
            case 21: 
            case 23: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.floatMove(0, 0);
                if (++this.index < 16) break;
                this.setStates(0);
                break;
            }
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                this.floatMove(0, 0);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 1: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.floatMove(this.dir == 3 ? -this.step : this.step, 0);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 15: 
            case 22: {
                this.motion = new byte[]{9, 9, 0, 0, 0};
                this.curIndex = this.motion[this.index];
                this.floatMove(this.speedX, 0);
                if (this.index == 1) {
                    this.speedX = 0;
                }
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 0, 0, 0, 0, 3, 4, 0, 6, 7, 8};
                this.curIndex = this.motion[this.index];
                this.floatMove(0, 0);
                if (++this.index < this.motion.length) break;
                this.setStates(21);
                break;
            }
            case 5: {
                this.motion = new byte[]{10, 11, 12, 13, 13};
                this.curIndex = this.motion[this.index];
                if (this.index < 3) {
                    this.floatMove(0, 0);
                    ++this.index;
                } else {
                    this.roleMove(0, 10);
                }
                if (!this.nextIsDead) break;
                this.nextIsDead = false;
                this.isDead = true;
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public void move25() {
        this.getdistance();
        this.checkNextState();
        switch (this.curStates) {
            case 21: 
            case 23: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(0, 10);
                if (++this.index < 16) break;
                this.setStates(0);
                break;
            }
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 1: {
                this.motion = new byte[]{1, 1, 1, 2, 2, 2};
                this.curIndex = this.motion[this.index % this.motion.length];
                byte[] adjustY = new byte[]{0, 0, 0, -10, -15, -10};
                this.offY = adjustY[this.index];
                this.roleMove(this.curIndex == 2 ? (this.dir == 3 ? (int)(-this.step) : (int)this.step) : 0, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 15: {
                this.motion = new byte[]{5, 5, 4, 4, 4};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 22: {
                this.curIndex = 5;
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 4: {
                this.curIndex = 2;
                this.roleMove(0, 10);
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 0, 0, 0, 0, 3, 3, 3, 4, 4, 4};
                byte[] adjustY = new byte[]{0, 0, 0, 0, 0, -10, -15, -10, 0, 0, 0};
                this.offY = adjustY[this.index];
                this.curIndex = this.motion[this.index];
                this.roleMove(this.index < 5 || this.index > 7 ? 0 : (this.dir == 3 ? (int)(-this.step) : (int)this.step), 10);
                if (++this.index < this.motion.length) break;
                this.setStates(21);
                break;
            }
            case 19: {
                this.curIndex = 6;
                this.roleMove(0, 10);
                if (++this.index < 10) break;
                this.dead();
                break;
            }
            case 5: {
                this.curIndex = -1;
                this.isDead = true;
            }
        }
    }

    public void move26() {
        this.getdistance();
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 21: 
            case 23: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                if (++this.index < 16) break;
                this.setStates(0);
                break;
            }
            case 1: {
                this.motion = new byte[]{0, 1, 2};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 15: {
                this.motion = new byte[]{3, 3, 0, 0, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 22: {
                this.curIndex = 3;
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 4: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 1, 2};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(21);
                break;
            }
            case 19: {
                this.curIndex = 4;
                this.roleMove(0, 10);
                if (++this.index < 10) break;
                this.dead();
                break;
            }
            case 5: {
                this.curIndex = -1;
                this.isDead = true;
            }
        }
    }

    public void move27() {
        this.getdistance();
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 21: 
            case 23: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(0);
                break;
            }
            case 1: {
                this.motion = new byte[]{2, 2, 3, 3, 4, 4, 5, 5};
                this.curIndex = this.motion[this.index];
                this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 0, 0, 0, 0, 2, 3, 4, 5, 2, 3, 4, 5, 2, 3, 4, 5};
                this.curIndex = this.motion[this.index];
                if (this.index > 4) {
                    if (this.index % 2 == 0) {
                        GameEngine.AddBlastEffectList(this.x + this.w / 2, this.y, 6, this.dir == 3 ? 1 : 0);
                    }
                    this.roleMove(2 * (this.dir == 3 ? -this.step : this.step), 10);
                } else {
                    this.roleMove(0, 10);
                }
                if (++this.index < this.motion.length) break;
                this.setStates(21);
                break;
            }
            case 15: {
                this.motion = new byte[]{6, 6, 0, 0, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 22: {
                this.curIndex = 6;
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 4: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 19: {
                this.curIndex = 7;
                this.roleMove(0, 10);
                if (++this.index < 10) break;
                this.dead();
                break;
            }
            case 5: {
                this.motion = new byte[]{8, 9};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.isDead = true;
            }
        }
    }

    public void move28() {
        this.getdistance();
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.curIndex = 5;
                this.roleMove(0, 10);
                break;
            }
            case 21: 
            case 23: {
                this.curIndex = 5;
                this.roleMove(0, 10);
                if (++this.index < 10) break;
                this.setStates(0);
                break;
            }
            case 1: {
                this.motion = new byte[]{0, 1, 2, 3, 4, 5};
                this.curIndex = this.motion[this.index];
                this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 3: {
                this.motion = new byte[]{5, 6, 6, 6, 7, 8, 5, 5, 5, 5, 5, 5, 5, 5};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(0);
                break;
            }
            case 15: {
                this.motion = new byte[]{9, 9, 5, 5, 5};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 22: {
                this.curIndex = 9;
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 4: {
                this.curIndex = 5;
                this.roleMove(0, 10);
                break;
            }
            case 19: {
                this.curIndex = 10;
                this.roleMove(0, 10);
                if (++this.index < 10) break;
                this.dead();
                break;
            }
            case 5: {
                this.curIndex = -1;
                this.isDead = true;
            }
        }
    }

    public void move29() {
        this.getdistance();
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 21: 
            case 23: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                if (++this.index < 10) break;
                this.setStates(0);
                break;
            }
            case 1: {
                this.motion = new byte[]{1, 0, 2, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 0, 0, 0, 0, 3, 3, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(21);
                break;
            }
            case 15: {
                this.motion = new byte[]{4, 4, 0, 0, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 22: {
                this.curIndex = 4;
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 4: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 19: {
                this.curIndex = 5;
                this.roleMove(0, 10);
                if (++this.index < 10) break;
                this.dead();
                break;
            }
            case 5: {
                this.curIndex = -1;
                this.isDead = true;
            }
        }
    }

    public void move31() {
        this.checkNextState();
        if (this.isHit) {
            this.isHit = false;
            this.offX = 1;
        }
        switch (this.curStates) {
            case 0: {
                this.curIndex = 0;
                this.floatMove(0, 0);
                break;
            }
            case 3: {
                this.motion = new byte[]{1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 2, 2};
                this.curIndex = this.motion[this.index];
                this.floatMove(0, 0);
                if (++this.index < this.motion.length) break;
                if (Script.scriptVar[60] >= 3) {
                    GameEngine.addShot(GameEngine.enemyShot, 7, this.x - 20, this.y - 22 + 8, -10, 0, this.attack);
                } else {
                    GameEngine.addShot(GameEngine.enemyShot, 4, this.x - 20, this.y - 22 + 8, -10, 0, 0);
                }
                this.setStates(0);
                break;
            }
            case 15: 
            case 22: {
                break;
            }
            case 4: {
                break;
            }
            case 19: {
                break;
            }
        }
    }

    public void AI_\u767d\u9aa8\u7cbe() {
        block15: {
            block14: {
                if (this.hp <= 0) break block14;
                if (this.ID != GameEngine.spriteIndex && !this.autoMove && Script.isNormal && this.backTime <= 0) break block15;
            }
            return;
        }
        int rx = GameEngine.sprite[GameEngine.spriteIndex].x + GameEngine.sprite[GameEngine.spriteIndex].w / 2;
        int ry = GameEngine.sprite[GameEngine.spriteIndex].y;
        int ex = this.x + this.w / 2;
        int ey = this.y;
        int nextPos = ex + (this.dir == 3 ? -this.step : this.step);
        switch (this.curStates) {
            case 23: {
                break;
            }
            case 0: {
                if (ex < rx && rx - ex < 100 && this.dir == 1 || ex >= rx && ex - rx < 100 && this.dir == 3 && Math.abs(ry - ey) < 32) {
                    this.setDir(rx < ex ? 3 : 1);
                    this.setStates(9);
                    break;
                }
                if (this.nextAreaIsDanger(nextPos, this.y + 10)) {
                    this.setDir(this.dir == 3 ? 1 : 3);
                }
                this.setStates(1);
                break;
            }
            case 1: {
                if (ex < rx && rx - ex < 100 && this.dir == 1 || ex >= rx && ex - rx < 100 && this.dir == 3 && Math.abs(ry - ey) < 32) {
                    this.setDir(rx < ex ? 3 : 1);
                    this.setStates(9);
                }
                if (!this.nextAreaIsDanger(nextPos, this.y + 10)) break;
                this.setStates(23);
                break;
            }
            case 15: {
                if (this.index != 1) break;
                this.setDir(ex < rx ? 1 : 3);
                break;
            }
            case 19: {
                this.setDir(ex < rx ? 1 : 3);
                this.setStates(9);
                break;
            }
            case 3: {
                if (!this.nextAreaIsDanger(nextPos, this.y + 10)) break;
                this.setStates(21);
                this.superTime = 0;
            }
        }
    }

    public void move32() {
        this.getdistance();
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 21: 
            case 23: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(0, 10);
                if (++this.index < 16) break;
                this.setStates(0);
                break;
            }
            case 1: {
                this.motion = new byte[]{2, 2, 3, 3};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 15: {
                this.motion = new byte[]{6, 6, 7, 7, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 22: {
                this.motion = new byte[]{6, 6, 7, 7, 6};
                this.curIndex = this.motion[this.index];
                if (this.index < this.motion.length - 1) {
                    ++this.index;
                }
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 4: {
                this.curIndex = 2;
                this.roleMove(0, 10);
                break;
            }
            case 3: {
                this.motion = new byte[]{4, 5, 10, 11, 12, 13, 10, 11, 12, 13, 10, 11, 12, 13};
                this.curIndex = this.motion[this.index];
                this.roleMove(this.dir == 3 ? -this.step * 2 : this.step * 2, 10);
                if (++this.index < this.motion.length) break;
                this.superTime = 0;
                this.setStates(21);
                break;
            }
            case 9: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                if (this.index == 0 || this.index == 8 || this.index == 16) {
                    this.superTime = 99;
                    GameEngine.AddBlastEffectList(this.x + this.w / 2, this.y - 16, 0, 0);
                }
                if (++this.index <= 24) break;
                this.setStates(3);
                break;
            }
            case 19: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                if (++this.index < 1) break;
                this.dead();
                break;
            }
            case 5: {
                this.motion = new byte[]{8, 8, 9, 9, 9, 9, 9, 9};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (this.index >= this.motion.length - 1) break;
                ++this.index;
                if (this.index != this.motion.length - 1) break;
                GameEngine.AddBlastEffectList(this.x + this.w / 2, this.y, 4, 0);
                int temp = Math.max(0, this.getExp - this.getExp * (GameEngine.sprite[0].level - this.level) / 10);
                GameEngine.sprite[0].getExp(temp);
                this.drop();
            }
        }
    }

    public void initDragon(int x, int y) {
        this.head[0] = (short)x;
        this.head[1] = (short)y;
        this.head[2] = 1;
        this.head[3] = 0;
        this.head[4] = 0;
        this.leftHand[0] = (short)(x - 80);
        this.leftHand[1] = (short)(y + 10);
        this.leftHand[2] = 1;
        this.leftHand[3] = 1;
        this.leftHand[4] = 0;
        this.leftHand[5] = 0;
        this.rightHand[0] = (short)(x + 80);
        this.rightHand[1] = (short)(y + 10);
        this.rightHand[2] = 3;
        this.rightHand[3] = 1;
        this.leftHand[4] = 0;
        this.leftHand[5] = 0;
    }

    public void move33() {
        this.moveLeftHand();
        this.moveRightHand();
        this.moveHead();
    }

    public void AI_\u9f99\u5934() {
        int rx = GameEngine.sprite[0].x + GameEngine.sprite[0].w / 2;
        int ry = GameEngine.sprite[0].y;
        if (this.leftHand[0] < this.startPosX - 120) {
            this.leftHand[2] = 1;
        } else if (this.leftHand[0] > this.startPosX - 25) {
            this.leftHand[2] = 3;
        }
        if (this.rightHand[0] < this.startPosX + 25) {
            this.rightHand[2] = 1;
        } else if (this.rightHand[0] > this.startPosX + 120) {
            this.rightHand[2] = 3;
        }
        switch (this.head[3]) {
            case 0: {
                if (rx < this.startPosX) {
                    if (Math.abs(rx - this.leftHand[0]) < 23 && this.leftHand[3] == 1) {
                        this.leftHand[3] = 3;
                        this.leftHand[4] = 0;
                        this.head[3] = 3;
                    }
                } else if (Math.abs(rx - this.rightHand[0]) < 23 && this.rightHand[3] == 1) {
                    this.rightHand[3] = 3;
                    this.rightHand[4] = 0;
                    this.head[3] = 3;
                }
                if (this.leftHand[3] != 0 || this.rightHand[3] != 0) break;
                this.head[3] = 19;
                this.head[4] = 0;
            }
        }
    }

    public void moveLeftHand() {
        switch (this.leftHand[3]) {
            case 0: {
                break;
            }
            case 1: {
                this.leftHand[0] = (short)(this.leftHand[0] + (this.leftHand[2] == 3 ? -3 : 3));
                break;
            }
            case 3: {
                this.leftHand[1] = (short)(this.leftHand[1] + 10);
                this.leftHand[4] = (short)(this.leftHand[4] + 1);
                if (this.leftHand[4] < 14) break;
                this.leftHand[3] = 23;
                this.leftHand[4] = 0;
                break;
            }
            case 23: {
                if (this.lx == 1) {
                    this.lx = 0;
                }
                if ((this.leftHand[4] = (short)(this.leftHand[4] + 1)) < 20) break;
                this.leftHand[3] = 21;
                this.leftHand[4] = 0;
                break;
            }
            case 21: {
                this.leftHand[1] = (short)(this.leftHand[1] - 10);
                this.leftHand[4] = (short)(this.leftHand[4] + 1);
                if (this.leftHand[4] < 14) break;
                this.leftHand[3] = this.leftHand[5] == 1 ? (short)0 : 1;
                this.leftHand[4] = 0;
                this.head[3] = 0;
            }
        }
    }

    public void moveRightHand() {
        switch (this.rightHand[3]) {
            case 0: {
                break;
            }
            case 1: {
                this.rightHand[0] = (short)(this.rightHand[0] + (this.rightHand[2] == 3 ? -3 : 3));
                break;
            }
            case 3: {
                this.rightHand[1] = (short)(this.rightHand[1] + 10);
                this.rightHand[4] = (short)(this.rightHand[4] + 1);
                if (this.rightHand[4] < 14) break;
                this.rightHand[3] = 23;
                this.rightHand[4] = 0;
                break;
            }
            case 23: {
                if (this.rx == 1) {
                    this.rx = 0;
                }
                if ((this.rightHand[4] = (short)(this.rightHand[4] + 1)) < 20) break;
                this.rightHand[3] = 21;
                this.rightHand[4] = 0;
                break;
            }
            case 21: {
                this.rightHand[1] = (short)(this.rightHand[1] - 10);
                this.rightHand[4] = (short)(this.rightHand[4] + 1);
                if (this.rightHand[4] < 14) break;
                this.rightHand[3] = this.rightHand[5] == 1 ? (short)0 : 1;
                this.rightHand[4] = 0;
                this.head[3] = 0;
            }
        }
    }

    public void moveHead() {
        switch (this.head[3]) {
            case 0: {
                break;
            }
            case 19: {
                this.head[1] = (short)(this.head[1] + 10);
                this.head[4] = (short)(this.head[4] + 1);
                if (this.head[4] < 16) break;
                this.head[4] = 0;
                this.head[3] = 9;
                break;
            }
            case 3: {
                break;
            }
            case 23: {
                this.head[1] = (short)(this.head[1] - 10);
                if (this.dy == 1) {
                    this.dy = 0;
                }
                if ((this.head[4] = (short)(this.head[4] + 1)) < 16) break;
                this.head[4] = 0;
                this.head[3] = 0;
                this.leftHand[3] = 1;
                this.rightHand[3] = 1;
                break;
            }
            case 9: {
                this.head[4] = (short)(this.head[4] + 1);
                if (this.head[4] < 20) break;
                this.head[4] = 0;
                this.head[3] = 23;
                break;
            }
            case 5: {
                GameEngine.AddBlastEffectList(this.head[0] + Event.getRandom(-58, 58), this.head[1] - Event.getRandom(0, 116), 3, 0);
                this.head[4] = (short)(this.head[4] + 1);
                if (this.head[4] < 50) break;
                this.head[4] = 0;
                this.isDead = true;
            }
        }
    }

    public void drawDragon(int lev) {
        int i = 0;
        while (i < 3) {
            Tools.addObject(90, this.head[0] + (this.leftHand[0] - this.head[0]) * (i + 1) / 4 - 7, this.head[1] + (this.leftHand[1] - this.head[1]) * (i + 1) / 4 + 7, Data.clip_hand[1], 36, (byte)0, lev);
            ++i;
        }
        Tools.addObject(90, this.leftHand[0] - 23 + this.lx, this.leftHand[1] + 18, Data.clip_hand[0], 36, (byte)0, lev + 1);
        int i2 = 0;
        while (i2 < 3) {
            Tools.addObject(90, this.head[0] + (this.rightHand[0] - this.head[0]) * (i2 + 1) / 4 - 7, this.head[1] + (this.rightHand[1] - this.head[1]) * (i2 + 1) / 4 + 7, Data.clip_hand[1], 36, (byte)0, lev);
            ++i2;
        }
        Tools.addObject(90, this.rightHand[0] - 23 + this.rx, this.rightHand[1] + 18, Data.clip_hand[0], 36, (byte)1, lev + 1);
        if (this.head[3] != 5 || this.head[4] <= 30 || GameMIDlet.gameIndex % 2 != 0) {
            Tools.addObject(89, this.head[0] - 58 + this.dy, this.head[1], 36, (byte)0, lev + 1);
            Tools.addObject(89, this.head[0], this.head[1] + this.dy, 36, (byte)1, lev + 1);
        }
    }

    public void move34() {
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.motion = new byte[]{0, 1, 2, 1};
                this.curIndex = this.motion[this.index];
                this.floatMove(0, 0);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 21: 
            case 23: {
                this.motion = new byte[]{0, 1, 2, 1};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.floatMove(0, 0);
                if (++this.index < 10) break;
                this.setStates(0);
                break;
            }
            case 1: {
                this.motion = new byte[]{0, 1, 2, 1};
                this.curIndex = this.motion[this.index];
                this.floatMove(this.dir == 3 ? -this.step : this.step, 0);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 0, 0, 0, 0, 3, 3, 4, 4, 4, 4, 4, 3, 0};
                this.curIndex = this.motion[this.index];
                this.floatMove(0, 0);
                if (this.index == 7) {
                    GameEngine.addShot(GameEngine.enemyShot, 0, this.x + this.w / 2, this.y - 19, this.dir == 3 ? -15 : 15, 0, this.attack);
                }
                if (++this.index < this.motion.length) break;
                this.setStates(21);
                break;
            }
            case 15: 
            case 22: {
                this.motion = new byte[]{5, 5, 0, 0, 0};
                this.curIndex = this.motion[this.index];
                this.floatMove(this.speedX, 0);
                if (this.index == 1) {
                    this.speedX = 0;
                }
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 4: {
                break;
            }
            case 19: {
                break;
            }
            case 5: {
                this.motion = new byte[]{6, 7};
                this.curIndex = this.motion[this.index];
                this.floatMove(0, 0);
                if (++this.index < this.motion.length) break;
                this.isDead = true;
            }
        }
    }

    public void move35() {
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.motion = new byte[]{0, 1, 2, 1};
                this.curIndex = this.motion[this.index];
                this.floatMove(0, 0);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 21: 
            case 23: {
                this.motion = new byte[]{0, 1, 2, 1};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.floatMove(0, 0);
                if (++this.index < 10) break;
                this.setStates(0);
                break;
            }
            case 1: {
                this.motion = new byte[]{0, 1, 2, 1};
                this.curIndex = this.motion[this.index];
                this.floatMove(this.dir == 3 ? -this.step : this.step, this.speedY);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 3: {
                this.curIndex = 3;
                this.floatMove(this.dir == 3 ? -this.step : this.step, this.step * 2);
                if (++this.index < 3) break;
                this.setStates(0);
                break;
            }
            case 15: {
                this.motion = new byte[]{4, 4, 5, 5, 5};
                this.getdistance();
                this.curIndex = this.motion[this.index];
                this.floatMove(this.speedX, 0);
                if (this.index == 1) {
                    this.speedX = 0;
                }
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 22: {
                this.motion = new byte[]{4, 4, 5, 5, 5};
                this.getdistance();
                this.curIndex = this.motion[this.index];
                this.roleMove(this.speedX, this.disY);
                if (this.index == 1) {
                    this.speedX = 0;
                }
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 4: {
                this.curIndex = 5;
                this.roleMove(0, 10);
                break;
            }
            case 19: {
                this.curIndex = 5;
                this.roleMove(0, 10);
                if (++this.index < 10) break;
                this.dead();
                break;
            }
            case 5: {
                this.curIndex = -1;
                this.isDead = true;
            }
        }
    }

    public void move36() {
        this.checkNextState();
        switch (this.curStates) {
            case 0: 
            case 3: 
            case 21: {
                this.curIndex = 4;
                this.floatMove(0, 0);
                break;
            }
            case 25: {
                this.motion = new byte[]{4, 3, 2, 1, 0};
                this.curIndex = this.motion[this.index];
                this.floatMove(0, 0);
                if (++this.index < this.motion.length) break;
                this.setStates(26);
                break;
            }
            case 26: {
                this.curIndex = 0;
                this.floatMove(0, 0);
                if (++this.index < GameEngine.rollSpeed) break;
                this.setStates(27);
                break;
            }
            case 27: {
                this.motion = new byte[]{0, 1, 2, 3, 4};
                this.curIndex = this.motion[this.index];
                this.floatMove(0, 0);
                if (++this.index < this.motion.length) break;
                this.setStates(21);
            }
        }
    }

    public void drawMirror(int cx, int cy, int cIndex, int lev) {
        Tools.addObject(this.imgIndex, cx + this.offX, cy, Tools.bToi(clipDat[this.mode][cIndex][0]), Tools.bToi(clipDat[this.mode][cIndex][1]), Tools.bToi(clipDat[this.mode][cIndex][2]), Tools.bToi(clipDat[this.mode][cIndex][3]), 36, (byte)0, lev);
        if (cIndex == 0) {
            Tools.addObject(46, cx + 9, cy - 7, 68 * this.mirror + GameMIDlet.gameIndex % 2 * 34, 0, 34, 58, 36, (byte)0, lev);
        }
        if (this.curStates == 3) {
            byte[] temp = new byte[]{2, 1, 0, 1, 2};
            Tools.addObject(94, this.x + (this.dir == 3 ? -66 : (int)this.w), this.y - 20, 0, temp[this.index] * 19, 66, 19, 36, this.dir == 3 ? (byte)1 : 0, lev - 1);
            if (++this.index >= temp.length) {
                this.setStates(21);
            }
        }
    }

    public void move37() {
        this.getdistance();
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 21: 
            case 23: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                if (++this.index < 10) break;
                this.setStates(0);
                break;
            }
            case 1: {
                this.motion = new byte[]{2, 0, 0, 1, 1, 0, 0, 2};
                this.curIndex = this.motion[this.index];
                this.roleMove(this.index % 2 == 0 ? (this.dir == 3 ? (int)(-this.step) : (int)this.step) : 0, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 3, 3, 3, 3, 4, 5, 6, 6, 6, 6};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(21);
                break;
            }
            case 15: {
                this.motion = new byte[]{7, 0, 0, 0, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.dead();
                break;
            }
            case 22: {
                this.curIndex = 0;
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 4: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 19: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                this.dead();
                break;
            }
            case 5: {
                this.curIndex = -1;
                this.isDead = true;
                break;
            }
            case 9: {
                this.motion = new byte[]{3, 8, 9, 8, 9, 8, 9, 4, 5, 6, 6, 6, 6, 6, 6, 6};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (this.index == 7) {
                    GameEngine.addShot(GameEngine.enemyShot, 1, this.x + this.w / 2 + (this.dir == 3 ? -60 : 60), this.y - 16, this.dir == 3 ? -5 : 5, 0, this.attack);
                }
                if (++this.index < this.motion.length) break;
                this.setStates(21);
            }
        }
    }

    public void move38() {
        this.getdistance();
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 21: 
            case 23: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                if (++this.index < 20) break;
                this.setStates(0);
                break;
            }
            case 1: {
                this.motion = new byte[]{1, 2, 3, 4, 5};
                this.curIndex = this.motion[this.index];
                this.roleMove(this.dir == 3 ? -this.step : this.step, 10);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 3: {
                this.motion = new byte[]{10, 10, 9, 9};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (++this.index < this.motion.length) break;
                this.setStates(21);
                break;
            }
            case 9: {
                this.motion = new byte[]{6, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 0};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 10);
                if (this.index == 6) {
                    GameEngine.addShot(GameEngine.enemyShot, 2, this.x, this.y - 26, this.dir == 3 ? -15 : 15, 0, this.attack);
                }
                if (++this.index < this.motion.length) break;
                this.setStates(21);
                break;
            }
            case 15: {
                this.curIndex = 12;
                this.roleMove(0, 10);
                if (++this.index < 5) break;
                this.dead();
                break;
            }
            case 22: {
                this.curIndex = 12;
                this.roleMove(this.disX, this.disY);
                break;
            }
            case 4: {
                this.curIndex = 7;
                this.roleMove(0, 10);
                break;
            }
            case 19: {
                this.curIndex = 13;
                this.roleMove(0, 10);
                if (++this.index < 10) break;
                this.dead();
                break;
            }
            case 5: {
                this.curIndex = -1;
                this.isDead = true;
            }
        }
    }

    public void move39() {
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.motion = new byte[]{0, 1};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.floatMove(0, 0);
                break;
            }
            case 1: {
                this.motion = new byte[]{0, 1};
                this.curIndex = this.motion[this.index % this.motion.length];
                this.floatMove(this.dir == 3 ? -this.step : this.step, 0);
            }
        }
    }

    public void moveRole() {
        this.checkNextState();
        switch (this.curStates) {
            case 0: {
                this.curIndex = 0;
                this.floatMove(0, 0);
                break;
            }
            case 1: {
                this.curIndex = 0;
                this.floatMove(this.speedX, this.speedY);
            }
        }
        this.offY = (byte)(-(GameMIDlet.gameIndex % 4 / 2));
    }

    public void drawRole(int x, int y, int lev) {
        Tools.addObject(120, x, y, 36, this.faceDir == 3 ? (byte)1 : 0, lev);
    }

    public void roleCtrl(int key) {
        switch (key) {
            case -3: 
            case 52: {
                this.setDir(3);
                this.speedX = (byte)-4;
                this.setStates(1);
                break;
            }
            case -4: 
            case 54: {
                this.setDir(1);
                this.speedX = (byte)4;
                this.setStates(1);
                break;
            }
            case -1: 
            case 50: {
                this.speedY = (byte)-4;
                this.setStates(1);
                break;
            }
            case -2: 
            case 56: {
                this.speedY = (byte)4;
                this.setStates(1);
            }
        }
    }

    public void setAttArea(int type, int curFrame) {
        GameSprite.tempAtt[0] = 0;
        GameSprite.tempAtt[1] = 0;
        GameSprite.tempAtt[2] = 0;
        GameSprite.tempAtt[3] = 0;
        if (this.curStates != 3 && this.curStates != 14 && this.mode != 22 && this.mode != 31) {
            this.attArea[3] = 0;
            this.attArea[2] = 0;
            return;
        }
        switch (this.mode) {
            case 0: {
                switch (curFrame) {
                    case 14: {
                        GameSprite.tempAtt[0] = 19;
                        GameSprite.tempAtt[1] = 6;
                        GameSprite.tempAtt[2] = 23;
                        GameSprite.tempAtt[3] = 42;
                        break;
                    }
                    case 19: {
                        GameSprite.tempAtt[0] = 19;
                        GameSprite.tempAtt[1] = 0;
                        GameSprite.tempAtt[2] = 35;
                        GameSprite.tempAtt[3] = 23;
                        break;
                    }
                    case 22: {
                        GameSprite.tempAtt[0] = 19;
                        GameSprite.tempAtt[1] = -8;
                        GameSprite.tempAtt[2] = 34;
                        GameSprite.tempAtt[3] = 61;
                        break;
                    }
                    case 27: {
                        GameSprite.tempAtt[0] = 19;
                        GameSprite.tempAtt[1] = -12;
                        GameSprite.tempAtt[2] = 74;
                        GameSprite.tempAtt[3] = 40;
                        break;
                    }
                    case 31: {
                        GameSprite.tempAtt[0] = 0;
                        GameSprite.tempAtt[1] = 0;
                        GameSprite.tempAtt[2] = 96;
                        GameSprite.tempAtt[3] = 36;
                        break;
                    }
                    case 33: {
                        GameSprite.tempAtt[0] = -74;
                        GameSprite.tempAtt[1] = 0;
                        GameSprite.tempAtt[2] = 93;
                        GameSprite.tempAtt[3] = 36;
                    }
                }
                break;
            }
            case 22: {
                GameSprite.tempAtt[0] = 0;
                GameSprite.tempAtt[1] = 0;
                GameSprite.tempAtt[2] = this.w;
                GameSprite.tempAtt[3] = this.h;
                break;
            }
            case 23: {
                switch (curFrame) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        GameSprite.tempAtt[0] = -23;
                        GameSprite.tempAtt[1] = 0;
                        GameSprite.tempAtt[2] = 48;
                        GameSprite.tempAtt[3] = 46;
                    }
                }
                break;
            }
            case 24: {
                switch (curFrame) {
                    case 4: {
                        GameSprite.tempAtt[0] = -40;
                        GameSprite.tempAtt[1] = 7;
                        GameSprite.tempAtt[2] = 54;
                        GameSprite.tempAtt[3] = 60;
                        break;
                    }
                    case 7: {
                        GameSprite.tempAtt[0] = -55;
                        GameSprite.tempAtt[1] = 3;
                        GameSprite.tempAtt[2] = 68;
                        GameSprite.tempAtt[3] = 26;
                    }
                }
                break;
            }
            case 25: {
                switch (curFrame) {
                    case 3: {
                        GameSprite.tempAtt[0] = 0;
                        GameSprite.tempAtt[1] = 0;
                        GameSprite.tempAtt[2] = 22;
                        GameSprite.tempAtt[3] = 33;
                    }
                }
                break;
            }
            case 26: 
            case 30: {
                GameSprite.tempAtt[0] = 0;
                GameSprite.tempAtt[1] = 0;
                GameSprite.tempAtt[2] = 22;
                GameSprite.tempAtt[3] = 33;
                break;
            }
            case 27: {
                GameSprite.tempAtt[0] = 0;
                GameSprite.tempAtt[1] = 0;
                GameSprite.tempAtt[2] = this.w;
                GameSprite.tempAtt[3] = this.h;
                break;
            }
            case 28: {
                switch (curFrame) {
                    case 7: {
                        GameSprite.tempAtt[0] = -34;
                        GameSprite.tempAtt[1] = 0;
                        GameSprite.tempAtt[2] = 34;
                        GameSprite.tempAtt[3] = 65;
                    }
                }
                break;
            }
            case 29: {
                switch (curFrame) {
                    case 3: {
                        GameSprite.tempAtt[0] = -41;
                        GameSprite.tempAtt[1] = -19;
                        GameSprite.tempAtt[2] = 63;
                        GameSprite.tempAtt[3] = 33;
                    }
                }
                break;
            }
            case 31: {
                GameSprite.tempAtt[0] = 0;
                GameSprite.tempAtt[1] = 0;
                GameSprite.tempAtt[2] = this.w;
                GameSprite.tempAtt[3] = this.h;
                break;
            }
            case 32: {
                switch (curFrame) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        GameSprite.tempAtt[0] = 0;
                        GameSprite.tempAtt[1] = 0;
                        GameSprite.tempAtt[2] = 85;
                        GameSprite.tempAtt[3] = 52;
                    }
                }
                break;
            }
            case 35: {
                switch (curFrame) {
                    case 3: {
                        GameSprite.tempAtt[0] = 0;
                        GameSprite.tempAtt[1] = 0;
                        GameSprite.tempAtt[2] = this.w;
                        GameSprite.tempAtt[3] = this.h;
                    }
                }
                break;
            }
            case 37: {
                switch (curFrame) {
                    case 4: {
                        GameSprite.tempAtt[0] = -55;
                        GameSprite.tempAtt[1] = 0;
                        GameSprite.tempAtt[2] = 55;
                        GameSprite.tempAtt[3] = 59;
                    }
                }
                break;
            }
            case 38: {
                switch (curFrame) {
                    case 9: {
                        GameSprite.tempAtt[0] = -35;
                        GameSprite.tempAtt[1] = -18;
                        GameSprite.tempAtt[2] = 47;
                        GameSprite.tempAtt[3] = 18;
                    }
                }
            }
        }
        this.attArea[0] = (short)(this.isMirror ? this.x + this.w - tempAtt[0] - tempAtt[2] : this.x + tempAtt[0]);
        this.attArea[1] = (short)(this.y + tempAtt[1]);
        this.attArea[2] = tempAtt[2];
        this.attArea[3] = tempAtt[3];
    }

    public void AI_0() {
        block16: {
            block15: {
                if (this.hp <= 0) break block15;
                if (this.ID != GameEngine.spriteIndex && !this.autoMove && this.backTime <= 0) break block16;
            }
            return;
        }
        if (!Script.isNormal) {
            if (this.curStates != 0) {
                this.setStates(0);
            }
            return;
        }
        int rx = GameEngine.sprite[GameEngine.spriteIndex].x + GameEngine.sprite[GameEngine.spriteIndex].w / 2;
        int ry = GameEngine.sprite[GameEngine.spriteIndex].y;
        int ex = this.x + this.w / 2;
        int ey = this.y;
        int nextPos = ex + (this.dir == 3 ? -this.step : this.step);
        switch (this.curStates) {
            case 23: {
                if (Math.abs(rx - ex) >= this.attBound || Math.abs(ry - ey) >= 32) break;
                this.setDir(rx < ex ? 3 : 1);
                this.setStates(3);
                break;
            }
            case 0: {
                if (Math.abs(rx - ex) < this.attBound && Math.abs(ry - ey) < 32) {
                    this.setDir(rx < ex ? 3 : 1);
                    this.setStates(3);
                    break;
                }
                if (this.nextAreaIsDanger(nextPos, this.y + 10)) {
                    this.setDir(this.dir == 3 ? 1 : 3);
                }
                this.setStates(1);
                break;
            }
            case 1: {
                if (Math.abs(rx - ex) < this.attBound && Math.abs(ry - ey) < 32) {
                    this.setDir(rx < ex ? 3 : 1);
                    this.setStates(3);
                }
                if (!this.nextAreaIsDanger(nextPos, this.y + 10)) break;
                this.setStates(23);
                break;
            }
            case 15: {
                if (this.index != 1) break;
                this.setDir(ex < rx ? 1 : 3);
                break;
            }
            case 3: {
                if (!this.nextAreaIsDanger(nextPos, this.y + 10)) break;
                this.setStates(21);
            }
        }
    }

    public void AI_1() {
        block18: {
            block17: {
                if (this.hp <= 0) break block17;
                if (this.ID != GameEngine.spriteIndex && !this.autoMove && this.backTime <= 0) break block18;
            }
            return;
        }
        if (!Script.isNormal) {
            if (this.curStates != 0) {
                this.setStates(0);
            }
            return;
        }
        int rx = GameEngine.sprite[GameEngine.spriteIndex].x + GameEngine.sprite[GameEngine.spriteIndex].w / 2;
        int ry = GameEngine.sprite[GameEngine.spriteIndex].y;
        int ex = this.x + this.w / 2;
        int ey = this.y;
        int nextPos = ex + (this.dir == 3 ? -this.step : this.step);
        switch (this.curStates) {
            case 23: {
                if (Math.abs(rx - ex) >= this.attBound || Math.abs(ry - ey) >= 32) break;
                this.setDir(rx < ex ? 3 : 1);
                this.setStates(3);
                break;
            }
            case 0: {
                if (Math.abs(rx - ex) < this.attBound && Math.abs(ry - ey) < 32) {
                    this.setDir(rx < ex ? 3 : 1);
                    this.setStates(3);
                    break;
                }
                if (ex > this.startPosX + this.bound / 2) {
                    this.setDir(3);
                } else if (ex < this.startPosX - this.bound / 2) {
                    this.setDir(1);
                }
                this.setStates(1);
                break;
            }
            case 1: {
                if (Math.abs(rx - ex) < this.attBound && Math.abs(ry - ey) < 32) {
                    this.setDir(rx < ex ? 3 : 1);
                    this.setStates(3);
                }
                if (!(ex > this.startPosX + this.bound / 2 && this.dir == 1 || ex < this.startPosX - this.bound / 2 && this.dir == 3 || this.x < this.w / 2)) {
                    GameMap cfr_ignored_0 = this.engine.map;
                    if (this.x <= GameMap.mapSize[0] * 24 - this.w / 2) break;
                }
                this.setStates(23);
                break;
            }
            case 15: {
                if (this.index != 1) break;
                this.setDir(ex < rx ? 1 : 3);
                break;
            }
        }
    }

    public void AI_2() {
        block20: {
            block19: {
                if (this.hp <= 0) break block19;
                if (this.ID != GameEngine.spriteIndex && !this.autoMove && this.backTime <= 0) break block20;
            }
            return;
        }
        if (!Script.isNormal) {
            if (this.curStates != 0) {
                this.setStates(0);
            }
            return;
        }
        int rx = GameEngine.sprite[GameEngine.spriteIndex].x + GameEngine.sprite[GameEngine.spriteIndex].w / 2;
        int ry = GameEngine.sprite[GameEngine.spriteIndex].y;
        int ex = this.x + this.w / 2;
        int ey = this.y;
        int nextPos = ex + (this.dir == 3 ? -this.step : this.step);
        switch (this.curStates) {
            case 23: {
                if (Math.abs(rx - ex) < this.attBound && Math.abs(ry - ey) < 32) {
                    this.setDir(rx < ex ? 3 : 1);
                    this.setStates(3);
                    break;
                }
                if ((ex <= rx || ex - rx >= this.attBound2 || this.dir != 3) && (ex >= rx || rx - ex >= this.attBound2 || this.dir != 1) || Math.abs(ry - ey) >= 32) break;
                this.setStates(9);
                break;
            }
            case 0: {
                if (Math.abs(rx - ex) < this.attBound && Math.abs(ry - ey) < 32) {
                    this.setDir(rx < ex ? 3 : 1);
                    this.setStates(3);
                    break;
                }
                if ((ex > rx && ex - rx < this.attBound2 && this.dir == 3 || ex < rx && rx - ex < this.attBound2 && this.dir == 1) && Math.abs(ry - ey) < 32) {
                    this.setStates(9);
                    break;
                }
                if (this.nextAreaIsDanger(nextPos, this.y + 10)) {
                    this.setDir(this.dir == 3 ? 1 : 3);
                }
                this.setStates(1);
                break;
            }
            case 1: {
                if (Math.abs(rx - ex) < this.attBound && Math.abs(ry - ey) < 32) {
                    this.setDir(rx < ex ? 3 : 1);
                    this.setStates(3);
                } else if ((ex > rx && ex - rx < this.attBound2 && this.dir == 3 || ex < rx && rx - ex < this.attBound2 && this.dir == 1) && Math.abs(ry - ey) < 32) {
                    this.setStates(9);
                }
                if (!this.nextAreaIsDanger(nextPos, this.y + 10)) break;
                this.setStates(23);
                break;
            }
            case 15: {
                if (this.index != 1) break;
                this.setDir(ex < rx ? 1 : 3);
                break;
            }
            case 3: {
                if (!this.nextAreaIsDanger(nextPos, this.y + 10)) break;
                this.setStates(21);
            }
        }
    }

    public void AI_3() {
        block19: {
            block18: {
                if (this.hp <= 0) break block18;
                if (this.ID != GameEngine.spriteIndex && !this.autoMove && this.backTime <= 0) break block19;
            }
            return;
        }
        if (!Script.isNormal) {
            if (this.curStates != 0) {
                this.setStates(0);
            }
            return;
        }
        int rx = GameEngine.sprite[GameEngine.spriteIndex].x + GameEngine.sprite[GameEngine.spriteIndex].w / 2;
        int ry = GameEngine.sprite[GameEngine.spriteIndex].y;
        int ex = this.x + this.w / 2;
        int ey = this.y;
        int nextPos = ex + (this.dir == 3 ? -this.step : this.step);
        switch (this.curStates) {
            case 23: {
                break;
            }
            case 0: {
                if (ex > this.startPosX + this.bound / 2) {
                    this.setDir(3);
                } else if (ex < this.startPosX - this.bound / 2) {
                    this.setDir(1);
                }
                this.setStates(1);
                break;
            }
            case 1: {
                if (Math.abs(this.startPosY - ey) < this.step) {
                    ey = this.startPosY;
                    this.speedY = 0;
                } else {
                    this.speedY = ey > this.startPosY ? -this.step : this.step;
                }
                if ((ex > rx && ex - rx < this.attBound && this.dir == 3 || ex < rx && rx - ex < this.attBound && this.dir == 1) && Math.abs(ry - ey) < 96 && ey == this.startPosY) {
                    this.setStates(3);
                }
                if (!(ex > this.startPosX + this.bound / 2 && this.dir == 1 || ex < this.startPosX - this.bound / 2 && this.dir == 3 || this.x < this.w / 2)) {
                    GameMap cfr_ignored_0 = this.engine.map;
                    if (this.x <= GameMap.mapSize[0] * 24 - this.w / 2) break;
                }
                if (ey != this.startPosY) break;
                this.setStates(23);
                break;
            }
            case 15: {
                if (this.index != 1) break;
                this.setDir(ex < rx ? 1 : 3);
                break;
            }
        }
    }

    public boolean nextAreaIsDanger(int x, int y) {
        return !this.engine.map.canRun(x, y - 10) || !this.engine.map.canRun(x, y - this.h - 10) || this.engine.map.canFall(x, y) && !this.engine.map.isLadder(x, y) && !this.engine.map.canSlant_LEFT(x, y) && !this.engine.map.canSlant_RIGHT(x, y) || x < GameMap.sceen_minX + this.w / 2 || x > GameMap.sceen_maxX - this.w / 2;
    }

    public void run() {
        if (this.injureTime > 0) {
            --this.injureTime;
        }
        if (this.superTime > 0) {
            --this.superTime;
        }
        if (this.isDead && ++this.deadTime > 100 && !Tools.isDraw(this.startPosX - 10, this.startPosY + 10, this.w + 20, this.h + 20, 36)) {
            this.backToLife(false);
        }
        if (!this.visible || this.isDead) {
            return;
        }
        if (this.backTime > 0) {
            --this.backTime;
        }
        this.sx = 0;
        this.sy = 0;
        this.offX = 0;
        this.offY = 0;
        if (this.autoMove) {
            if (this.curStates == 0) {
                this.setStates(1);
            }
            if (Math.abs(this.x - this.toX) > this.step) {
                if (this.x < this.toX) {
                    this.setDir(1);
                } else if (this.x > this.toX) {
                    this.setDir(3);
                }
            } else if (Math.abs(this.y - this.toY) <= this.step) {
                this.x = this.toX;
                this.y = this.toY;
                this.setStates(0);
                this.autoMove = false;
                this.finish();
            }
        }
        if (!Tools.isDraw(this.x - 200, this.y + 200, 400, 400, 36)) {
            return;
        }
        switch (GameEngine.gameRank) {
            case 18: {
                if (this.mode != 0 || this.y <= GameMap.setOffY + GameMap.SCREEN_HEIGHT + 40 || this.hp <= 0) break;
                this.hp = 0;
                this.setStates(5);
                break;
            }
            default: {
                GameMap cfr_ignored_0 = this.engine.map;
                if (this.y <= GameMap.mapSize[1] * 24 + 40 || this.hp <= 0) break;
                this.hp = 0;
                this.setStates(5);
            }
        }
        switch (this.mode) {
            case 0: {
                this.move0();
                break;
            }
            case 1: {
                this.move1();
                break;
            }
            case 2: {
                this.move2();
                break;
            }
            case 3: {
                this.move3();
                break;
            }
            case 16: {
                this.move16();
                break;
            }
            case 22: {
                this.move22();
                break;
            }
            case 23: {
                this.AI_\u91d1\u89d2\u5927\u738b();
                this.move23();
                break;
            }
            case 24: {
                this.AI_1();
                this.move24();
                break;
            }
            case 25: {
                this.AI_0();
                this.move25();
                break;
            }
            case 26: 
            case 30: {
                this.AI_0();
                this.move26();
                break;
            }
            case 27: {
                this.AI_0();
                this.move27();
                break;
            }
            case 28: {
                this.AI_0();
                this.move28();
                break;
            }
            case 29: {
                this.AI_0();
                this.move29();
                break;
            }
            case 31: {
                this.move31();
                break;
            }
            case 32: {
                this.AI_\u767d\u9aa8\u7cbe();
                this.move32();
                break;
            }
            case 33: {
                this.AI_\u9f99\u5934();
                this.move33();
                break;
            }
            case 34: {
                this.AI_1();
                this.move34();
                break;
            }
            case 35: {
                this.AI_3();
                this.move35();
                break;
            }
            case 36: {
                this.move36();
                break;
            }
            case 37: {
                this.AI_2();
                this.move37();
                break;
            }
            case 38: {
                this.AI_0();
                this.move38();
                break;
            }
            case 39: {
                this.move39();
                break;
            }
            case 40: {
                this.moveRole();
                break;
            }
            default: {
                this.move4();
            }
        }
        this.setMirror();
        this.setAttArea(this.mode, this.curIndex);
        if (this.isDead) {
            GameEngine.AddBlastEffectList(this.x + this.w / 2, this.y, 4, 0);
            int temp = this.getExp;
            if (!this.isBoss()) {
                temp = Math.max(0, this.getExp - this.getExp * (GameEngine.sprite[0].level - this.level) / 10);
            }
            GameEngine.sprite[0].getExp(temp);
            this.drop();
            this.deadTime = 0;
        }
        this.sx = this.x + (this.isMirror ? -this.rx : -this.lx) + this.offX;
        this.sy = this.y + this.dy + 5 + this.offY;
    }

    public boolean isBoss() {
        return this.mode == 22 || this.mode == 23 || this.mode == 32 || this.mode == 33;
    }

    public void getExp(int value) {
        if (value == 0) {
            return;
        }
        if (this.level >= levMax) {
            return;
        }
        this.exp += (value *= MyGameCanvas.twiceExp ? 2 : 1);
        while (this.exp >= this.exp_max) {
            this.levelUp();
        }
        GameEngine.addGetExpNum(1, value, this.x + Event.getRandom(this.w / 3, this.w * 2 / 3), this.y - Event.getRandom(this.h / 3, this.h * 2 / 3));
    }

    public void drop() {
        int rate = Event.getRandom(0, 100);
        if (rate < 5) {
            GameEngine.addDrop(0, Math.min(24, this.level / 4 * 3), this.x + this.w / 2, this.y - this.h, 0, -20);
        } else if (rate < 10) {
            GameEngine.addDrop(0, Math.min(54, 30 + this.level / 4 * 3), this.x + this.w / 2, this.y - this.h, 0, -20);
        } else if (rate < 15) {
            GameEngine.addDrop(0, Math.min(69, 60 + this.level / 4), this.x + this.w / 2, this.y - this.h, 0, -20);
        } else if (rate < 20) {
            GameEngine.addDrop(1, Math.min(2, this.level / 10), this.x + this.w / 2, this.y - this.h, 0, -20);
        } else if (rate < 25) {
            GameEngine.addDrop(1, 3, this.x + this.w / 2, this.y - this.h, 0, -20);
        } else if (rate < 30) {
            GameEngine.addDrop(1, 4, this.x + this.w / 2, this.y - this.h, 0, -20);
        } else {
            int temp = this.getMoney;
            if (temp == 0) {
                return;
            }
            boolean tempDir = true;
            int b = Math.max(10, temp / 10);
            int tempSpeedX = 0;
            while (temp > 0) {
                int tempSpeedY = 15 + Event.getRandom(5, 10);
                if (temp > b) {
                    GameEngine.addDrop(2, b, this.x + this.w / 2, this.y - this.h, tempSpeedX * (tempDir ? 1 : -1), -tempSpeedY);
                    tempDir = !tempDir;
                    temp -= b;
                    ++tempSpeedX;
                    continue;
                }
                GameEngine.addDrop(2, temp, this.x + this.w / 2, this.y - this.h, tempSpeedX * (tempDir ? 1 : -1), -tempSpeedY);
                temp = 0;
            }
        }
    }

    public void useItem(Item item) {
        this.getExp(item.exp);
        this.attack += item.att_Max;
        this.defend += item.def_Max;
        this.hp_max += item.hp_Max;
        this.resetProp();
        this.hp = Math.min(this.allHp, this.hp + item.hp1);
        this.mp = Math.min(this.mp_max, this.mp + item.mp1);
    }

    public void drawLevUp(int x, int y, int lev, int index) {
        byte[] levMotion = new byte[]{0, 1, 2, 3, 4, 5};
        if (index >= levMotion.length) {
            return;
        }
        byte[] adjustY = new byte[]{0, 0, 0, -4, -12, -32};
        Tools.addObject(196, x, y + adjustY[index], Data.clip_up[levMotion[index]], 40, (byte)0, lev);
        Tools.addObject(196, x - 1, y + adjustY[index], Data.clip_up[levMotion[index]], 36, (byte)1, lev);
        if (index > 0) {
            Tools.addObject(197, x - 8, y - 20 - 2 * index, 36, (byte)0, lev);
        }
    }

    public void drawLight(int lev) {
        byte[] motion = new byte[]{0, 1, 2, 3};
        int i = 0;
        while (i < 4) {
            int tempIndex = this.lightIndex - 4 - i;
            if (tempIndex >= 0 && tempIndex <= 3) {
                byte curLight = motion[tempIndex];
                Tools.addObject(51, GameMap.setOffX + GameMap.SCREEN_WIDTH / 5 * (i + 1) - Data.indent_light[curLight][0], GameMap.setOffY + GameMap.SCREEN_HEIGHT + Data.indent_light[curLight][3], Data.clip_light[curLight], 36, (byte)0, lev);
            }
            ++i;
        }
        Tools.addObject(52, GameMap.setOffX, GameMap.setOffY + Math.min(-27 + 9 * this.lightIndex, 0), 20, (byte)0, lev);
        ++this.lightIndex;
    }

    public void paint() {
        if (!this.visible || this.isDead) {
            return;
        }
        if (this.curIndex == -1) {
            return;
        }
        if (this.injureTime > 0 && GameMIDlet.gameIndex % 2 == 0) {
            return;
        }
        if (this.backTime > 0 && GameMIDlet.gameIndex % 2 == 0) {
            return;
        }
        this.drawLev = this.mode == 0 || this.autoMove ? 55 : 50;
        if (!(this.curStates != 31 && this.curStates != 32 || this.index >= 70 && GameMIDlet.gameIndex % 2 != 0)) {
            Tools.addObject(17, this.x + this.w / 2 - (this.isMirror ? 23 : 37), this.y + 13 + 5, GameMap.imgDat_cloud[1], 36, this.isMirror ? (byte)0 : 1, this.drawLev);
        }
        if (this.mode == 22) {
            this.drawHeart(this.drawLev);
        }
        if (this.mode == 16) {
            Tools.addObject(this.imgIndex, this.sx, this.sy, 21 * this.curIndex, 0, 21, 37, 36, this.faceDir == 3 ? (byte)0 : 1, this.drawLev);
        } else if (this.mode == 39) {
            this.drawDust(this.x, this.y, this.drawLev);
        } else if (this.mode == 33) {
            this.drawDragon(this.drawLev);
        } else if (this.mode == 36) {
            this.drawMirror(this.sx, this.sy, this.curIndex, this.drawLev - 10);
        } else if (this.mode == 40) {
            this.drawRole(this.sx, this.sy, this.drawLev);
        } else if (this.mode >= 4 && this.mode < 22 || this.mode > 40) {
            Tools.addObject(this.imgIndex, this.sx, this.sy + (this.mode == 8 ? -10 : 0), 36, this.faceDir == 3 ? (byte)0 : 1, this.drawLev);
        } else {
            Tools.drawFrame(this.imgIndex, this.sx, this.sy, frameDat[this.mode][this.curIndex], clipDat[this.mode], this.isMirror, this.drawLev);
        }
        this.drawFace(this.x - 7, this.y - 36, this.drawLev);
        if (this.isBoss() && Tools.isDraw(this.x, this.y, this.w, this.h, 36) && this.type != 0) {
            Tools.addObject((byte)1, GameMap.setOffX + GameMap.SCREEN_WIDTH - 100, GameMap.setOffY + GameMap.SCREEN_HEIGHT - 3, 100, 5, true, 36, 0xFF0000, 100);
            Tools.addObject((byte)1, GameMap.setOffX + GameMap.SCREEN_WIDTH - 100, GameMap.setOffY + GameMap.SCREEN_HEIGHT - 3, this.hp * 100 / this.allHp, 5, true, 36, 0xFFFF00, 100);
        }
    }

    public void drawDust(int x, int y, int lev) {
        Tools.addObject(97, x + 12 - 47, y + 5, imgDatDust[GameMIDlet.gameIndex % 2], 36, (byte)0, lev);
        GameEngine.AddBlastEffectList(x + 12 + Event.getRandom(-40, 40), y - 35 + Event.getRandom(-40, 40), 1, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ctrl(int keyCode) {
        if (this.autoMove || this.isAction || this.isStep || this.hp <= 0) {
            return;
        }
        if (!Script.isNormal) {
            return;
        }
        if (this.mode == 40) {
            this.roleCtrl(keyCode);
            return;
        }
        switch (keyCode) {
            case -5: 
            case 53: {
                this.isConAtt = false;
                switch (this.curStates) {
                    case 0: 
                    case 1: {
                        this.setStates(3);
                        return;
                    }
                    case 3: {
                        this.isConAtt = true;
                        return;
                    }
                    case 2: {
                        this.setStates(14);
                    }
                }
                return;
            }
            case -1: 
            case 50: {
                if (this.mode != 0) {
                    return;
                }
                switch (this.curStates) {
                    case 0: 
                    case 1: {
                        this.setStates(2);
                        this.jumpKey = false;
                        this.speedY = (byte)-24;
                        GameEngine.AddBlastEffectList(this.x + this.w / 2 - 12, this.y, 6, 0);
                        GameEngine.AddBlastEffectList(this.x + this.w / 2 + 12, this.y, 6, 1);
                    }
                }
                return;
            }
            case 49: {
                switch (this.curStates) {
                    case 0: 
                    case 1: {
                        this.setStates(2);
                        this.setDir(3);
                        this.jumpKey = true;
                        this.speedY = (byte)-24;
                        GameEngine.AddBlastEffectList(this.x + this.w / 2 - 12, this.y, 6, 0);
                        GameEngine.AddBlastEffectList(this.x + this.w / 2 + 12, this.y, 6, 1);
                    }
                }
                return;
            }
            case 51: {
                switch (this.curStates) {
                    case 0: 
                    case 1: {
                        this.setStates(2);
                        this.setDir(1);
                        this.jumpKey = true;
                        this.speedY = (byte)-24;
                        GameEngine.AddBlastEffectList(this.x + this.w / 2 - 12, this.y, 6, 0);
                        GameEngine.AddBlastEffectList(this.x + this.w / 2 + 12, this.y, 6, 1);
                    }
                }
                return;
            }
            case 55: {
                switch (this.curStates) {
                    case 0: {
                        if (this.skills == null) return;
                        this.skillIndex = (this.skillIndex + 1) % this.skills.length;
                    }
                }
                return;
            }
            case 57: {
                switch (this.curStates) {
                    case 0: {
                        if (this.skills == null || this.mp < this.mp_max) return;
                        GameEngine.skillTime = 999;
                        this.setStates(25);
                        this.mp = 0;
                        this.superTime = 999;
                    }
                }
            }
        }
    }

    public void addPower(int value) {
        this.hp = Math.min(this.allHp, this.hp + Math.max(1, this.allHp * 2 / 100));
        this.mp = Math.min(this.mp_max, this.mp + value);
    }

    public void ctrlRelease(int key) {
        if (!Script.isNormal) {
            return;
        }
        if (this.mode == 40) {
            this.speedY = 0;
            this.speedX = 0;
            return;
        }
        if (this.curStates == 1 || this.nextStates == 1) {
            this.setStates(0);
        }
    }

    public void setStates(int state) {
        this.nextStates = (byte)state;
        this.index = 0;
        if (this.isAction) {
            this.finish();
            this.isAction = false;
        }
    }

    public void setDir(int direct) {
        this.nextDir = direct;
        this.nextFaceDir = direct;
    }

    public void setNextPoint(int nx, int ny) {
        this.toX = nx;
        this.toY = ny;
        this.setStates(1);
        this.autoMove = true;
    }

    public void step(boolean isBack, int steps) {
        if (isBack) {
            this.nextDir = (this.dir + 2) % 4;
        }
        this.steps = steps;
        this.setStates(1);
        this.isStep = true;
    }

    public void showAction(int state) {
        this.setStates(state);
        switch (state) {
            case 2: {
                this.speedY = (byte)-20;
            }
        }
        this.isAction = true;
    }

    public void setVisible(int x, int y, int dir) {
        this.visible = true;
        this.x = x;
        this.y = y;
        this.nextDir = this.dir = dir;
        this.faceDir = this.dir;
        this.nextFaceDir = this.dir;
        this.curStates = 0;
        this.nextStates = 0;
        this.index = 0;
    }

    public void setUnVisible() {
        this.visible = false;
    }

    public void getSize(int index) {
        if (index == -1) {
            return;
        }
        if (this.mode == 16) {
            this.rx = 1;
            this.lx = 1;
            this.dy = 0;
        } else if (this.mode == 39) {
            this.rx = 0;
            this.lx = 0;
            this.dy = 0;
        } else if (this.mode == 40) {
            this.lx = 11;
            this.rx = 3;
            this.dy = 2;
        } else if (this.mode > 40) {
            this.lx = 9;
            this.rx = 0;
            this.dy = 3;
        } else if (this.mode >= 4 && this.mode < 22) {
            this.lx = allIndent[this.mode - 4][0];
            this.rx = allIndent[this.mode - 4][1];
            this.dy = allIndent[this.mode - 4][3];
        } else {
            this.lx = indent[this.mode][index][0];
            this.rx = indent[this.mode][index][1];
            this.dy = indent[this.mode][index][3];
        }
        if (this.mode == 0) {
            if (index == 3) {
                this.w = (short)19;
                this.h = (short)18;
            } else {
                this.w = (short)19;
                this.h = (short)36;
            }
        }
    }

    private void toStopStatus() {
        switch (this.curStates) {
            case 2: 
            case 4: 
            case 14: {
                this.index = 0;
                if (this.mode == 23) {
                    this.curStates = 21;
                    this.nextStates = 21;
                } else {
                    this.curStates = 0;
                    this.nextStates = 0;
                }
                if (this.mode != 0) break;
                GameEngine.AddBlastEffectList(this.x + this.w / 2 - 12, this.y, 6, 0);
                GameEngine.AddBlastEffectList(this.x + this.w / 2 + 12, this.y, 6, 1);
                break;
            }
            case 22: {
                this.index = 0;
                this.speedX = 0;
                this.curStates = 19;
                this.nextStates = 19;
                break;
            }
            case 5: {
                this.nextIsDead = true;
            }
        }
        this.setRebornXY();
    }

    public void floatMove(int mx, int my) {
        this.getSize(this.curIndex);
        this.x += mx;
        this.y += my;
        if (MyGameCanvas.gameStatus == 7) {
            if (this.x > GameMap.sceen_minX - 20 && this.x + this.w < GameMap.sceen_maxX + 20) {
                this.x = (short)Math.max(GameMap.sceen_minX, this.x);
                this.x = (short)Math.min(this.x, GameMap.sceen_maxX - this.w);
            }
            this.y = (short)Math.max(10, this.y);
            this.y = (short)Math.min(this.y, GameMap.mapSize[1] * 24);
        }
    }

    public void roleMove(int mx, int my) {
        GameMap map = this.engine.map;
        this.getSize(this.curIndex);
        int dx = mx + (mx < 0 ? 0 : (mx == 0 ? (this.dir == 3 ? 0 : this.w - 1) : this.w - 1));
        if (mx != 0) {
            this.x = !map.canRun(this.x + dx, this.y) || !map.canRun(this.x + dx, this.y - this.h) ? (mx < 0 ? (int)((short)((this.x + dx) / GameMap.tileWidth * GameMap.tileWidth + GameMap.tileWidth)) : (int)((short)((this.x + dx) / GameMap.tileWidth * GameMap.tileWidth - this.w - 1))) : (this.x += mx);
        }
        if (my > 0) {
            if (!map.canFall(this.x + 5, this.y + my) || !map.canFall(this.x + this.w - 5, this.y + my)) {
                this.y = (short)((this.y + my) / GameMap.tileHight * GameMap.tileHight - 1);
                this.toStopStatus();
            } else if (map.isLadder(this.x + this.w / 2, this.y + my)) {
                this.y = (short)((this.y + my) / GameMap.tileHight * GameMap.tileHight - 1);
                this.toStopStatus();
            } else {
                this.y += my;
                if (this.curStates != 4 && this.curStates != 2 && this.curStates != 14 && this.curStates != 22) {
                    this.isDrop = true;
                }
            }
        } else if (my < 0) {
            if (!map.canUp(this.x, this.y + my - this.h) || !map.canUp(this.x + this.w, this.y + my - this.h)) {
                this.y = (short)((this.y + my - this.h) / GameMap.tileHight * GameMap.tileHight + GameMap.tileHight + this.h);
                this.isDrop = true;
            } else {
                this.y += my;
            }
        }
        if (map.canSlant_LEFT(this.x + this.w / 2, this.y) && my > 0) {
            this.y = (short)(this.y / 24 * 24 + 24 - (this.x + this.w / 2) % 24 - 1);
            this.toStopStatus();
        } else if (map.canSlant_RIGHT(this.x + this.w / 2, this.y) && my > 0) {
            this.y = (short)(this.y / 24 * 24 + (this.x + this.w / 2) % 24 - 1);
            this.toStopStatus();
        } else if (this.isDrop && (this.hp > 0 || this.type == 0)) {
            this.setStates(4);
        }
        this.isDrop = false;
        if (MyGameCanvas.gameStatus == 7) {
            if (this.x > GameMap.sceen_minX - 20 && this.x + this.w < GameMap.sceen_maxX + 20) {
                this.x = (short)Math.max(GameMap.sceen_minX, this.x);
                this.x = (short)Math.min(this.x, GameMap.sceen_maxX - this.w);
            }
            this.y = (short)Math.max(GameMap.sceen_minY + 10, this.y);
        }
    }

    private void setRebornXY() {
        if (this.mode != 0) {
            return;
        }
        this.reborn_x = this.x;
        this.reborn_y = this.y;
    }

    public void reborn() {
        this.isDead = false;
        this.hp = this.allHp;
        this.curStates = 0;
        this.nextStates = 0;
        this.index = 0;
        this.backTime = 10;
        this.superTime = 30;
        this.x = this.reborn_x;
        this.y = this.reborn_y;
        if (GameEngine.gameRank == 18) {
            this.curStates = 31;
            this.nextStates = 31;
            this.x = GameMap.setOffX + GameMap.SCREEN_WIDTH / 2 - 10;
            this.y = GameMap.setOffY + GameMap.SCREEN_HEIGHT;
        }
    }

    public void showFace(int face) {
        this.faceID = face;
        this.faceIndex = 0;
    }

    public void drawFace(int x, int y, int lev) {
        if (this.faceID == -1) {
            return;
        }
        Tools.addObject(faceImg[this.faceID], x - 11, y, faceMotion[this.faceIndex] * 21, 0, 21, 23, 36, (byte)0, lev);
        if (++this.faceIndex >= faceMotion.length) {
            this.faceIndex = 0;
            this.faceID = -1;
            this.finish();
        }
    }

    public void setRoleLev(int lev) {
        if (lev <= this.level) {
            return;
        }
        lev = Math.min(lev, levMax);
        int levOff = lev - this.level;
        this.attack += 7 * levOff;
        this.defend += 5 * levOff;
        this.hp_max += 21 * levOff;
        this.resetProp();
        this.hp = this.allHp;
        this.level = lev;
        this.exp_max = this.getStandardExpMax(this.type, this.level);
        this.setStates(6);
    }

    public void levelUp() {
        this.attack += 7;
        this.defend += 5;
        this.hp_max += 21;
        this.resetProp();
        this.hp = this.allHp;
        this.exp = Math.max(0, this.exp - this.exp_max);
        ++this.level;
        this.exp_max = this.getStandardExpMax(this.type, this.level);
        this.setStates(6);
    }

    public int getStandardExpMax(int type, int lev) {
        if (lev <= 20) {
            return (3 * (lev + 1) + 4 * (lev - 1) * lev) * 6;
        }
        if (lev < 40) {
            return (3 * (lev + 1) + 4 * (lev - 1) * lev) * 5 / 4 * 8;
        }
        return 99999;
    }

    public void setAttack() {
        this.allAtt = this.attack;
        int i = 0;
        while (i < this.equips.length) {
            if (this.equips[i] != -1) {
                this.allAtt += GameEngine.equips[this.equips[i]].att;
            }
            ++i;
        }
    }

    public void setDefend() {
        this.allDef = this.defend;
        int i = 0;
        while (i < this.equips.length) {
            if (this.equips[i] != -1) {
                this.allDef += GameEngine.equips[this.equips[i]].def;
            }
            ++i;
        }
    }

    public void setFlash() {
        this.allFlash = this.flash;
        int i = 0;
        while (i < this.equips.length) {
            if (this.equips[i] != -1) {
                this.allFlash += GameEngine.equips[this.equips[i]].flash;
            }
            ++i;
        }
    }

    public void setCollect() {
        this.allCollect = this.collect;
        int i = 0;
        while (i < this.equips.length) {
            if (this.equips[i] != -1) {
                this.allCollect += GameEngine.equips[this.equips[i]].addMP;
            }
            ++i;
        }
    }

    public void setHP_MAX() {
        this.allHp = this.hp_max;
        int i = 0;
        while (i < this.equips.length) {
            if (this.equips[i] != -1) {
                this.allHp += GameEngine.equips[this.equips[i]].HP;
            }
            ++i;
        }
        if (this.hp > this.allHp) {
            this.hp = this.allHp;
        }
    }

    public void resetProp() {
        this.setAttack();
        this.setDefend();
        this.setFlash();
        this.setCollect();
        this.setHP_MAX();
    }

    public void backToLife(boolean isLocal) {
        if (this.isBoss() || GameEngine.isPeace == 1) {
            return;
        }
        this.isDead = false;
        this.hp = this.allHp;
        this.setStates(0);
        this.backTime = 10;
        if (!isLocal) {
            this.x = this.startPosX;
            this.y = this.startPosY;
        }
    }

    public void sender(Event event, String command) {
        this.event = event;
        this.command = command;
    }

    public void finish() {
        if (this.event != null) {
            this.event.setEnd(this.command);
            this.event = null;
            this.command = null;
        }
    }

    public static void free() {
        int i = 4;
        while (i < ROLE_MAX) {
            GameSprite.clipDat[i] = null;
            GameSprite.frameDat[i] = null;
            GameSprite.indent[i] = null;
            ++i;
        }
    }
}

