/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Event {
    static final String COMMAND_IF = "if";
    static final String COMMAND_ELSE = "else";
    static final String COMMAND_ENDIF = "endIf";
    static final String COMMAND_SYNC = "sync";
    static final String COMMAND_ENDSYNC = "endSync";
    static final String COMMAND_LOOP = "loop";
    static final String COMMAND_ENDLOOP = "endLoop";
    static final String ORDER_STATUS_READY = "ready";
    static final String ORDER_STATUS_GO = "go";
    static final String ORDER_STATUS_END = "end";
    static final int BLOCK_SYNC = 0;
    static final int BLOCK_STEP = 1;
    private Vector vRoot = new Vector();
    public String name;
    public int id;
    static int waitTime;
    public static final int OCCUR_ERROR = -1;
    public static final int OCCUR_AREA = 0;
    public static final int OCCUR_SPRITE = 1;
    public static final int OCCUR_NULL = 2;
    public static final int OCCUR_NEXT_AREA = 3;
    public static final int OCCUR_TEXT = 4;
    private int occurType;
    private int[] occurNpcs;
    private int[] area;
    private String text;
    boolean eventIsAlive;
    boolean inEventArea = true;
    public boolean isKeyAlive;
    static int mapID;
    static int posX;
    static int posY;
    static int dir;
    static boolean isChangeMap;
    static boolean isVisible;
    private static boolean isNot;
    private static boolean minus;
    static String[] buff;

    public Event(String[] str) {
        String[] contents = this.init(str);
        if (contents == null) {
            System.out.println("script error!!!");
            return;
        }
        this.vRoot = this.parseOrderGroup(contents, 0, contents.length, "", 1);
    }

    public void run() {
        if (this.id >= 0 && Script.scriptVar[this.id] != 0) {
            return;
        }
        if (!this.eventIsAlive) {
            this.checkEventCondition();
        }
        if (Script.scriptPause) {
            return;
        }
        if (this.eventIsAlive) {
            this.runOrder(this.vRoot);
            if (((String)this.vRoot.elementAt(1)).equals(ORDER_STATUS_END)) {
                this.eventIsAlive = false;
                if (this.id < 0 || Script.scriptVar[this.id] == 0) {
                    this.initVector(this.vRoot);
                }
            }
        }
    }

    public boolean runInitEvent() {
        this.runOrder(this.vRoot);
        return ((String)this.vRoot.elementAt(1)).equals(ORDER_STATUS_END);
    }

    private void setCondition(String str) {
        String condition = str.substring(str.indexOf(32) + 1, str.length());
        String[] param = Event.getParams(condition, ",");
        String type = param[0];
        if (type.equals("area")) {
            this.occurType = 0;
            this.area = new int[]{Event.sToi(param[1]) - 1, Event.sToi(param[2]), Event.sToi(param[3]), Event.sToi(param[4])};
        } else if (type.equals("nextArea")) {
            this.occurType = 3;
            this.area = new int[]{Event.sToi(param[1]) - 1, Event.sToi(param[2]), Event.sToi(param[3]), Event.sToi(param[4])};
        } else if (type.equals("sprite")) {
            this.occurNpcs = new int[param.length - 1];
            int i = 0;
            while (i < this.occurNpcs.length) {
                this.occurNpcs[i] = Event.sToi(param[i + 1]);
                ++i;
            }
            this.occurType = 1;
            this.isKeyAlive = false;
        } else if (type.equals("null")) {
            this.occurType = 2;
        } else if (type.equals("text")) {
            this.occurType = 4;
            this.text = param[1];
        } else {
            this.occurType = -1;
        }
    }

    private void checkEventCondition() {
        if (!Script.isNormal) {
            return;
        }
        short w = GameEngine.sprite[GameEngine.spriteIndex].w;
        short h = GameEngine.sprite[GameEngine.spriteIndex].h;
        int posX = GameEngine.sprite[GameEngine.spriteIndex].x;
        int posY = GameEngine.sprite[GameEngine.spriteIndex].y - h;
        block0 : switch (this.occurType) {
            case 4: {
                if (!Event.conditionIsTrue(this.text)) break;
                this.eventIsAlive = true;
                break;
            }
            case 2: {
                this.eventIsAlive = true;
                break;
            }
            case 0: 
            case 3: {
                if (this.inEventArea) {
                    if (!Tools.hit(posX, posY, w, h, this.area[0], this.area[1], this.area[2], this.area[3])) {
                        this.inEventArea = false;
                    }
                } else if (Tools.hit(posX, posY, w, h, this.area[0], this.area[1], this.area[2], this.area[3])) {
                    if (!this.isKeyAlive) {
                        this.inEventArea = true;
                        this.eventIsAlive = true;
                    } else if (MyGameCanvas.confirmKey) {
                        this.eventIsAlive = true;
                    }
                }
                if (!this.eventIsAlive || GameEngine.sprite[GameEngine.spriteIndex].curStates == 1 || GameEngine.sprite[GameEngine.spriteIndex].curStates == 0) break;
                Script.scriptPause = true;
                Script.wall = GameEngine.sprite[GameEngine.spriteIndex].x;
                break;
            }
            case 1: {
                if (this.occurNpcs == null) {
                    return;
                }
                if (!MyGameCanvas.confirmKey) {
                    return;
                }
                int i = 0;
                while (i < this.occurNpcs.length) {
                    if (GameEngine.sprite[this.occurNpcs[i]].visible && Tools.hit(posX, posY, w, h, GameEngine.sprite[this.occurNpcs[i]].x, GameEngine.sprite[this.occurNpcs[i]].y, GameEngine.sprite[this.occurNpcs[i]].w, GameEngine.sprite[this.occurNpcs[i]].h)) {
                        this.eventIsAlive = true;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private String[] init(String[] str) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < str.length) {
            int start;
            String s;
            String command = this.getCommand(str[i]);
            if (command.equals("id")) {
                this.id = Event.sToi(Event.getParams(str[i], " ")[1]);
            } else if (command.equals("condition")) {
                this.setCondition(Event.getParams(str[i], " ")[1]);
            } else if (command.equals("keyOK")) {
                this.isKeyAlive = Event.getParams(str[i], " ")[1].equals("true");
            } else if (command.indexOf(".") != -1 && !(s = str[i].substring(start = str[i].indexOf(" ") + 1, str[i].length()).trim()).equals("")) {
                v.addElement(s);
            }
            ++i;
        }
        Object[] buff = new String[v.size()];
        v.copyInto(buff);
        return buff;
    }

    private static String trim(String str) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c != ' ') {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private Vector parseOrderGroup(String[] s, int start, int end, String parentName, int type) {
        int count = 3;
        Vector<Object> v = new Vector<Object>();
        v.addElement("" + type);
        v.addElement(ORDER_STATUS_READY);
        v.addElement("3");
        if (start > 0) {
            v.addElement(new String[]{s[start - 1], ORDER_STATUS_READY, parentName + "|" + count++});
        }
        int i = start;
        while (i < end) {
            int endIndex;
            String name = parentName + "|" + count++;
            String command = this.getCommand(s[i]);
            if (this.strCmp(command, "{") == 0) {
                endIndex = this.getEndIndex(s, i, "{", "}");
                v.addElement(this.parseOrderGroup(s, i + 1, endIndex + 1, name, 1));
                i = endIndex;
            } else if (this.strCmp(command, COMMAND_IF) == 0) {
                endIndex = this.getEndIndex(s, i, COMMAND_IF, COMMAND_ENDIF);
                v.addElement(this.parseOrderGroup(s, i + 1, endIndex + 1, name, 1));
                i = endIndex;
            } else if (this.strCmp(command, COMMAND_LOOP) == 0) {
                endIndex = this.getEndIndex(s, i, COMMAND_LOOP, COMMAND_ENDLOOP);
                v.addElement(this.parseOrderGroup(s, i + 1, endIndex + 1, name, 1));
                i = endIndex;
            } else if (this.strCmp(command, COMMAND_SYNC) == 0) {
                endIndex = this.getEndIndex(s, i, COMMAND_SYNC, COMMAND_ENDSYNC);
                v.addElement(this.parseOrderGroup(s, i + 1, endIndex + 1, name, 0));
                i = endIndex;
            } else {
                v.addElement(new String[]{s[i], ORDER_STATUS_READY, name});
            }
            ++i;
        }
        return v;
    }

    private int getElseIndex(Vector v) {
        int size = v.size();
        int i = 3;
        while (i < size) {
            String command;
            Object obj = v.elementAt(i);
            if (!(obj instanceof Vector) && this.strCmp(command = this.getCommand(((String[])obj)[0]), COMMAND_ELSE) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getEndIndex(String[] str, int cLine, String begin, String end) {
        int level = 0;
        int i = cLine;
        while (i < str.length) {
            String script = str[i];
            String command = this.getCommand(str[i]);
            if (this.strCmp(command, begin) == 0) {
                ++level;
            } else if (this.strCmp(command, end) == 0 && --level == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setEnd(String command) {
        this.getOrderEnd(this.vRoot, command);
    }

    private String getOrderEnd(Vector vector, String orderPath) {
        int len = vector.size();
        if (len <= 0) {
            return ORDER_STATUS_END;
        }
        int end = orderPath.indexOf(124, 1);
        if (end == -1) {
            end = orderPath.length();
        }
        int type = Event.sToi((String)vector.elementAt(0));
        int curLine = Event.sToi(orderPath.substring(1, end));
        switch (type) {
            case 1: {
                Object obj = vector.elementAt(curLine);
                if (obj instanceof Vector) {
                    Vector subclass = (Vector)obj;
                    String subName = orderPath.substring(end, orderPath.length());
                    String state = this.getOrderEnd(subclass, subName);
                    if (state.equals(ORDER_STATUS_END)) {
                        String sCurLine = "" + (Event.sToi((String)vector.elementAt(2)) + 1);
                        vector.setElementAt(sCurLine, 2);
                        if (curLine == vector.size() - 1) {
                            vector.setElementAt(ORDER_STATUS_END, 1);
                            return ORDER_STATUS_END;
                        }
                        return ORDER_STATUS_READY;
                    }
                    return ORDER_STATUS_READY;
                }
                String sCurLine = "" + (Event.sToi((String)vector.elementAt(2)) + 1);
                vector.setElementAt(sCurLine, 2);
                String[] str = (String[])vector.elementAt(curLine);
                str[1] = ORDER_STATUS_END;
                if (curLine == vector.size() - 1) {
                    vector.setElementAt(ORDER_STATUS_END, 1);
                    return ORDER_STATUS_END;
                }
                return ORDER_STATUS_READY;
            }
            case 0: {
                String result = ORDER_STATUS_END;
                int i = 4;
                while (i < vector.size() - 1) {
                    Object obj = vector.elementAt(i);
                    if (obj instanceof Vector) {
                        Vector subclass = (Vector)obj;
                        if (i == curLine) {
                            String subName = orderPath.substring(end, orderPath.length());
                            String state = this.getOrderEnd(subclass, subName);
                            if (!state.equals(ORDER_STATUS_END)) {
                                result = ORDER_STATUS_READY;
                            }
                        } else if (!((String)subclass.elementAt(1)).equals(ORDER_STATUS_END)) {
                            result = ORDER_STATUS_READY;
                        }
                    } else {
                        String[] str = (String[])obj;
                        if (i == curLine) {
                            str[1] = ORDER_STATUS_END;
                        }
                        if (!str[1].equals(ORDER_STATUS_END)) {
                            result = ORDER_STATUS_READY;
                        }
                    }
                    ++i;
                }
                vector.setElementAt(result, 1);
                return result;
            }
        }
        return ORDER_STATUS_END;
    }

    private void runOrder(Vector vector) {
        if (vector.size() <= 0) {
            return;
        }
        if (((String)vector.elementAt(1)).equals(ORDER_STATUS_END)) {
            return;
        }
        int type = Event.sToi((String)vector.elementAt(0));
        switch (type) {
            case 1: {
                int curLine = Event.sToi((String)vector.elementAt(2));
                Object obj = vector.elementAt(curLine);
                if (obj instanceof Vector) {
                    Vector subclass = (Vector)obj;
                    this.runOrder(subclass);
                    break;
                }
                String order = ((String[])obj)[0];
                String command = this.getCommand(order);
                if (command.equals(COMMAND_LOOP)) {
                    String condition = this.getCondition(order);
                    if (!Event.conditionIsTrue(Event.trim(condition))) {
                        curLine = vector.size() - 1;
                        vector.setElementAt("" + curLine, 2);
                        obj = vector.elementAt(curLine);
                        this.setEnd(((String[])obj)[2]);
                        return;
                    }
                    this.initVector(vector);
                    vector.setElementAt("" + ++curLine, 2);
                    this.runOrder(vector);
                    break;
                }
                if (command.equals(COMMAND_IF)) {
                    String condition = this.getCondition(order);
                    String sCurLine = "";
                    if (Event.conditionIsTrue(Event.trim(condition))) {
                        ++curLine;
                    } else {
                        int elseIndex = this.getElseIndex(vector);
                        if (elseIndex != -1) {
                            curLine = elseIndex + 1;
                        } else {
                            curLine = vector.size() - 1;
                            sCurLine = "" + curLine;
                            vector.setElementAt(sCurLine, 2);
                            obj = vector.elementAt(curLine);
                            this.setEnd(((String[])obj)[2]);
                            return;
                        }
                    }
                    vector.setElementAt("" + curLine, 2);
                    this.runOrder(vector);
                    break;
                }
                if (command.equals(COMMAND_SYNC) || command.equals("{")) {
                    String sCurLine = "" + (Event.sToi((String)vector.elementAt(2)) + 1);
                    vector.setElementAt(sCurLine, 2);
                    this.runOrder(vector);
                    break;
                }
                if (command.equals(COMMAND_ELSE)) {
                    curLine = vector.size() - 1;
                    vector.setElementAt("" + curLine, 2);
                    obj = vector.elementAt(curLine);
                    this.setEnd(((String[])obj)[2]);
                    break;
                }
                if (command.equals(COMMAND_ENDSYNC) || command.equals("}") || command.equals(COMMAND_ENDIF)) {
                    String sCurLine = "" + (Event.sToi((String)vector.elementAt(2)) + 1);
                    vector.setElementAt(sCurLine, 2);
                    this.setEnd(((String[])obj)[2]);
                    break;
                }
                if (command.equals(COMMAND_ENDLOOP)) {
                    curLine = 3;
                    vector.setElementAt("" + curLine, 2);
                    this.runOrder(vector);
                    break;
                }
                this.parseOrder((String[])obj);
                break;
            }
            case 0: {
                int i = 4;
                while (i < vector.size() - 1) {
                    Object obj = vector.elementAt(i);
                    if (obj instanceof Vector) {
                        Vector subclass = (Vector)obj;
                        this.runOrder(subclass);
                    } else {
                        this.parseOrder((String[])obj);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void initVector(Vector v) {
        int i = 0;
        while (i < v.size()) {
            Object obj = v.elementAt(i);
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    v.setElementAt(ORDER_STATUS_READY, 1);
                    break;
                }
                case 2: {
                    v.setElementAt("3", 2);
                    break;
                }
                default: {
                    if (obj instanceof Vector) {
                        this.initVector((Vector)obj);
                        break;
                    }
                    String[] order = (String[])obj;
                    order[1] = ORDER_STATUS_READY;
                }
            }
            ++i;
        }
    }

    private void parseOrder(String[] order) {
        if (order[1].equals(ORDER_STATUS_READY)) {
            System.out.println("order  " + order[0]);
            order[1] = ORDER_STATUS_GO;
            String command = this.getCommand(order[0]);
            if (command.equals("ctrl")) {
                String[] params = Event.getParams(order[0], " ");
                Script.isNormal = Event.getBoolValue(params[1]);
                Event.stopCurSprite();
            } else if (command.equals("set")) {
                String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                this.set(params[0], params[1]);
            } else if (command.equals("complete")) {
                String[] params = Event.getParams(order[0], " ");
                int result = Event.sToi(params[1]);
                if (this.id >= 0) {
                    Script.scriptVar[this.id] = (short)result;
                    if (result > 0) {
                        this.eventIsAlive = false;
                    }
                }
                if (isChangeMap) {
                    Event.changeMap();
                }
            } else {
                if (command.equals("move")) {
                    String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                    int id = Event.sToi(params[0]);
                    int x = Event.sToi(params[1]);
                    int y = Event.arithValue(params[2]);
                    GameEngine.sprite[id].sender(this, order[2]);
                    GameEngine.sprite[id].setNextPoint(x, y);
                    return;
                }
                if (command.equals("wait")) {
                    String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                    waitTime = Event.sToi(params[1]);
                } else if (command.equals("npcAppear")) {
                    String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                    int id = Event.sToi(params[0]);
                    int x = Event.sToi(params[2]);
                    int y = Event.sToi(params[3]);
                    int dir = GameSprite.getDir(params[4]);
                    GameEngine.sprite[id].setVisible(x, y, dir);
                } else if (command.equals("npcDisappear")) {
                    String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                    int id = Event.sToi(params[0]);
                    GameEngine.sprite[id].setUnVisible();
                } else if (command.equals("setDir")) {
                    String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                    int id = Event.sToi(params[0]);
                    int dir = GameSprite.getDir(params[1]);
                    GameEngine.sprite[id].setDir(dir);
                } else if (command.equals("setFace")) {
                    String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                    int id = Event.sToi(params[0]);
                    int face = Event.sToi(params[1]);
                    if (face >= 0 && face <= 7) {
                        GameEngine.sprite[id].showFace(face);
                        GameEngine.sprite[id].sender(this, order[2]);
                        return;
                    }
                } else {
                    if (command.equals("step")) {
                        String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                        int id = Event.sToi(params[0]);
                        boolean isBack = Event.getBoolValue(params[1]);
                        int steps = Event.sToi(params[2]);
                        boolean isCurSprite = Event.getBoolValue(params[3]);
                        id = isCurSprite ? GameEngine.spriteIndex : id;
                        GameEngine.sprite[id].step(isBack, steps);
                        GameEngine.sprite[id].sender(this, order[2]);
                        return;
                    }
                    if (command.equals("showAction")) {
                        String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                        int id = Event.sToi(params[0]);
                        if (params[1].equals("jump")) {
                            GameEngine.sprite[id].showAction(2);
                            GameEngine.sprite[id].sender(this, order[2]);
                            return;
                        }
                        if (params[1].equals("skill1")) {
                            GameEngine.sprite[id].showAction(25);
                            GameEngine.sprite[id].sender(this, order[2]);
                            return;
                        }
                        if (params[1].equals("up")) {
                            GameEngine.sprite[id].showAction(3);
                            GameEngine.sprite[id].sender(this, order[2]);
                            return;
                        }
                        if (params[1].equals("down")) {
                            GameEngine.sprite[id].showAction(26);
                            GameEngine.sprite[id].sender(this, order[2]);
                            return;
                        }
                        if (params[1].equals("small")) {
                            GameEngine.sprite[id].showAction(28);
                            GameEngine.sprite[id].sender(this, order[2]);
                            return;
                        }
                        if (params[1].equals("big")) {
                            GameEngine.sprite[id].showAction(30);
                            GameEngine.sprite[id].sender(this, order[2]);
                            return;
                        }
                    } else if (command.equals("showText")) {
                        String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                        int iconID = Event.sToi(params[0]);
                        int iconPos = Event.sToi(params[1]);
                        String title = params[2];
                        StringBuffer sb = new StringBuffer();
                        int i = 3;
                        while (i < params.length) {
                            sb.append(params[i]);
                            if (i != params.length - 1) {
                                sb.append(",");
                            }
                            ++i;
                        }
                        String text = sb.toString();
                        MyGameCanvas.initTalk(iconID, iconPos, title, text);
                        Event.stopCurSprite();
                    } else if (command.equals("showChoice")) {
                        String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                        boolean isBack = Event.getBoolValue(params[0]);
                        String title = this.parseStr(params[1]);
                        String[] options = new String[params.length - 2];
                        int i = 0;
                        while (i < options.length) {
                            options[i] = params[i + 2];
                            ++i;
                        }
                        GameEngine.toChooseStatus(title, options, isBack);
                    } else if (command.equals("setScene")) {
                        String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                        int mapID = Event.sToi(params[0]);
                        int x = Event.sToi(params[1]);
                        int y = Event.sToi(params[2]);
                        int dir = GameSprite.getDir(params[3]);
                        boolean visible = Event.getBoolValue(params[4]);
                        Event.toMap(mapID, x, y, dir, visible);
                        Script.isNormal = false;
                    } else {
                        if (command.equals("setCamera")) {
                            GameEngine.isToPoint = false;
                            String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                            if (params.length == 1) {
                                int spriteID = Event.sToi(params[0]);
                                GameEngine.spriteIndex = (byte)spriteID;
                            } else {
                                GameEngine.posX = Event.sToi(params[0]);
                                GameEngine.posY = Event.sToi(params[1]);
                                GameEngine.isToPoint = true;
                            }
                            GameMap.sender(this, order[2]);
                            GameMap.isMoveScreen = true;
                            Event.stopCurSprite();
                            return;
                        }
                        if (command.equals("gameOver")) {
                            MyGameCanvas.setST((byte)15);
                            GameEngine.gameFinish = true;
                        } else if (command.equals("addLog")) {
                            String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                            String key = params[0];
                            GameEngine.addTask(key);
                        } else if (command.equals("delLog")) {
                            String key = Event.getParams(order[0], " ")[1];
                            GameEngine.delTask(key);
                        } else if (command.equals("changeSkill")) {
                            String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                            boolean isAdd = params[0].equals("add");
                            int id = Event.sToi(params[1]);
                            byte skillId = (byte)Event.sToi(params[2]);
                            GameEngine.getSkill(skillId, isAdd);
                        } else if (command.equals("changeEquip")) {
                            String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                            boolean isAdd = params[0].equals("add");
                            if (isAdd) {
                                int id = Event.sToi(params[1]);
                                int val = Event.sToi(params[2]);
                                GameEngine.getItem(0, id, val);
                            }
                        } else if (command.equals("changeItem")) {
                            String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                            boolean isAdd = params[0].equals("add");
                            if (isAdd) {
                                int id = Event.sToi(params[1]);
                                int val = Event.sToi(params[2]);
                                GameEngine.getItem(1, id, val);
                            }
                        } else if (command.equals("showEffect")) {
                            String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                            int type = Event.sToi(params[0]);
                            int x = Event.sToi(params[1]) + GameMap.tileWidth / 2;
                            int y = Event.sToi(params[2]);
                            int isMirror = Event.sToi(params[3]) == 0 ? 0 : 1;
                            GameEngine.AddBlastEffectList(x, y, type, isMirror);
                        } else if (command.equals("random")) {
                            String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                            Script.temp = Event.getRandom(Event.sToi(params[0]), Event.sToi(params[1]));
                        } else if (command.equals("showCG")) {
                            String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                            int cgName = Event.sToi(params[0]);
                            String text = params[1];
                            MyGameCanvas.toBlackStatus(cgName, text);
                        } else {
                            if (command.equals("aside")) {
                                int first = order[0].indexOf(" ");
                                String text = order[0].substring(first, order[0].length()).trim();
                                MyGameCanvas.setInfo(text, 0);
                                MyGameCanvas.sender(this, order[2]);
                                return;
                            }
                            if (command.equals("filmStart")) {
                                GameEngine.filmSwitch = 1;
                                Script.isNormal = false;
                                Event.stopCurSprite();
                                GameEngine.sender(this, order[2]);
                                return;
                            }
                            if (command.equals("filmEnd")) {
                                GameEngine.filmSwitch = -1;
                                GameEngine.sender(this, order[2]);
                                Script.isNormal = true;
                                return;
                            }
                            if (command.equals("buyItem")) {
                                String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                                byte[] items = new byte[params.length];
                                int i = 0;
                                while (i < params.length) {
                                    items[i] = (byte)Event.sToi(params[i]);
                                    ++i;
                                }
                                MyGameCanvas.initSellItem(items);
                                Event.stopCurSprite();
                            } else if (command.equals("rest")) {
                                GameEngine.sprite[0].hp = GameEngine.sprite[0].allHp;
                            } else if (command.equals("chargePoint")) {
                                String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                                int id = Event.sToi(params[0]);
                                if (MyMessage.canSendAgian(MyMessage.PPid[id])) {
                                    MyGameCanvas.toPayState(MyMessage.PPid[id]);
                                }
                            } else if (command.equals("showGame")) {
                                String[] params = Event.getParams(order[0], " ");
                                GameEngine.isShowGame = Event.getBoolValue(params[1]);
                            } else if (command.equals("shake")) {
                                String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                                GameMap.shakeTime = Event.sToi(params[0]);
                            } else if (command.equals("taskFlag")) {
                                String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                                if (params[0].equals("null")) {
                                    GameMap.flagMap = -1;
                                } else {
                                    GameMap.flagMap = Event.sToi(params[0]);
                                    GameMap.flagX = Event.sToi(params[1]);
                                    GameMap.flagY = Event.sToi(params[2]);
                                }
                            } else if (command.equals("setCurSprite")) {
                                String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                                int id = Event.sToi(params[0]);
                                int dir = GameSprite.getDir(params[1]);
                                GameEngine.spriteIndex = id;
                                GameEngine.sprite[id].faceDir = GameEngine.sprite[id].nextFaceDir = dir;
                                GameEngine.sprite[id].nextDir = GameEngine.sprite[id].nextFaceDir;
                                GameEngine.sprite[id].dir = GameEngine.sprite[id].nextFaceDir;
                            } else if (command.equals("screenLock")) {
                                String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                                int min = Event.sToi(params[0]);
                                int w = Event.sToi(params[2]);
                                GameMap.lockSceen(min, min + w);
                            } else if (command.equals("screenUnLock")) {
                                GameMap.unLockSceen();
                            } else if (command.equals("autoMap")) {
                                String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                                GameMap.autoMapV = Event.sToi(params[0]);
                            } else if (command.equals("dropEquip")) {
                                String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                                int id = Event.sToi(params[0]);
                                int equipID = Event.sToi(params[1]);
                                GameSprite role = GameEngine.sprite[id];
                                GameEngine.addDrop(0, equipID, role.x + role.w / 2, role.y - role.h, 0, -20);
                            } else if (command.equals("dropItem")) {
                                String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                                int id = Event.sToi(params[0]);
                                int itemId = Event.sToi(params[1]);
                                GameSprite role = GameEngine.sprite[id];
                                GameEngine.addDrop(1, itemId, role.x + role.w / 2, role.y - role.h, 0, -20);
                            } else if (command.equals("adjustSceen")) {
                                String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                                int spriteID = Event.sToi(params[0]);
                                GameSprite role = GameEngine.sprite[spriteID];
                                GameMap.adjustSrceen(role.x + role.w / 2, role.y, role.dir == 3);
                                Event.stopCurSprite();
                            } else {
                                if (command.equals("input")) {
                                    String[] params = Event.getParams(Event.getParams(order[0], " ")[1], ",");
                                    GameEngine.inputKey = Event.sToi(params[0]);
                                    GameEngine.sender(this, order[2]);
                                    return;
                                }
                                if (command.equals("teachInfo")) {
                                    int first = order[0].indexOf(" ");
                                    String text = order[0].substring(first, order[0].length()).trim();
                                    GameEngine.showTeachInfo(text);
                                } else {
                                    System.out.println("Command:    " + command + "    is not find!!!");
                                }
                            }
                        }
                    }
                }
            }
            this.setEnd(order[2]);
        }
    }

    public static int getRandom(int min, int max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        return (GameEngine.rnd.nextInt() >>> 1) % (max - min) + min;
    }

    public static void stopCurSprite() {
        if (GameEngine.sprite[GameEngine.spriteIndex].curStates == 29 || GameEngine.sprite[GameEngine.spriteIndex].curStates == 28) {
            return;
        }
        if (GameEngine.sprite[GameEngine.spriteIndex].type == 0 || GameEngine.sprite[GameEngine.spriteIndex].hp > 0) {
            GameEngine.sprite[GameEngine.spriteIndex].setStates(0);
        }
    }

    public static void toMap(int id, int x, int y, int direct, boolean visible) {
        mapID = id;
        posX = x;
        posY = y;
        dir = direct;
        isChangeMap = true;
        isVisible = visible;
    }

    public static void changeMap() {
        GameEngine.setPlayXY(posX, posY, dir, isVisible);
        GameEngine.setRankEnd(mapID);
    }

    public static String[] splitString(String src, String key) {
        Vector<String> vt = new Vector<String>();
        int w = 0;
        boolean end = false;
        while (!end) {
            String s;
            int pos = src.indexOf(key, w);
            if (pos == -1) {
                pos = src.length();
                end = true;
            }
            int endIndex = pos;
            if (pos > 0 && src.charAt(pos - 1) == '\r') {
                endIndex = pos - 1;
            }
            if (!(s = src.substring(w, endIndex).trim()).equals("")) {
                vt.addElement(s);
            }
            w = pos + 1;
        }
        Object[] cs = new String[vt.size()];
        vt.copyInto(cs);
        vt = null;
        return cs;
    }

    private String getCommand(String script) {
        String s = script.indexOf(32) != -1 ? script.substring(0, script.indexOf(32)) : script.substring(0, script.length());
        return s;
    }

    public static String[] getParams(String order, String key) {
        String[] s = Event.splitString(order, key);
        return s;
    }

    public static int sToi(String s) {
        return Event.getIntValue(s);
    }

    public static short sTos(String s) {
        return Short.parseShort(s);
    }

    private int strCmp(String s1, String s2) {
        return s1.equals(s2) ? 0 : 1;
    }

    private String getCondition(String script) {
        int start = script.indexOf(32);
        int end = script.indexOf(13);
        if (end == -1) {
            end = script.length();
        }
        return script.substring(start, end);
    }

    private static int getFlagIndex(String string) {
        int level = 0;
        int i = 0;
        while (i < string.length()) {
            char tempChar = string.charAt(i);
            if (tempChar == '(') {
                ++level;
            } else if (tempChar == ')') {
                --level;
            }
            if (i > 0 && level == 0 && (tempChar == '&' || tempChar == '@')) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean getCompValue(String string) {
        int flagIndex = -1;
        int strLen = string.length();
        int i = 0;
        while (i < strLen) {
            char tempChar = string.charAt(i);
            if (tempChar == '>' || tempChar == '<' || tempChar == '=' || tempChar == '~') {
                flagIndex = i;
            }
            ++i;
        }
        if (flagIndex == -1) {
            boolean notIsExist;
            boolean bl = notIsExist = string.indexOf(33) != -1;
            return notIsExist ? !Event.getBoolValue(string.substring(1, string.length())) : Event.getBoolValue(string);
        }
        String first = string.substring(0, flagIndex);
        String second = string.substring(flagIndex + 1, string.length());
        boolean result = false;
        switch (string.charAt(flagIndex)) {
            case '>': {
                result = Event.getIntValue(first) > Event.getIntValue(second);
                break;
            }
            case '<': {
                result = Event.getIntValue(first) < Event.getIntValue(second);
                break;
            }
            case '=': {
                result = Event.getIntValue(first) == Event.getIntValue(second);
                break;
            }
            case '~': {
                result = Event.getIntValue(first) != Event.getIntValue(second);
            }
        }
        return result;
    }

    private static String getSubString(String string, int start, int end) {
        String tempString = string.substring(start, end);
        int level = 0;
        isNot = false;
        int flagStart = 0;
        int strLen = tempString.length();
        int i = 0;
        while (i < strLen) {
            if (tempString.charAt(i) != '!' || i != flagStart) break;
            ++flagStart;
            ++i;
        }
        if (tempString.charAt(flagStart) == '(') {
            ++level;
            int tmpLen = tempString.length();
            int i2 = flagStart + 1;
            while (i2 < tmpLen) {
                char tempChar = tempString.charAt(i2);
                if (tempChar == '(') {
                    ++level;
                } else if (tempChar == ')') {
                    --level;
                }
                if (level == 0 && i2 < tempString.length() - 1) {
                    return tempString;
                }
                ++i2;
            }
            boolean bl = isNot = flagStart % 2 != 0;
            if (isNot) {
                return tempString.substring(flagStart, tempString.length());
            }
            return tempString.substring(flagStart + 1, tempString.length() - 1);
        }
        return tempString;
    }

    public static boolean conditionIsTrue(String condition) {
        int operator = 0;
        boolean result = false;
        int flag = 120;
        boolean isTmpNot = false;
        String allSub = condition;
        allSub = Event.getSubString(allSub, 0, allSub.length());
        isTmpNot = isNot;
        operator = Event.getFlagIndex(allSub);
        if (operator == -1) {
            boolean isExpression = false;
            int strLen = allSub.length();
            int i = 0;
            while (i < strLen) {
                char tempChar = allSub.charAt(i);
                if (tempChar == '&' || tempChar == '@' || tempChar == '(') {
                    isExpression = true;
                    break;
                }
                ++i;
            }
            if (isExpression) {
                if (isTmpNot) {
                    return !Event.conditionIsTrue(allSub);
                }
                return Event.conditionIsTrue(allSub);
            }
            if (isTmpNot) {
                return !Event.getCompValue(allSub);
            }
            return Event.getCompValue(allSub);
        }
        boolean first = Event.conditionIsTrue(allSub.substring(0, operator));
        flag = allSub.charAt(operator);
        boolean second = Event.conditionIsTrue(allSub.substring(operator + 1, allSub.length()));
        switch (flag) {
            case 38: {
                result = first && second;
                break;
            }
            case 64: {
                result = first || second;
            }
        }
        return result;
    }

    private static String getSubString_Var(String string, int start, int end) {
        String tempString = string.substring(start, end);
        int level = 0;
        minus = false;
        int flagStart = 0;
        int strLen = tempString.length();
        int i = 0;
        while (i < strLen) {
            if (tempString.charAt(i) != '^' || i != flagStart) break;
            ++flagStart;
            minus = true;
            ++i;
        }
        if (tempString.charAt(flagStart) == '(') {
            ++level;
            int tempLen = tempString.length();
            int i2 = flagStart + 1;
            while (i2 < tempLen) {
                char tempChar = tempString.charAt(i2);
                if (tempChar == '(') {
                    ++level;
                } else if (tempChar == ')') {
                    --level;
                }
                if (level == 0 && i2 < tempString.length() - 1) {
                    return tempString;
                }
                ++i2;
            }
            if (minus) {
                return tempString.substring(flagStart, tempString.length());
            }
            return tempString.substring(flagStart + 1, tempString.length() - 1);
        }
        if (minus) {
            return tempString.substring(flagStart, tempString.length());
        }
        return tempString;
    }

    private static int getFlag4Index(String string) {
        int level = 0;
        int strLen = string.length();
        int i = 0;
        while (i < strLen) {
            char tempChar = string.charAt(i);
            if (tempChar == '(') {
                ++level;
            } else if (tempChar == ')') {
                --level;
            }
            if (level == 0 && (tempChar == '+' || tempChar == '-' || tempChar == '*' || tempChar == '/' || tempChar == '%')) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int arithValue(String expression) {
        int operator = 0;
        int first = 0;
        int second = 0;
        int result = 0;
        int flag = 120;
        boolean isTmpminus = false;
        String allSub = expression;
        allSub = Event.getSubString_Var(allSub, 0, allSub.length());
        isTmpminus = minus;
        operator = Event.getFlag4Index(allSub);
        if (operator == -1) {
            boolean isExpression = false;
            int i = 0;
            while (i < allSub.length()) {
                char tempChar = allSub.charAt(i);
                if (tempChar == '+' || tempChar == '-' || tempChar == '*' || tempChar == '/' || tempChar == '%' || tempChar == '^' || tempChar == '(') {
                    isExpression = true;
                    break;
                }
                ++i;
            }
            if (isExpression) {
                if (isTmpminus) {
                    return -Event.arithValue(allSub);
                }
                return Event.arithValue(allSub);
            }
            if (isTmpminus) {
                return -Event.getIntValue(allSub);
            }
            return Event.getIntValue(allSub);
        }
        first = Event.arithValue(allSub.substring(0, operator));
        flag = allSub.charAt(operator);
        second = Event.arithValue(allSub.substring(operator + 1, allSub.length()));
        switch (flag) {
            case 43: {
                result = first + second;
                break;
            }
            case 45: {
                result = first - second;
                break;
            }
            case 42: {
                result = first * second;
                break;
            }
            case 47: {
                result = first / second;
                break;
            }
            case 37: {
                result = first % second;
            }
        }
        return result;
    }

    private static boolean getBoolValue(String paramName) {
        String param = paramName.trim();
        if (param.equals("true")) {
            return true;
        }
        if (param.equals("false")) {
            return false;
        }
        if (param.equals("KEY_OK")) {
            return MyGameCanvas.confirmKey;
        }
        return false;
    }

    private String getStrValue(String paramName) {
        String param = paramName.trim();
        if (param.equals("ac")) {
            return "str1";
        }
        return "!!!error string!!!";
    }

    public static String[] parseArray(String paramName) {
        int index = paramName.indexOf("[");
        if (index == -1) {
            return null;
        }
        Event.buff[0] = paramName.substring(0, index);
        Event.buff[1] = paramName.substring(index + 1, paramName.indexOf("]"));
        return buff;
    }

    private static int getArrayValue(String[] param) {
        String name = param[0];
        int id = Event.sToi(param[1]);
        if (name.equals("event")) {
            return Script.scriptVar[id];
        }
        if (name.equals("hp")) {
            return GameEngine.sprite[id].hp;
        }
        if (name.equals("mp")) {
            return GameEngine.sprite[id].mp;
        }
        if (name.equals("mirror")) {
            return GameEngine.sprite[id].mirror;
        }
        if (name.equals("equiped")) {
            return GameEngine.sprite[0].equips[id];
        }
        if (name.equals("equip")) {
            return GameEngine.getAllEquipNum(id);
        }
        if (name.equals("point")) {
            return MyMessage.PPData[id];
        }
        System.out.println("get array value error !!!   " + name);
        return Integer.MAX_VALUE;
    }

    private void setArrayValue(String[] param, int val) {
        String name = param[0];
        int id = Event.sToi(param[1]);
        if (name.equals("event")) {
            Script.scriptVar[id] = (short)val;
        } else if (name.equals("mirror")) {
            GameEngine.sprite[id].mirror = (byte)val;
        } else if (name.equals("mp")) {
            GameEngine.sprite[id].mp = val;
        } else {
            System.out.println("set array value error !!!    " + name);
        }
    }

    private static int getIntValue(String paramName) {
        String param = paramName.trim();
        try {
            return Integer.parseInt(paramName);
        }
        catch (NumberFormatException e) {
            String[] array = Event.parseArray(param);
            if (array != null) {
                return Event.getArrayValue(array);
            }
            if (param.equals("temp")) {
                return Script.temp;
            }
            if (param.equals("choice")) {
                return MyGameCanvas.choice;
            }
            if (param.equals("isHit")) {
                return GameEngine.isHit;
            }
            if (param.equals("money")) {
                return GameEngine.money;
            }
            System.out.println("get int value error !!!:   " + paramName);
            return Integer.MAX_VALUE;
        }
    }

    private void set(String varName, String expression) {
        String[] array = Event.parseArray(varName);
        int val = Event.arithValue(expression);
        if (array != null) {
            this.setArrayValue(array, val);
            return;
        }
        if (varName.equals("temp")) {
            Script.temp = val;
        } else if (varName.equals("isHit")) {
            GameEngine.isHit = val;
        } else if (varName.equals("rollSpeed")) {
            GameEngine.rollSpeed = (byte)val;
        } else if (varName.equals("isPeace")) {
            GameEngine.isPeace = val;
        }
    }

    private String parseStr(String str) {
        StringBuffer buff = new StringBuffer();
        boolean isTxt = true;
        StringBuffer varName = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '<') {
                isTxt = false;
            } else if (c == '>') {
                isTxt = true;
                String[] s = Event.getParams(varName.toString(), " ");
                if (s[0].equals("int")) {
                    buff.append(Event.getIntValue(s[1]));
                } else if (s[0].equals("str")) {
                    buff.append(this.getStrValue(s[1]));
                }
                varName = new StringBuffer();
            } else if (isTxt) {
                buff.append(c);
            } else {
                varName.append(c);
            }
            ++i;
        }
        return buff.toString();
    }

    static {
        isNot = false;
        minus = false;
        buff = new String[2];
    }
}

