/*
 * Decompiled with CFR 0.152.
 */
package com.allinone.rain.tool;

import javax.microedition.lcdui.Graphics;

public class ColTool {
    public final void drawRGBfillrect(Graphics g, int alpha, int R, int G, int B, int x, int y, int w, int h) {
        int[] rgbdata = new int[w * h];
        int i = 0;
        while (i < rgbdata.length) {
            int n = i++;
            rgbdata[n] = rgbdata[n] + (alpha << 24 & 0xFF000000 | R << 16 & 0xFF0000 | G << 8 & 0xFF00 | B & 0xFF);
        }
        g.drawRGB(rgbdata, 0, 0, x, y, w, h, true);
    }

    public final void drawRGBVRect(Graphics g, int color, int x, int y, int width, int height) {
        int[] rgb = this.getRGBVColor(color, height);
        int i = 0;
        while (i < width) {
            int nTemp = x + width - (i - x);
            nTemp = nTemp > 4 ? 4 : nTemp;
            g.drawRGB(rgb, 0, 4, i, y, nTemp, height, true);
            i += 4;
        }
    }

    private final int[] getRGBVColor(int color, int h) {
        int RGB_L = h;
        int nRgbData = RGB_L * 4;
        int[] rgb = new int[nRgbData];
        int i = 0;
        while (i < RGB_L) {
            int col;
            int a = i;
            if (a > 255) {
                a = 255;
            }
            rgb[i * 4] = col = color | a << 24;
            rgb[i * 4 + 1] = col;
            rgb[i * 4 + 2] = col;
            rgb[i * 4 + 3] = col;
            ++i;
        }
        return rgb;
    }

    public final void drawRGBHRect(Graphics g, int color, int x, int y, int width, int height) {
        int[] rgb = this.getRGBHColor(color, width);
        int by = y;
        while (by < y + height) {
            int nTemp = y + height - (by - y);
            nTemp = nTemp > 4 ? 4 : nTemp;
            g.drawRGB(rgb, 0, width, x, by, width, nTemp, true);
            by += 4;
        }
    }

    private final int[] getRGBHColor(int color, int h) {
        int RGB_L = h;
        int nRgbData = RGB_L * 4;
        int[] rgb = new int[nRgbData];
        int alpha = -127;
        int i = 0;
        while (i < RGB_L) {
            int col;
            alpha = -127 + i;
            rgb[i] = col = color | 128 - alpha << 24;
            rgb[i + RGB_L] = col;
            rgb[i + RGB_L * 2] = col;
            rgb[i + RGB_L * 3] = col;
            ++i;
        }
        return rgb;
    }
}

