/*
 * Decompiled with CFR 0.152.
 */
package com.bf.effect;

import com.allinone.bf.tool.T;
import com.bf.canvas.GameCanvas;
import com.bf.ctrl.MapCtrl;
import com.bf.effect.Fog4WarData;
import com.bf.i.ICanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Fog4War {
    private String path = "/pic/effect/";
    private boolean isLive = false;
    public int b_map_x;
    public int b_map_y;
    public int b_scr_x;
    public int b_scr_y;
    private int map_w;
    private int map_h;
    private static Image imageSrc;
    private int fogSpeed = 1;
    private int[] fogDelay = new int[]{50, 100, 150};
    private int fogDelayNum;
    private long fogTime;
    private long fogLastTime;
    private int fogNum;

    public Fog4War() {
        this.loadingImage();
    }

    private void loadingImage() {
        if (imageSrc == null) {
            imageSrc = T.TP.createImg(this.path, "fog.png");
        }
    }

    public void show(int x, int y, int mapw, int maph) {
        if (!this.isLive) {
            this.isLive = true;
            this.b_map_x = x;
            this.b_map_y = y;
            this.map_w = mapw;
            this.map_h = maph;
            this.fogDelayNum = T.getRandom(3);
            this.fogNum = T.getRandom(Fog4WarData.NUM);
        }
    }

    public void paint(Graphics g) {
        try {
            if (this.isLive) {
                MapCtrl.paintImageX(g, imageSrc, this.b_map_x - GameCanvas.mc.camera_x(), this.b_map_y - GameCanvas.mc.camera_y(), this.fogNum, 240, 80);
                g.setClip(0, 0, ICanvas.sWidth, ICanvas.sHeight);
                this.fogLastTime = System.currentTimeMillis();
                if (this.fogLastTime - this.fogTime >= (long)this.fogDelay[this.fogDelayNum]) {
                    this.fogTime = this.fogLastTime;
                    this.b_map_x -= this.fogSpeed;
                    if (this.b_map_x + imageSrc.getWidth() / 2 <= 0) {
                        this.b_map_x = this.map_w + imageSrc.getWidth() / 2;
                        this.b_map_y = T.getRandom(this.map_h);
                        this.fogNum = T.getRandom(Fog4WarData.NUM);
                    }
                }
            }
        }
        catch (Exception e) {
            T.log("Fog4War.java paint() : " + e.getMessage());
        }
    }

    public boolean isLive() {
        return this.isLive;
    }
}

