/*
 * Decompiled with CFR 0.152.
 */
package com.bf.i;

import com.allinone.bf.tool.T;
import com.bf.i.ICanvas;
import com.bf.i.IConstance;
import com.bf.midlet.TW_MIDlet;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class IDisplay
implements IConstance {
    private static final int KEY_CODE_NUM0 = 48;
    private static final int KEY_CODE_NUM1 = 49;
    private static final int KEY_CODE_NUM2 = 50;
    private static final int KEY_CODE_NUM3 = 51;
    private static final int KEY_CODE_NUM4 = 52;
    private static final int KEY_CODE_NUM5 = 53;
    private static final int KEY_CODE_NUM6 = 54;
    private static final int KEY_CODE_NUM7 = 55;
    private static final int KEY_CODE_NUM8 = 56;
    private static final int KEY_CODE_NUM9 = 57;
    private static final int KEY_CODE_STAR = 42;
    private static final int KEY_CODE_POUND = 35;
    private static final int KEY_CODE_SOFT_M = -8;
    private static final int KEY_CODE_SEND = -10;
    private static final int KEY_CODE_END = -11;
    private static final int KEY_CODE_UP = 1;
    private static final int KEY_CODE_DOWN = 6;
    private static final int KEY_CODE_LEFT = 2;
    private static final int KEY_CODE_RIGHT = 5;
    private static final int KEY_CODE_SELECT = 8;
    private static final int KEY_CODE_SOFT_L = 9;
    private static final int KEY_CODE_SOFT_R = 10;
    private static final int KEY_CODE_UP_TYPE1 = -1;
    private static final int KEY_CODE_DOWN_TYPE1 = -2;
    private static final int KEY_CODE_LEFT_TYPE1 = -3;
    private static final int KEY_CODE_RIGHT_TYPE1 = -4;
    private static final int KEY_CODE_SELECT_TYPE1 = -5;
    private static final int KEY_CODE_SOFT_L_TYPE1 = -6;
    private static final int KEY_CODE_SOFT_R_TYPE1 = -7;
    private static final int KEY_CODE_UP_TYPE2 = -1;
    private static final int KEY_CODE_DOWN_TYPE2 = -6;
    private static final int KEY_CODE_LEFT_TYPE2 = -2;
    private static final int KEY_CODE_RIGHT_TYPE2 = -5;
    private static final int KEY_CODE_SELECT_TYPE2 = -20;
    private static final int KEY_CODE_SOFT_L_TYPE2 = -21;
    private static final int KEY_CODE_SOFT_R_TYPE2 = -22;
    private static final int KEY_TYPE_0 = 0;
    private static final int KEY_TYPE_1 = 1;
    private static final int KEY_TYPE_2 = 2;
    private static int keyType = 0;
    private static int DELAY = 50;
    private static final IDisplay INSTANCE = new IDisplay();
    private static int keyPressed;
    private static int keyHeld;
    private static int keyReleased;
    private AppCanvas canvas;
    private Display naviteDisplay;
    private Thread EDT;
    private long time;
    private long fpsTime;
    private ICanvas icanvas;
    private static String trace;
    private int debugColor = 0xFFFFFF;
    private long use;
    private long total;
    private int fps;
    private long updateDelay;
    public static boolean isRock;
    public static int rockOffset;
    private static int minSw;
    private static int minSh;

    static {
        trace = "";
        isRock = false;
        rockOffset = 1;
    }

    private IDisplay() {
        this.initStartConfig();
        this.canvas = new AppCanvas();
    }

    private void initStartConfig() {
        String config;
        block18: {
            InputStream is = null;
            byte[] bs = null;
            config = "";
            try {
                try {
                    is = this.getClass().getResourceAsStream("/bf_config.ini");
                    bs = new byte[is.available()];
                    is.read(bs);
                    config = new String(bs);
                }
                catch (IOException iOException) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block18;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (!config.equals("")) {
                int w = Integer.parseInt(config.substring(0, config.indexOf(",")));
                config = config.substring(config.indexOf(",") + 1);
                int h = Integer.parseInt(config.substring(0, config.indexOf(",")));
                config = config.substring(config.indexOf(",") + 1);
                int kt = Integer.parseInt(config.substring(0, config.indexOf(",")));
                config = config.substring(config.indexOf(",") + 1);
                int rgbImage = Integer.parseInt(config.substring(0, config.indexOf(",")));
                IDisplay.setMinSwh(w, h);
                keyType = kt;
                if (rgbImage == 0) {
                    T.isRGBCreatImage = false;
                }
            }
        }
        catch (Exception e) {
            T.log("initStartConfig error :" + e.getMessage());
        }
    }

    public static void setFPS(int frame) {
        if (frame > 0) {
            DELAY = 1000 / frame;
        }
    }

    public static void init(MIDlet midlet) {
        IDisplay.INSTANCE.naviteDisplay = Display.getDisplay((MIDlet)midlet);
        if (IDisplay.INSTANCE.EDT == null) {
            IDisplay.INSTANCE.EDT = new Thread(){

                public void run() {
                    INSTANCE.mainEDTLoop();
                }
            };
            IDisplay.INSTANCE.EDT.setPriority(6);
            IDisplay.INSTANCE.EDT.start();
        }
    }

    private void hideNotify() {
        if (this.icanvas != null) {
            this.icanvas.hideNotify();
        }
    }

    private void showNotify() {
        if (this.icanvas != null) {
            this.icanvas.showNotify();
        }
    }

    public static void debug(String msg) {
    }

    private void showDebug(Graphics g) {
    }

    public static void setCurrent(Displayable d) {
        IDisplay.INSTANCE.naviteDisplay.setCurrent(d);
    }

    boolean shouldEDTSleep() {
        return this.icanvas == null;
    }

    private void mainEDTLoop() {
        try {
            while (true) {
                long currentTime = System.currentTimeMillis();
                if (this.icanvas != null) {
                    this.edtLoopImpl();
                }
                this.time = System.currentTimeMillis() - currentTime;
                Thread.sleep(Math.max(1L, (long)DELAY - this.time));
                this.fpsTime = System.currentTimeMillis() - currentTime;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            IDisplay.debug(e.toString());
            IDisplay.flushGraphics();
            return;
        }
    }

    private void edtLoopImpl() throws Exception {
        this.icanvas.keyAction();
        this.icanvas.run();
        this.icanvas.repaint();
        TW_MIDlet.playBg();
    }

    public static int getGameAction(int keyCode) {
        return IDisplay.INSTANCE.canvas.getGameAction(keyCode);
    }

    private void keyPressed(int keyCode) {
        if (this.icanvas == null) {
            return;
        }
        int tmp = this.getKeyMask(keyCode);
        keyHeld |= tmp;
        keyPressed |= tmp;
    }

    private void keyReleased(int keyCode) {
        if (this.icanvas == null) {
            return;
        }
        keyHeld &= ~this.getKeyMask(keyCode);
        int tmp = this.getKeyMask(keyCode);
        keyReleased |= tmp;
    }

    public static boolean isKeyAction() {
        return keyPressed != 0 || keyHeld != 0;
    }

    public static boolean isKeyPressed(int code) {
        boolean b;
        boolean bl = b = (keyPressed & code) != 0;
        if (b) {
            keyPressed = 0;
        }
        return b;
    }

    public static boolean isKeyHeld(int code) {
        return (code & keyHeld) != 0;
    }

    public static boolean isKeyReleased(int code) {
        boolean b;
        boolean bl = b = (keyReleased & code) != 0;
        if (b) {
            keyReleased = 0;
        }
        return b;
    }

    private int getKeyMask(int keyCode) {
        switch (keyCode) {
            case 49: {
                return 2;
            }
            case 50: {
                return 4;
            }
            case 51: {
                return 8;
            }
            case 52: {
                return 16;
            }
            case 53: {
                return 32;
            }
            case 54: {
                return 64;
            }
            case 55: {
                return 128;
            }
            case 56: {
                return 256;
            }
            case 57: {
                return 512;
            }
            case 42: {
                return 262144;
            }
            case 48: {
                return 1;
            }
            case 35: {
                return 524288;
            }
            case -8: {
                return 131072;
            }
            case -10: {
                return 0x100000;
            }
            case -11: {
                return 0x200000;
            }
        }
        switch (keyType) {
            case 0: {
                switch (keyCode) {
                    case 1: {
                        return 1024;
                    }
                    case 6: {
                        return 2048;
                    }
                    case 2: {
                        return 4096;
                    }
                    case 5: {
                        return 8192;
                    }
                    case 8: {
                        return 16384;
                    }
                    case 9: {
                        return 32768;
                    }
                    case 10: {
                        return 65536;
                    }
                }
                break;
            }
            case 1: {
                switch (keyCode) {
                    case -1: {
                        return 1024;
                    }
                    case -2: {
                        return 2048;
                    }
                    case -3: {
                        return 4096;
                    }
                    case -4: {
                        return 8192;
                    }
                    case -5: {
                        return 16384;
                    }
                    case -6: {
                        return 32768;
                    }
                    case -7: {
                        return 65536;
                    }
                }
                break;
            }
            case 2: {
                switch (keyCode) {
                    case -1: {
                        return 1024;
                    }
                    case -6: {
                        return 2048;
                    }
                    case -2: {
                        return 4096;
                    }
                    case -5: {
                        return 8192;
                    }
                    case -20: {
                        return 16384;
                    }
                    case -21: {
                        return 32768;
                    }
                    case -22: {
                        return 65536;
                    }
                }
            }
        }
        return 0;
    }

    public static int getWidth() {
        return IDisplay.INSTANCE.canvas.getScreenWidth();
    }

    public static int getHeight() {
        return IDisplay.INSTANCE.canvas.getScreenHeight();
    }

    public static void show() {
        if (IDisplay.INSTANCE.icanvas != null) {
            IDisplay.INSTANCE.naviteDisplay.setCurrent((Displayable)IDisplay.INSTANCE.canvas);
            keyHeld = 0;
            keyPressed = 0;
        }
    }

    static void show(ICanvas canvas) {
        if (IDisplay.INSTANCE.icanvas != canvas) {
            IDisplay.INSTANCE.icanvas = canvas;
            IDisplay.INSTANCE.naviteDisplay.setCurrent((Displayable)IDisplay.INSTANCE.canvas);
            keyHeld = 0;
            keyPressed = 0;
        }
    }

    static void flushGraphics() {
        if (IDisplay.INSTANCE.canvas != null) {
            INSTANCE.showDebug(IDisplay.INSTANCE.canvas.getGraphics());
        }
        IDisplay.INSTANCE.canvas.repaint();
        IDisplay.INSTANCE.canvas.serviceRepaints();
    }

    public static Graphics getGraphics() {
        return IDisplay.INSTANCE.canvas.getGraphics();
    }

    public static void setRockScr(int i) {
        isRock = true;
        IDisplay.INSTANCE.canvas.initWait();
    }

    public static void setMinSwh(int minSw_, int minSh_) {
        minSw = minSw_;
        minSh = minSh_;
    }

    class AppCanvas
    extends Canvas {
        private Image bufImage;
        private Graphics gfx;
        private int screen_height;
        private int screen_width;
        private int waitDelay = 1000;
        private long waitTime;
        private long waitTimeLast;

        AppCanvas() {
            this.setFullScreenMode(true);
            this.repaint();
            this.screen_width = this.getWidth();
            this.screen_height = this.getHeight();
            if (this.screen_width < minSw) {
                this.screen_width = minSw;
            }
            if (this.screen_height < minSh) {
                this.screen_height = minSh;
            }
            this.bufImage = Image.createImage((int)this.screen_width, (int)this.screen_height);
            T.setWH(this.screen_width, this.screen_height);
            this.gfx = this.bufImage.getGraphics();
            Font font = Font.getFont((int)0, (int)0, (int)8);
            this.gfx.setFont(font);
        }

        public int getScreenWidth() {
            return this.screen_width;
        }

        private int getScreenHeight() {
            return this.screen_height;
        }

        protected void paint(Graphics graphics) {
            if (this.bufImage != null) {
                int x = 0;
                int y = 0;
                if (isRock) {
                    x = T.getRandom(rockOffset + 1);
                    y = T.getRandom(rockOffset + 1);
                    this.waitTimeLast = System.currentTimeMillis();
                    if (this.waitTimeLast - this.waitTime > (long)this.waitDelay) {
                        isRock = false;
                    }
                }
                T.cls(graphics);
                graphics.drawImage(this.bufImage, x, y, 0);
            }
        }

        public void initWait() {
            this.waitTime = System.currentTimeMillis();
            this.waitTimeLast = System.currentTimeMillis();
        }

        public Graphics getGraphics() {
            return this.gfx;
        }

        protected void keyRepeated(int arg0) {
            super.keyRepeated(arg0);
        }

        protected void keyPressed(int keyCode) {
            IDisplay.this.keyPressed(keyCode);
        }

        protected void keyReleased(int keyCode) {
            IDisplay.this.keyReleased(keyCode);
        }

        protected void hideNotify() {
            IDisplay.this.hideNotify();
        }

        protected void showNotify() {
            IDisplay.this.showNotify();
        }
    }
}

