/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class Data {
    public static Data data;
    public static final int TYPE_ARM = 0;
    public static final int TYPE_ITEM = 1;
    public static final int TYPE_SKILL = 2;
    public static short[] short_value;
    public static int[] int_value;
    public static boolean[] bool_value;
    public static short[][] shortarray_value;
    public static byte[] byte_value;
    public static String[] string_value;
    public static byte[][] bytearray_value;
    public static byte[] list_value;
    public static int ITEM_COUNT;
    public static short[][] SHORT_ITEM;
    public static int[][] INT_ITEM;
    public static boolean[][] BOOL_ITEM;
    public static short[][][] SHORTARRAY_ITEM;
    public static byte[][] BYTE_ITEM;
    public static String[][] STRING_ITEM;
    public static byte[][][] BYTEARRAY_ITEM;
    public static byte[][] LIST_ITEM;
    public static byte[][] LIST_ITEM_type;
    public static int ARM_COUNT;
    public static short[][] SHORT_ARM;
    public static int[][] INT_ARM;
    public static boolean[][] BOOL_ARM;
    public static short[][][] SHORTARRAY_ARM;
    public static byte[][] BYTE_ARM;
    public static String[][] STRING_ARM;
    public static byte[][][] BYTEARRAY_ARM;
    public static byte[][] LIST_ARM;
    public static int SKILL_COUNT;
    public static short[][] SHORT_SKILL;
    public static int[][] INT_SKILL;
    public static boolean[][] BOOL_SKILL;
    public static short[][][] SHORTARRAY_SKILL;
    public static byte[][] BYTE_SKILL;
    public static String[][] STRING_SKILL;
    public static byte[][][] BYTEARRAY_SKILL;
    public static byte[][] LIST_SKILL;
    public static String[][] STR_BAS;
    public static byte[] TYPE;
    public static short[][] SHORT_VALUE;
    public static int[][] INT_VALUE;
    public static boolean[][] BOOL_VALUE;
    public static short[][][] SHORTARRAY_VALUE;
    public static byte[][] BYTE_VALUE;
    public static String[][] STRING_VALUE;
    public static byte[][][] BYTEARRAY_VALUE;
    public static byte[][] LIST_VALUE;
    public static final int INDEX_NAME = 0;
    public static final int INDEX_INTRO = 1;
    public static final int AREA_MSINGLE = 0;
    public static final int AREA_MMULTI = 1;
    public static final int AREA_MALL = 2;
    public static final int AREA_ESINGLE = 3;
    public static final int AREA_EMULTI = 4;
    public static final int AREA_EALL = 5;
    public static final int TYPE_Shallowblue = 0;
    public static final int TYPE_Yellow = 1;
    public static final int TYPE_Blue = 2;
    public static final int TYPE_Green = 3;
    public static final int TYPE_Orange = 4;
    public static final int TYPE_Purple = 5;
    public static final int TYPE_Smallblood = 5;
    public static final int TYPE_Smallblue = 5;
    public static final int TYPE_Bigblue = 5;
    public static final int TYPE_Rain = 5;
    public static final int TYPE_Bigblood = 5;
    private static int byteOffCount;
    public static final int FLAG_ITEM_REC = 1;
    public static final int FLAG_ITEM_GEMT = 2;
    public static final int FLAG_ITEM_SEEDS = 4;
    public static final int FLAG_RENWU_BOOK = 8;
    public static final int FLAG_ITEM_BOOK = 16;
    public static final int FLAG_ITEM_ASIS = 32;
    public static final int FLAG_ITEM_ELSE = 64;
    public static final int FLAG_ITEM_TASK = 128;
    public static final int FLAG_ARM_ARM = 2048;
    public static final int FLAG_SKILL_ATT = 0x400000;
    public static final int FLAG_SKILL_ASIS = 0x800000;
    public static final int FLAG_SKILL_PASS = 0x1000000;
    public static final int SEX_ANY = 2;
    public static final int SEX_MALE = 0;
    public static final int SEX_FEMALE = 1;
    public static final int SPE_ZHANGSAN = 0;
    public static final int SPE_LISI = 1;
    public static final int SPE_WANGWU = 2;
    public static final int SPE_ZHAOLIU = 3;
    public static final int SPE_ANY = 4;
    public static final int ARM_TYPE_COUNT = 16;
    public static final int ARM_WEAPON = 2;
    public static final int ARM_ARMOR = 1;
    public static final int ARM_SHOES = 3;
    public static final int ARM_TOU = 0;
    public static final int TRI_NONE = 0;
    public static final int TRI_KEYFRAME = 1;
    public static final int TRI_BSKILL = 2;
    public static final int TRI_ASKILL = 3;
    public static final int BG_EFF_NONE = 0;
    public static final int BG_EFF_FLASH_RED = 1;
    public static final int BG_EFF_FLASH_WHITE = 2;
    public static final int BG_SHAKE_NONE = 0;
    public static final int BG_SHAKE_H = 1;
    public static final int BG_SHAKE_V = 2;
    public static final int BG_SHAKE_VH = 3;
    public static final int PAR_NONE = 0;
    public static final int PAR_SWORD = 1;
    public static final int PAR_COLD = 2;
    public static final int PAR_WARM = 3;
    public static final int PAR_REC = 4;
    public static final int PAR_CHAOS = 5;
    public static final int PAR_POISON = 6;
    public static final int ITEM_REC = 0;
    public static final int ITEM_GEMT = 1;
    public static final int RENWU_BOOK = 2;
    public static final int ITEM_BOOK = 3;
    public static final int ITEM_ASIS = 4;
    public static final int ITEM_ELSE = 5;
    public static final int ARM_ARM = 0;
    public static final int SKILL_ATT = 0;
    public static final int SKILL_ASIS = 1;
    public static final int SKILL_PASS = 2;
    public static final int[] ET_INDEX;
    public static final int ICON_ARMTYPE = 0;
    public static final int ICON_RECTYPE = 1;
    public static final int ICON_GEMTTYPE = 2;
    public static final int ICON_RENWUTYPE = 3;

    public static void loadData(String file, int type) {
        DataInputStream dis = new DataInputStream(file.getClass().getResourceAsStream(file));
        int count = 0;
        try {
            count = dis.readShort();
            switch (type) {
                case 0: {
                    ARM_COUNT = count;
                    break;
                }
                case 1: {
                    ITEM_COUNT = count;
                    break;
                }
                case 2: {
                    SKILL_COUNT = count;
                }
            }
            Data.openSpace(count);
            for (int i = 0; i < count; ++i) {
                Data.loadUnit(i, dis, type);
            }
            Data.initData(type);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private static void loadUnit(int index, DataInputStream dis, int kind) throws IOException {
        int j;
        int i;
        byte type = dis.readByte();
        String name = dis.readUTF();
        String intro = dis.readUTF();
        short id = dis.readShort();
        byteOffCount = kind == 2 ? 3 : 1;
        int count = dis.readByte();
        Data.BYTE_VALUE[index] = new byte[count + byteOffCount];
        for (i = 1; i <= count; ++i) {
            Data.BYTE_VALUE[index][i] = dis.readByte();
        }
        Data.BYTE_VALUE[index][0] = type;
        Data.SHORT_VALUE[index] = new short[dis.readByte() + 1];
        for (i = 1; i < SHORT_VALUE[index].length; ++i) {
            Data.SHORT_VALUE[index][i] = dis.readShort();
        }
        Data.SHORT_VALUE[index][0] = id;
        Data.INT_VALUE[index] = new int[dis.readByte()];
        for (i = 0; i < INT_VALUE[index].length; ++i) {
            Data.INT_VALUE[index][i] = dis.readInt();
        }
        Data.BOOL_VALUE[index] = new boolean[dis.readByte()];
        for (i = 0; i < BOOL_VALUE[index].length; ++i) {
            Data.BOOL_VALUE[index][i] = dis.readBoolean();
        }
        Data.STRING_VALUE[index] = new String[dis.readByte() + 2];
        for (i = 2; i < STRING_VALUE[index].length; ++i) {
            Data.STRING_VALUE[index][i] = dis.readUTF();
        }
        Data.BYTEARRAY_VALUE[index] = new byte[dis.readByte()][];
        for (i = 0; i < BYTEARRAY_VALUE[index].length; ++i) {
            Data.BYTEARRAY_VALUE[index][i] = new byte[dis.readByte()];
            for (j = 0; j < BYTEARRAY_VALUE[index][i].length; ++j) {
                Data.BYTEARRAY_VALUE[index][i][j] = dis.readByte();
            }
        }
        Data.SHORTARRAY_VALUE[index] = new short[dis.readByte()][];
        for (i = 0; i < SHORTARRAY_VALUE[index].length; ++i) {
            Data.SHORTARRAY_VALUE[index][i] = new short[dis.readByte()];
            for (j = 0; j < SHORTARRAY_VALUE[index][i].length; ++j) {
                Data.SHORTARRAY_VALUE[index][i][j] = dis.readShort();
            }
        }
        Data.LIST_VALUE[index] = new byte[dis.readByte()];
        for (i = 0; i < LIST_VALUE[index].length; ++i) {
            Data.LIST_VALUE[index][i] = dis.readByte();
        }
        if (kind == 2) {
            Data.BYTE_VALUE[index][Data.BYTE_VALUE[index].length - 2] = dis.readByte();
            Data.BYTE_VALUE[index][Data.BYTE_VALUE[index].length - 1] = dis.readByte();
        }
        Data.STRING_VALUE[index][0] = name;
        Data.STRING_VALUE[index][1] = intro;
    }

    public static void initData(int type) {
        switch (type) {
            case 1: {
                SHORT_ITEM = SHORT_VALUE;
                INT_ITEM = INT_VALUE;
                BOOL_ITEM = BOOL_VALUE;
                SHORTARRAY_ITEM = SHORTARRAY_VALUE;
                BYTE_ITEM = BYTE_VALUE;
                STRING_ITEM = STRING_VALUE;
                BYTEARRAY_ITEM = BYTEARRAY_VALUE;
                LIST_ITEM = LIST_VALUE;
                break;
            }
            case 0: {
                SHORT_ARM = SHORT_VALUE;
                INT_ARM = INT_VALUE;
                BOOL_ARM = BOOL_VALUE;
                SHORTARRAY_ARM = SHORTARRAY_VALUE;
                BYTE_ARM = BYTE_VALUE;
                STRING_ARM = STRING_VALUE;
                BYTEARRAY_ARM = BYTEARRAY_VALUE;
                LIST_ARM = LIST_VALUE;
                break;
            }
            case 2: {
                SHORT_SKILL = SHORT_VALUE;
                INT_SKILL = INT_VALUE;
                BOOL_SKILL = BOOL_VALUE;
                SHORTARRAY_SKILL = SHORTARRAY_VALUE;
                BYTE_SKILL = BYTE_VALUE;
                STRING_SKILL = STRING_VALUE;
                BYTEARRAY_SKILL = BYTEARRAY_VALUE;
                LIST_SKILL = LIST_VALUE;
            }
        }
    }

    public static Unit getUnitValue(int type, int index) {
        switch (type) {
            case 1: {
                short_value = SHORT_ITEM[index];
                int_value = INT_ITEM[index];
                bool_value = BOOL_ITEM[index];
                shortarray_value = SHORTARRAY_ITEM[index];
                byte_value = BYTE_ITEM[index];
                string_value = STRING_ITEM[index];
                bytearray_value = BYTEARRAY_ITEM[index];
                list_value = LIST_ITEM[index];
                break;
            }
            case 0: {
                short_value = SHORT_ARM[index];
                int_value = INT_ARM[index];
                bool_value = BOOL_ARM[index];
                shortarray_value = SHORTARRAY_ARM[index];
                byte_value = BYTE_ARM[index];
                string_value = STRING_ARM[index];
                bytearray_value = BYTEARRAY_ARM[index];
                list_value = LIST_ARM[index];
                break;
            }
            case 2: {
                short_value = SHORT_SKILL[index];
                int_value = INT_SKILL[index];
                bool_value = BOOL_SKILL[index];
                shortarray_value = SHORTARRAY_SKILL[index];
                byte_value = BYTE_SKILL[index];
                string_value = STRING_SKILL[index];
                bytearray_value = BYTEARRAY_SKILL[index];
                list_value = LIST_SKILL[index];
            }
        }
        if (type == 0) {
            String in;
            Unit arm = Data.setUnitIndex(type, byte_value[0]);
            StringBuffer sb = new StringBuffer();
            if (arm.intro != null && arm.intro.length() != 0) {
                sb.append(arm.intro);
                sb.append('|');
            }
            sb.append(arm.uselevel);
            sb.append("\u7ea7");
            sb.append(arm.name);
            sb.append(',');
            if (arm.maxatt != 0 || arm.minatt != 0) {
                sb.append('\u653b');
                sb.append(arm.minatt);
                sb.append('-');
                sb.append(arm.maxatt);
                sb.append(',');
            }
            if (arm.define != 0 || arm.defineodd != 0) {
                sb.append('\u9632');
                sb.append(arm.define);
                sb.append(',');
            }
            if (arm.jink / 100 != 0) {
                sb.append('\u95ea');
                sb.append(arm.jink / 100);
                sb.append(',');
            }
            if (arm.breakhit / 100 != 0) {
                sb.append('\u66b4');
                sb.append(arm.breakhit / 100);
                sb.append(',');
            }
            if (arm.hplimit != 0) {
                sb.append('\u547d');
                sb.append(arm.hplimit);
                sb.append(',');
            }
            if (arm.mplimit != 0) {
                sb.append('\u6c14');
                sb.append(arm.mplimit);
                sb.append(',');
            }
            if (arm.iceanti != 0) {
                sb.append('\u6297');
                sb.append(arm.iceanti);
                sb.append(',');
            }
            if ((in = new String(sb)).charAt(in.length() - 1) == ',') {
                in = in.substring(0, in.length() - 1);
            }
            arm.intro = in;
            return arm;
        }
        return Data.setUnitIndex(type, byte_value[0]);
    }

    public static void openSpace(int count) {
        BYTE_VALUE = new byte[count][];
        SHORT_VALUE = new short[count][];
        INT_VALUE = new int[count][];
        BOOL_VALUE = new boolean[count][];
        SHORTARRAY_VALUE = new short[count][][];
        LIST_VALUE = new byte[count][];
        STRING_VALUE = new String[count][];
        BYTEARRAY_VALUE = new byte[count][][];
    }

    public static Unit[] getUnitList(int type, short[] list) {
        Unit[] unitlist = new Unit[list.length];
        for (int i = 0; i < list.length; ++i) {
            unitlist[i] = Data.getUnitValue(type, list[i]);
        }
        return unitlist;
    }

    private static boolean matchUnit(Unit unit, int flag) {
        if (unit.datatype == 0 && (flag & 1) != 0) {
            return true;
        }
        if (unit.datatype == 1 && (flag & 2) != 0) {
            return true;
        }
        if (unit.datatype == 2 && (flag & 8) != 0) {
            return true;
        }
        if (unit.datatype == 3 && (flag & 0x10) != 0) {
            return true;
        }
        if (unit.datatype == 4 && (flag & 0x20) != 0) {
            return true;
        }
        if (unit.datatype == 5 && (flag & 0x40) != 0) {
            return true;
        }
        if (unit.datatype == 0 && (flag & 0x800) != 0) {
            return true;
        }
        if (unit.datatype == 0 && (flag & 0x400000) != 0) {
            return true;
        }
        if (unit.datatype == 1 && (flag & 0x800000) != 0) {
            return true;
        }
        return unit.datatype == 2 && (flag & 0x1000000) != 0;
    }

    public static Unit[] getUnits(int type, short[] articals, int flag) {
        Vector<Unit> vecArtical = new Vector<Unit>(articals.length);
        for (int i = 0; i < articals.length; ++i) {
            Unit unit;
            if (articals[i] <= -1 || !Data.matchUnit(unit = Data.getUnitValue(type, articals[i]), flag)) continue;
            vecArtical.addElement(unit);
        }
        Unit[] ret = new Unit[vecArtical.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Unit)vecArtical.elementAt(i);
        }
        return ret;
    }

    public static Unit[] getITEM_REC() {
        Vector<Unit> vec = new Vector<Unit>();
        for (int i = 0; i < ITEM_COUNT; ++i) {
            Unit unit = Data.getUnitValue(1, i);
            if (unit.datatype != 0) continue;
            vec.addElement(unit);
        }
        Unit[] ret = new Unit[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            ret[i] = (Unit)vec.elementAt(i);
        }
        return ret;
    }

    public static Unit[] getITEM_GEMT() {
        Vector<Unit> vec = new Vector<Unit>();
        for (int i = 0; i < ITEM_COUNT; ++i) {
            Unit unit = Data.getUnitValue(1, i);
            if (unit.datatype != 1) continue;
            vec.addElement(unit);
        }
        Unit[] ret = new Unit[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            ret[i] = (Unit)vec.elementAt(i);
        }
        return ret;
    }

    public static Unit[] getRenwu() {
        Vector<Unit> vec = new Vector<Unit>();
        for (int i = 0; i < ITEM_COUNT; ++i) {
            Unit unit = Data.getUnitValue(1, i);
            if (unit.datatype != 2) continue;
            vec.addElement(unit);
        }
        Unit[] ret = new Unit[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            ret[i] = (Unit)vec.elementAt(i);
        }
        return ret;
    }

    public static Unit[] getAllSameKindOfItem(int type) {
        Vector<Unit> vector = new Vector<Unit>();
        for (int i = 0; i < ITEM_COUNT; ++i) {
            Unit unit = Data.getUnitValue(1, i);
            if (unit.datatype != type) continue;
            vector.addElement(unit);
        }
        Unit[] list = new Unit[vector.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = (Unit)vector.elementAt(i);
        }
        return list;
    }

    public static Unit setUnitIndex(int kind, int type) {
        Unit unit = new Unit();
        switch (kind) {
            case 1: {
                switch (type) {
                    case 0: {
                        unit.objnum = byte_value[1];
                        unit.recmpodd = byte_value[2];
                        unit.rechpodd = byte_value[3];
                        unit.recgpodd = byte_value[4];
                        unit.price = short_value[1];
                        unit.reprice = short_value[2];
                        unit.recmp = short_value[3];
                        unit.rechp = short_value[4];
                        unit.recgp = short_value[5];
                        unit.costround = bool_value[0];
                        unit.relive = bool_value[1];
                        unit.godrec = bool_value[2];
                        unit.usearea = list_value[0];
                        unit.ITEMype = list_value[1];
                        break;
                    }
                    case 1: {
                        unit.uselevel = byte_value[1];
                        unit.price = short_value[1];
                        unit.reprice = short_value[2];
                        unit.Gemtype = list_value[0];
                        unit.GStype = list_value[1];
                        break;
                    }
                    case 2: {
                        unit.reprice = short_value[1];
                        unit.encourageGold = short_value[2];
                        unit.encourageEquip = short_value[3];
                        unit.encourageItem = short_value[4];
                        unit.trade = bool_value[0];
                        unit.Missionsicon = list_value[0];
                        unit.Missionstype = list_value[1];
                        break;
                    }
                    case 3: {
                        unit.uselevel = byte_value[1];
                        unit.price = short_value[1];
                        unit.reprice = short_value[2];
                        unit.skillid = short_value[3];
                        unit.usearea = list_value[0];
                        unit.sex = list_value[1];
                        break;
                    }
                    case 4: {
                        unit.objnum = byte_value[1];
                        unit.price = short_value[1];
                        unit.reprice = short_value[2];
                        unit.unfroze = bool_value[0];
                        unit.unfire = bool_value[1];
                        unit.unchaos = bool_value[2];
                        unit.escape = bool_value[3];
                        unit.costround = bool_value[4];
                        unit.usearea = list_value[0];
                        break;
                    }
                    case 5: {
                        unit.price = short_value[1];
                        unit.reprice = short_value[2];
                        unit.backtown = bool_value[0];
                        unit.descforget = string_value[2];
                        unit.itemtype = list_value[0];
                    }
                }
                break;
            }
            case 0: {
                switch (type) {
                    case 0: {
                        unit.uselevel = byte_value[1];
                        unit.nicety = byte_value[2];
                        unit.iceanti = byte_value[3];
                        unit.icehurt = byte_value[4];
                        unit.iceround = byte_value[5];
                        unit.fireanti = byte_value[6];
                        unit.firehurt = byte_value[7];
                        unit.fireround = byte_value[8];
                        unit.thunderanti = byte_value[9];
                        unit.thunderhurt = byte_value[10];
                        unit.thunderround = byte_value[11];
                        unit.hplimit = short_value[1];
                        unit.mplimit = short_value[2];
                        unit.gplimit = short_value[3];
                        unit.price = short_value[4];
                        unit.reprice = short_value[5];
                        unit.minatt = short_value[6];
                        unit.maxatt = short_value[7];
                        unit.define = short_value[8];
                        unit.jink = short_value[9];
                        unit.breakhit = short_value[10];
                        unit.suiteneed = bytearray_value[0];
                        unit.armtypeicon = list_value[0];
                        unit.zhuanshu = list_value[1];
                        unit.armtype = list_value[2];
                    }
                }
                break;
            }
            case 2: {
                switch (type) {
                    case 0: {
                        unit.replaceid = byte_value[1];
                        unit.selfhpodd = byte_value[2];
                        unit.selfmpodd = byte_value[3];
                        unit.selfgpodd = byte_value[4];
                        unit.hurtdepthodd = byte_value[5];
                        unit.objnum = byte_value[6];
                        unit.antipower = byte_value[7];
                        unit.defineodd = byte_value[8];
                        unit.iceanti = byte_value[9];
                        unit.icehurt = byte_value[10];
                        unit.iceround = byte_value[11];
                        unit.fireanti = byte_value[12];
                        unit.firehurt = byte_value[13];
                        unit.fireround = byte_value[14];
                        unit.thunderanti = byte_value[15];
                        unit.thunderhurt = byte_value[16];
                        unit.thunderround = byte_value[17];
                        unit.limskilllevel = byte_value[18];
                        unit.selfhp = short_value[1];
                        unit.selfmp = short_value[2];
                        unit.selfgp = short_value[3];
                        unit.hurtdepth = short_value[4];
                        unit.keyframe = short_value[5];
                        unit.hidebg = bool_value[0];
                        unit.hidemate = bool_value[1];
                        unit.hideelse = bool_value[2];
                        unit.linerole = bool_value[3];
                        unit.special = bool_value[4];
                        unit.nextpower = string_value[2];
                        unit.nextdesc = string_value[3];
                        unit.usearea = list_value[0];
                        unit.atttype = list_value[1];
                        unit.antitype = list_value[2];
                        unit.hurttype = list_value[3];
                        unit.costtype = list_value[4];
                        unit.efffire = list_value[5];
                        unit.bgshake = list_value[6];
                        unit.flashbg = list_value[7];
                        unit.parteff = list_value[8];
                        break;
                    }
                    case 1: {
                        unit.replaceid = byte_value[1];
                        unit.hpodd = byte_value[2];
                        unit.mpodd = byte_value[3];
                        unit.selfhpodd = byte_value[4];
                        unit.selfmpodd = byte_value[5];
                        unit.selfgpodd = byte_value[6];
                        unit.objnum = byte_value[7];
                        unit.bufodd = byte_value[8];
                        unit.buftime = byte_value[9];
                        unit.addattodd = byte_value[10];
                        unit.adddefineodd = byte_value[11];
                        unit.limskilllevel = byte_value[12];
                        unit.hp = short_value[1];
                        unit.mp = short_value[2];
                        unit.selfhp = short_value[3];
                        unit.selfmp = short_value[4];
                        unit.selfgp = short_value[5];
                        unit.bufvalue = short_value[6];
                        unit.keyframe = short_value[7];
                        unit.relive = bool_value[0];
                        unit.hidebg = bool_value[1];
                        unit.hidemate = bool_value[2];
                        unit.hideelse = bool_value[3];
                        unit.linerole = bool_value[4];
                        unit.special = bool_value[5];
                        unit.nextpower = string_value[2];
                        unit.nextdesc = string_value[3];
                        unit.usearea = list_value[0];
                        unit.costtype = list_value[1];
                        unit.efffire = list_value[2];
                        unit.bgshake = list_value[3];
                        unit.flashbg = list_value[4];
                        unit.parteff = list_value[5];
                        break;
                    }
                    case 2: {
                        unit.replaceid = byte_value[1];
                        unit.limithpodd = byte_value[2];
                        unit.limitmpodd = byte_value[3];
                        unit.addattodd = byte_value[4];
                        unit.adddefineodd = byte_value[5];
                        unit.limskilllevel = byte_value[6];
                        unit.minatt = short_value[1];
                        unit.maxatt = short_value[2];
                        unit.define = short_value[3];
                        unit.jink = short_value[4];
                        unit.breakhit = short_value[5];
                        unit.nicety_s = short_value[6];
                        unit.hplimit = short_value[7];
                        unit.mplimit = short_value[8];
                        unit.gplimit = short_value[9];
                        unit.attvalue = shortarray_value[0];
                        unit.antinicetyarray = shortarray_value[1];
                        unit.nextpower = string_value[2];
                        unit.nextdesc = string_value[3];
                        unit.antitype = list_value[0];
                        unit.costtype = list_value[1];
                    }
                }
                unit.effid = byte_value[byte_value.length - 2];
                unit.selfeffid = byte_value[byte_value.length - 1];
            }
        }
        unit.datatype = byte_value[0];
        unit.name = string_value[0];
        unit.intro = string_value[1];
        unit.id = short_value[0];
        return unit;
    }

    static {
        short_value = null;
        int_value = null;
        bool_value = null;
        shortarray_value = null;
        byte_value = null;
        string_value = null;
        bytearray_value = null;
        list_value = null;
        ITEM_COUNT = 0;
        SHORT_ITEM = null;
        INT_ITEM = null;
        BOOL_ITEM = null;
        SHORTARRAY_ITEM = null;
        BYTE_ITEM = null;
        STRING_ITEM = null;
        BYTEARRAY_ITEM = null;
        LIST_ITEM = null;
        LIST_ITEM_type = null;
        ARM_COUNT = 0;
        SHORT_ARM = null;
        INT_ARM = null;
        BOOL_ARM = null;
        SHORTARRAY_ARM = null;
        BYTE_ARM = null;
        STRING_ARM = null;
        BYTEARRAY_ARM = null;
        LIST_ARM = null;
        SKILL_COUNT = 0;
        SHORT_SKILL = null;
        INT_SKILL = null;
        BOOL_SKILL = null;
        SHORTARRAY_SKILL = null;
        BYTE_SKILL = null;
        STRING_SKILL = null;
        BYTEARRAY_SKILL = null;
        LIST_SKILL = null;
        STR_BAS = null;
        TYPE = null;
        SHORT_VALUE = null;
        INT_VALUE = null;
        BOOL_VALUE = null;
        SHORTARRAY_VALUE = null;
        BYTE_VALUE = null;
        STRING_VALUE = null;
        BYTEARRAY_VALUE = null;
        LIST_VALUE = null;
        byteOffCount = 0;
        ET_INDEX = new int[]{2, 10, 18, 28, 38, 50, 60, 68, 78, 90, 100, 112, 118, 130, 138, 148, 158, 170, 182, 192, 206, 216, 230, 238, 252, 260, 270, 276, 286, 298, 310, 316, 326, 338, 346, 356, 368, 378, 388, 400, 410, 420, 432, 438, 450, 460, 474, 480, 486, 496, 508, 520, 530, 538, 550, 560, 572, 582, 594, 604, 614, 620, 632, 640, 652, 662, 672, 682, 694, 702, 714, 720, 726, 732, 738, 744, 750, 760, 768, 780, 794, 804, 814, 826, 836};
    }
}

