/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public class Monster
extends Role {
    public short t_skillid = 0;
    public int gold;
    public short magicodd;
    public short[] items;
    public short[] arms;
    public short[] itemodd;
    public short[] armodd;
    public short[] skillodd;

    public Monster() {
    }

    public Monster(Monster mon) {
        super(mon);
        this.gold = mon.gold;
        this.items = Tools.arraycopy(mon.items);
        this.itemodd = Tools.arraycopy(mon.itemodd);
        this.arms = Tools.arraycopy(mon.arms);
        this.armodd = Tools.arraycopy(mon.armodd);
        this.skillodd = Tools.arraycopy(mon.skillodd);
    }

    public void setDie(Team selfTeam, Team killerTeam, Role killer) {
        if (this.c_hp > 0) {
            return;
        }
        this.actor.setVisible(false);
        this.setEffect(1);
        if (killerTeam == World.myteam) {
            if (killer instanceof Mate) {
                World.myteam.addPrice(this, (Mate)killer);
            } else {
                World.myteam.addPrice(this, null);
            }
        }
    }

    public void load(DataInputStream dis) {
        super.load(dis);
        if ((Battle.battleFlag & 0x40) != 0) {
            this.b_maxatt *= 10;
            this.b_minatt *= 10;
        }
        this.b_mp = this.level * 20 + 140;
        this.b_gp = 100;
        try {
            int i;
            this.gold = dis.readShort();
            this.magicodd = dis.readShort();
            this.items = new short[dis.readShort()];
            for (i = 0; i < this.items.length; ++i) {
                this.items[i] = dis.readShort();
            }
            this.itemodd = new short[dis.readShort()];
            for (i = 0; i < this.itemodd.length; ++i) {
                this.itemodd[i] = dis.readShort();
            }
            this.arms = new short[dis.readShort()];
            for (i = 0; i < this.arms.length; ++i) {
                this.arms[i] = dis.readShort();
            }
            this.armodd = new short[dis.readShort()];
            for (i = 0; i < this.armodd.length; ++i) {
                this.armodd[i] = dis.readShort();
            }
            this.skillodd = new short[dis.readShort()];
            for (i = 0; i < this.skillodd.length; ++i) {
                this.skillodd[i] = dis.readShort();
            }
            dis.readShort();
            dis.readShort();
            dis.readShort();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void calcCurrentAttribute() {
        super.calcCurrentAttribute();
        this.c_hp = this.f_hp;
        this.c_mp = this.f_mp;
        this.c_gp = this.f_gp;
    }

    public int selectAction(boolean isAuto) {
        if (isAuto) {
            if (this.skillodd.length > 0) {
                for (int i = 0; i < this.skillodd.length; ++i) {
                    if (this.chaos > 0) {
                        return 0;
                    }
                    if (Tools.random(99) >= this.skillodd[i] && (Battle.battleFlag & 0x40) == 0 || !this.matchArtical(2, Data.getUnitValue(2, this.skills[i]))) continue;
                    this.t_skillid = this.skills[i];
                    return 2;
                }
            }
            return 0;
        }
        return 0;
    }

    public void setStatus(int action) {
        switch (action) {
            case 4: 
            case 8: {
                this.actor.setActorParam(0, true, false, false, false, this.actor.posX, this.actor.posY);
                break;
            }
            case 5: {
                this.setStatus(0);
                break;
            }
            case 9: 
            case 10: {
                this.actor.setActorParam(9, false, false, false, false, this.actor.posX, this.actor.posY);
                break;
            }
            case 0: {
                this.actor.setActorParam(action, false, false, true, false, this.posx, this.posy);
                break;
            }
            case 7: {
                this.actor.setActorParam(3, false, false, true, false, this.posx, this.posy);
                break;
            }
            case 2: {
                this.actor.setActorParam(action, true, false, false, false, this.posx, this.posy);
                break;
            }
            default: {
                this.actor.setActorParam(action, false, false, false, false, this.actor.posX, this.actor.posY);
            }
        }
    }

    public Unit selectSkill(boolean isAuto) {
        return Data.getUnitValue(2, this.t_skillid);
    }

    public Unit selectItem(Team selfTeam, boolean isAuto) {
        return null;
    }
}

