/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public abstract class Role {
    public static GameCanvas gc = World.gameCanvas;
    public static final int ROLE_FITOUT = 0;
    public static final int ROLE_REST = 1;
    public static final int ROLE_HARM = 2;
    public static final int ROLE_DUCK = 3;
    public static final int ROLE_USE = 4;
    public static final int ROLE_GBH = 5;
    public static final int ROLE_DIE = 6;
    public static final int ROLE_MAGIC = 7;
    public static final int ROLE_TREND = 8;
    public static final int ROLE_ATTACK0 = 9;
    public static final int ROLE_ATTACK1 = 10;
    public static final int ROLE_A = 11;
    public static final int ROLE_B = 12;
    Role fireMan = null;
    public short id;
    public String name;
    public String intro;
    public int b_hp;
    public int c_hp;
    public int f_hp;
    public int b_mp;
    public int c_mp;
    public int f_mp;
    public int b_gp;
    public int c_gp;
    public int f_gp;
    public int b_minatt;
    public int c_minatt;
    public int f_minatt;
    public int b_maxatt;
    public int c_maxatt;
    public int f_maxatt;
    public int b_define;
    public int c_define;
    public int f_define;
    public int b_jink;
    public int c_jink;
    public int f_jink;
    public short b_jinkodd;
    public int b_breakhit;
    public int c_breakhit;
    public int f_breakhit;
    public short b_nicety;
    public short c_nicety;
    public short f_nicety;
    public short b_dishurt;
    public short c_dishurt;
    public short f_dishurt;
    public short b_dishurtodd;
    public int beishu = 1;
    public short b_icehurt;
    public short c_icehurt;
    public short f_icehurt;
    public short b_iceround;
    public short c_iceround;
    public short f_iceround;
    public short b_iceanti;
    public short c_iceanti;
    public short f_iceanti;
    public short b_firehurt;
    public short c_firehurt;
    public short f_firehurt;
    public short b_fireround;
    public short c_fireround;
    public short f_fireround;
    public short b_fireanti;
    public short c_fireanti;
    public short f_fireanti;
    public short b_thunderhurt;
    public short c_thunderhurt;
    public short f_thunderhurt;
    public short b_thunderround;
    public short c_thunderround;
    public short f_thunderround;
    public short b_thunderanti;
    public short c_thunderanti;
    public short f_thunderanti;
    public int b_level;
    public int level;
    public int exp = 0;
    public short[] skills = new short[0];
    public String path;
    public short effect = (short)-1;
    public short width;
    public short height;
    public short posx = (short)20;
    public short posy = (short)20;
    public String dialog;
    public short dlgtime;
    public short dlgodd;
    public static final int DLG_BEFORE = 0;
    public static final int DLG_AFTER = 1;
    public boolean flip;
    public Actor actor;
    public Actor effactor;
    public Actor selactor;
    int f = 0;
    int a = 0;
    int b = 0;
    int c = 0;
    int d = 0;
    int[] MJ = new int[]{this.a, this.b, this.c, this.d};
    public boolean hasAction;
    public boolean isSelected;
    public boolean isLiving = true;
    public byte hasActionCoun;
    public boolean autoHasAction;
    private boolean repeatAtt;
    public boolean helper;
    private boolean BreakhitToo;
    private boolean fanbiAtt;
    private int attCout;
    private boolean isKo;
    public static final int ACT_CANCEL = -1;
    public static final int ACT_NONE = 5;
    public static final int ACT_ATTACK = 0;
    public static final int ACT_SKILL = 2;
    public static final int ACT_USEITEM = 1;
    public static final int ACT_ALLKILL = 4;
    public static final int ACT_SHOP = 3;
    public static final int ACT_LEFT = 6;
    public static final int ACT_RIGHT = 7;
    public static final int ACT_KILLALL = 8;
    public short chaos;
    public short burn;
    public short frozen;
    public short suitHunDun;
    public short suitFanTian;
    public short suitSiXiang;
    public static final int BURN_ODD = 10;
    public short buftime;
    public int t_maxatt;
    public int t_minatt;
    public int t_define;
    public int t_hp;
    public int t_mp;
    public boolean[] isPassBreakhit = new boolean[5];
    private boolean t_nohurt;
    private int[] t_calcHP = new int[5];
    public int[] t_loseHPFrame = new int[5];
    public int[][] t_pos = new int[5][4];
    public static final int ag = 3;
    public static final int LOSEHP_FRAMES = 15;
    public static final int FLAG_NODEAD = 2;
    public static final int FLAG_NOCHAOS = 4;
    public static final int FLAG_NOBURN = 8;
    public static final int FLAG_NOFROZEN = 16;
    public int DiaoHP = 0;
    public static final int ACT_NOTDO = 0;
    public static final int ACT_OVER = 1;
    public static final int ACT_BREAK = 2;
    public String strWarn;
    public static final int HP_ANIM_NUM = 5;
    public int hpIndex;
    public int hpBeginIndex = 0;
    public int hpEndIndex = 0;
    private short tempx;
    private short tempy;

    public Role() {
    }

    public Role(Role role) {
        this.name = role.name;
        this.intro = role.intro;
        this.id = role.id;
        this.path = role.path;
        this.effect = role.effect;
        this.skills = Tools.arraycopy(role.skills);
        if (role.actor != null) {
            this.actor = role.actor.clone();
        }
        this.level = role.level;
        this.exp = role.exp;
        this.dialog = role.dialog;
        this.dlgtime = role.dlgtime;
        this.dlgodd = role.dlgodd;
        this.width = role.height;
        this.height = role.height;
        this.posx = role.posx;
        this.posy = role.posy;
        this.b_minatt = role.b_minatt;
        this.b_maxatt = role.b_maxatt;
        this.b_define = role.b_define;
        this.b_jink = role.b_jink;
        this.b_breakhit = role.b_breakhit;
        this.b_hp = role.b_hp;
        this.b_mp = role.b_mp;
        this.b_gp = role.b_gp;
        this.b_nicety = role.b_nicety;
        this.b_dishurt = role.b_dishurt;
        this.b_dishurtodd = role.b_dishurtodd;
        this.b_icehurt = role.b_icehurt;
        this.b_iceround = role.b_iceround;
        this.b_iceanti = role.b_iceanti;
        this.b_firehurt = role.b_firehurt;
        this.b_fireround = role.b_fireround;
        this.b_fireanti = role.b_fireanti;
        this.b_thunderhurt = role.b_thunderhurt;
        this.b_thunderround = role.b_thunderround;
        this.b_thunderanti = role.b_thunderanti;
    }

    public void load(DataInputStream dis) {
        try {
            this.name = dis.readUTF();
            this.intro = dis.readUTF();
            this.id = dis.readShort();
            dis.readShort();
            this.b_minatt = dis.readInt();
            this.b_maxatt = dis.readInt();
            this.b_define = dis.readInt();
            this.b_jink = dis.readInt();
            this.b_breakhit = dis.readInt();
            this.b_hp = dis.readInt();
            dis.readShort();
            this.b_nicety = dis.readShort();
            this.b_dishurt = dis.readShort();
            this.b_dishurtodd = dis.readShort();
            dis.readShort();
            dis.readShort();
            this.b_iceanti = dis.readShort();
            this.b_icehurt = dis.readShort();
            this.b_iceround = dis.readShort();
            this.b_fireanti = dis.readShort();
            this.b_firehurt = dis.readShort();
            this.b_fireround = dis.readShort();
            this.b_thunderanti = dis.readShort();
            this.b_thunderhurt = dis.readShort();
            this.b_thunderround = dis.readShort();
            this.level = this.b_level = (int)dis.readShort();
            this.exp = dis.readUnsignedShort();
            this.path = dis.readUTF();
            this.effect = dis.readShort();
            this.dialog = dis.readUTF();
            this.dlgtime = dis.readShort();
            this.dlgodd = dis.readShort();
            this.width = dis.readShort();
            this.height = dis.readShort();
            this.skills = new short[dis.readShort()];
            for (int i = 0; i < this.skills.length; ++i) {
                this.skills[i] = dis.readShort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void calcFinalAttribute() {
        this.f_hp = this.b_hp;
        this.f_mp = this.b_mp;
        this.f_gp = this.b_gp;
        this.f_minatt = this.b_minatt;
        this.f_maxatt = this.b_maxatt;
        this.f_define = this.b_define;
        this.f_jink = this.b_jink;
        this.f_breakhit = this.b_breakhit;
        this.f_nicety = this.b_nicety;
        this.f_dishurt = this.b_dishurt;
        this.f_icehurt = this.b_icehurt;
        this.f_iceround = this.b_iceround;
        this.f_iceanti = this.b_iceanti;
        this.f_firehurt = this.b_firehurt;
        this.f_fireround = this.b_fireround;
        this.f_fireanti = this.b_fireanti;
        this.f_thunderhurt = this.b_thunderhurt;
        this.f_thunderround = this.b_thunderround;
        this.f_thunderanti = this.b_thunderanti;
    }

    public void calcCurrentAttribute() {
        this.c_minatt = this.f_minatt;
        this.c_maxatt = this.f_maxatt;
        this.c_define = this.f_define;
        this.c_jink = this.f_jink;
        this.c_breakhit = this.f_breakhit;
        this.c_nicety = this.f_nicety;
        this.c_dishurt = this.f_dishurt;
        this.c_icehurt = this.f_icehurt;
        this.c_iceround = this.f_iceround;
        this.c_iceanti = this.f_iceanti;
        this.c_firehurt = this.f_firehurt;
        this.c_fireround = this.f_fireround;
        this.c_fireanti = this.f_fireanti;
        this.c_thunderhurt = this.f_thunderhurt;
        this.c_thunderround = this.f_thunderround;
        this.c_thunderanti = this.f_thunderanti;
    }

    public void recoverAttribute() {
        this.isLiving = true;
        this.c_hp = this.f_hp;
        this.c_mp = this.f_mp;
        this.buftime = (short)-1;
        this.chaos = 0;
        this.frozen = 0;
        this.burn = 0;
        this.calcCurrentAttribute();
    }

    public void refreshAttribute() {
        this.calcFinalAttribute();
        this.calcCurrentAttribute();
    }

    public boolean matchRole(int flag) {
        if (!this.isLiving && (flag & 2) != 0) {
            return false;
        }
        if (this.chaos > 0 && (flag & 4) != 0) {
            return false;
        }
        if (this.burn > 0 && (flag & 8) != 0) {
            return false;
        }
        return this.frozen <= 0 || (flag & 0x10) == 0;
    }

    public void initTurn() {
        if (this.isLiving) {
            int i;
            this.hasAction = false;
            this.isSelected = false;
            this.autoHasAction = false;
            this.setStatus(0);
            for (i = 0; i < this.isPassBreakhit.length; ++i) {
                this.isPassBreakhit[i] = false;
            }
            this.hasActionCoun = 0;
            this.helper = false;
            this.repeatAtt = false;
            this.BreakhitToo = false;
            this.fanbiAtt = false;
            this.attCout = 0;
            this.isKo = false;
            for (i = 0; i < this.skills.length; ++i) {
                if (this.skills[i] == 42) {
                    this.hasActionCoun = (byte)2;
                }
                if (this.skills[i] == 37) {
                    this.repeatAtt = true;
                }
                if (this.skills[i] == 41) {
                    this.helper = true;
                }
                if (this.skills[i] == 40) {
                    this.BreakhitToo = true;
                }
                if (this.skills[i] == 39) {
                    this.fanbiAtt = true;
                }
                if (this.skills[i] == 38) {
                    this.attCout = 2;
                }
                if (this.skills[i] == 43) {
                    this.attCout = 3;
                }
                if (this.skills[i] == 44) {
                    this.attCout = 4;
                }
                if (this.skills[i] != 1) continue;
                this.isKo = true;
            }
            this.hpEndIndex = 0;
            this.hpBeginIndex = 0;
            this.addBufEffect();
        }
    }

    private void addBufEffect() {
        if (this.buftime > 0) {
            this.buftime = (short)(this.buftime - 1);
            this.c_minatt = this.f_minatt + this.t_minatt;
            this.c_maxatt = this.f_maxatt + this.t_maxatt;
            this.c_define = this.f_define + this.t_define;
            this.calcHP(this.t_hp);
            this.calcMP(this.t_mp);
        } else {
            this.c_minatt = this.f_minatt;
            this.c_maxatt = this.f_maxatt;
            this.c_define = this.f_define;
        }
    }

    public int startAction(Team actTeam, Team otherTeam, boolean isAuto) {
        if (this.isLiving && this.frozen <= 0) {
            int ret;
            if (this.chaos > 0) {
                isAuto = true;
                Team tempTeam = actTeam;
                actTeam = otherTeam;
                otherTeam = tempTeam;
            }
            this.effactor.setEnabled(false);
            if (this.suitHunDun > 0) {
                this.suitHunDun = (short)(this.suitHunDun - 1);
                this.c_minatt -= this.f_minatt * World.attPercentage / 100;
                this.c_maxatt -= this.f_maxatt * World.attPercentage / 100;
            }
            if (this.suitFanTian > 0) {
                this.suitFanTian = (short)(this.suitFanTian - 1);
                this.c_minatt += this.f_minatt * World.attUp / 100;
                this.c_maxatt += this.f_maxatt * World.attUp / 100;
            }
            if (this.suitSiXiang > 0) {
                this.suitSiXiang = (short)(this.suitSiXiang - 1);
                this.c_define += this.f_define * World.definePercentage / 100;
            }
            if ((ret = this.runAction(actTeam, otherTeam, isAuto)) == 1) {
                this.isSelected = false;
            } else {
                return ret;
            }
        }
        if (actTeam.isEscape) {
            this.hasAction = true;
            return 1;
        }
        if (this.chaos > 0) {
            this.chaos = (short)(this.chaos - 1);
        }
        if (this.burn > 0 && otherTeam.getFighterCount() > 0) {
            this.burn = (short)(this.burn - 1);
            if (this.burn > 0) {
                this.effactor.setActorParam(2, true, false, true, false, this.posx, this.posy);
                this.calcHP(-this.b_dishurtodd * this.f_define * this.beishu);
                UI.showBattle(8);
                this.effactor.setEnabled(false);
                this.setDie(actTeam, otherTeam, null);
                UI.showBattle(5);
            }
            Battle.battle.dealAfterTurn();
            if (Battle.battleResult == 2) {
                UI.showBattle(1);
                if (!((Battle.battleFlag & 0x40) != 0)) {
                    this.buyRelive();
                }
            }
            if (Battle.battleResult == 2) {
                return 2;
            }
        }
        if (this.frozen > 0) {
            this.frozen = (short)(this.frozen - 1);
        }
        this.hasActionCoun = (byte)(this.hasActionCoun - 1);
        this.hasAction = this.hasActionCoun <= 0;
        this.autoHasAction = true;
        return 1;
    }

    public int startAction1(Team actTeam, Team otherTeam, boolean isAuto) {
        if (this.isLiving && this.frozen <= 0) {
            if (this.chaos > 0) {
                isAuto = true;
                Team tempTeam = actTeam;
                actTeam = otherTeam;
                otherTeam = tempTeam;
            }
            this.effactor.setEnabled(false);
            int ret = this.runAction(actTeam, otherTeam, isAuto);
            if (ret == 1) {
                this.isSelected = false;
            } else {
                return ret;
            }
        }
        if (actTeam.isEscape) {
            this.hasAction = true;
            return 1;
        }
        if (this.chaos > 0) {
            this.chaos = (short)(this.chaos - 1);
        }
        if (this.burn > 0 && otherTeam.getFighterCount() > 0) {
            this.burn = (short)(this.burn - 1);
            if (this.burn > 0) {
                this.effactor.setActorParam(2, true, false, true, false, this.posx, this.posy);
                this.calcHP(this.DiaoHP);
                UI.showBattle(8);
                this.effactor.setEnabled(false);
                this.setDie(actTeam, otherTeam, null);
                UI.showBattle(5);
            }
            Battle.battle.dealAfterTurn();
            if (Battle.battleResult == 2) {
                UI.showBattle(1);
                if (!((Battle.battleFlag & 0x40) != 0)) {
                    this.buyRelive();
                }
            }
            if (Battle.battleResult == 2) {
                return 2;
            }
        }
        if (this.frozen > 0) {
            this.frozen = (short)(this.frozen - 1);
        }
        return 1;
    }

    public int runAction(Team actTeam, Team otherTeam, boolean isAuto) {
        boolean isquit = false;
        while (!isquit) {
            int action = this.selectAction(isAuto);
            this.isSelected = false;
            switch (action) {
                case -1: {
                    UI.setBattleInfo1("\u53d6\u6d88\u51fa\u624b");
                    return 0;
                }
                case 5: {
                    UI.setBattleInfo1("\u672a\u51fa\u624b");
                    isquit = true;
                    break;
                }
                case 0: {
                    UI.setBattleInfo1("\u666e\u901a\u653b\u51fb");
                    isquit = this.act_attack(actTeam, otherTeam, isAuto);
                    break;
                }
                case 2: {
                    UI.setBattleInfo1("\u91ca\u653e\u6280\u80fd");
                    isquit = this.act_useskill(actTeam, otherTeam, isAuto);
                    break;
                }
                case 1: {
                    UI.setBattleInfo1("\u4f7f\u7528\u7269\u54c1");
                    isquit = this.act_useitem(actTeam, otherTeam, isAuto, false);
                    break;
                }
                case 4: {
                    UI.setBattleInfo1(null);
                    isquit = this.act_allkill();
                    break;
                }
                case 3: {
                    isquit = this.act_goshop(actTeam);
                    break;
                }
                case 6: {
                    UI.setBattleInfo1("\u4f7f\u7528\u7269\u54c1");
                    World.myteam.currbattle = World.myteam.battleLeft;
                    isquit = this.act_useitem(actTeam, otherTeam, isAuto, true);
                    break;
                }
                case 7: {
                    UI.setBattleInfo1("\u4f7f\u7528\u7269\u54c1");
                    World.myteam.currbattle = World.myteam.battleRight;
                    isquit = this.act_useitem(actTeam, otherTeam, isAuto, true);
                }
            }
            Battle.battle.dealAfterTurn();
            if (Battle.battleResult != 2) continue;
            UI.showBattle(1);
            if (!((Battle.battleFlag & 0x40) != 0)) {
                this.buyRelive();
            }
            return 2;
        }
        return 1;
    }

    private void buyRelive() {
        if (Tools.isMdo && (Battle.battleFlag & 8) == 0 && UI.showConfirm(World.g, "\u590d\u6d3b\u5168\u4f53\u961f\u53cb,\u751f\u547d\u3001\u5185\u529b\u3001\u6012\u6c14\u5168\u6ee1,\u83b7\u8d60\u91d11000\u91d1\uff0c", true)) {
            World.saveRecord(2);
            World.myteam.reliveAll();
            for (int i = 0; i < World.myteam.fighters.length; ++i) {
                World.myteam.fighters[i].c_gp = World.myteam.fighters[i].f_gp;
            }
            World.myteam.gold += 1000;
            World.myteam.pos = 300;
            Battle.battleResult = 0;
        }
    }

    public abstract int selectAction(boolean var1);

    public abstract Unit selectSkill(boolean var1);

    public abstract Unit selectItem(Team var1, boolean var2);

    public boolean matchArtical(int type, Unit unit) {
        if (type == 2) {
            if (this.c_hp + unit.selfhp + unit.selfhpodd * this.c_hp / 100 < 0) {
                this.strWarn = "\u751f\u547d\u4e0d\u8db3";
                return false;
            }
            if (this.c_mp + unit.selfmp + unit.selfmpodd * this.c_mp / 100 < 0) {
                this.strWarn = "\u9b54\u6cd5\u4e0d\u8db3";
                return false;
            }
            if (this.c_gp + unit.selfgp + unit.selfgpodd * this.c_gp / 100 < 0) {
                this.strWarn = "\u6012\u6c14\u4e0d\u8db3";
                if (!World.isOpenGasLimit) {
                    this.strWarn = "\u6012\u6c14\u4e0d\u8db3|\u63a8\u8350\u5f00\u901a\u4e09\u500d\u6012\u6c14|\u6240\u5411\u62ab\u9761\u5a01\u731b\u65e0\u654c";
                }
                return false;
            }
        }
        return true;
    }

    public boolean act_attack(Team actTeam, Team oppTeam, boolean isAuto) {
        Role[] oppRole;
        UI.setBattleInfo1("\u9009\u62e9\u88ab\u6253\u7684\u5bf9\u8c61");
        if (isAuto) {
            oppRole = oppTeam.autoSelectOppFighters(2, this, 1);
            UI.showBattle(5);
        } else {
            oppRole = oppTeam.selectOppFighters(2, this, this.repeatAtt ? 2 : 1);
        }
        if (oppRole == null) {
            return false;
        }
        if (oppRole.length > 0) {
            int M;
            UI.setBattleInfo1(this.name + "\u5f00\u59cb\u653b\u51fb");
            boolean t_flip = this.actor.flipX;
            if (this.chaos > 0 && Math.abs(this.posx - (M = GameCanvas.SCREEN_WIDTH >> 1)) < Math.abs(oppRole[0].posx - M)) {
                this.actor.flipX = !this.actor.flipX;
            }
            this.setStatus(8);
            this.tempx = this.posx;
            this.tempy = this.posy;
            if (this.repeatAtt) {
                for (int i = 0; i < oppRole.length; ++i) {
                    this.moveToEnemy(oppRole[i]);
                }
            } else {
                this.moveToEnemy(oppRole[0]);
            }
            for (int attSum = 0; attSum < (this.attCout == 4 ? 4 : (this.attCout == 3 ? 3 : (this.attCout == 2 ? 2 : 1))); ++attSum) {
                boolean isBreakhit = Tools.random(9999) < this.c_breakhit;
                int attack = Tools.random(this.c_minatt, this.c_maxatt) + (isBreakhit ? this.c_maxatt + (this.BreakhitToo ? this.c_maxatt : 0) : 0) / 2;
                if (this.fanbiAtt) {
                    attack += attack * (this.f_hp - this.c_hp) / this.f_hp;
                }
                this.setStatus(isBreakhit ? 10 : 9);
                if (!isAuto & isBreakhit) {
                    UI.showBattle(this.actor.getActionTime());
                }
                for (int i = 0; i < oppRole.length; ++i) {
                    oppRole[i].isSelected = false;
                    this.NormalAttack(oppRole[i], attack, isBreakhit);
                }
                if (!isBreakhit || oppRole[0].t_nohurt) continue;
                UI.setBgFlashMode(3, 0xFF0000);
            }
            this.showAction(oppRole);
            UI.setBattleInfo1(null);
            if (this.dialog == null || this.dlgtime == 1) {
                // empty if block
            }
            for (int i = 0; i < oppRole.length; ++i) {
                oppRole[i].setDie(oppTeam, actTeam, this);
            }
            this.actor.flipX = t_flip;
            UI.showBattle(2);
        }
        return true;
    }

    public void NormalAttack(Role oppRole, int attack, boolean isBreakhit) {
        if (!oppRole.isLiving) {
            return;
        }
        oppRole.t_nohurt = true;
        oppRole.t_loseHPFrame[oppRole.hpEndIndex] = 15;
        oppRole.initBloodFLyParam();
        this.c_nicety = (short)(this.f_nicety + (this.level - oppRole.level) / 3);
        if ((Battle.battleFlag & 0x40) != 0 && this instanceof Monster) {
            this.c_nicety = (short)999;
        }
        if (Tools.random(99) < this.c_nicety) {
            if (this.c_nicety < 9999 && Tools.random(9999) >= oppRole.c_jink || oppRole.frozen > 0) {
                int att_hp = attack * (100 - oppRole.c_dishurt) / 100 - oppRole.b_dishurtodd * oppRole.c_define;
                if (att_hp < 0) {
                    att_hp = 1;
                }
                oppRole.isPassBreakhit[oppRole.hpEndIndex] = isBreakhit;
                oppRole.calcHP(this, -att_hp);
                this.calcGP(World.GP_ADD);
                oppRole.calcGP(World.GP_ADD);
                oppRole.setStatus(2);
            } else {
                oppRole.setStatus(3);
                UI.setBattleInfo1(oppRole.name + "\u8eb2\u8fc7\u653b\u51fb");
            }
        } else {
            oppRole.setStatus(3);
        }
    }

    private void initBloodFLyParam() {
        this.t_pos[this.hpEndIndex][0] = 0;
        this.t_pos[this.hpEndIndex][1] = this.height;
        this.t_pos[this.hpEndIndex][2] = Tools.random(0, 6) - 3;
        this.t_pos[this.hpEndIndex][3] = Tools.random(1, 2);
    }

    public void SkillAttack(Role oppRole, int attack, boolean isBreakhit, Unit skill) {
        oppRole.setEffect(skill.effid);
        int att_hp = attack * (100 - oppRole.c_dishurt) / 100 - oppRole.b_dishurtodd * oppRole.c_define;
        if (att_hp <= 0) {
            att_hp = 1;
        }
        oppRole.isPassBreakhit[oppRole.hpEndIndex] = isBreakhit;
        oppRole.t_calcHP[oppRole.hpEndIndex] = -att_hp;
        oppRole.addDebuf(skill, this);
    }

    public void initHPArray() {
        this.hpBeginIndex = 0;
        this.hpEndIndex = 0;
    }

    public void calcHP(int hp) {
        this.c_hp += hp;
        if (-hp >= -999999999 && World.Dhp <= -hp) {
            World.Dhp = -hp;
        }
        if ((Battle.battleFlag & 0x40) == 0 || this instanceof Monster) {
            // empty if block
        }
        this.t_calcHP[this.hpEndIndex] = hp;
        if (this.c_hp <= 0) {
            this.c_hp = 0;
            this.isLiving = false;
        } else if (this.c_hp > this.f_hp) {
            int n = this.hpEndIndex;
            this.t_calcHP[n] = this.t_calcHP[n] - (this.c_hp - this.f_hp);
            this.c_hp = this.f_hp;
        }
        this.t_nohurt = false;
        this.t_loseHPFrame[this.hpEndIndex] = 15;
        this.initBloodFLyParam();
        ++this.hpEndIndex;
        this.hpEndIndex %= 5;
    }

    public void calcHP(Role role, int hp) {
        if ((Battle.battleFlag & 0x40) == 0 || !(this instanceof Monster)) {
            ++this.f;
            this.c_hp += hp;
            if (-hp >= -999999999 && World.Dhp <= -hp) {
                World.Dhp = -hp;
            }
        }
        this.t_calcHP[this.hpEndIndex] = hp;
        if (this.c_hp <= 0) {
            this.c_hp = 0;
            this.isLiving = false;
        } else if (this.c_hp > this.f_hp) {
            int n = this.hpEndIndex;
            this.t_calcHP[n] = this.t_calcHP[n] - (this.c_hp - this.f_hp);
            this.c_hp = this.f_hp;
        }
        this.t_nohurt = false;
        this.t_loseHPFrame[this.hpEndIndex] = 15;
        this.initBloodFLyParam();
        ++this.hpEndIndex;
        this.hpEndIndex %= 5;
    }

    public abstract void setDie(Team var1, Team var2, Role var3);

    public void calcMP(int mp) {
        this.c_mp += mp;
        this.c_mp = Tools.limit(this.c_mp, 0, this.f_mp);
    }

    public void calcGP(int gp) {
        this.c_gp += gp;
        this.c_gp = Tools.limit(this.c_gp, 0, this.f_gp);
    }

    public void addDebuf(Role actRole) {
        if (Tools.random(99) < actRole.c_icehurt - this.c_iceanti) {
            this.frozen = actRole.c_iceround;
            this.burn = 0;
            this.chaos = 0;
            UI.setBattleInfo1(this.name + "\u51b0\u51bb" + this.frozen + "\u56de\u5408");
        } else if (Tools.random(99) < actRole.c_firehurt - this.c_fireanti) {
            this.burn = actRole.c_fireround;
            this.chaos = 0;
            this.frozen = 0;
            UI.setBattleInfo1(this.name + "\u707c\u70e7" + this.burn + "\u56de\u5408");
        } else if (Tools.random(99) < actRole.c_thunderhurt - this.c_thunderanti) {
            this.chaos = actRole.c_thunderround;
            this.burn = 0;
            this.frozen = 0;
            UI.setBattleInfo1(this.name + "\u6df7\u4e71" + this.chaos + "\u56de\u5408");
        }
    }

    public void addDebuf(Unit skill, Role fireMan) {
        if (Tools.random(99) < skill.icehurt - this.c_iceanti) {
            this.frozen = skill.iceround;
            this.burn = 0;
            this.chaos = 0;
            UI.setBattleInfo1(this.name + "\u51b0\u51bb" + this.frozen + "\u56de\u5408");
        } else if (Tools.random(99) < skill.firehurt - this.c_fireanti) {
            this.DiaoHP = this.b_dishurtodd * this.f_define * this.beishu;
            this.burn = skill.fireround;
            this.chaos = 0;
            this.frozen = 0;
            UI.setBattleInfo1(this.name + "\u707c\u70e7" + this.burn + "\u56de\u5408");
        } else if (Tools.random(99) < skill.thunderhurt - this.c_thunderanti) {
            this.chaos = skill.thunderround;
            this.burn = 0;
            this.frozen = 0;
            UI.setBattleInfo1(this.name + "\u6df7\u4e71" + this.chaos + "\u56de\u5408");
        }
    }

    public Role[] selectArticalOppRole(Team selfTeam, Team otherTeam, boolean isAuto, Unit artical) {
        Team team = null;
        int num = 1;
        switch (artical.usearea) {
            case 0: {
                team = selfTeam;
                num = 1;
                break;
            }
            case 1: {
                team = selfTeam;
                num = artical.objnum;
                break;
            }
            case 2: {
                team = selfTeam;
                num = selfTeam.fighters.length;
                isAuto = true;
                break;
            }
            case 3: {
                team = otherTeam;
                num = 1;
                break;
            }
            case 4: {
                team = otherTeam;
                num = artical.objnum;
                break;
            }
            case 5: {
                team = otherTeam;
                num = otherTeam.fighters.length;
                isAuto = true;
            }
        }
        int flag = 0;
        if (!artical.relive) {
            flag |= 2;
        }
        if (isAuto) {
            return team.autoSelectOppFighters(flag, null, num);
        }
        return team.selectOppFighters(flag, null, num);
    }

    public static void showBattle(int tick) {
        for (int i = 0; i < tick; ++i) {
            UI.drawBattle(World.g);
            UI.drawFightersHead(World.g);
            UI.gc.flush();
            World.waitOneFrame();
        }
    }

    public boolean act_useskill(Team selfTeam, Team otherTeam, boolean isAuto) {
        int i;
        UI.setBattleInfo1("\u9009\u62e9\u6280\u80fd");
        Unit skill = this.selectSkill(isAuto);
        if (skill == null) {
            return false;
        }
        Role[] oppRole = this.selectArticalOppRole(selfTeam, otherTeam, isAuto, skill);
        if (oppRole == null) {
            return false;
        }
        if (oppRole.length <= 0) {
            return false;
        }
        if (skill.selfhpodd != 0 || skill.selfhp != 0) {
            this.calcHP(skill.selfhpodd * this.c_hp / 100 + skill.selfhp);
        }
        this.calcMP(skill.selfmpodd * this.c_mp / 100 + skill.selfmp);
        this.calcGP(skill.selfgpodd * this.c_gp / 100 + skill.selfgp);
        UI.setBattleInfo1("\u4f7f\u7528\u6280\u80fd" + skill.name);
        for (i = 0; i < oppRole.length; ++i) {
            oppRole[i].isSelected = false;
        }
        if (skill.datatype == 0) {
            this.setStatus(7);
        } else {
            this.setStatus(7);
        }
        this.setEffect(skill.selfeffid);
        UI.showBattle(this.actor.getActionTime() / 4);
        if (skill.efffire == 2) {
            this.setBgEffect(skill, selfTeam, otherTeam, oppRole[0]);
        }
        if (skill.datatype == 0) {
            boolean isBreakhit = Tools.random(9999) < this.c_breakhit;
            int attack = 0;
            attack = Tools.random(this.c_minatt, this.c_maxatt) + (isBreakhit ? this.c_maxatt + (this.BreakhitToo ? this.c_minatt : 0) / 2 : 0);
            attack = attack * (100 + skill.hurtdepth) / 100;
            if (this.fanbiAtt) {
                attack += attack * (this.f_hp - this.c_hp) / this.f_hp;
            }
            for (int i2 = 0; i2 < oppRole.length; ++i2) {
                this.SkillAttack(oppRole[i2], attack, isBreakhit, skill);
            }
        } else if (skill.datatype == 1) {
            UI.showBattle(this.effactor.getActionTime() / 2);
            for (i = 0; i < oppRole.length; ++i) {
                oppRole[i].useAssistSkill(skill);
                oppRole[i].setEffect(skill.effid);
            }
        }
        int lasttime = oppRole[0].effactor.getActionTime();
        UI.showBattle(skill.keyframe);
        if (skill.efffire == 1) {
            this.setBgEffect(skill, selfTeam, otherTeam, oppRole[0]);
        }
        if (skill.bgshake == 1) {
            UI.setBgShakeMode(true, false);
        } else if (skill.bgshake == 2) {
            UI.setBgShakeMode(false, true);
        } else if (skill.bgshake == 3) {
            UI.setBgShakeMode(true, true);
        }
        if (skill.flashbg == 1) {
            UI.setBgFlashMode(lasttime - skill.keyframe, 0xFF0000);
        } else if (skill.flashbg == 2) {
            UI.setBgFlashMode(lasttime - skill.keyframe, 0xFFFFFF);
        }
        UI.showBattle(lasttime - skill.keyframe);
        if (skill.datatype == 0) {
            for (int i3 = 0; i3 < oppRole.length; ++i3) {
                oppRole[i3].calcHP(this, oppRole[i3].t_calcHP[oppRole[i3].hpEndIndex]);
                oppRole[i3].setDie(otherTeam, selfTeam, this);
            }
        }
        UI.setBgBlackMode(false);
        Battle.battle.resetFightersPos();
        return true;
    }

    public boolean act_useitem(Team selfTeam, Team otherTeam, boolean isAuto, boolean isLR) {
        int i;
        Unit item = null;
        if (!isLR) {
            UI.setBattleInfo1("\u9009\u62e9\u7269\u54c1");
            item = this.selectItem(selfTeam, isAuto);
        } else {
            UI.setBattleInfo1("\u9009\u62e9\u7528\u836f\u5bf9\u8c61");
            Unit[] items = World.myteam.getItem(new int[]{0, 4, 5}, true);
            for (i = 0; i < items.length; ++i) {
                if (items[i].id != World.myteam.currbattle) continue;
                item = items[i];
                break;
            }
        }
        if (item == null) {
            return false;
        }
        UI.setBattleInfo1("\u4f7f\u7528\u7269\u54c1" + item.name);
        if (item.escape) {
            if ((Battle.battleFlag & 4) != 0) {
                UI.showMessage(World.g, "\u4e0d\u5141\u8bb8\u9003\u8dd1", -1, 3);
                return false;
            }
            this.useItem(selfTeam, item);
            World.myteam.delItem(item.id, 1);
            this.setStatus(4);
            this.setEffect(9);
            UI.showBattle(this.effactor.getActionTime() / 2);
            this.setStatus(0);
            UI.showBattle(2);
            return true;
        }
        Role[] oppRole = this.selectArticalOppRole(selfTeam, otherTeam, isAuto, item);
        if (oppRole == null) {
            return false;
        }
        if (oppRole.length == 0) {
            return false;
        }
        World.myteam.delItem(item.id, 1);
        this.setStatus(4);
        for (i = 0; i < oppRole.length; ++i) {
            if (item.rechpodd > 0 || item.rechp > 0) {
                oppRole[i].t_loseHPFrame[oppRole[i].hpEndIndex] = 15;
                oppRole[i].initBloodFLyParam();
            }
            oppRole[i].useItem(selfTeam, item);
            oppRole[i].setEffect(12);
        }
        this.showAction(oppRole);
        return item.costround;
    }

    public boolean act_goshop(Team selfTeam) {
        UI.showBattleShop((Mate)this, Data.getUnitList(1, World.NPC_SHOP_LIST[0][1]));
        return false;
    }

    public void draw(Graphics g) {
        if (this.actor.enabled && this.actor.visible) {
            this.actor.draw(g, 0, 0);
        }
        if (this.isSelected) {
            this.selactor.enabled = true;
            this.selactor.visible = true;
            this.selactor.actionCycle = true;
            this.selactor.draw(g, 0, 0);
            this.selactor.nextFrame();
        } else {
            this.selactor.enabled = false;
            this.selactor.visible = false;
        }
        if (this.effactor.enabled) {
            this.effactor.draw(g, 0, 0);
            this.effactor.nextFrame();
        }
        int endIndex = this.hpEndIndex;
        if (this.hpBeginIndex > this.hpEndIndex) {
            endIndex = this.hpEndIndex + 5;
        }
        for (int i = this.hpBeginIndex; i < endIndex; ++i) {
            int index = i % 5;
            if (this.t_loseHPFrame[index] <= 0 || this.t_nohurt || this.t_calcHP[index] == 0) continue;
            if (this.isPassBreakhit[index]) {
                UI.drawNumbers(g, this.isPassBreakhit[index] ? 1 : 1, 0, UI.mapNumToBit("\u66b4" + (this.t_calcHP[index] > 0 ? (char)'+' : '-') + String.valueOf(Math.abs(this.t_calcHP[index]))), this.posx + this.t_pos[index][0], this.posy - this.t_pos[index][1], 2);
            } else {
                UI.drawNumbers(g, this.isPassBreakhit[index] ? 1 : 1, 0, UI.mapNumToBit((this.t_calcHP[index] > 0 ? (char)'+' : '-') + String.valueOf(Math.abs(this.t_calcHP[index]))), this.posx + this.t_pos[index][0], this.posy - this.t_pos[index][1], 2);
            }
            int[] nArray = this.t_pos[index];
            nArray[0] = nArray[0] + this.t_pos[index][2];
            int[] nArray2 = this.t_pos[index];
            nArray2[3] = nArray2[3] - 3;
            int[] nArray3 = this.t_pos[index];
            nArray3[1] = nArray3[1] + this.t_pos[index][3];
            if (this.t_pos[index][1] < 0) {
                this.t_pos[index][1] = Math.abs(this.t_pos[index][1]);
                this.t_pos[index][3] = Math.abs(this.t_pos[index][3] * 5 / 6);
                this.t_pos[index][2] = this.t_pos[index][2] * 3 / 4;
            }
            int n = index;
            this.t_loseHPFrame[n] = this.t_loseHPFrame[n] - 1;
        }
        if (endIndex == this.hpBeginIndex + 5 - 1) {
            ++this.hpBeginIndex;
            this.hpBeginIndex %= 5;
        }
        if (this.frozen <= 0) {
            this.actor.nextFrame();
        }
    }

    public abstract void setStatus(int var1);

    public void setEffect(int effect) {
        switch (effect) {
            case 11: {
                this.effactor.setActorParam(effect, true, true, false, false, this.actor.posX, this.actor.posY - this.height * 1 / 3);
                break;
            }
            case 3: {
                this.effactor.setActorParam(effect, true, true, false, false, this.actor.posX, this.actor.posY - this.height * 2 / 3);
                break;
            }
            default: {
                this.effactor.setActorParam(effect, true, true, false, false, this.actor.posX, this.actor.posY);
            }
        }
    }

    public void setDebufEffect() {
        if (!this.isLiving) {
            return;
        }
        if (this.frozen > 0) {
            this.effactor.setActorParam(4, true, false, true, false, this.posx, this.posy);
        } else if (this.chaos > 0) {
            this.effactor.setActorParam(3, true, false, true, false, this.posx, this.posy - this.height * 2 / 3);
        } else if (this.burn > 0) {
            this.effactor.setActorParam(2, true, false, true, false, this.posx, this.posy);
        } else {
            this.effactor.setEnabled(false);
        }
    }

    public void setBgEffect(Unit skill, Team selfTeam, Team otherTeam, Role oppRole) {
        int i;
        UI.setBgBlackMode(skill.hidebg);
        if (skill.hidemate) {
            for (i = 0; i < selfTeam.fighters.length; ++i) {
                selfTeam.fighters[i].actor.setVisible(false);
            }
            this.actor.setVisible(true);
        }
        if (skill.hideelse) {
            for (i = 0; i < otherTeam.fighters.length; ++i) {
                otherTeam.fighters[i].actor.setVisible(false);
            }
            if (skill.linerole) {
                oppRole.moveOneLine();
            }
            oppRole.actor.setVisible(true);
        }
        if (skill.linerole) {
            this.moveOneLine();
        }
    }

    public void moveToEnemy(Role objRole) {
        if (objRole != null) {
            int sx = objRole.posx - this.tempx;
            int sy = objRole.posy - this.tempy;
            sx = (Math.abs(sx) - objRole.width / 2 - this.width / 2) * (sx > 0 ? 1 : -1);
            int vx = sx >> 1;
            int vy = sy >> 1;
            for (int i = 0; i < 3; ++i) {
                this.actor.posX = this.tempx + Tools.limit(vx * i, 0, sx);
                this.actor.posY = this.tempy + Tools.limit(vy * i, 0, sy) + 1;
                UI.showBattle(1);
            }
            this.tempx = (short)this.actor.posX;
            this.tempy = (short)this.actor.posY;
        }
    }

    private void moveOneLine() {
        int x = GameCanvas.SCREEN_WIDTH / 4;
        int y = GameCanvas.SCREEN_HEIGHT * 3 / 5;
        if (this.posx < GameCanvas.SCREEN_WIDTH / 2) {
            this.actor.posX = x;
            this.actor.posY = y;
            this.effactor.posX = this.actor.posX;
            this.effactor.posY = this.actor.posY;
        } else {
            this.actor.posX = GameCanvas.SCREEN_WIDTH - x;
            this.actor.posY = y;
            this.effactor.posX = this.actor.posX;
            this.effactor.posY = this.actor.posY;
        }
    }

    private void showAction(Role[] oppRole) {
        int count = 0;
        boolean isquit = false;
        while (!isquit && count++ <= 3) {
            UI.showBattle(1);
            if (this.actor.actionOver) {
                this.setStatus(0);
                isquit = true;
            }
            for (int i = 0; i < oppRole.length; ++i) {
                if (oppRole[i].actor.actionOver) {
                    oppRole[i].setStatus(0);
                }
                if (!oppRole[i].effactor.enabled || oppRole[i].effactor.actionOver) continue;
                isquit = false;
            }
        }
        UI.showBattle(5);
    }

    public void useItem(Team selfTeam, Unit item) {
        switch (item.datatype) {
            case 0: {
                this.calcHP(this.f_hp * item.rechpodd / 100 + item.rechp);
                this.calcMP(this.f_mp * item.recmpodd / 100 + item.recmp);
                this.calcGP(this.f_gp * item.recgpodd / 100 + item.recgp);
                if (!item.relive) break;
                this.isLiving = true;
                this.buftime = (short)-1;
                this.chaos = 0;
                this.frozen = 0;
                this.burn = 0;
                if (item.costround || selfTeam.fighters == null) break;
                for (int i = 0; i < selfTeam.fighters.length; ++i) {
                    selfTeam.fighters[i].hasAction = false;
                }
                break;
            }
            case 4: {
                if (item.unfroze) {
                    this.frozen = 0;
                }
                if (item.unfire) {
                    this.burn = 0;
                }
                if (item.unchaos) {
                    this.chaos = 0;
                }
                if (!item.escape) break;
                selfTeam.isEscape = true;
                break;
            }
        }
    }

    public void useAssistSkill(Unit skill) {
        if (skill.relive) {
            this.isLiving = true;
            this.buftime = (short)-1;
            this.chaos = 0;
            this.frozen = 0;
            this.burn = 0;
        }
        if (skill.buftime > 0) {
            this.buftime = skill.buftime;
            this.t_define = this.f_define * skill.adddefineodd / 100;
            this.t_maxatt = this.f_maxatt * skill.addattodd / 100;
            this.t_minatt = this.f_minatt * skill.addattodd / 100;
            this.t_hp = this.f_hp * skill.hpodd / 100 + skill.hp;
            this.t_mp = this.f_mp * skill.mpodd / 100 + skill.mp;
            this.addBufEffect();
        }
    }

    public boolean act_allkill() {
        if ((Battle.battleFlag & 0x40) != 0) {
            return false;
        }
        if (World.vars[0] == 9 || World.vars[0] == 11 || World.vars[0] == 31 || World.vars[0] == 33 || World.vars[0] == 37 || World.vars[0] == 44 || World.vars[0] == 45) {
            UI.showMessage(World.g, "\u6b64\u6b21\u6218\u6597\u4e0d\u652f\u6301\u9003\u8dd1\u3002", 10, 3);
            return false;
        }
        if (UI.showSMSPanel(World.g, 13)) {
            World.myteam.isEscape = true;
        }
        return false;
    }
}

